/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.business.utils;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IFormView;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.url.UrlService;

public class SyncFileAttachmentUtils {
    private static final Log LOG = LogFactory.getLog(SyncFileAttachmentUtils.class);

    public static void syncFileAttachment(Long srcPkValue, IFormView view) {
        QFilter[] filters = new QFilter[]{new QFilter("FInterID", "=", (Object)String.valueOf(srcPkValue)), new QFilter("FBillType", "=", (Object)view.getModel().getDataEntityType().getName()), new QFilter("fattachmentpanel", "=", (Object)"attachmentpanel")};
        DynamicObject[] files = BusinessDataServiceHelper.load((String)"bos_attachment", (String)"fattachmentname,fattachmentsize,fbilltype,fnumber,ffileid,fmodifytime", (QFilter[])filters);
        ArrayList attchmentList = new ArrayList(32);
        for (DynamicObject file : files) {
            String fileName = file.getString("fattachmentname");
            LinkedHashMap<String, String> attachmentMap = new LinkedHashMap<String, String>(16);
            attachmentMap.put("name", fileName);
            attachmentMap.put("size", file.getString("fattachmentsize"));
            attachmentMap.put("status", "success");
            attachmentMap.put("type", file.getString("fbilltype"));
            attachmentMap.put("uid", file.getString("fnumber"));
            String fullUrl = UrlService.getAttachmentFullUrl((String)file.getString("ffileid"));
            attachmentMap.put("url", SyncFileAttachmentUtils.generateTempUrl(fullUrl, fileName));
            attchmentList.add(attachmentMap);
        }
        AttachmentPanel attachmentPanel = (AttachmentPanel)view.getControl("attachmentpanel");
        attachmentPanel.upload(attchmentList);
    }

    public static void syncFileDiffAttachment(Long srcPkValue, IFormView view) {
        QFilter[] filters = new QFilter[]{new QFilter("FInterID", "=", (Object)String.valueOf(srcPkValue)), new QFilter("FBillType", "=", (Object)((ListShowParameter)view.getParentView().getFormShowParameter()).getBillFormId()), new QFilter("fattachmentpanel", "=", (Object)"attachmentpanel")};
        DynamicObject[] files = BusinessDataServiceHelper.load((String)"bos_attachment", (String)"fattachmentname,fattachmentsize,fbilltype,fnumber,ffileid,fmodifytime", (QFilter[])filters);
        ArrayList attchmentList = new ArrayList(32);
        for (DynamicObject file : files) {
            String fileName = file.getString("fattachmentname");
            LinkedHashMap<String, String> attachmentMap = new LinkedHashMap<String, String>(16);
            attachmentMap.put("name", fileName);
            attachmentMap.put("size", file.getString("fattachmentsize"));
            attachmentMap.put("status", "success");
            attachmentMap.put("type", file.getString("fbilltype"));
            attachmentMap.put("uid", file.getString("fnumber"));
            String fullUrl = UrlService.getAttachmentFullUrl((String)file.getString("ffileid"));
            attachmentMap.put("url", SyncFileAttachmentUtils.generateTempUrl(fullUrl, fileName));
            attchmentList.add(attachmentMap);
        }
        AttachmentPanel attachmentPanel = (AttachmentPanel)view.getControl("attachmentpanel");
        attachmentPanel.upload(attchmentList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String generateTempUrl(String fileUrl, String fileName) {
        TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        InputStream inputStream = null;
        try {
            URL url = new URL(fileUrl);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            inputStream = conn.getResponseCode() >= 400 ? conn.getErrorStream() : conn.getInputStream();
            String tempUrl = cache.saveAsUrl(fileName, inputStream, 5000);
            String address = RequestContext.get().getClientFullContextPath();
            if (!address.endsWith("/")) {
                address = address + "/";
            }
            String string = tempUrl = address + tempUrl;
            return string;
        }
        catch (IOException e) {
            LOG.error("fail to generate temp url" + e.getMessage());
            String string = "";
            return string;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
        }
    }
}

