/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.servicehelper;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.pmgt.pmbs.common.enums.BudgetCtrlEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;

public class BudgetCtrlHelper {
    private static final Log logger = LogFactory.getLog(BudgetCtrlHelper.class);

    public static String invokeAdjustInterface(DynamicObject dataEntity, BudgetCtrlEnum type) {
        String result;
        DynamicObject kind;
        String newDimmemName;
        String newDimmemNumber;
        HashMap<String, String> dimmember = new HashMap<String, String>(16);
        if (dataEntity.getDynamicObjectType().getName().equals("pmas_pro_approval")) {
            newDimmemNumber = dataEntity.getString("billno");
            newDimmemName = dataEntity.getString("billname");
            kind = dataEntity.getDynamicObject("kind");
            if (kind != null) {
                kind = BusinessDataServiceHelper.loadSingle((Object)kind.getPkValue(), (String)"bd_projectkind");
                DynamicObject parent = kind.getDynamicObject("parent");
                while (parent != null) {
                    kind = BusinessDataServiceHelper.loadSingle((Object)parent.getPkValue(), (String)"bd_projectkind");
                    parent = kind.getDynamicObject("parent");
                }
            }
            dimmember.put("budgetMoney", "realundertakeamt");
        } else {
            DynamicObject project = dataEntity.getDynamicObject("project");
            newDimmemNumber = project.getString("number");
            newDimmemName = project.getString("name");
            kind = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_projectkind"));
            dimmember.put("budgetMoney", "realdifferenceamt");
        }
        dimmember.put("proRootKind", (String)kind);
        dimmember.put("new_dimmemNumber", newDimmemNumber);
        dimmember.put("new_dimmemName", newDimmemName);
        dimmember.put("userId", RequestContext.get().getUserId());
        dimmember.put("entrytityName", "realbudgetentry");
        dimmember.put("budgetitem", "realbudgetitem");
        dimmember.put("ebMemberNumKey", "realpronumber");
        dimmember.put("proMemberIdKey", "realproid");
        dimmember.put("costOrgKey", "realundertakeorg");
        dimmember.put("costPeriodKey", "realundertakeperiod");
        dimmember.put("restoreData", type.getValue());
        logger.info("IAdjustExternalInvokeService.adjustAudio\u201d\uff0c[dimmember]\uff1a{}\uff0c[dataentity]{}", dimmember, (Object)dataEntity);
        try (TXHandle h = TX.requiresNew();){
            try {
                result = (String)DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"IAdjustExternalInvokeService", (String)"adjustAudio", (Object[])new Object[]{dataEntity, dimmember});
            }
            catch (Exception e1) {
                h.markRollback();
                logger.error("IAdjustExternalInvokeService.adjustAudio\uff1a", (Throwable)e1);
                if (e1.getMessage() == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8c03\u7528\u4f01\u4e1a\u7ee9\u6548\u4e91\u201c\u9884\u7b97\u8c03\u5242\u5355\u63a5\u53e3\u201d\u8fd4\u56de\u5f02\u5e38\u4fe1\u606f\u4e3a\u7a7a\u3002", (String)"BudgetCtrlHelper_25", (String)"pmgt-pmbs-servicehelper", (Object[])new Object[0]));
                }
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8c03\u7528\u4f01\u4e1a\u7ee9\u6548\u4e91\u63a5\u53e3\u62a5\u9519\uff1a%s\u3002", (String)"BudgetCtrlHelper_29", (String)"pmgt-pmbs-servicehelper", (Object[])new Object[0]), e1.getMessage()));
            }
        }
        logger.info("IAdjustExternalInvokeService.adjustAudio\u201d\uff0cresult\uff1a{}", (Object)result);
        if (result == null && !BudgetCtrlEnum.CLOSE.getValue().equals(type.getValue())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u7528\u4f01\u4e1a\u7ee9\u6548\u4e91\u201c\u9884\u7b97\u8c03\u5242\u5355\u63a5\u53e3\u201d\u672a\u8fd4\u56de\u4efb\u4f55\u6570\u636e\u3002", (String)"BudgetCtrlHelper_19", (String)"pmgt-pmbs-servicehelper", (Object[])new Object[0]));
        }
        return result;
    }

    public static String queryMemBalance(Long modelId, List<Map<String, String>> dimmember) {
        String result;
        logger.info("BgControlService.queryMemBalance\uff0c[dimmember]\uff1a{}", dimmember);
        try (TXHandle h = TX.requiresNew();){
            try {
                result = (String)DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"BgControlService", (String)"queryMemBalance", (Object[])new Object[]{modelId, dimmember});
            }
            catch (Exception e1) {
                h.markRollback();
                logger.error("BgControlService.queryMemBalance\uff1a", (Throwable)e1);
                if (e1.getMessage() == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8c03\u7528\u4f01\u4e1a\u7ee9\u6548\u4e91\u201c\u9884\u7b97\u9879\u76ee\u5f53\u671f\u4f59\u989d\u63a5\u53e3\u201d\u8fd4\u56de\u5f02\u5e38\u4fe1\u606f\u4e3a\u7a7a\u3002", (String)"BudgetCtrlHelper_26", (String)"pmgt-pmbs-servicehelper", (Object[])new Object[0]));
                }
                throw new KDBizException(e1.getMessage());
            }
        }
        logger.info("BgControlService.queryMemBalance\uff0cresult\uff1a{}", (Object)result);
        if (result == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u7528\u4f01\u4e1a\u7ee9\u6548\u4e91\u201c\u9884\u7b97\u9879\u76ee\u5f53\u671f\u4f59\u989d\u63a5\u53e3\u201d\u672a\u8fd4\u56de\u4efb\u4f55\u6570\u636e\u3002", (String)"BudgetCtrlHelper_21", (String)"pmgt-pmbs-servicehelper", (Object[])new Object[0]));
        }
        return result;
    }

    public static String queryTotalBalances(Long modelId, List<Map<String, String>> dimmember) {
        String result;
        logger.info("OlapDataQueryService.queryTotalBalances\uff0c[dimmember]{}", dimmember);
        try (TXHandle h = TX.requiresNew();){
            try {
                result = (String)DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"OlapDataQueryService", (String)"queryTotalBalances", (Object[])new Object[]{modelId, dimmember});
            }
            catch (Exception e1) {
                h.markRollback();
                logger.error("OlapDataQueryService.queryTotalBalances\uff1a", (Throwable)e1);
                if (e1.getMessage() == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8c03\u7528\u4f01\u4e1a\u7ee9\u6548\u4e91\u201c\u9884\u7b97\u7d2f\u8ba1\u4f59\u989d\u63a5\u53e3\u201d\u8fd4\u56de\u5f02\u5e38\u4fe1\u606f\u4e3a\u7a7a\u3002", (String)"BudgetCtrlHelper_27", (String)"pmgt-pmbs-servicehelper", (Object[])new Object[0]));
                }
                throw new KDBizException(e1.getMessage());
            }
        }
        logger.info("OlapDataQueryService.queryTotalBalances\uff1a{}", (Object)result);
        if (result == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u7528\u4f01\u4e1a\u7ee9\u6548\u4e91\u201c\u9884\u7b97\u7d2f\u8ba1\u4f59\u989d\u63a5\u53e3\u201d\u672a\u8fd4\u56de\u4efb\u4f55\u6570\u636e\u3002", (String)"BudgetCtrlHelper_23", (String)"pmgt-pmbs-servicehelper", (Object[])new Object[0]));
        }
        return result;
    }

    public static String queryTotalBalances(Long modelId, Long busModelId, List<Map<String, String>> dimmember) {
        String result;
        logger.info("OlapDataQueryService.queryTotalBalances\uff0c[modelId]\uff1a{}, [busModelId]\uff1a{}, [dimmember]\uff1a{}", new Object[]{modelId, busModelId, dimmember});
        try (TXHandle h = TX.requiresNew();){
            try {
                result = (String)DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"OlapDataQueryService", (String)"queryTotalBalances", (Object[])new Object[]{modelId, busModelId, dimmember});
            }
            catch (Exception e1) {
                h.markRollback();
                logger.error("OlapDataQueryService.queryTotalBalances\uff1a", (Throwable)e1);
                if (e1.getMessage() == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u4f01\u4e1a\u7ee9\u6548\u4e91\u201c\u9884\u7b97\u7d2f\u8ba1\u4f59\u989d\u63a5\u53e3\u201d\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a\u3002", (String)"BudgetCtrlHelper_24", (String)"pmgt-pmbs-servicehelper", (Object[])new Object[0]));
                }
                throw new KDBizException(e1.getMessage());
            }
        }
        logger.info("OlapDataQueryService.queryTotalBalances\uff1a{}", (Object)result);
        if (result == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u7528\u4f01\u4e1a\u7ee9\u6548\u4e91\u201c\u9884\u7b97\u7d2f\u8ba1\u4f59\u989d\u63a5\u53e3\u201d\u672a\u8fd4\u56de\u4efb\u4f55\u6570\u636e\u3002", (String)"BudgetCtrlHelper_23", (String)"pmgt-pmbs-servicehelper", (Object[])new Object[0]));
        }
        return result;
    }

    public static Object requestBudget(DynamicObject dataEntity, String entityNumber, String registerOp, boolean isJsonStr, String msg) {
        String bizId = dataEntity.getPkValue().toString();
        String result = (String)DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"BgControlService", (String)"requestBudget", (Object[])new Object[]{entityNumber, bizId, registerOp, isJsonStr});
        logger.info("requestBudget: msg\uff1a{}\uff0cresult\uff1a{}", (Object)msg, (Object)result);
        if (result == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\uff1a%s\uff0c\u8c03\u7528\u4f01\u4e1a\u7ee9\u6548\u4e91\u201c\u9884\u7b97\u6263\u51cf\u63a5\u53e3\u201d\u672a\u8fd4\u56de\u4efb\u4f55\u6570\u636e\u3002", (String)"BudgetCtrlHelper_28", (String)"pmgt-pmbs-servicehelper", (Object[])new Object[0]), registerOp));
        }
        return result;
    }

    public static void returnBudget(DynamicObject dataEntity, String entityNumber, String registerOp, String msg) {
        String bizId = dataEntity.getPkValue().toString();
        logger.info("returnBudget : msg\uff1a{}", (Object)msg);
        DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"BgControlService", (String)"returnBudget", (Object[])new Object[]{entityNumber, bizId, registerOp});
    }

    public static void closeBudget(DynamicObject dataEntity, String entityNumber, String registerOp, String msg) {
        String bizId = dataEntity.getPkValue().toString();
        logger.info("closeBudget msg\uff1a{}", (Object)msg);
        DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"BgControlService", (String)"closeBudget", (Object[])new Object[]{entityNumber, bizId, registerOp});
    }

    public static DynamicObject getProjectApproval(DynamicObject project) {
        if (project == null) {
            return null;
        }
        QFilter projectFilter = new QFilter("pro", "=", project.getPkValue());
        QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        DynamicObject[] projectApprovalArray = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"id", (QFilter[])new QFilter[]{projectFilter, billStatusFilter});
        if (projectApprovalArray.length == 0) {
            return null;
        }
        return BusinessDataServiceHelper.loadSingle((Object)projectApprovalArray[0].getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmas_pro_approval"));
    }
}

