/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.servicehelper;

import java.util.ArrayList;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.form.upgrade.AbstractUpgradePlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.UpgradeResult;
import kd.pmgt.pmbs.common.enums.BudgetCtlModeEnum;

public class ProjectKindUpgradePlugin
extends AbstractUpgradePlugin {
    private static final Log logger = LogFactory.getLog(ProjectKindUpgradePlugin.class);

    public UpgradeResult beforeExecuteSql(String ver, String iteration, String dbKey, String sqlFileName) {
        String syncIds;
        String bdSelect;
        String algoKey = "ProjectKindUpgradePlugin.beforeExecuteSql";
        String pmgtSelect = "SELECT fid FROM T_PMBS_PROJECTKIND;";
        DataSet pmgtDataSet = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.of((String)"cr"), (String)pmgtSelect);
        StringBuilder idsSb = new StringBuilder();
        while (pmgtDataSet.hasNext()) {
            Row row = pmgtDataSet.next();
            idsSb.append(row.get(0).toString()).append(",");
        }
        String ids = idsSb.toString();
        if (!ids.isEmpty()) {
            ids = ids.substring(0, ids.length() - 1);
            bdSelect = "SELECT FID,FNUMBER,FSTATUS,FCREATORID,FMODIFIERID,FENABLE,FCREATETIME,FMODIFYTIME,FMASTERID,FLONGNUMBER,FLEVEL,FISLEAF,FPARENTID,FCREATEORGID,FORGID,FCTRLSTRATEGY,FUSEORGID FROM T_BD_PROJECTKIND WHERE FENABLE = '1' AND FSTATUS = 'C' AND FID NOT IN (" + ids + ");";
        } else {
            bdSelect = "SELECT FID,FNUMBER,FSTATUS,FCREATORID,FMODIFIERID,FENABLE,FCREATETIME,FMODIFYTIME,FMASTERID,FLONGNUMBER,FLEVEL,FISLEAF,FPARENTID,FCREATEORGID,FORGID,FCTRLSTRATEGY,FUSEORGID FROM T_BD_PROJECTKIND WHERE FENABLE = '1' AND FSTATUS = 'C';";
        }
        DataSet bdDataSet = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.of((String)"sys"), (String)bdSelect);
        ArrayList<Object[]> pmgtParamsList = new ArrayList<Object[]>(10);
        StringBuilder syncIdsSb = new StringBuilder();
        while (bdDataSet.hasNext()) {
            Row row = bdDataSet.next();
            syncIdsSb.append(row.get(0).toString()).append(",");
            Object[] param = new Object[row.size()];
            for (int i = 0; i < row.size(); ++i) {
                param[i] = row.get(i);
            }
            pmgtParamsList.add(param);
        }
        if (!pmgtParamsList.isEmpty()) {
            String pmgtInsert = "insert into t_pmbs_projectkind (FID,FNUMBER,FSTATUS,FCREATORID,FMODIFIERID,FENABLE,FCREATETIME,FMODIFYTIME,FMASTERID,FLONGNUMBER,FLEVEL,FISLEAF,FPARENTID,FCREATEORGID,FORGID,FCTRLSTRATEGY,FUSEORGID) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?);";
            DB.executeBatch((DBRoute)DBRoute.of((String)"cr"), (String)pmgtInsert, pmgtParamsList);
        }
        if (!(syncIds = syncIdsSb.toString()).isEmpty()) {
            syncIds = syncIds.substring(0, syncIds.length() - 1);
            String bdlSelect = "SELECT FID,FLOCALEID,FNAME,FFULLNAME,FPKID FROM T_BD_PROJECTKIND_L WHERE FID IN(" + syncIds + ");";
            DataSet bdlDataSet = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.of((String)"sys"), (String)bdlSelect);
            ArrayList<Object[]> pmgtlParamsList = new ArrayList<Object[]>(10);
            while (bdlDataSet.hasNext()) {
                Row row = bdlDataSet.next();
                Object[] param = new Object[row.size()];
                for (int i = 0; i < row.size(); ++i) {
                    param[i] = row.get(i);
                }
                pmgtlParamsList.add(param);
            }
            if (!pmgtlParamsList.isEmpty()) {
                String pmgtlInsert = "insert into t_pmbs_projectkind_l (FID,FLOCALEID,FNAME,FFULLNAME,FPKID) values (?,?,?,?,?);";
                DB.executeBatch((DBRoute)DBRoute.of((String)"cr"), (String)pmgtlInsert, pmgtlParamsList);
            }
            String[] syncIdsArr = syncIds.split(",");
            ArrayList<Long> syncProKindIdsList = new ArrayList<Long>(10);
            String settingSelect = "select FPROJECTKINDID from t_pmbs_prokindctrlsetting where FPROJECTKINDID =?;";
            for (String proKindIdStr : syncIdsArr) {
                Long proKindId = Long.parseLong(proKindIdStr);
                Object[] params = new Object[]{proKindId};
                DataSet settingResult = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.of((String)"cr"), (String)settingSelect, (Object[])params);
                if (!settingResult.isEmpty()) continue;
                syncProKindIdsList.add(proKindId);
            }
            int count = syncProKindIdsList.size();
            if (count > 0) {
                long[] proKindCtrlSettingIds = DB.genLongIds((String)"t_pmbs_prokindctrlsetting", (int)count);
                ArrayList<Object[]> settingParamsList = new ArrayList<Object[]>(10);
                String insertSettingSql = "insert into t_pmbs_prokindctrlsetting (FID,FENABLE,FISMAJORTYPE,FINBUDGETTPLID,FOUTBUDGETTPLID,FPROJECTKINDID,FBUDGETCONTROLMODE,FPROJECTCOSTCONTROL) values (?,?,?,?,?,?,?,?)";
                for (int i = 0; i < proKindCtrlSettingIds.length; ++i) {
                    Object[] param = new Object[]{proKindCtrlSettingIds[i], true, false, 0L, 0L, syncProKindIdsList.get(i), BudgetCtlModeEnum.NOTCONTROL.getValue(), false};
                    settingParamsList.add(param);
                }
                if (!settingParamsList.isEmpty()) {
                    DB.executeBatch((DBRoute)DBRoute.of((String)"cr"), (String)insertSettingSql, settingParamsList);
                }
                long[] stageIds = DB.genLongIds((String)"t_pmbs_projectstageentry", (int)count);
                ArrayList<Object[]> stageParamsList = new ArrayList<Object[]>(10);
                String insertStageSql = "insert into t_pmbs_projectstageentry (FENTRYID,FID,FSEQ,FPROJECTSTAGEID) values (?,?,?,?)";
                for (int i = 0; i < stageIds.length; ++i) {
                    Object[] param = new Object[]{stageIds[i], proKindCtrlSettingIds[i], 0L, 841049277089613824L};
                    stageParamsList.add(param);
                }
                if (!stageParamsList.isEmpty()) {
                    DB.executeBatch((DBRoute)DBRoute.of((String)"cr"), (String)insertStageSql, stageParamsList);
                }
                long[] budgetIds = DB.genLongIds((String)"t_pmbs_budgetstageentry", (int)count);
                ArrayList<Object[]> budgetParamsList = new ArrayList<Object[]>(10);
                String insertBudgetSql = "insert into t_pmbs_budgetstageentry (FENTRYID,FID,FSEQ,FBUDGETSTAGEID) values (?,?,?,?)";
                for (int i = 0; i < stageIds.length; ++i) {
                    Object[] param = new Object[]{budgetIds[i], proKindCtrlSettingIds[i], 0L, 843410915230915584L};
                    budgetParamsList.add(param);
                }
                if (!budgetParamsList.isEmpty()) {
                    DB.executeBatch((DBRoute)DBRoute.of((String)"cr"), (String)insertBudgetSql, budgetParamsList);
                }
            }
        }
        return super.beforeExecuteSql(ver, iteration, dbKey, sqlFileName);
    }

    public UpgradeResult afterExecuteSql(String ver, String iteration, String dbKey, String sqlFileName) {
        return super.afterExecuteSql(ver, iteration, dbKey, sqlFileName);
    }
}

