/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmco.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pmgt.pmbs.common.enums.BudgetCtlModeEnum;
import kd.pmgt.pmbs.common.enums.SplitTypeEnum;
import kd.pmgt.pmbs.servicehelper.BudgetCtrlHelper;

public class OutBudgetAdjustOp
extends AbstractOperationServicePlugIn {
    public static final String BUDGET_CONTROL_MODE = "budgetcontrolmode";
    public static final String PMCO_OUTBUDGETADJUST = "pmco_outbudgetadjust";
    private static final Log logger = LogFactory.getLog(OutBudgetAdjustOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("undertakeorg");
        fieldKeys.add("undertakeperiod");
        fieldKeys.add("entryproname");
        fieldKeys.add("currentratio");
        fieldKeys.add("currentamt");
        fieldKeys.add("adjustbudgetitem");
        fieldKeys.add("splittype");
        fieldKeys.add("differenceamt");
        fieldKeys.add("project");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new OutBudgetAdjustSubmitValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        block5: {
            DynamicObject[] dataEntities;
            String operationKey;
            block7: {
                block6: {
                    block4: {
                        operationKey = e.getOperationKey();
                        dataEntities = e.getDataEntities();
                        if (!StringUtils.equals((CharSequence)operationKey, (CharSequence)"submit")) break block4;
                        for (DynamicObject dataEntity : dataEntities) {
                            DynamicObject project = dataEntity.getDynamicObject("project");
                            DynamicObject projectApproval = BudgetCtrlHelper.getProjectApproval((DynamicObject)project);
                            String budgetControlMode = projectApproval.getString(BUDGET_CONTROL_MODE);
                            if (!StringUtils.equals((CharSequence)budgetControlMode, (CharSequence)BudgetCtlModeEnum.CONTROLANDOCCUPY.getValue())) continue;
                            DynamicObject lastBillObj = this.getLastBillObj(projectApproval, project);
                            this.occupyChangeAmount(dataEntity, lastBillObj, "submit");
                        }
                        break block5;
                    }
                    if (!StringUtils.equals((CharSequence)operationKey, (CharSequence)"unsubmit")) break block6;
                    for (DynamicObject dataEntity : dataEntities) {
                        DynamicObject project = dataEntity.getDynamicObject("project");
                        DynamicObject projectApproval = BudgetCtrlHelper.getProjectApproval((DynamicObject)project);
                        String budgetControlMode = projectApproval.getString(BUDGET_CONTROL_MODE);
                        if (!StringUtils.equals((CharSequence)budgetControlMode, (CharSequence)BudgetCtlModeEnum.CONTROLANDOCCUPY.getValue())) continue;
                        DynamicObject lastBillObj = this.getLastBillObj(projectApproval, project);
                        this.returnOccupyChangeAmount(dataEntity, lastBillObj, "unsubmit", "unsubmitoccupy");
                    }
                    break block5;
                }
                if (!StringUtils.equals((CharSequence)operationKey, (CharSequence)"audit")) break block7;
                for (DynamicObject dataEntity : dataEntities) {
                    DynamicObject project = dataEntity.getDynamicObject("project");
                    DynamicObject projectApproval = BudgetCtrlHelper.getProjectApproval((DynamicObject)project);
                    String budgetControlMode = projectApproval.getString(BUDGET_CONTROL_MODE);
                    if (!StringUtils.equals((CharSequence)budgetControlMode, (CharSequence)BudgetCtlModeEnum.CONTROLANDOCCUPY.getValue())) continue;
                    DynamicObject lastBillObj = this.getLastBillObj(projectApproval, project);
                    this.executeOccupyChangeAmount(dataEntity, lastBillObj, "audit");
                }
                break block5;
            }
            if (!StringUtils.equals((CharSequence)operationKey, (CharSequence)"unaudit")) break block5;
            for (DynamicObject dataEntity : dataEntities) {
                DynamicObject project = dataEntity.getDynamicObject("project");
                DynamicObject projectApproval = BudgetCtrlHelper.getProjectApproval((DynamicObject)project);
                String budgetControlMode = projectApproval.getString(BUDGET_CONTROL_MODE);
                if (!StringUtils.equals((CharSequence)budgetControlMode, (CharSequence)BudgetCtlModeEnum.CONTROLANDOCCUPY.getValue())) continue;
                DynamicObject lastBillObj = this.getLastBillObj(projectApproval, project);
                this.returnOccupyChangeAmount(dataEntity, lastBillObj, "unaudit", "unauditoccupy");
            }
        }
    }

    private DynamicObject getLastBillObj(DynamicObject projectApprovalObj, DynamicObject project) {
        DynamicObject lastBillObj = null;
        QFilter proFilter = new QFilter("project", "=", project.getPkValue());
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)"C");
        DynamicObject[] proBudgets = BusinessDataServiceHelper.load((String)"pmas_outbudget", (String)"id", (QFilter[])new QFilter[]{proFilter, statusFilter});
        if (proBudgets.length <= 1) {
            lastBillObj = projectApprovalObj;
        } else {
            QFilter validFilter = new QFilter("isvalid", "=", (Object)"1");
            lastBillObj = BusinessDataServiceHelper.loadSingle((String)"pmas_outbudget", (String)"id, budgetcontrolmode", (QFilter[])new QFilter[]{proFilter, validFilter});
        }
        return lastBillObj;
    }

    private void occupyChangeAmount(DynamicObject curBillObj, DynamicObject lastBillObj, String operate) {
        String budgetControlMode = lastBillObj.getString(BUDGET_CONTROL_MODE);
        if (StringUtils.equals((CharSequence)budgetControlMode, (CharSequence)BudgetCtlModeEnum.CONTROLANDOCCUPY.getValue())) {
            try {
                String msg1 = String.format(ResManager.loadKDString((String)"\u652f\u51fa\u9884\u7b97\u8c03\u5242\u5355%1$s\u64cd\u4f5c\uff0c\u8c03\u7528\u4f01\u4e1a\u7ee9\u6548\u4e91\u201c\u9884\u7b97\u6263\u51cf\u63a5\u53e3\u201cBgControlService.requestBudget\u201d\u505a\u5360\u7528\uff0c\u5360\u7528\u64cd\u4f5c%2$s\uff1a", (String)"OutBudgetAdjustOp_14", (String)"pmgt-pmco-opplugin", (Object[])new Object[0]), operate, "submitoccupy");
                BudgetCtrlHelper.requestBudget((DynamicObject)curBillObj, (String)PMCO_OUTBUDGETADJUST, (String)"submitoccupy", (boolean)true, (String)msg1);
            }
            catch (Exception e) {
                String msg2 = String.format(ResManager.loadKDString((String)"\u652f\u51fa\u9884\u7b97\u8c03\u5242\u5355%1$s\u64cd\u4f5c\uff0c\u8c03\u7528\u4f01\u4e1a\u7ee9\u6548\u4e91\u201c\u9884\u7b97\u6263\u51cf\u63a5\u53e3\u201cBgControlService.requestBudget\u201d\u505a\u5360\u7528\uff0c\u5360\u7528\u64cd\u4f5c%2$s\uff1a\u5f02\u5e38\u3002", (String)"OutBudgetAdjustOp_15", (String)"pmgt-pmco-opplugin", (Object[])new Object[0]), operate, "submitoccupy");
                logger.error(msg2);
                logger.error(e.getMessage());
                throw new KDBizException(e.getMessage());
            }
        }
    }

    private void returnOccupyChangeAmount(DynamicObject curBillObj, DynamicObject lastBillObj, String operate, String registerOp) {
        String budgetControlMode = lastBillObj.getString(BUDGET_CONTROL_MODE);
        if (StringUtils.equals((CharSequence)budgetControlMode, (CharSequence)BudgetCtlModeEnum.CONTROLANDOCCUPY.getValue())) {
            try {
                String msg1 = String.format(ResManager.loadKDString((String)"\u652f\u51fa\u9884\u7b97\u8c03\u5242\u5355%1$s\u64cd\u4f5c\uff0c\u8c03\u7528\u4f01\u4e1a\u7ee9\u6548\u4e91\u201c\u9884\u7b97\u8fd4\u8fd8\u63a5\u53e3\u201cBgControlService.returnBudget\u201d\uff0c\u8fd4\u8fd8\u64cd\u4f5c%2$s\uff1a", (String)"OutBudgetAdjustOp_16", (String)"pmgt-pmco-opplugin", (Object[])new Object[0]), operate, registerOp);
                BudgetCtrlHelper.returnBudget((DynamicObject)curBillObj, (String)PMCO_OUTBUDGETADJUST, (String)registerOp, (String)msg1);
            }
            catch (Exception e) {
                logger.error(e.getMessage());
                throw new KDBizException(e.getMessage());
            }
        }
    }

    private void executeOccupyChangeAmount(DynamicObject curBillObj, DynamicObject lastBillObj, String operate) {
        String budgetControlMode = lastBillObj.getString(BUDGET_CONTROL_MODE);
        if (StringUtils.equals((CharSequence)budgetControlMode, (CharSequence)BudgetCtlModeEnum.CONTROLANDOCCUPY.getValue())) {
            try {
                String msg1 = String.format(ResManager.loadKDStringExt((String)"\u652f\u51fa\u9884\u7b97\u8c03\u5242\u5355%1$s\u64cd\u4f5c\uff0c\u8c03\u7528\u4f01\u4e1a\u7ee9\u6548\u4e91\u201c\u9884\u7b97\u6263\u51cf\u63a5\u53e3\u201cBgControlService.requestBudget\u201d\u505a\u6267\u884c\uff0c\u6267\u884c\u64cd\u4f5c%2$s\uff1a", (String)"OutBudgetAdjustOp_17", (String)"pmgt-pmco-opplugin", (Object[])new Object[0]), operate, "auditexecute");
                BudgetCtrlHelper.requestBudget((DynamicObject)curBillObj, (String)PMCO_OUTBUDGETADJUST, (String)"auditexecute", (boolean)true, (String)msg1);
                String msg2 = String.format(ResManager.loadKDStringExt((String)"\u652f\u51fa\u9884\u7b97\u8c03\u5242\u5355%1$s\u64cd\u4f5c\uff0c\u8c03\u7528\u4f01\u4e1a\u7ee9\u6548\u4e91\u201c\u9884\u7b97\u5173\u95ed\u63a5\u53e3\u201cBgControlService.closeBudget\u201d\uff0c\u5173\u95ed\u64cd\u4f5c%2$s\uff1a", (String)"OutBudgetAdjustOp_18", (String)"pmgt-pmco-opplugin", (Object[])new Object[0]), operate, "auditreturn");
                BudgetCtrlHelper.closeBudget((DynamicObject)curBillObj, (String)PMCO_OUTBUDGETADJUST, (String)"auditreturn", (String)msg2);
            }
            catch (Exception e) {
                logger.error(e.getMessage());
                throw new KDBizException(e.getMessage());
            }
        }
    }

    static class OutBudgetAdjustSubmitValidator
    extends AbstractValidator {
        OutBudgetAdjustSubmitValidator() {
        }

        public void validate() {
            String key = this.getOperateKey();
            if (StringUtils.equals((CharSequence)"submit", (CharSequence)key)) {
                ExtendedDataEntity[] dataEntities;
                for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                    DynamicObject outBudgetAdjustObj = dataEntity.getDataEntity();
                    DynamicObject project = outBudgetAdjustObj.getDynamicObject("project");
                    if (project == null) continue;
                    DynamicObjectCollection adjustDetailEntryCol = outBudgetAdjustObj.getDynamicObjectCollection("adjustdetailentry");
                    HashMap<String, ArrayList<Integer>> dimensionsLineMap = new HashMap<String, ArrayList<Integer>>(16);
                    BigDecimal totalAmount = outBudgetAdjustObj.getBigDecimal("totalamount");
                    BigDecimal totalRatio = BigDecimal.ZERO;
                    BigDecimal totalEntryCurrentAmt = BigDecimal.ZERO;
                    HashMap<String, BigDecimal> budgetItemAmtMap = new HashMap<String, BigDecimal>(16);
                    HashMap<String, BigDecimal> budgetItemNameDiffAmtMap = new HashMap<String, BigDecimal>(16);
                    String splitType = outBudgetAdjustObj.getString("splittype");
                    if (QueryServiceHelper.exists((String)OutBudgetAdjustOp.PMCO_OUTBUDGETADJUST, (QFilter[])new QFilter[]{new QFilter("project", "=", project.getPkValue()), new QFilter("billstatus", "<>", (Object)"C"), new QFilter("id", "<>", outBudgetAdjustObj.getPkValue())})) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9879\u76ee\u201c%s\u201d\u5b58\u5728\u672a\u5ba1\u6838\u7684\u9879\u76ee\u652f\u51fa\u9884\u7b97\u8c03\u5242\u5355\uff0c\u8bf7\u5b8c\u6210\u5ba1\u6838\u3002", (String)"OutBudgetAdjustOp_10", (String)"pmgt-pmco-opplugin", (Object[])new Object[0]), project.getString("name")));
                    }
                    for (int i = 0; i < adjustDetailEntryCol.size(); ++i) {
                        DynamicObject adjustDetailEntry = (DynamicObject)adjustDetailEntryCol.get(i);
                        String ctrlBudgetItemId = adjustDetailEntry.getString("adjustbudgetitem_id");
                        DynamicObject adjustbudgetitem = adjustDetailEntry.getDynamicObject("adjustbudgetitem");
                        if (adjustbudgetitem != null) {
                            String adjustBudgetItemName = adjustbudgetitem.getString("name");
                            BigDecimal differenceamt = adjustDetailEntry.getBigDecimal("differenceamt");
                            BigDecimal budgetDiffAmt = (BigDecimal)budgetItemNameDiffAmtMap.get(adjustBudgetItemName);
                            if (budgetDiffAmt == null) {
                                budgetItemNameDiffAmtMap.put(adjustBudgetItemName, differenceamt);
                            } else {
                                budgetItemNameDiffAmtMap.put(adjustBudgetItemName, budgetDiffAmt.add(differenceamt));
                            }
                        }
                        String undertakeOrgId = adjustDetailEntry.getString("undertakeorg_id");
                        Date undertakePeriodDate = adjustDetailEntry.getDate("undertakeperiod");
                        String entryProName = adjustDetailEntry.getString("entryproname");
                        BigDecimal currentRatio = adjustDetailEntry.getBigDecimal("currentratio");
                        BigDecimal currentAmt = adjustDetailEntry.getBigDecimal("currentamt");
                        StringBuilder dimensionsKey = new StringBuilder();
                        dimensionsKey.append(undertakeOrgId).append(undertakePeriodDate).append(entryProName).append(ctrlBudgetItemId);
                        ArrayList<Integer> lineList = (ArrayList<Integer>)dimensionsLineMap.get(dimensionsKey.toString());
                        if (lineList == null) {
                            lineList = new ArrayList<Integer>(10);
                        }
                        lineList.add(i + 1);
                        dimensionsLineMap.put(dimensionsKey.toString(), lineList);
                        totalRatio = totalRatio.add(currentRatio);
                        totalEntryCurrentAmt = totalEntryCurrentAmt.add(currentAmt);
                        BigDecimal ctrlBudgetAmt = (BigDecimal)budgetItemAmtMap.get(ctrlBudgetItemId);
                        if (ctrlBudgetAmt == null) {
                            budgetItemAmtMap.put(ctrlBudgetItemId, currentAmt);
                            continue;
                        }
                        budgetItemAmtMap.put(ctrlBudgetItemId, ctrlBudgetAmt.add(currentAmt));
                    }
                    if (StringUtils.equals((CharSequence)"2", (CharSequence)splitType) || StringUtils.equals((CharSequence)"3", (CharSequence)splitType)) {
                        for (Map.Entry entry : budgetItemNameDiffAmtMap.entrySet()) {
                            BigDecimal budgetItemDiffAmt = (BigDecimal)entry.getValue();
                            if (budgetItemDiffAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8c03\u5242\u660e\u7ec6\u5206\u5f55\u6807\u51c6\u9884\u7b97\u9879\uff1a%s\u91d1\u989d\u524d\u540e\u4e0d\u4e00\u81f4\u3002", (String)"OutBudgetAdjustOp_11", (String)"pmgt-pmco-opplugin", (Object[])new Object[0]), entry.getKey()));
                        }
                    }
                    if (StringUtils.equals((CharSequence)SplitTypeEnum.TOTALAMTSPLIT.getValue(), (CharSequence)splitType) && totalRatio.compareTo(BigDecimal.valueOf(100L)) != 0) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u6bd4\u4f8b\u7d2f\u8ba1\u4e0d\u7b49\u4e8e100%\u3002", (String)"OutBudgetAdjustOp_12", (String)"pmgt-pmco-opplugin", (Object[])new Object[0]));
                        return;
                    }
                    if (totalAmount.compareTo(totalEntryCurrentAmt) != 0) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8c03\u5242\u660e\u7ec6\u5206\u5f55\u73b0\u91d1\u989d\u7d2f\u8ba1\u4e0e\u9879\u76ee\u652f\u51fa\u603b\u91d1\u989d\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OutBudgetAdjustOp_7", (String)"pmgt-pmco-opplugin", (Object[])new Object[0]));
                        return;
                    }
                    Collection listCollection = dimensionsLineMap.values();
                    for (List list : listCollection) {
                        if (list.size() <= 1) continue;
                        String tipStringBuilder = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u7684\u7ef4\u5ea6\u4fe1\u606f\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OutBudgetAdjustOp_13", (String)"pmgt-pmco-opplugin", (Object[])new Object[0]), list.toString());
                        this.addErrorMessage(dataEntity, tipStringBuilder);
                    }
                }
            }
        }
    }
}

