/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmco.opplugin;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.utils.SystemParamHelper;

public class PayApplyCostSplitOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("id");
        e.getFieldKeys().add("project");
        e.getFieldKeys().add("costdimension");
        e.getFieldKeys().add("auditdate");
        e.getFieldKeys().add("costdetails");
        e.getFieldKeys().add("costsplitdetails");
        e.getFieldKeys().add("costitem");
        e.getFieldKeys().add("probudget");
        e.getFieldKeys().add("contract");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                switch (this.getOperateKey()) {
                    case "submit": {
                        this.submitValidate();
                        break;
                    }
                    case "unaudit": {
                        this.unAuditValidate();
                        break;
                    }
                }
            }

            private void submitValidate() {
                ExtendedDataEntity[] dataEntities;
                for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                    DynamicObject bill = dataEntity.getDataEntity();
                    DynamicObject project = bill.getDynamicObject("project");
                    if (project == null) continue;
                    Object parameter = SystemParamHelper.getSystemParameter((String)"mustinputcostitem", (String)"pmbs", (Long)OrgUnitServiceHelper.getRootOrgId());
                    boolean mustInput = parameter == null || (Boolean)parameter != false;
                    DynamicObjectCollection entryEntity = bill.getDynamicObjectCollection("costdetails");
                    block1: for (DynamicObject row : entryEntity) {
                        DynamicObject contract = row.getDynamicObject("contract");
                        DynamicObjectCollection subEntryEntity = row.getDynamicObjectCollection("costsplitdetails");
                        HashMap proBudgetMap = new HashMap(16);
                        for (DynamicObject subEntry : subEntryEntity) {
                            DynamicObject costItem = subEntry.getDynamicObject("costitem");
                            if (costItem == null && mustInput) {
                                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5408\u540c\u201c%1$s\u201d\u7684\u6210\u672c\u5206\u644a\u660e\u7ec6\u4e2d\uff0c\u5b58\u5728\u7a7a\u7684\u6210\u672c\u9879\u6570\u636e\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PayApplyCostSplitOp_4", (String)"pmgt-pmco-opplugin", (Object[])new Object[0]), contract.getString("billname")));
                                continue block1;
                            }
                            DynamicObject proBudget = subEntry.getDynamicObject("probudget");
                            if (proBudget == null || costItem == null) continue;
                            long proBudgetId = Long.parseLong(proBudget.getPkValue().toString());
                            long costItemId = Long.parseLong(costItem.getPkValue().toString());
                            HashSet<Long> costItemIds = (HashSet<Long>)proBudgetMap.get(proBudgetId);
                            if (costItemIds == null) {
                                costItemIds = new HashSet<Long>();
                            } else if (costItemIds.contains(costItemId)) {
                                proBudget = BusinessDataServiceHelper.loadSingle((Object)proBudgetId, (String)"pmas_projectbudget", (String)"name");
                                costItem = BusinessDataServiceHelper.loadSingle((Object)costItemId, (String)"pmbs_costitem", (String)"name");
                                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5408\u540c\u201c%1$s\u201d\u6210\u672c\u5206\u644a\u660e\u7ec6\u4e2d\uff0c\u9884\u7b97\u9879\u201c%2$s\u201d\u3001\u6210\u672c\u9879\u201c%3$s\u201d\u7b49\u5b57\u6bb5\u7684\u7ec4\u5408\u503c\u5b58\u5728\u91cd\u590d\u5206\u644a\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PayApplyCostSplitOp_5", (String)"pmgt-pmco-opplugin", (Object[])new Object[0]), contract.getString("billname"), proBudget.get("name"), costItem.getLocaleString("name")));
                                continue;
                            }
                            costItemIds.add(costItemId);
                            proBudgetMap.put(proBudgetId, costItemIds);
                        }
                    }
                    QFilter qFilter = new QFilter("project", "=", (Object)Long.parseLong(project.getPkValue().toString()));
                    qFilter.and("id", "!=", (Object)Long.parseLong(bill.getPkValue().toString()));
                    qFilter.and("billstatus", "=", (Object)StatusEnum.UNCHECKED.getValue());
                    DynamicObject[] submitBills = BusinessDataServiceHelper.load((String)"pmco_payapplycostsplit", (String)"id", (QFilter[])new QFilter[]{qFilter});
                    if (submitBills.length <= 0) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u9879\u76ee\u5b58\u5728\u5df2\u63d0\u4ea4\u72b6\u6001\u7684\u4ed8\u6b3e\u7533\u8bf7\u6210\u672c\u5f52\u96c6\u4e0e\u5206\u644a\u5355\uff0c\u4e0d\u53ef\u91cd\u590d\u63d0\u4ea4\u3002", (String)"PayApplyCostSplitOp_6", (String)"pmgt-pmco-opplugin", (Object[])new Object[0]));
                }
            }

            private void unAuditValidate() {
                ExtendedDataEntity[] dataEntities;
                for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                    DynamicObject[] lowerBills;
                    DynamicObject bill = dataEntity.getDataEntity();
                    DynamicObjectCollection costDetails = bill.getDynamicObjectCollection("costdetails");
                    if (costDetails.size() == 0) continue;
                    Set contractIdSet = costDetails.stream().map(o -> Long.parseLong(o.getDynamicObject("contract").getPkValue().toString())).collect(Collectors.toSet());
                    DynamicObject project = bill.getDynamicObject("project");
                    DynamicObject costDimension = bill.getDynamicObject("costdimension");
                    Date auditDate = bill.getDate("auditdate");
                    QFilter qFilter = new QFilter("project", "=", (Object)Long.parseLong(project.getPkValue().toString()));
                    qFilter.and("id", "!=", (Object)Long.parseLong(bill.getPkValue().toString()));
                    if (costDimension != null) {
                        qFilter.and("costdimension", "=", (Object)Long.parseLong(costDimension.getPkValue().toString()));
                    }
                    qFilter.and("createtime", ">", (Object)auditDate);
                    for (DynamicObject lowerBill : lowerBills = BusinessDataServiceHelper.load((String)"pmco_payapplycostsplit", (String)"contract", (QFilter[])new QFilter[]{qFilter})) {
                        DynamicObjectCollection lowerCostDetails = lowerBill.getDynamicObjectCollection("costdetails");
                        for (DynamicObject lowerCostDetail : lowerCostDetails) {
                            long contractId;
                            DynamicObject contract = lowerCostDetail.getDynamicObject("contract");
                            if (contract == null || !contractIdSet.contains(contractId = Long.parseLong(contract.getPkValue().toString()))) continue;
                            String errMsg = String.format(ResManager.loadKDString((String)"\u5408\u540c\u201c%1$s\u201d\u672c\u6b21\u5206\u644a\u6570\u636e\u5df2\u88ab\u540e\u7eed\u5355\u636e\u4f7f\u7528\u3002\u4e0d\u5141\u8bb8\u6267\u884c\u53cd\u5ba1\u6838\u64cd\u4f5c\u3002\u5efa\u8bae\u5220\u9664\u5ba1\u6279\u540e\u521b\u5efa\u7684\u540c\u7c7b\u5355\u636e\u3002", (String)"PayApplyCostSplitOp_7", (String)"pmgt-pmco-opplugin", (Object[])new Object[0]), contract.getString("billno"));
                            this.addErrorMessage(dataEntity, errMsg);
                        }
                    }
                }
            }
        });
    }
}

