/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmco.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmco.business.helper.ProCostSplitBudgetHelper;
import kd.pmgt.pmco.opplugin.validator.ProCostSplitBudgetValidator;
import org.apache.commons.collections4.CollectionUtils;

public class ProCostSplitEditOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("project");
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("billname");
        e.getFieldKeys().add("creator");
        e.getFieldKeys().add("createtime");
        e.getFieldKeys().add("auditor");
        e.getFieldKeys().add("auditdate");
        e.getFieldKeys().add("currency");
        e.getFieldKeys().add("enablemultipro");
        e.getFieldKeys().add("entryorg");
        e.getFieldKeys().add("entryproject");
        e.getFieldKeys().add("costamt");
        e.getFieldKeys().add("budgetitem");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        String operationKey = e.getOperationKey();
        block10: for (DynamicObject dataEntity : dataEntities) {
            switch (operationKey) {
                case "submit": {
                    this.setEntryField(dataEntity);
                    continue block10;
                }
                case "audit": {
                    this.updateBudgetCost(dataEntity, false);
                    continue block10;
                }
                case "unaudit": {
                    this.updateBudgetCost(dataEntity, true);
                    continue block10;
                }
            }
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        String operationKey = e.getOperationKey();
        for (DynamicObject dataEntity : dataEntities) {
            if (!StringUtils.equals((CharSequence)operationKey, (CharSequence)"submit") && !StringUtils.equals((CharSequence)operationKey, (CharSequence)"unsubmit") && !StringUtils.equals((CharSequence)operationKey, (CharSequence)"audit") && !StringUtils.equals((CharSequence)operationKey, (CharSequence)"unaudit")) continue;
            ProCostSplitBudgetHelper.updateProBudget((DynamicObject)dataEntity, (String)operationKey);
        }
    }

    private void setEntryField(DynamicObject dataEntity) {
        boolean enableMultiPro = dataEntity.getBoolean("enablemultipro");
        if (!enableMultiPro) {
            DynamicObjectCollection proCostSplitEntries = dataEntity.getDynamicObjectCollection("procostsplitentry");
            DynamicObject org = dataEntity.getDynamicObject("org");
            DynamicObject project = dataEntity.getDynamicObject("project");
            for (DynamicObject proCostSplitEntry : proCostSplitEntries) {
                proCostSplitEntry.set("entryorg", (Object)org);
                proCostSplitEntry.set("entryproject", (Object)project);
            }
        }
    }

    private void updateBudgetCost(DynamicObject dataEntity, boolean negate) {
        HashMap budgetCostMap = new HashMap(16);
        DynamicObjectCollection proCostSplitEntities = dataEntity.getDynamicObjectCollection("procostsplitentry");
        proCostSplitEntities.stream().filter(it -> it.getDynamicObject("budgetitem") != null).collect(Collectors.groupingBy(it -> it.getDynamicObject("budgetitem").getPkValue())).forEach((budgetId, proCostByBudget) -> {
            BigDecimal budgetCostAmt = proCostByBudget.stream().map(it -> it.getBigDecimal("costamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
            budgetCostMap.put(Long.parseLong(budgetId.toString()), budgetCostAmt);
        });
        HashMap projectBudgetMap = new HashMap(10);
        List<DynamicObject> updateBudgetList = budgetCostMap.entrySet().stream().map(entrySet -> this.doUpdateBudgetCost((Long)entrySet.getKey(), negate ? ((BigDecimal)entrySet.getValue()).negate() : (BigDecimal)entrySet.getValue(), projectBudgetMap)).flatMap(Collection::stream).collect(Collectors.toList());
        SaveServiceHelper.update((DynamicObject[])updateBudgetList.toArray(new DynamicObject[0]));
    }

    private List<DynamicObject> doUpdateBudgetCost(Long budgetId, BigDecimal budgetCost, Map<Long, DynamicObject> projectBudgetMap) {
        ArrayList<DynamicObject> projectBudgetList = new ArrayList<DynamicObject>(16);
        if (budgetId == 0L) {
            return projectBudgetList;
        }
        DynamicObject projectBudget = projectBudgetMap.get(budgetId);
        if (projectBudget == null && QueryServiceHelper.exists((String)"pmas_projectbudget", (Object)budgetId)) {
            projectBudget = BusinessDataServiceHelper.loadSingle((Object)budgetId, (String)"pmas_projectbudget");
            projectBudgetMap.put(budgetId, projectBudget);
            projectBudgetList.add(projectBudget);
            BigDecimal proCostAmt = projectBudget.getBigDecimal("procostamt");
            projectBudget.set("procostamt", (Object)proCostAmt.add(budgetCost));
            long parentBudgetId = projectBudget.getLong("parent");
            projectBudgetList.addAll(this.doUpdateBudgetCost(parentBudgetId, budgetCost, projectBudgetMap));
        }
        return projectBudgetList;
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                switch (this.getOperateKey()) {
                    case "submit": {
                        this.submitValidate();
                        break;
                    }
                    case "unaudit": {
                        this.unAuditValidate();
                        break;
                    }
                }
            }

            private void submitValidate() {
                ExtendedDataEntity[] dataEntities;
                for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                    DynamicObject entry;
                    boolean hasErr;
                    StringBuilder errMsg;
                    int i;
                    DynamicObject data = dataEntity.getDataEntity();
                    boolean enableMultiPro = data.getBoolean("enablemultipro");
                    DynamicObjectCollection entries = data.getDynamicObjectCollection("procostsplitentry");
                    if (enableMultiPro) {
                        for (i = 0; i < entries.size(); ++i) {
                            BigDecimal costAmt;
                            DynamicObject entryProject;
                            errMsg = new StringBuilder();
                            hasErr = false;
                            entry = (DynamicObject)entries.get(i);
                            errMsg.append(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u9879\u76ee\u7efc\u5408\u6210\u672c\u5206\u644a\u660e\u7ec6\u201d\uff0c\u7b2c%s\u884c\uff1a", (String)"ProCostSplitEditOp_8", (String)"pmgt-pmco-opplugin", (Object[])new Object[0]), i + 1));
                            DynamicObject entryOrg = entry.getDynamicObject("entryorg");
                            if (entryOrg == null) {
                                hasErr = true;
                                errMsg.append(String.format("\u201c%s\u201d", ((IDataEntityProperty)entry.getDataEntityType().getProperties().get((Object)"entryorg")).getDisplayName()));
                            }
                            if ((entryProject = entry.getDynamicObject("entryproject")) == null) {
                                hasErr = true;
                                errMsg.append(String.format("\u201c%s\u201d", ((IDataEntityProperty)entry.getDataEntityType().getProperties().get((Object)"entryproject")).getDisplayName()));
                            }
                            if ((costAmt = entry.getBigDecimal("costamt")) == null || costAmt.compareTo(BigDecimal.ZERO) == 0) {
                                hasErr = true;
                                errMsg.append(String.format("\u201c%s\u201d", ((IDataEntityProperty)entry.getDataEntityType().getProperties().get((Object)"costamt")).getDisplayName()));
                            }
                            if (!hasErr) continue;
                            this.addErrorMessage(dataEntity, errMsg.toString().concat("\u3002"));
                        }
                        continue;
                    }
                    if (data.getDynamicObject("project") == null) {
                        String projectErrMsg = String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%s\u201d\u3002", (String)"ProCostSplitEditOp_2", (String)"pmgt-pmco-opplugin", (Object[])new Object[0]), ((IDataEntityProperty)data.getDataEntityType().getProperties().get((Object)"project")).getDisplayName());
                        this.addErrorMessage(dataEntity, projectErrMsg);
                    }
                    for (i = 0; i < entries.size(); ++i) {
                        errMsg = new StringBuilder();
                        hasErr = false;
                        entry = (DynamicObject)entries.get(i);
                        BigDecimal costAmt = entry.getBigDecimal("costamt");
                        if (costAmt == null || costAmt.compareTo(BigDecimal.ZERO) == 0) {
                            errMsg.append(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u9879\u76ee\u7efc\u5408\u6210\u672c\u5206\u644a\u660e\u7ec6\u201d\uff0c\u7b2c%s\u884c\uff1a", (String)"ProCostSplitEditOp_8", (String)"pmgt-pmco-opplugin", (Object[])new Object[0]), i + 1));
                            hasErr = true;
                            errMsg.append(String.format("\u201c%s\u201d", ((IDataEntityProperty)entry.getDataEntityType().getProperties().get((Object)"costamt")).getDisplayName()));
                        }
                        if (!hasErr) continue;
                        this.addErrorMessage(dataEntity, errMsg.toString().concat("\u3002"));
                    }
                }
            }

            private void unAuditValidate() {
                ExtendedDataEntity[] dataEntities;
                for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                    DynamicObject data = dataEntity.getDataEntity();
                    long billId = Long.parseLong(data.getPkValue().toString());
                    DynamicObjectCollection proCostSlitEntities = data.getDynamicObjectCollection("procostsplitentry");
                    for (DynamicObject proCostSlitEntity : proCostSlitEntities) {
                        boolean needUpdateBudget = proCostSlitEntity.getBoolean("needupdatebudget");
                        if (needUpdateBudget) {
                            this.checkNeedUpdateBudget(dataEntity, billId);
                            continue;
                        }
                        this.checkNoNeedUpdateBudget(dataEntity, billId, proCostSlitEntity);
                    }
                }
            }

            private void checkNeedUpdateBudget(ExtendedDataEntity dataEntity, long billId) {
                String sql = "select fentryid sourceid from t_pmas_bugetperformentry where fbillid = " + billId;
                List billNoList = (List)DB.query((DBRoute)new DBRoute(EntityMetadataCache.getDataEntityType((String)"pmco_procostsplit").getDBRouteKey()), (String)sql, rs -> {
                    ArrayList<Long> result = new ArrayList<Long>(16);
                    if (rs.next()) {
                        result.add(rs.getLong("sourceid"));
                    }
                    return result;
                });
                if (!CollectionUtils.isEmpty((Collection)billNoList)) {
                    for (Long billNo : new HashSet(billNoList)) {
                        this.doCheck(dataEntity, billNo, dataEntity.getBillNo(), billNo);
                    }
                }
            }

            private void checkNoNeedUpdateBudget(ExtendedDataEntity dataEntity, long billId, DynamicObject proCostSlitEntity) {
                DynamicObjectCollection costSourceEntities = proCostSlitEntity.getDynamicObjectCollection("costsourceentity");
                for (DynamicObject costSourceEntity : costSourceEntities) {
                    long sourceId = costSourceEntity.getLong("sourceid");
                    String sourceDetailNo = costSourceEntity.getString("sourcenumber");
                    this.doCheck(dataEntity, billId, sourceDetailNo, sourceId);
                }
            }

            private void doCheck(ExtendedDataEntity dataEntity, long billId, String sourceDetailNo, long sourceId) {
                String sql = "select tpp.fbillno billno from t_pmco_procostsplit tpp, t_pmco_costsplitsubentry sub, t_pmco_procostsplitentry tppe where tpp.fid = tppe.fid and tppe.fentryid = sub.fentryid and sub.fsourceid = " + sourceId + " and tpp.fid != " + billId + " and tpp.fcreatetime > '" + dataEntity.getDataEntity().getDate("createtime") + "'";
                List billNoList = (List)DB.query((DBRoute)new DBRoute(EntityMetadataCache.getDataEntityType((String)"pmco_procostsplit").getDBRouteKey()), (String)sql, rs -> {
                    ArrayList<String> result = new ArrayList<String>(16);
                    if (rs.next()) {
                        result.add(rs.getString("billno"));
                    }
                    return result;
                });
                if (!CollectionUtils.isEmpty((Collection)billNoList)) {
                    StringBuilder errorMsgBuilder = new StringBuilder();
                    for (String billNo : billNoList) {
                        errorMsgBuilder.append("\u3010");
                        errorMsgBuilder.append(billNo);
                        errorMsgBuilder.append("\u3011");
                    }
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8d39\u7528\u6765\u6e90\u660e\u7ec6\u201c%1$s\u201d\u5df2\u88ab%2$s\u5f15\u7528\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"ProCostSplitEditOp_10", (String)"pmgt-pmco-opplugin", (Object[])new Object[0]), sourceDetailNo, errorMsgBuilder.toString()));
                }
            }
        });
        e.getValidators().add(new ProCostSplitBudgetValidator());
    }
}

