/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmco.opplugin;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class ProMappingCostOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("costsplitdetails");
        e.getFieldKeys().add("probudget");
        e.getFieldKeys().add("costdimension");
        e.getFieldKeys().add("costitem");
        e.getFieldKeys().add("issave");
        e.getFieldKeys().add("isleaf");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                switch (this.getOperateKey()) {
                    case "save": 
                    case "submit": {
                        this.saveOrSubmitValidate();
                        break;
                    }
                }
            }

            private void saveOrSubmitValidate() {
                ExtendedDataEntity[] dataEntities;
                for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                    DynamicObject data = dataEntity.getDataEntity();
                    DynamicObjectCollection costDetails = data.getDynamicObjectCollection("costsplitdetails");
                    HashMap proBudgetMap = new HashMap(16);
                    for (DynamicObject detail : costDetails) {
                        boolean isLeaf = detail.getBoolean("isleaf");
                        if (!isLeaf) continue;
                        DynamicObject proBudget = detail.getDynamicObject("probudget");
                        DynamicObject costDimension = detail.getDynamicObject("costdimension");
                        DynamicObject costItem = detail.getDynamicObject("costitem");
                        StringBuffer errMsg = new StringBuffer();
                        String operateKey = this.getOperateKey();
                        if ("submit".equals(operateKey)) {
                            if (proBudget == null) {
                                errMsg.append(ResManager.loadKDString((String)"\u6210\u672c\u9879\u6620\u5c04\u660e\u7ec6\u201c\u9884\u7b97\u9879\u201d\u5217\u5b58\u5728\u672a\u5f55\u6570\u636e\uff0c\u8bf7\u586b\u5199\u3002", (String)"ProMappingCostOp_4", (String)"pmgt-pmco-opplugin", (Object[])new Object[0]));
                            }
                            if (costDimension == null) {
                                if (StringUtils.isNotBlank((CharSequence)errMsg)) {
                                    errMsg.append("\n");
                                }
                                errMsg.append(ResManager.loadKDString((String)"\u6210\u672c\u9879\u6620\u5c04\u660e\u7ec6\u201c\u6210\u672c\u7ef4\u5ea6\u201d\u5217\u5b58\u5728\u672a\u5f55\u6570\u636e\uff0c\u8bf7\u586b\u5199\u3002", (String)"ProMappingCostOp_5", (String)"pmgt-pmco-opplugin", (Object[])new Object[0]));
                            }
                            if (costItem == null) {
                                if (StringUtils.isNotBlank((CharSequence)errMsg)) {
                                    errMsg.append("\n");
                                }
                                errMsg.append(ResManager.loadKDString((String)"\u6210\u672c\u9879\u6620\u5c04\u660e\u7ec6\u201c\u6210\u672c\u9879\u201d\u5217\u5b58\u5728\u672a\u5f55\u6570\u636e\uff0c\u8bf7\u586b\u5199\u3002", (String)"ProMappingCostOp_6", (String)"pmgt-pmco-opplugin", (Object[])new Object[0]));
                            }
                            if (StringUtils.isNotBlank((CharSequence)errMsg)) {
                                this.addErrorMessage(dataEntity, errMsg.toString());
                                return;
                            }
                        }
                        if (proBudget == null || costItem == null) continue;
                        long proBudgetId = Long.parseLong(proBudget.getPkValue().toString());
                        long costItemId = Long.parseLong(costItem.getPkValue().toString());
                        HashSet<Long> costItemIds = (HashSet<Long>)proBudgetMap.get(proBudgetId);
                        if (costItemIds == null) {
                            costItemIds = new HashSet<Long>();
                            costItemIds.add(costItemId);
                        } else if (costItemIds.contains(costItemId)) {
                            proBudget = BusinessDataServiceHelper.loadSingle((Object)proBudgetId, (String)"pmas_projectbudget", (String)"name");
                            costItem = BusinessDataServiceHelper.loadSingle((Object)costItemId, (String)"pmbs_costitem", (String)"name");
                            errMsg = new StringBuffer(String.format(ResManager.loadKDString((String)"\u9884\u7b97\u9879\u201c%1$s\u201d\u3001\u6210\u672c\u9879\u201c%2$s\u201d\u7b49\u5b57\u6bb5\u7684\u7ec4\u5408\u503c\u5b58\u5728\u91cd\u590d\u3002\u8bf7\u786e\u8ba4\u6807\u51c6\u9884\u7b97\u9879\u662f\u5426\u5df2\u7ecf\u6620\u5c04\uff0c\u907f\u514d\u91cd\u590d\u6620\u5c04\u3002", (String)"ProMappingCostOp_7", (String)"pmgt-pmco-opplugin", (Object[])new Object[0]), proBudget.get("name"), costItem.getLocaleString("name")));
                            this.addErrorMessage(dataEntity, errMsg.toString());
                        } else {
                            costItemIds.add(costItemId);
                        }
                        proBudgetMap.put(proBudgetId, costItemIds);
                    }
                }
            }
        });
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        String operationKey = e.getOperationKey();
        block7: for (DynamicObject dataEntity : dataEntities) {
            switch (operationKey) {
                case "save": 
                case "submit": {
                    DynamicObjectCollection details = dataEntity.getDynamicObjectCollection("costsplitdetails");
                    if (details.size() <= 0) continue block7;
                    Iterator iterator = details.iterator();
                    while (iterator.hasNext()) {
                        DynamicObject rowEntity = (DynamicObject)iterator.next();
                        boolean ifLeaf = rowEntity.getBoolean("isleaf");
                        boolean ifSave = rowEntity.getBoolean("issave");
                        if (!ifLeaf) {
                            iterator.remove();
                            continue;
                        }
                        if (ifSave) continue;
                        iterator.remove();
                    }
                    continue block7;
                }
            }
        }
    }
}

