/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmco.opplugin.validator;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.common.enums.StatusEnum;

public class BudgetDataInitValidator
extends AbstractValidator {
    public void validate() {
        String operateKey = this.getOperateKey();
        if ("submit".equals(operateKey)) {
            this.budgetValidate();
        }
    }

    private void budgetValidate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            DynamicObject data = dataEntity.getDataEntity();
            DynamicObject project = data.getDynamicObject("project");
            QFilter statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
            QFilter projectFilter = new QFilter("project", "=", project.getPkValue());
            DynamicObject budgetDataInit = BusinessDataServiceHelper.loadSingle((String)"budget_data_init", (QFilter[])new QFilter[]{projectFilter, statusFilter});
            if (budgetDataInit != null) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u9879\u76ee\u521d\u59cb\u5316\u9884\u7b97\u6570\u636e\u5df2\u5f55\u5165\uff0c\u65e0\u9700\u91cd\u590d\u5f55\u5165\u3002", (String)"BudgetDataInitValidator_3", (String)"pmgt-pmco-opplugin", (Object[])new Object[0]), project.getString("name")));
                continue;
            }
            DynamicObjectCollection entryEntity = data.getDynamicObjectCollection("treeentryentity");
            if (entryEntity.isEmpty()) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u672a\u6709\u4efb\u4f55\u9884\u7b97\u6570\u636e\uff0c\u65e0\u6548\u63d0\u4ea4\u3002", (String)"BudgetDataInitValidator_0", (String)"pmgt-pmco-opplugin", (Object[])new Object[0]));
                continue;
            }
            for (DynamicObject entry : entryEntity) {
                BigDecimal yearBudgetAmt;
                BigDecimal useAmt;
                BigDecimal budgetAmt;
                boolean leaf = entry.getBoolean("leaf");
                if (!leaf) continue;
                BigDecimal occupyAmt = entry.getBigDecimal("entryinitoccupyamt");
                if (occupyAmt.compareTo(budgetAmt = entry.getBigDecimal("budgetamt")) > 0) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1s\u5355\u636e\u3010\u9884\u7b97\u660e\u7ec6\u3011\u5206\u5f55\u4e2d\u7b2c%2s\u884c\u7684\u201c\u521d\u59cb\u5316\u5360\u7528\u91d1\u989d\u201d\u503c\u5927\u4e8e\u603b\u9884\u7b97\u91d1\u989d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BudgetDataInitValidator_1", (String)"pmgt-pmco-opplugin", (Object[])new Object[0]), data.getString("billno"), entry.getInt("seq")));
                }
                if ((useAmt = entry.getBigDecimal("entryinituseamt")).compareTo(yearBudgetAmt = entry.getBigDecimal("yearbudgetamt")) <= 0) continue;
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1s\u5355\u636e\u3010\u9884\u7b97\u660e\u7ec6\u3011\u5206\u5f55\u4e2d\u7b2c%2s\u884c\u7684\u201c\u521d\u59cb\u5316\u4f7f\u7528\u91d1\u989d\u201d\u503c\u5927\u4e8e\u5e74\u5ea6\u9884\u7b97\u91d1\u989d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BudgetDataInitValidator_2", (String)"pmgt-pmco-opplugin", (Object[])new Object[0]), data.getString("billno"), entry.getInt("seq")));
            }
        }
    }
}

