/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmco.opplugin.validator;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pmgt.pmbs.common.enums.BudgetControlTargetEnum;

public class BudgetDataRelSubmitValidator
extends AbstractValidator {
    public void validate() {
        String operateKey = this.getOperateKey();
        if ("submit".equals(operateKey)) {
            this.budgetSubmitValidate();
        }
    }

    private void budgetSubmitValidate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            DynamicObject data = dataEntity.getDataEntity();
            DynamicObjectCollection entryEntity = data.getDynamicObjectCollection("entryentity");
            if (entryEntity.isEmpty()) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u672a\u6709\u4efb\u4f55\u9884\u7b97\u6570\u636e\uff0c\u65e0\u6548\u63d0\u4ea4\u3002", (String)"BudgetDataRelSubmitValidator_0", (String)"pmgt-pmco-opplugin", (Object[])new Object[0]));
                continue;
            }
            List billPkList = entryEntity.stream().map(dyn -> dyn.getString("entrybillpk")).collect(Collectors.toList());
            QFilter billFilter = new QFilter("billid", "in", billPkList);
            QFilter effectFilter = new QFilter("iseffect", "=", (Object)Boolean.TRUE);
            DynamicObjectCollection hasExeRecordBillList = QueryServiceHelper.query((String)"pmas_budgetexerecord", (String)"billid", (QFilter[])new QFilter[]{billFilter, effectFilter});
            Set hasExeRecordBillSet = hasExeRecordBillList.stream().map(dyn -> dyn.getLong("billid")).collect(Collectors.toSet());
            List projectIdList = entryEntity.stream().flatMap(dyn -> dyn.getDynamicObjectCollection("billprojectlist").stream()).map(list -> list.getDynamicObject("fbasedataid").getPkValue()).distinct().collect(Collectors.toList());
            QFilter totalProjectFilter = new QFilter("tproject", "in", projectIdList);
            DynamicObjectCollection totalProjectCtrlList = QueryServiceHelper.query((String)"pmas_totalbudgetctrl", (String)"tproject", (QFilter[])new QFilter[]{totalProjectFilter});
            List totalProjectCtrlIdList = totalProjectCtrlList.stream().map(dyn -> dyn.getLong("tproject")).collect(Collectors.toList());
            QFilter yearProjectFilter = new QFilter("yproject", "in", projectIdList);
            DynamicObjectCollection yearProjectCtrlList = QueryServiceHelper.query((String)"pmas_ybudgetctrl", (String)String.join((CharSequence)",", "yproject", "yyear"), (QFilter[])new QFilter[]{yearProjectFilter});
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
            Map yearProjectCtrlIdMap = yearProjectCtrlList.stream().collect(Collectors.groupingBy(dyn -> dyn.getLong("yproject"), Collectors.mapping(dyn -> Integer.parseInt(sdf.format(dyn.getDate("yyear"))), Collectors.toList())));
            for (DynamicObject entity : entryEntity) {
                String controlTarget = entity.getString("controltarget");
                DynamicObjectCollection billProjectList = entity.getDynamicObjectCollection("billprojectlist");
                if (billProjectList.isEmpty()) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u7f16\u53f7%s\u5355\u636e\u4e2d\u4e0d\u5305\u542b\u4efb\u4f55\u9879\u76ee\u4fe1\u606f\uff0c\u65e0\u6cd5\u521d\u59cb\u5316\u3002", (String)"BudgetDataRelSubmitValidator_5", (String)"pmgt-pmco-opplugin", (Object[])new Object[0]), entity.getString("entrybillno")));
                    continue;
                }
                long billPk = entity.getLong("entrybillpk");
                if (hasExeRecordBillSet.contains(billPk)) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u7f16\u53f7%s\u5355\u636e\u5df2\u7ecf\u521d\u59cb\u5316\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u5173\u8054\u3002", (String)"BudgetDataRelSubmitValidator_2", (String)"pmgt-pmco-opplugin", (Object[])new Object[0]), entity.getString("entrybillno")));
                    continue;
                }
                Date entrydate = entity.getDate("entrydate");
                int entryDateInt = entrydate != null ? Integer.parseInt(sdf.format(entrydate)) : 0;
                for (DynamicObject project : billProjectList) {
                    List yearCtrlList;
                    long projectId = project.getDynamicObject("fbasedataid").getLong("id");
                    if (BudgetControlTargetEnum.BUDGETOCCUPY.getValue().equals(controlTarget)) {
                        if (totalProjectCtrlIdList.contains(projectId)) continue;
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u7f16\u53f7%1s\u5355\u636e\u65e0\u6cd5\u521d\u59cb\u5316\uff0c\u56e0\u4e3a\uff1a\u9879\u76ee%2s\u672a\u7f16\u5236\u603b\u4f53\u9884\u7b97\u3002", (String)"BudgetDataRelSubmitValidator_3", (String)"pmgt-pmco-opplugin", (Object[])new Object[0]), entity.getString("entrybillno"), project.getDynamicObject("fbasedataid").getString("name")));
                        continue;
                    }
                    if (BudgetControlTargetEnum.BUDGETUSE.getValue().equals(controlTarget)) {
                        yearCtrlList = yearProjectCtrlIdMap.get(projectId);
                        if (!yearCtrlList.isEmpty() && yearCtrlList.contains(entryDateInt)) continue;
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u7f16\u53f7%1s\u5355\u636e\u65e0\u6cd5\u521d\u59cb\u5316\uff0c\u56e0\u4e3a\uff1a\u9879\u76ee%2s\u672a\u7f16\u5236%3s\u5e74\u9884\u7b97\u3002", (String)"BudgetDataRelSubmitValidator_4", (String)"pmgt-pmco-opplugin", (Object[])new Object[0]), entity.getString("entrybillno"), project.getDynamicObject("fbasedataid").getString("name"), entryDateInt));
                        continue;
                    }
                    if (!BudgetControlTargetEnum.BUDGETOCCUPYANDUSE.getValue().equals(controlTarget)) continue;
                    if (!totalProjectCtrlIdList.contains(projectId)) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u7f16\u53f7%1s\u5355\u636e\u65e0\u6cd5\u521d\u59cb\u5316\uff0c\u56e0\u4e3a\uff1a\u9879\u76ee%2s\u672a\u7f16\u5236\u603b\u4f53\u9884\u7b97\u3002", (String)"BudgetDataRelSubmitValidator_3", (String)"pmgt-pmco-opplugin", (Object[])new Object[0]), entity.getString("entrybillno"), project.getDynamicObject("fbasedataid").getString("name")));
                    }
                    if (!(yearCtrlList = yearProjectCtrlIdMap.get(projectId)).isEmpty() && yearCtrlList.contains(entryDateInt)) continue;
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u7f16\u53f7%1s\u5355\u636e\u65e0\u6cd5\u521d\u59cb\u5316\uff0c\u56e0\u4e3a\uff1a\u9879\u76ee%2s\u672a\u7f16\u5236%3s\u5e74\u9884\u7b97\u3002", (String)"BudgetDataRelSubmitValidator_4", (String)"pmgt-pmco-opplugin", (Object[])new Object[0]), entity.getString("entrybillno"), project.getDynamicObject("fbasedataid").getString("name"), entryDateInt));
                }
            }
        }
    }
}

