/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmco.opplugin.validator;

import java.math.RoundingMode;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.pmgt.pmbs.common.utils.budget.BudgetValidateInfo;
import kd.pmgt.pmco.business.helper.ProCostSplitBudgetHelper;

public class ProCostSplitBudgetValidator
extends AbstractValidator {
    public void validate() {
        this.budgetValidate();
    }

    private void budgetValidate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            BudgetValidateInfo validateInfo = ProCostSplitBudgetHelper.validateBudget((ExtendedDataEntity)dataEntity, (String)this.getOperateKey());
            StringBuilder msg = new StringBuilder();
            if (validateInfo == null) continue;
            boolean outOfControl = validateInfo.isOutOfControl();
            boolean outOfRemind = validateInfo.isOutOfRemind();
            int amtPrecision = 2;
            Map resultMap = validateInfo.getResultMap();
            for (Map.Entry resultEntry : resultMap.entrySet()) {
                DynamicObject originalBudget = (DynamicObject)resultEntry.getKey();
                DynamicObject validateBudget = (DynamicObject)resultEntry.getValue();
                if (originalBudget.getPkValue().equals(validateBudget.getPkValue())) {
                    if (outOfControl) {
                        msg.append(String.format(ResManager.loadKDString((String)"\u9884\u7b97\u9879\u201c%s\u201d\u7684\u7d2f\u8ba1\u91d1\u989d\u5df2\u7ecf\u8d85\u51fa\u63a7\u5236\u9650\u989d\u3002", (String)"ProCostSplitBudgetValidator_0", (String)"pmgt-pmco-opplugin", (Object[])new Object[0]), originalBudget.getString("name")));
                        msg.append("\r\n");
                        continue;
                    }
                    if (!outOfRemind) continue;
                    msg.append(String.format(ResManager.loadKDString((String)"\u9884\u7b97\u9879\u201c%1$s\u201d\u7684\u7d2f\u8ba1\u91d1\u989d\u5df2\u7ecf\u8fbe\u5230%2$s\uff0c\u9884\u7b97\u91d1\u989d\u662f%3$s\u3002", (String)"ProCostSplitBudgetValidator_1", (String)"pmgt-pmco-opplugin", (Object[])new Object[0]), originalBudget.getString("name"), originalBudget.getBigDecimal("occupyamt").setScale(amtPrecision, RoundingMode.DOWN).toString(), originalBudget.getBigDecimal("budgetamount").setScale(amtPrecision, RoundingMode.DOWN).toString()));
                    msg.append("\r\n");
                    continue;
                }
                if (outOfControl) {
                    msg.append(String.format(ResManager.loadKDString((String)"\u9884\u7b97\u9879\u201c%1$s\u201d\u7684\u4e0a\u7ea7\u9884\u7b97\u9879\u201c%2$s\u201d\u7684\u7d2f\u8ba1\u91d1\u989d\u5df2\u7ecf\u8d85\u51fa\u63a7\u5236\u9650\u989d\u3002", (String)"ProCostSplitBudgetValidator_2", (String)"pmgt-pmco-opplugin", (Object[])new Object[0]), originalBudget.getString("name"), validateBudget.getString("name")));
                    msg.append("\r\n");
                    continue;
                }
                if (!outOfRemind) continue;
                msg.append(String.format(ResManager.loadKDString((String)"\u9884\u7b97\u9879\u201c%1$s\u201d\u7684\u4e0a\u7ea7\u9884\u7b97\u9879\u201c%2$s\u201d\u7684\u7d2f\u8ba1\u91d1\u989d\u5df2\u7ecf\u8fbe\u5230%3$s\uff0c\u9884\u7b97\u91d1\u989d\u662f%4$s\u3002", (String)"ProCostSplitBudgetValidator_3", (String)"pmgt-pmco-opplugin", (Object[])new Object[0]), originalBudget.getString("name"), validateBudget.getString("name"), validateBudget.getBigDecimal("occupyamt").setScale(amtPrecision, RoundingMode.DOWN).toString(), validateBudget.getBigDecimal("budgetamount").setScale(amtPrecision, RoundingMode.DOWN).toString()));
                msg.append("\r\n");
            }
            if (!StringUtils.isNotEmpty((CharSequence)msg.toString())) continue;
            if (outOfControl) {
                this.addErrorMessage(dataEntity, msg.toString());
            }
            if (!outOfRemind) continue;
            this.addWarningMessage(dataEntity, msg.toString());
        }
    }
}

