/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmco.formplugin;

import java.util.EventObject;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.common.enums.BudgetSourceTypeEnum;
import kd.pmgt.pmco.formplugin.base.AbstractPmcoBillPlugin;

public class BudgetControlSettingEditPlugin
extends AbstractPmcoBillPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit proBudgetItem = (BasedataEdit)this.getControl("probudgetitem");
        proBudgetItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit orgBudgetItem = (BasedataEdit)this.getControl("orgbudgetitem");
        orgBudgetItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String propName = beforeF7SelectEvent.getProperty().getName();
        if (StringUtils.equals((CharSequence)propName, (CharSequence)"probudgetitem")) {
            DynamicObject project = this.getModel().getDataEntity().getDynamicObject("project");
            if (project == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9879\u76ee\u3002", (String)"BudgetControlSettingEditPlugin_0", (String)"pmgt-pmco-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            QFilter sourceTypeFilter = new QFilter("sourcetype", "!=", (Object)BudgetSourceTypeEnum.IN.getValue());
            QFilter projectFilter = new QFilter("project", "=", project.getPkValue());
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showParameter.setCustomParam("notonlyleaf", (Object)"1");
            DynamicObjectCollection budgetEntryCol = this.getModel().getEntryEntity("budgetcontrolentry");
            HashSet<Object> proBudgetIdSet = new HashSet<Object>(16);
            for (DynamicObject budgetEntry : budgetEntryCol) {
                DynamicObject proBudgetItem = budgetEntry.getDynamicObject("probudgetitem");
                if (proBudgetItem == null) continue;
                proBudgetIdSet.add(proBudgetItem.getPkValue());
            }
            QFilter proBudgetIdFilter = new QFilter("id", "not in", proBudgetIdSet);
            showParameter.getListFilterParameter().getQFilters().add(projectFilter.and(proBudgetIdFilter).and(sourceTypeFilter));
        } else if (StringUtils.equals((CharSequence)propName, (CharSequence)"orgbudgetitem")) {
            DynamicObjectCollection budgetEntryCol = this.getModel().getEntryEntity("budgetcontrolentry");
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            HashSet<Object> orgBudgetIdSet = new HashSet<Object>(16);
            for (DynamicObject budgetEntry : budgetEntryCol) {
                DynamicObject orgBudgetItem = budgetEntry.getDynamicObject("orgbudgetitem");
                if (orgBudgetItem == null) continue;
                orgBudgetIdSet.add(orgBudgetItem.getPkValue());
            }
            QFilter budgetIdFilter = new QFilter("id", "not in", orgBudgetIdSet);
            showParameter.getListFilterParameter().getQFilters().add(budgetIdFilter);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        ChangeData changeData = changeSet[0];
        int rowIndex = changeData.getRowIndex();
        Object newValue = changeData.getNewValue();
        Object oldValue = changeData.getOldValue();
        if (StringUtils.equals((CharSequence)"probudgetitem", (CharSequence)propName)) {
            if (newValue == null) {
                return;
            }
            DynamicObject newProBudget = (DynamicObject)newValue;
            DynamicObjectCollection budgetControlEntryCol = this.getModel().getEntryEntity("budgetcontrolentry");
            int size = budgetControlEntryCol.size();
            for (int i = 0; i < size; ++i) {
                DynamicObject budgetControl;
                long proBudgetItemId;
                if (rowIndex == i || (proBudgetItemId = (budgetControl = (DynamicObject)budgetControlEntryCol.get(i)).getLong("probudgetitem_id")) == 0L || newProBudget.getLong("id") != proBudgetItemId) continue;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u9879\u76ee\u9884\u7b97\u9879\u5df2\u5b58\u5728\uff1a%s\u3002", (String)"BudgetControlSettingEditPlugin_3", (String)"pmgt-pmco-formplugin", (Object[])new Object[0]), newProBudget.getString("name")));
                this.getModel().setValue("probudgetitem", oldValue, rowIndex);
            }
        } else if (StringUtils.equals((CharSequence)"controltype", (CharSequence)propName)) {
            if (newValue == null) {
                return;
            }
            if ("0".equals(newValue.toString())) {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"org"});
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (StringUtils.equals((CharSequence)"enable", (CharSequence)operateKey) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            DynamicObjectCollection ctrlEntryCol = this.getModel().getEntryEntity("budgetcontrolentry");
            SaveServiceHelper.update((DynamicObject[])((DynamicObject[])ctrlEntryCol.toArray((Object[])new DynamicObject[ctrlEntryCol.size()])));
        }
    }
}

