/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmco.formplugin;

import java.util.EventObject;
import java.util.Iterator;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.pmgt.pmbs.formplugin.base.AbstractPmgtBillPlugin;
import kd.pmgt.pmco.business.helper.BudgetDataRelHelper;

public class BudgetDataRelEditPlugin
extends AbstractPmgtBillPlugin
implements HyperLinkClickListener,
RowClickEventListener {
    private static final Log log = LogFactory.getLog(BudgetDataRelEditPlugin.class);
    private static final String ENTRY_BILL_NO_SELECT = "entry_bill_no_select";
    private static final String BILL_NO_CLOSE_CALL_BACK = "bill_no_close_call_back";

    public void registerListener(EventObject e) {
        try {
            EntryGrid grid;
            super.registerListener(e);
            TextEdit entryBillNoEdit = (TextEdit)this.getControl("entrybillno");
            if (entryBillNoEdit != null) {
                entryBillNoEdit.addClickListener((ClickListener)this);
            }
            if ((grid = (EntryGrid)this.getControl("entryentity")) != null) {
                grid.addHyperClickListener((HyperLinkClickListener)this);
            }
        }
        catch (Exception exception) {
            log.error((Throwable)exception);
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        try {
            super.beforeClick(evt);
            int currentRow = BudgetDataRelHelper.getCurrentRow((IFormView)this.getView());
            Object budgetRegister = this.getModel().getValue("budgetregist", currentRow);
            if (budgetRegister == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e1a\u52a1\u5355\u636e\u9884\u7b97\u6ce8\u518c\u65b9\u6848\u3002", (String)"BudgetDataRelEditPlugin_0", (String)"pmgt-pmco-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        }
        catch (Exception exception) {
            log.error((Throwable)exception);
        }
    }

    public void click(EventObject evt) {
        try {
            super.click(evt);
            Control c = (Control)evt.getSource();
            String key = c.getKey().toLowerCase();
            if (key.equals("entrybillno")) {
                BudgetDataRelHelper.clickBill((IFormView)this.getView(), (IFormPlugin)this);
            }
        }
        catch (Exception exception) {
            log.error((Throwable)exception);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        try {
            super.closedCallBack(event);
            String actionId = event.getActionId();
            if (ENTRY_BILL_NO_SELECT.equals(actionId)) {
                BudgetDataRelHelper.selectBill((ClosedCallBackEvent)event, (IFormView)this.getView());
            }
        }
        catch (Exception exception) {
            log.error((Throwable)exception);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        try {
            super.propertyChanged(e);
            String propName = e.getProperty().getName();
            ChangeData changeData = e.getChangeSet()[0];
            Object newValue = changeData.getNewValue();
            Object oldValue = changeData.getOldValue();
            int currentRow = BudgetDataRelHelper.getCurrentRow((IFormView)this.getView());
            String isCallback = this.getPageCache().get(BILL_NO_CLOSE_CALL_BACK);
            switch (propName) {
                case "project": {
                    String projectName;
                    boolean checkResult = BudgetDataRelHelper.checkProject((DynamicObject)((DynamicObject)newValue), (IFormView)this.getView());
                    if (!checkResult) {
                        this.getModel().setValue("project", oldValue);
                        return;
                    }
                    BudgetDataRelHelper.loadDataByProject((DynamicObject)((DynamicObject)newValue), (IFormView)this.getView());
                    String billName = (String)this.getModel().getValue("billname");
                    DynamicObject project = (DynamicObject)newValue;
                    String string = projectName = project != null ? project.getString("name") : "";
                    if (newValue == null || billName == null || !billName.isEmpty() && billName.contains(projectName)) break;
                    String splitStr = ResManager.loadKDString((String)"\u9884\u7b97\u6570\u636e\u521d\u59cb\u5316\u5173\u8054", (String)"BudgetDataRelEditPlugin_2", (String)"pmgt-pmco-formplugin", (Object[])new Object[0]);
                    billName = project.getString("name") + splitStr;
                    this.getModel().setValue("billname", (Object)billName);
                    break;
                }
                case "year": {
                    BudgetDataRelHelper.loadDataByProject((DynamicObject)((DynamicObject)this.getModel().getValue("project")), (IFormView)this.getView());
                    break;
                }
                case "amt": {
                    BudgetDataRelHelper.autoSumAmount((IFormView)this.getView());
                    break;
                }
                case "budgetregist": {
                    if (isCallback != null) break;
                    this.getModel().setValue("entrybillno", null, currentRow);
                    break;
                }
                case "entrybillno": {
                    if (isCallback != null || newValue != null && !Objects.equals(newValue.toString(), "")) break;
                    this.getModel().setValue("billprojectlist", null, currentRow);
                    break;
                }
            }
        }
        catch (Exception exception) {
            log.error((Throwable)exception);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        try {
            String fieldName = event.getFieldName();
            if (StringUtils.equals((CharSequence)"entrybillno", (CharSequence)fieldName)) {
                BudgetDataRelHelper.linkClickBill((HyperLinkClickEvent)event, (IFormView)this.getView());
            }
        }
        catch (Exception exception) {
            log.error((Throwable)exception);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (operateKey.equals("submit")) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            boolean hasEmptyProject = false;
            for (DynamicObject entity : entryEntity) {
                DynamicObjectCollection billProjectList = entity.getDynamicObjectCollection("billprojectlist");
                if (!billProjectList.isEmpty()) continue;
                hasEmptyProject = true;
                break;
            }
            if (hasEmptyProject) {
                ConfirmCallBackListener callBack = new ConfirmCallBackListener("submit", (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u9884\u7b97\u660e\u7ec6\u5b58\u5728\u9879\u76ee\u4e3a\u7a7a\u7684\u6570\u636e\uff0c\u662f\u5426\u9700\u8981\u81ea\u52a8\u6e05\u9664\u65e0\u9879\u76ee\u6570\u636e\u5e76\u63d0\u4ea4\uff1f", (String)"BudgetDataRelEditPlugin_3", (String)"pmgt-pmco-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, callBack);
                args.setCancel(true);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        MessageBoxResult result;
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        if ("submit".equals(callBackId) && (result = event.getResult()).getValue() == MessageBoxResult.Yes.getValue()) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            Iterator iterator = entryEntity.iterator();
            while (iterator.hasNext()) {
                DynamicObject next = (DynamicObject)iterator.next();
                DynamicObjectCollection billProjectList = next.getDynamicObjectCollection("billprojectlist");
                if (!billProjectList.isEmpty()) continue;
                iterator.remove();
            }
            this.getModel().updateEntryCache(entryEntity);
            this.getView().updateView("entryentity");
            this.getView().invokeOperation("submit");
        }
    }
}

