/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmco.formplugin;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.EventObject;
import java.util.List;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.SubEntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.AmountEdit;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.pmgt.pmbs.business.helper.ContractHelper;
import kd.pmgt.pmbs.business.helper.ProBudgetControlHelper;
import kd.pmgt.pmbs.business.helper.ProjectHelper;
import kd.pmgt.pmbs.common.enums.BudgetSourceTypeEnum;
import kd.pmgt.pmbs.common.utils.DetailBillUtils;
import kd.pmgt.pmbs.common.utils.ProjectPermissionHelper;
import kd.pmgt.pmbs.common.utils.SystemParamHelper;
import kd.pmgt.pmco.business.helper.ContractCostHelper;
import kd.pmgt.pmco.formplugin.base.AbstractPmcoBillPlugin;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ContractCostBillPlugin
extends AbstractPmcoBillPlugin
implements BeforeF7SelectListener {
    private static final Log LOGGER = LogFactory.getLog(ContractCostBillPlugin.class);
    public static final String AUTO_GET_DATA = "autogetdata";
    public static final String NEWSUBENTRY = "newsubentry";
    public static final String DELETESUBENTRY = "deletesubentry";
    private static final String EXPORTSETTLEDETAIL = "exportsettledetail";

    public void registerListener(EventObject e) {
        BasedataEdit costItem;
        BasedataEdit costDimension;
        BasedataEdit budgetItem;
        BasedataEdit project;
        super.registerListener(e);
        BasedataEdit contract = (BasedataEdit)this.getView().getControl("contract");
        if (contract != null) {
            contract.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            contract.addBeforeF7ViewDetailListener(beforeF7ViewDetailEvent -> {
                beforeF7ViewDetailEvent.setCancel(true);
                this.getView().showForm((FormShowParameter)DetailBillUtils.viewDetail((String)"pmct_outcontract", (Object)beforeF7ViewDetailEvent.getPkId()));
            });
        }
        if ((project = (BasedataEdit)this.getView().getControl("project")) != null) {
            project.addBeforeF7ViewDetailListener(beforeF7ViewDetailEvent -> {
                beforeF7ViewDetailEvent.setCancel(true);
                this.getView().showForm((FormShowParameter)ProjectHelper.getProjectDetailShowParameter((Object)beforeF7ViewDetailEvent.getPkId()));
            });
        }
        if ((budgetItem = (BasedataEdit)this.getView().getControl("budgetitem")) != null) {
            budgetItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((costDimension = (BasedataEdit)this.getView().getControl("costdimension")) != null) {
            costDimension.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((costItem = (BasedataEdit)this.getView().getControl("costitem")) != null) {
            costItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        QFilter monthFilter;
        LocalDate now = LocalDate.now();
        int year = now.getYear();
        int month = now.getMonthValue();
        QFilter yearFilter = new QFilter("periodyear", "=", (Object)year);
        DynamicObject[] peridArr = BusinessDataServiceHelper.load((String)"bd_period", (String)"number,name,periodyear,periodnumber", (QFilter[])new QFilter[]{yearFilter, monthFilter = new QFilter("periodnumber", "=", (Object)month)});
        if (peridArr != null && peridArr.length > 0) {
            DynamicObject period = peridArr[0];
            this.getModel().setValue("period", (Object)period);
        }
    }

    public void afterBindData(EventObject e) {
        SubEntryGrid costSplitDetails;
        super.afterBindData(e);
        Object parameter = SystemParamHelper.getSystemParameter((String)"mustinputcostitem", (String)"pmbs", (Long)OrgUnitServiceHelper.getRootOrgId());
        boolean mustInput = parameter == null || (Boolean)parameter != false;
        FieldEdit costDimension = (FieldEdit)this.getControl("costdimension");
        if (costDimension != null) {
            costDimension.setMustInput(mustInput);
        }
        if ((costSplitDetails = (SubEntryGrid)this.getView().getControl("subentryentity")) != null) {
            costSplitDetails.setMustInput("costitem", mustInput);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (key = formOperate.getOperateKey()) {
            case "autogetdata": {
                if (!ContractCostHelper.judgeCondition((IFormView)this.getView())) break;
                ContractCostHelper.loadSettleInfo((IFormView)this.getView());
                ContractCostHelper.setCostAmt((IDataModel)this.getModel());
                break;
            }
            case "newsubentry": {
                int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
                int rowCount = this.getModel().getEntryRowCount("entryentity");
                if (rowCount > 0 && rowIndex >= 0) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u5408\u540c\u7ed3\u7b97\u660e\u7ec6\u3002", (String)"ContractCostBillPlugin_12", (String)"pmgt-pmco-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
            case "deletesubentry": {
                int subEntryIndex = this.getModel().getEntryCurrentRowIndex("subentryentity");
                if (subEntryIndex < 0) break;
                int parentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
                BigDecimal totalAmt = ContractCostHelper.sumAmount((String)"subentryentity", (String)"amount", (IDataModel)this.getModel());
                BigDecimal deleteAmt = (BigDecimal)this.getModel().getValue("amount", subEntryIndex);
                totalAmt = totalAmt.subtract(deleteAmt);
                this.getModel().setValue("splitamount", (Object)totalAmt, parentRowIndex);
                break;
            }
            case "exportsettledetail": {
                this.exportSettleDetail();
                break;
            }
        }
    }

    private void exportSettleDetail() {
        int i;
        int rowCount = this.getModel().getEntryRowCount("entryentity");
        if (rowCount <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5206\u5f55\u65e0\u6570\u636e\u3002", (String)"ContractCostBillPlugin_13", (String)"pmgt-pmco-formplugin", (Object[])new Object[0]));
            return;
        }
        XSSFWorkbook wb = new XSSFWorkbook();
        EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
        List items = grid.getItems();
        int size = items.size() - 1;
        String[] title = new String[size];
        String[] numbers = new String[size];
        int index = 0;
        for (Control item : items) {
            FieldEdit column = (FieldEdit)item;
            if (StringUtils.equals((CharSequence)column.getKey(), (CharSequence)"settleid")) continue;
            numbers[index] = column.getKey();
            String titleStr = column.getProperty().getDisplayName().getLocaleValue();
            if (titleStr == null) {
                titleStr = "";
            }
            title[index] = titleStr;
            ++index;
        }
        XSSFSheet sheet = wb.createSheet(ResManager.loadKDString((String)"\u5408\u540c\u7ed3\u7b97\u660e\u7ec6", (String)"ContractCostBillPlugin_2", (String)"pmgt-pmco-formplugin", (Object[])new Object[0]));
        XSSFCellStyle style = wb.createCellStyle();
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setFillForegroundColor(IndexedColors.YELLOW.getIndex());
        style.setAlignment(HorizontalAlignment.CENTER_SELECTION);
        XSSFCellStyle dataStyle = wb.createCellStyle();
        dataStyle.setAlignment(HorizontalAlignment.RIGHT);
        XSSFRow row = sheet.createRow(0);
        for (i = 0; i < size; ++i) {
            XSSFCell cell = row.createCell(i);
            cell.setCellValue(title[i]);
            cell.setCellStyle((CellStyle)style);
            sheet.setColumnWidth(i, 4024);
        }
        for (i = 0; i < rowCount; ++i) {
            XSSFRow cur = sheet.createRow(i + 1);
            for (int count = 0; count < numbers.length; ++count) {
                String cellValue;
                String number = numbers[count];
                XSSFCell dataCell = cur.createCell(count);
                Object value = this.getModel().getValue(number, i);
                if (value != null) {
                    if (value instanceof DynamicObject) {
                        Object name = "pmct_contractf7".equals(((DynamicObject)value).getDynamicObjectType().getName()) ? ((DynamicObject)value).get("billname") : ((DynamicObject)value).get("name");
                        if (name instanceof LocaleString) {
                            String titleStr = ((LocaleString)name).getLocaleValue();
                            if (titleStr == null) {
                                titleStr = "";
                            }
                            cellValue = titleStr;
                        } else {
                            cellValue = name.toString();
                        }
                    } else if (value instanceof BigDecimal) {
                        DynamicObject currency = (DynamicObject)this.getModel().getValue(this.getCurrency());
                        Control control = this.getControl(number);
                        if (currency != null && control instanceof AmountEdit) {
                            int precision = currency.getInt("amtprecision");
                            cellValue = ((BigDecimal)value).setScale(precision, 4).toPlainString();
                        } else {
                            cellValue = ((BigDecimal)value).toPlainString();
                        }
                        if ("0E-10".equals(cellValue)) {
                            cellValue = "0.00";
                        }
                        dataCell.setCellStyle((CellStyle)dataStyle);
                    } else {
                        cellValue = value.toString();
                    }
                } else {
                    cellValue = "";
                }
                dataCell.setCellValue(cellValue);
            }
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            wb.write((OutputStream)os);
        }
        catch (IOException e) {
            LOGGER.error((Throwable)e);
        }
        byte[] content = os.toByteArray();
        ByteArrayInputStream in = new ByteArrayInputStream(content);
        String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(this.getFileName(), (InputStream)in, 5000);
        this.getView().download(url);
        try {
            wb.close();
        }
        catch (IOException e) {
            LOGGER.error((Throwable)e);
        }
    }

    private String getFileName() {
        Object billNumber = this.getModel().getValue("billno");
        if (billNumber != null) {
            return String.format(ResManager.loadKDString((String)"%s\u5408\u540c\u6210\u672c\u5206\u644a-\u5408\u540c\u7ed3\u7b97\u660e\u7ec6.xlsx", (String)"ContractCostBillPlugin_3", (String)"pmgt-pmco-formplugin", (Object[])new Object[0]), billNumber.toString());
        }
        return ResManager.loadKDString((String)"\u5408\u540c\u6210\u672c\u5206\u644a-\u5408\u540c\u7ed3\u7b97\u660e\u7ec6.xlsx", (String)"ContractCostBillPlugin_4", (String)"pmgt-pmco-formplugin", (Object[])new Object[0]);
    }

    private void onDataChange() {
        try {
            this.getModel().deleteEntryData("entryentity");
            this.getModel().deleteEntryData("subentryentity");
        }
        catch (NullPointerException e) {
            StackTraceElement[] stackTraces = e.getStackTrace();
            StringBuilder sb = new StringBuilder();
            for (StackTraceElement stackTrace : stackTraces) {
                sb.append(stackTrace.toString()).append("\r\n");
            }
            LOGGER.error(String.format("ContractCostBillPlugin.onDataChange,%s", sb.toString()));
        }
        ContractCostHelper.setCostAmt((IDataModel)this.getModel());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        if (StringUtils.equals((CharSequence)key, (CharSequence)"project")) {
            boolean isNew;
            this.onDataChange();
            DynamicObject pro = (DynamicObject)changeData.getNewValue();
            if (pro != null && (isNew = ProBudgetControlHelper.checkIsNewProBudgetCtrl((Long)Long.parseLong(pro.getPkValue().toString())))) {
                String tipMsg = String.format(ResManager.loadKDString((String)"%s\u9879\u76ee\u5df2\u7ecf\u6309\u6700\u65b0\u9884\u7b97\u63a7\u5236\u903b\u8f91\u8fdb\u884c\u9884\u7b97\u63a7\u5236\uff0c\u65e0\u9700\u8fdb\u884c\u5408\u540c\u7ed3\u7b97\u6210\u672c\u5f52\u96c6\u4e0e\u5206\u644a\u3002", (String)"ContractCostBillPlugin_20", (String)"pmgt-pmco-formplugin", (Object[])new Object[0]), pro.getString("name"));
                this.getView().showTipNotification(tipMsg);
                this.getModel().setValue("project", null);
            }
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)"period")) {
            this.onDataChange();
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)"splitamount")) {
            int index = changeData.getRowIndex();
            ContractCostHelper.calUnSplitAmt((int)index, (IDataModel)this.getModel());
            ContractCostHelper.setCostAmt((IDataModel)this.getModel());
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)"amount")) {
            BigDecimal totalAmt = ContractCostHelper.sumAmount((String)"subentryentity", (String)"amount", (IDataModel)this.getModel());
            this.getModel().setValue("splitamount", (Object)totalAmt, changeData.getParentRowIndex());
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        super.beforeF7Select(e);
        switch (key = e.getProperty().getName()) {
            case "contract": {
                ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
                ContractHelper.getContractByStatus((String)"pmco_contractcost", (ListShowParameter)showParameter, null);
                break;
            }
            case "budgetitem": {
                DynamicObject project = (DynamicObject)this.getModel().getValue("project");
                if (project == null) break;
                QFilter projectFilter = new QFilter("project", "=", (Object)project.getLong("id"));
                projectFilter.and(new QFilter("sourcetype", "!=", (Object)BudgetSourceTypeEnum.IN.getValue()));
                ListShowParameter parameter = (ListShowParameter)e.getFormShowParameter();
                parameter.getListFilterParameter().getQFilters().add(projectFilter);
                break;
            }
            case "costdimension": {
                Object orgObj = this.getModel().getValue("org");
                if (orgObj == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u7ec4\u7ec7\u3002", (String)"ContractCostBillPlugin_18", (String)"pmgt-pmco-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                long currUserId = RequestContext.get().getCurrUserId();
                List allPermOrgList = ProjectPermissionHelper.getAllPermOrgsByPermItem((String)"15", (String)String.valueOf(currUserId), (String)"pmbs", (String)"pmbs_cost_dimension", (String)"47150e89000000ac");
                QFilter qFilter = BaseDataServiceHelper.getBaseDataFilter((String)"pmbs_cost_dimension", (List)allPermOrgList, (boolean)true);
                ListShowParameter parameter = (ListShowParameter)e.getFormShowParameter();
                parameter.getListFilterParameter().getQFilters().add(qFilter);
                break;
            }
            case "costitem": {
                DynamicObject costDimension = (DynamicObject)this.getModel().getValue("costdimension");
                if (costDimension == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u7ef4\u5ea6\u3002", (String)"ContractCostBillPlugin_19", (String)"pmgt-pmco-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                QFilter qFilter = new QFilter("costdimension", "=", (Object)Long.parseLong(costDimension.getPkValue().toString()));
                qFilter.and("isleaf", "=", (Object)true);
                ListShowParameter parameter = (ListShowParameter)e.getFormShowParameter();
                parameter.getListFilterParameter().getQFilters().add(qFilter);
                break;
            }
        }
    }
}

