/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmco.formplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.pmgt.pmbs.common.utils.ProjectPermissionHelper;
import kd.pmgt.pmco.formplugin.base.AbstractPmcoBillPlugin;
import org.apache.commons.lang3.StringUtils;

public class CostItemMappingBillPlugin
extends AbstractPmcoBillPlugin
implements BeforeF7SelectListener {
    public static final String ID = "id";
    public static final String IS_PROJECT_ADD = "isprojectadd";

    public void registerListener(EventObject e) {
        BasedataEdit costItem;
        BasedataEdit costDimension;
        BasedataEdit proBudget;
        super.registerListener(e);
        BasedataEdit project = (BasedataEdit)this.getView().getControl("project");
        if (project != null) {
            project.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((proBudget = (BasedataEdit)this.getView().getControl("probudget")) != null) {
            proBudget.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((costDimension = (BasedataEdit)this.getView().getControl("costdimension")) != null) {
            costDimension.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((costItem = (BasedataEdit)this.getView().getControl("costitem")) != null) {
            costItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.getProBudgetItem(true);
        this.setCostEntryBackground();
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        super.beforeF7Select(e);
        DynamicObjectCollection costSplitDetails = this.getModel().getEntryEntity("costsplitdetails");
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("costsplitdetails");
        DynamicObject rowEntity = this.getModel().getEntryRowEntity("costsplitdetails", entryCurrentRowIndex);
        String name = e.getProperty().getName();
        ListShowParameter param = (ListShowParameter)e.getFormShowParameter();
        switch (name) {
            case "project": {
                param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectPro"));
                break;
            }
            case "probudget": {
                Object projectObj = this.getModel().getValue("project");
                if (projectObj == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9879\u76ee\u3002", (String)"CostItemMappingBillPlugin_6", (String)"pmgt-pmco-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                DynamicObject project = (DynamicObject)projectObj;
                QFilter qFilter = new QFilter("project", "=", (Object)Long.parseLong(project.getPkValue().toString()));
                qFilter.and("leaf", "=", (Object)true);
                DynamicObject curCostItem = rowEntity.getDynamicObject("costitem");
                if (curCostItem != null) {
                    HashSet<Long> selectProBudgets = new HashSet<Long>();
                    long curCostItemId = Long.parseLong(curCostItem.getPkValue().toString());
                    for (int i = 0; i < costSplitDetails.size(); ++i) {
                        DynamicObject proBudget;
                        DynamicObject entity = (DynamicObject)costSplitDetails.get(i);
                        if (entity.getDynamicObject("costitem") == null) continue;
                        DynamicObject costItem = entity.getDynamicObject("costitem");
                        if (i == entryCurrentRowIndex || Long.parseLong(costItem.getPkValue().toString()) != curCostItemId || (proBudget = entity.getDynamicObject("probudget")) == null) continue;
                        selectProBudgets.add(Long.parseLong(proBudget.getPkValue().toString()));
                    }
                    if (selectProBudgets.size() > 0) {
                        qFilter.and(ID, "not in", selectProBudgets);
                    }
                }
                param.getListFilterParameter().getQFilters().add(qFilter);
                break;
            }
            case "costdimension": {
                Object orgObj = this.getModel().getValue("org");
                if (orgObj == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u7ec4\u7ec7\u3002", (String)"CostItemMappingBillPlugin_7", (String)"pmgt-pmco-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                long currUserId = RequestContext.get().getCurrUserId();
                List allPermOrgList = ProjectPermissionHelper.getAllPermOrgsByPermItem((String)"15", (String)String.valueOf(currUserId), (String)"pmbs", (String)"pmbs_cost_dimension", (String)"47150e89000000ac");
                QFilter qFilter = BaseDataServiceHelper.getBaseDataFilter((String)"pmbs_cost_dimension", (List)allPermOrgList, (boolean)true);
                param.getListFilterParameter().getQFilters().add(qFilter);
                break;
            }
            case "costitem": {
                if (rowEntity == null) break;
                DynamicObject costDimension = rowEntity.getDynamicObject("costdimension");
                if (costDimension == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u7ef4\u5ea6\u3002", (String)"CostItemMappingBillPlugin_8", (String)"pmgt-pmco-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                DynamicObject proBudget = rowEntity.getDynamicObject("probudget");
                if (proBudget == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9884\u7b97\u9879\u3002", (String)"CostItemMappingBillPlugin_9", (String)"pmgt-pmco-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                long proBudgetId = Long.parseLong(proBudget.getPkValue().toString());
                HashSet<Long> selectCostItems = new HashSet<Long>();
                for (int i = 0; i < costSplitDetails.size(); ++i) {
                    DynamicObject costItem;
                    DynamicObject entity = (DynamicObject)costSplitDetails.get(i);
                    if (entity.getDynamicObject("probudget") == null) continue;
                    DynamicObject curProBudget = entity.getDynamicObject("probudget");
                    if (i == entryCurrentRowIndex || Long.parseLong(curProBudget.getPkValue().toString()) != proBudgetId || (costItem = entity.getDynamicObject("costitem")) == null) continue;
                    selectCostItems.add(Long.parseLong(costItem.getPkValue().toString()));
                }
                QFilter qFilter = new QFilter("costdimension", "=", (Object)Long.parseLong(costDimension.getPkValue().toString()));
                if (selectCostItems.size() > 0) {
                    qFilter.and(ID, "not in", selectCostItems);
                }
                qFilter.and("isleaf", "=", (Object)true);
                param.getListFilterParameter().getQFilters().add(qFilter);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId = e.getActionId();
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)"selectPro") && e.getReturnData() != null) {
            ListSelectedRowCollection returnData = (ListSelectedRowCollection)e.getReturnData();
            ListSelectedRow selectedRow = returnData.get(0);
            QFilter qFilter = new QFilter("project", "=", (Object)Long.parseLong(selectedRow.getPrimaryKeyValue().toString()));
            DynamicObject auditBill = BusinessDataServiceHelper.loadSingle((String)"pmco_budgetmapcost", (String)ID, (QFilter[])new QFilter[]{qFilter});
            if (auditBill != null) {
                this.getView().showErrorNotification(ResManager.loadKDStringExt((String)"\u6b64\u9879\u76ee\u5df2\u5b58\u5728\u4e0e\u6210\u672c\u9879\u7684\u6620\u5c04\u6570\u636e\uff0c\u8bf7\u5728\u5df2\u6709\u8bb0\u5f55\u4e0a\u7f16\u8f91\u3002", (String)"CostItemMappingBillPlugin_4", (String)"pmgt-pmco-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getModel().setValue("project", selectedRow.getPrimaryKeyValue());
        }
        super.closedCallBack(e);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        int rowIndex = changeSet[0].getRowIndex();
        switch (propName) {
            case "project": {
                this.getProBudgetItem(false);
                this.setCostEntryBackground();
                break;
            }
            case "probudget": {
                this.setProBudgetItem(rowIndex);
                this.setCostEntryBackground();
                break;
            }
            case "costdimension": {
                this.getModel().beginInit();
                this.getModel().setValue("costitem", null, rowIndex);
                this.getView().updateView("costitem", rowIndex);
                this.getModel().endInit();
                this.autoSetBlankLine(rowIndex);
                this.setCostEntryBackground();
                break;
            }
            case "costitem": {
                this.setRowEntity(rowIndex);
                this.setCostEntryBackground();
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("deleteentry".equals(operateKey)) {
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("costsplitdetails");
            DynamicObject rowEntity = this.getModel().getEntryRowEntity("costsplitdetails", entryCurrentRowIndex);
            if (rowEntity != null && rowEntity.getBoolean(IS_PROJECT_ADD)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6807\u51c6\u9884\u7b97\u9879\u6620\u5c04\u7684\u6210\u672c\u9879\u4fe1\u606f\u4e0d\u53ef\u5220\u9664\u3002", (String)"CostItemMappingBillPlugin_10", (String)"pmgt-pmco-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        if ("newentry".equals(operateKey)) {
            DynamicObject rowEntity;
            int rowCount = this.getModel().getEntryRowCount("costsplitdetails");
            if (rowCount > 1 && (rowEntity = this.getModel().getEntryRowEntity("costsplitdetails", rowCount - 2)) != null && rowEntity.getDynamicObject("costdimension") != null) {
                this.getModel().setValue("costdimension", (Object)rowEntity.getDynamicObject("costdimension"), rowCount - 1);
            }
        } else {
            OperationResult operationResult = e.getOperationResult();
            if (operationResult != null && operationResult.isSuccess() && ("save".equals(operateKey) || "submit".equals(operateKey))) {
                this.getView().invokeOperation("refresh");
            }
        }
        this.setCostEntryBackground();
    }

    private void setRowEntity(int rowIndex) {
        DynamicObject rowEntity = this.getModel().getEntryRowEntity("costsplitdetails", rowIndex);
        DynamicObject proBudget = rowEntity.getDynamicObject("probudget");
        DynamicObject costDimension = rowEntity.getDynamicObject("costdimension");
        if (rowIndex > 0) {
            DynamicObject preCostDimension;
            DynamicObject preProBudget;
            DynamicObject preRowEntity = this.getModel().getEntryRowEntity("costsplitdetails", rowIndex - 1);
            if (proBudget == null && (preProBudget = preRowEntity.getDynamicObject("probudget")) != null) {
                rowEntity.set("probudget", (Object)preProBudget);
                rowEntity.set("parentbudget", (Object)preRowEntity.getString("parentbudget"));
            }
            if (costDimension == null && (preCostDimension = preRowEntity.getDynamicObject("costdimension")) != null) {
                rowEntity.set("costdimension", (Object)preCostDimension);
            }
            DynamicObject curProBudget = rowEntity.getDynamicObject("probudget");
            rowEntity.set("pid", (Object)curProBudget.getLong("parent"));
            rowEntity.set("isleaf", (Object)true);
            DynamicObjectCollection details = this.getModel().getEntryEntity("costsplitdetails");
            this.getModel().updateEntryCache(details);
            this.getView().updateView("costsplitdetails");
        }
    }

    private void setProBudgetItem(int rowIndex) {
        DynamicObject rowEntity = this.getModel().getEntryRowEntity("costsplitdetails", rowIndex);
        DynamicObject proBudget = rowEntity.getDynamicObject("probudget");
        if (proBudget != null) {
            DynamicObject preRowEntity;
            DynamicObject preCostDimension;
            DynamicObject costDimension = rowEntity.getDynamicObject("costdimension");
            if (costDimension == null && rowIndex > 0 && (preCostDimension = (preRowEntity = this.getModel().getEntryRowEntity("costsplitdetails", rowIndex - 1)).getDynamicObject("costdimension")) != null) {
                rowEntity.set("costdimension", (Object)preCostDimension);
            }
            long parentId = proBudget.getLong("parent");
            String parentTitle = null;
            if (parentId != 0L) {
                DynamicObject parent = BusinessDataServiceHelper.loadSingle((Object)parentId, (String)"pmas_projectbudget", (String)"name");
                parentTitle = parent.getString("name");
            }
            rowEntity.set("parentbudget", parentTitle);
            rowEntity.set("pid", (Object)parentId);
            rowEntity.set("isleaf", (Object)true);
        }
        DynamicObjectCollection details = this.getModel().getEntryEntity("costsplitdetails");
        this.getModel().updateEntryCache(details);
        this.getView().updateView("costsplitdetails");
    }

    private void autoSetBlankLine(int rowIndex) {
        DynamicObject rowEntity = this.getModel().getEntryRowEntity("costsplitdetails", rowIndex);
        DynamicObject costDimension = null;
        if (rowEntity != null) {
            costDimension = rowEntity.getDynamicObject("costdimension");
        }
        if (costDimension != null) {
            DynamicObjectCollection details = this.getModel().getEntryEntity("costsplitdetails");
            for (int i = 0; i < details.size(); ++i) {
                DynamicObject entity = (DynamicObject)details.get(i);
                if (!entity.getBoolean("isleaf") || i == rowIndex || entity.getDynamicObject("costdimension") != null) continue;
                entity.set("costdimension", (Object)costDimension);
            }
            this.getModel().updateEntryCache(details);
            this.getView().updateView("costsplitdetails");
        }
    }

    private void getProBudgetItem(boolean needMerge) {
        DynamicObjectCollection entryData = this.getModel().getEntryEntity("costsplitdetails");
        Object projectObj = this.getModel().getValue("project");
        List<Object> proBudgetIds = new ArrayList(16);
        HashMap<Long, HashSet<Long>> proBudgetMap = new HashMap<Long, HashSet<Long>>(16);
        DynamicObjectCollection cloneEntry = null;
        if (needMerge && entryData.size() > 0) {
            cloneEntry = (DynamicObjectCollection)entryData.clone();
            this.setParentBudget(cloneEntry);
            proBudgetIds = entryData.stream().filter(o -> o.getDynamicObject("probudget") != null).map(o -> Long.parseLong(o.getDynamicObject("probudget").getPkValue().toString())).collect(Collectors.toList());
            for (DynamicObject entry : entryData) {
                DynamicObject proBudget = entry.getDynamicObject("probudget");
                DynamicObject costItem = entry.getDynamicObject("costitem");
                if (proBudget == null || costItem == null) continue;
                long proBudgetId = Long.parseLong(proBudget.getPkValue().toString());
                HashSet<Long> costItems = (HashSet<Long>)proBudgetMap.get(proBudgetId);
                if (costItems == null) {
                    costItems = new HashSet<Long>(16);
                }
                costItems.add(Long.parseLong(costItem.getPkValue().toString()));
                proBudgetMap.put(proBudgetId, costItems);
            }
        }
        entryData.clear();
        if (projectObj == null) {
            this.getModel().updateEntryCache(entryData);
            this.getView().updateView("costsplitdetails");
            return;
        }
        DynamicObject project = (DynamicObject)projectObj;
        QFilter qFilter = new QFilter("project", "=", (Object)Long.parseLong(project.getPkValue().toString()));
        DynamicObject[] proBudgetItems = BusinessDataServiceHelper.load((String)"pmas_projectbudget", (String)String.join((CharSequence)",", "name", "parent", "budgetitem", "leaf"), (QFilter[])new QFilter[]{qFilter});
        if (proBudgetItems.length > 0) {
            ORM orm = ORM.create();
            DynamicObjectType dt = entryData.getDynamicObjectType();
            for (DynamicObject proBudgetItem : proBudgetItems) {
                DynamicObject newTreeEntryData;
                if ((proBudgetItem = BusinessDataServiceHelper.loadSingle((Object)proBudgetItem.getPkValue(), (String)"pmas_projectbudget")) == null) continue;
                long parentId = proBudgetItem.getLong("parent");
                String parentTitle = null;
                if (parentId != 0L) {
                    DynamicObject parent = BusinessDataServiceHelper.loadSingle((Object)parentId, (String)"pmas_projectbudget", (String)"name");
                    parentTitle = parent.getString("name");
                }
                DynamicObjectCollection costItems = null;
                DynamicObject budgetItem = proBudgetItem.getDynamicObject("budgetitem");
                if (budgetItem != null) {
                    budgetItem = BusinessDataServiceHelper.loadSingle((Object)budgetItem.getPkValue(), (String)"pmbs_budgetitem");
                    costItems = budgetItem.getDynamicObjectCollection("costitem");
                }
                long proBudgetId = Long.parseLong(proBudgetItem.getPkValue().toString());
                if (!proBudgetItem.getBoolean("leaf") || budgetItem == null || costItems == null || costItems.size() == 0) {
                    if (proBudgetIds.size() > 0 && proBudgetIds.contains(proBudgetId)) continue;
                    newTreeEntryData = new DynamicObject(dt);
                    if (!proBudgetItem.getBoolean("leaf")) {
                        newTreeEntryData.set(ID, proBudgetItem.getPkValue());
                    } else {
                        newTreeEntryData.set(ID, (Object)orm.genLongId((IDataEntityType)dt));
                    }
                    newTreeEntryData.set("probudget", (Object)proBudgetItem);
                    newTreeEntryData.set("parentbudget", (Object)parentTitle);
                    newTreeEntryData.set("pid", (Object)parentId);
                    newTreeEntryData.set("isleaf", (Object)proBudgetItem.getBoolean("leaf"));
                    if (!proBudgetItem.getBoolean("leaf")) {
                        newTreeEntryData.set("issave", (Object)false);
                    }
                    newTreeEntryData.set(IS_PROJECT_ADD, (Object)true);
                    entryData.add((Object)newTreeEntryData);
                    continue;
                }
                for (DynamicObject costItem : costItems) {
                    Set costItemIds;
                    long costItemId = Long.parseLong(costItem.getDynamicObject("fbasedataid").getPkValue().toString());
                    if (!proBudgetMap.isEmpty() && (costItemIds = (Set)proBudgetMap.get(proBudgetId)) != null && costItemIds.contains(costItemId)) continue;
                    costItem = BusinessDataServiceHelper.loadSingle((Object)costItemId, (String)"pmbs_costitem");
                    newTreeEntryData = new DynamicObject(dt);
                    newTreeEntryData.set(ID, (Object)orm.genLongId((IDataEntityType)dt));
                    newTreeEntryData.set("pid", (Object)parentId);
                    newTreeEntryData.set("probudget", (Object)proBudgetItem);
                    newTreeEntryData.set("parentbudget", (Object)parentTitle);
                    newTreeEntryData.set("costdimension", (Object)costItem.getDynamicObject("costdimension"));
                    newTreeEntryData.set("costitem", (Object)costItem);
                    newTreeEntryData.set("isleaf", (Object)proBudgetItem.getBoolean("leaf"));
                    newTreeEntryData.set("issave", (Object)false);
                    newTreeEntryData.set(IS_PROJECT_ADD, (Object)true);
                    entryData.add((Object)newTreeEntryData);
                }
            }
            if (cloneEntry != null && cloneEntry.size() > 0) {
                entryData.addAll((Collection)cloneEntry);
            }
            this.getModel().updateEntryCache(entryData);
            TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getView().getControl("costsplitdetails");
            treeEntryGrid.setCollapse(false);
        } else {
            if (cloneEntry != null && cloneEntry.size() > 0) {
                entryData.addAll((Collection)cloneEntry);
            }
            this.getModel().updateEntryCache(entryData);
        }
        this.getView().updateView("costsplitdetails");
    }

    private void setParentBudget(DynamicObjectCollection entry) {
        for (DynamicObject item : entry) {
            long parentId;
            DynamicObject proBudget = item.getDynamicObject("probudget");
            if (proBudget == null || (parentId = (proBudget = BusinessDataServiceHelper.loadSingle((Object)proBudget.getPkValue(), (String)"pmas_projectbudget")).getLong("parent")) == 0L) continue;
            DynamicObject parent = BusinessDataServiceHelper.loadSingle((Object)parentId, (String)"pmas_projectbudget", (String)"name");
            item.set("parentbudget", (Object)parent.getString("name"));
        }
    }

    private void setCostEntryBackground() {
        DynamicObjectCollection costSplitDetails = this.getModel().getEntryEntity("costsplitdetails");
        EntryGrid entryGrid = (EntryGrid)this.getControl("costsplitdetails");
        for (int i = 0; i < costSplitDetails.size(); ++i) {
            DynamicObject costSplitDetail = (DynamicObject)costSplitDetails.get(i);
            boolean isSave = costSplitDetail.getBoolean("issave");
            boolean isLeaf = costSplitDetail.getBoolean("isleaf");
            if (!isSave && isLeaf) {
                entryGrid.setRowBackcolor("#f6f7f9", new int[]{i});
                continue;
            }
            entryGrid.setRowBackcolor("#ffffff", new int[]{i});
        }
    }
}

