/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmco.formplugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.common.enums.BudgetCtlModeEnum;
import kd.pmgt.pmbs.common.enums.BudgetSourceTypeEnum;
import kd.pmgt.pmbs.common.enums.ProjectStatusEnum;
import kd.pmgt.pmbs.common.enums.SplitTypeEnum;
import kd.pmgt.pmbs.common.utils.ProjectPermissionHelper;
import kd.pmgt.pmco.formplugin.base.AbstractPmcoBillPlugin;

public class OutBudgetAdjustEditPlugin
extends AbstractPmcoBillPlugin
implements BeforeF7SelectListener {
    private DynamicObject getValidOutBudget() {
        long projectId = this.getModel().getDataEntity().getLong("project_id");
        if (projectId == 0L) {
            return null;
        }
        QFilter outBudgetItemFilter = new QFilter("sourcetype", "=", (Object)BudgetSourceTypeEnum.OUT.getValue());
        QFilter projectFilter = new QFilter("project", "=", (Object)projectId);
        QFilter isValidFilter = new QFilter("isvalid", "=", (Object)"1");
        DynamicObject validBudget = BusinessDataServiceHelper.loadSingle((String)"pmas_outbudget", (String)"budgetcontrolmode, splittype,projectapplydate,ctrlbudgetitem,entryproid,entrypronumber,entryproname,ctrlbudgetitemname,ctrlprobudgetitem,undertakeorg,undertakeperiod,currentratio,currentamt,controlinfocommon", (QFilter[])new QFilter[]{isValidFilter, projectFilter, outBudgetItemFilter});
        return validBudget;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit project = (BasedataEdit)this.getControl("project");
        project.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit adjustBudgetItem = (BasedataEdit)this.getControl("adjustbudgetitem");
        adjustBudgetItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit undertakeOrg = (BasedataEdit)this.getControl("undertakeorg");
        undertakeOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        IDataModel model = this.getModel();
        if (StringUtils.equals((CharSequence)"save", (CharSequence)operateKey)) {
            DynamicObject validBudget = this.getValidOutBudget();
            if (validBudget == null) {
                return;
            }
            String budgetControlMode = validBudget.getString("budgetcontrolmode");
            if (!StringUtils.equals((CharSequence)BudgetCtlModeEnum.CONTROLANDOCCUPY.getValue(), (CharSequence)budgetControlMode)) {
                return;
            }
            if (!this.setRealBudgetEntry(model, validBudget)) {
                return;
            }
        } else if (StringUtils.equals((CharSequence)"submit", (CharSequence)operateKey)) {
            DynamicObject validBudget = this.getValidOutBudget();
            if (validBudget == null) {
                return;
            }
            String budgetControlMode = validBudget.getString("budgetcontrolmode");
            if (!StringUtils.equals((CharSequence)BudgetCtlModeEnum.CONTROLANDOCCUPY.getValue(), (CharSequence)budgetControlMode)) {
                return;
            }
            QFilter idFilter = new QFilter("id", "=", model.getDataEntity().getPkValue());
            DynamicObject outbudgetAdjust = BusinessDataServiceHelper.loadSingle((String)"pmco_outbudgetadjust", (String)"", (QFilter[])new QFilter[]{idFilter});
            boolean dataChanged = model.getDataChanged();
            if (outbudgetAdjust == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\uff0c\u518d\u63d0\u4ea4\u3002", (String)"OutBudgetAdjustEditPlugin_0", (String)"pmgt-pmco-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (dataChanged) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u8bf7\u5148\u4fdd\u5b58\uff0c\u518d\u63d0\u4ea4\u3002", (String)"OutBudgetAdjustEditPlugin_1", (String)"pmgt-pmco-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (!this.setRealBudgetEntry(model, validBudget)) {
                return;
            }
        } else if (StringUtils.equals((CharSequence)"deladjustdetailentry", (CharSequence)operateKey)) {
            int[] selectRows;
            EntryGrid controlInfoEntryGrid = (EntryGrid)this.getControl("adjustdetailentry");
            for (int i : selectRows = controlInfoEntryGrid.getSelectRows()) {
                Boolean thisNew = (Boolean)model.getValue("thisnew", i);
                if (thisNew.booleanValue()) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u81ea\u52a8\u5e26\u5165\u7684\u884c\u4e0d\u53ef\u5220\u9664\uff0c\u4ec5\u53ef\u5220\u9664\u65b0\u589e\u7684\u884c\u3002", (String)"OutBudgetAdjustEditPlugin_3", (String)"pmgt-pmco-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    private boolean setRealBudgetEntry(IDataModel model, DynamicObject validBudget) {
        model.deleteEntryData("realbudgetentry");
        model.updateCache();
        String splitType = validBudget.getString("splittype");
        DynamicObjectCollection realBudgetEntryCol = model.getEntryEntity("realbudgetentry");
        DynamicObjectType realBudgetEntryType = realBudgetEntryCol.getDynamicObjectType();
        Object projectId = model.getValue("project_id");
        DynamicObject[] validProBudgetItemArr = this.getValidProBudgetItemArr(projectId);
        DynamicObjectCollection adjustDetailEntryCol = model.getEntryEntity("adjustdetailentry");
        Map<String, BigDecimal> projectTotalAmtMap = this.getProjectTotalAmtMap(projectId);
        BigDecimal proTotalPerformAmt = projectTotalAmtMap.get("performAmt");
        BigDecimal proTotalBudgetAmt = projectTotalAmtMap.get("budgetAmt");
        if (StringUtils.equals((CharSequence)SplitTypeEnum.TOTALAMTSPLIT.getValue(), (CharSequence)splitType)) {
            int parentBudgetEntrySize = validProBudgetItemArr.length;
            int controlInfoSize = adjustDetailEntryCol.size();
            int totalRowSize = parentBudgetEntrySize * controlInfoSize;
            if (totalRowSize <= 0) {
                return false;
            }
            int[] newEntryRowIndexArr = model.batchCreateNewEntryRow("realbudgetentry", totalRowSize);
            int beginRowIndex = newEntryRowIndexArr[0];
            for (DynamicObject validProBudgetItem : validProBudgetItemArr) {
                BigDecimal performAmt = validProBudgetItem.getBigDecimal("performamt");
                for (DynamicObject adjustDetail : adjustDetailEntryCol) {
                    DynamicObject undertakeOrg = adjustDetail.getDynamicObject("undertakeorg");
                    Date undertakePeriod = adjustDetail.getDate("undertakeperiod");
                    model.setValue("realundertakeorg", (Object)undertakeOrg, beginRowIndex);
                    model.setValue("realundertakeperiod", (Object)undertakePeriod, beginRowIndex);
                    model.setValue("realbudgetitem", validProBudgetItem.get("budgetitem"), beginRowIndex);
                    model.setValue("realprobudgetname", (Object)validProBudgetItem.getString("name"), beginRowIndex);
                    model.setValue("realproname", adjustDetail.get("entryproname"), beginRowIndex);
                    model.setValue("realpronumber", adjustDetail.get("entrypronumber"), beginRowIndex);
                    model.setValue("realproid", adjustDetail.get("entryproid"), beginRowIndex);
                    BigDecimal beforeAmt = adjustDetail.getBigDecimal("beforeamt");
                    BigDecimal currentAmt = adjustDetail.getBigDecimal("currentamt");
                    if (proTotalPerformAmt.compareTo(BigDecimal.ZERO) != 0) {
                        BigDecimal afterBeforeAmt = beforeAmt.multiply(performAmt).divide(proTotalPerformAmt, 10, RoundingMode.HALF_UP);
                        BigDecimal afterCurrentAmt = currentAmt.multiply(performAmt).divide(proTotalPerformAmt, 10, RoundingMode.HALF_UP);
                        model.setValue("realbeforeamt", (Object)afterBeforeAmt, beginRowIndex);
                        model.setValue("realundertakeamt", (Object)afterCurrentAmt, beginRowIndex);
                        model.setValue("realdifferenceamt", (Object)afterCurrentAmt.subtract(afterBeforeAmt), beginRowIndex);
                    }
                    ++beginRowIndex;
                }
            }
        } else {
            int size = adjustDetailEntryCol.size();
            int[] entryRowIndexArr = model.batchCreateNewEntryRow("realbudgetentry", size);
            int i = 0;
            for (int j : entryRowIndexArr) {
                DynamicObject adjustDetailEntry = (DynamicObject)adjustDetailEntryCol.get(i++);
                DynamicObject undertakeOrg = adjustDetailEntry.getDynamicObject("undertakeorg");
                Date undertakePeriod = adjustDetailEntry.getDate("undertakeperiod");
                model.setValue("realundertakeorg", (Object)undertakeOrg, j);
                model.setValue("realundertakeperiod", (Object)undertakePeriod, j);
                model.setValue("realbudgetitem", adjustDetailEntry.get("adjustbudgetitem"), j);
                model.setValue("realproname", adjustDetailEntry.get("entryproname"), j);
                model.setValue("realpronumber", adjustDetailEntry.get("entrypronumber"), j);
                model.setValue("realproid", adjustDetailEntry.get("entryproid"), j);
                model.setValue("realprobudgetname", adjustDetailEntry.get("adjustbudgetitemname"), j);
                model.setValue("realbeforeamt", adjustDetailEntry.get("beforeamt"), j);
                model.setValue("realundertakeamt", adjustDetailEntry.get("currentamt"), j);
                model.setValue("realdifferenceamt", adjustDetailEntry.get("differenceamt"), j);
            }
        }
        return true;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
    }

    public void afterCopyData(EventObject e) {
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        int insertRow = e.getInsertRow();
        String entryName = e.getEntryProp().getName();
        if (StringUtils.equals((CharSequence)"adjustdetailentry", (CharSequence)entryName)) {
            RowDataEntity[] rowDataEntities;
            for (RowDataEntity rowDataEntity : rowDataEntities = e.getRowDataEntities()) {
                int rowIndex = rowDataEntity.getRowIndex();
                this.getModel().setValue("beforeratio", (Object)0, rowIndex);
                this.getModel().setValue("beforeamt", (Object)0, rowIndex);
            }
        }
    }

    protected Map<String, BigDecimal> getProjectTotalAmtMap(Object projectId) {
        HashMap<String, BigDecimal> projectTotalAmtMap = new HashMap<String, BigDecimal>(16);
        DynamicObject[] outBudgetItemArr = this.getValidProBudgetItemArr(projectId);
        BigDecimal proTotalPerformAmt = BigDecimal.ZERO;
        BigDecimal proTotalBudgetAmt = BigDecimal.ZERO;
        for (DynamicObject outBudgetItem : outBudgetItemArr) {
            proTotalPerformAmt = proTotalPerformAmt.add(outBudgetItem.getBigDecimal("performamt"));
            proTotalBudgetAmt = proTotalBudgetAmt.add(outBudgetItem.getBigDecimal("budgetamount"));
        }
        projectTotalAmtMap.put("performAmt", proTotalPerformAmt);
        projectTotalAmtMap.put("budgetAmt", proTotalBudgetAmt);
        return projectTotalAmtMap;
    }

    private DynamicObject[] getValidProBudgetItemArr(Object projectId) {
        QFilter notLeafFilter = new QFilter("parent", "=", (Object)0);
        QFilter outBudgetItemFilter = new QFilter("sourcetype", "=", (Object)BudgetSourceTypeEnum.OUT.getValue());
        QFilter projectFilter = new QFilter("project", "=", projectId);
        return BusinessDataServiceHelper.load((String)"pmas_projectbudgetperform", (String)"parent,budgetitem,name,budgetamount,performamt,remainamt,remainrate", (QFilter[])new QFilter[]{projectFilter, outBudgetItemFilter, notLeafFilter});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)"project", (CharSequence)propName)) {
            DynamicObject proCloseBill = this.getProCloseBill();
            if (proCloseBill == null) {
                return;
            }
            this.getModel().setValue("projectapplydate", proCloseBill.get("projectapplydate"));
            this.getModel().setValue("splittype", (Object)proCloseBill.getString("splittype"));
            this.getModel().deleteEntryData("adjustdetailentry");
            Object projectId = this.getModel().getValue("project_id");
            Map<String, BigDecimal> projectTotalAmtMap = this.getProjectTotalAmtMap(projectId);
            BigDecimal proTotalPerformAmt = projectTotalAmtMap.get("performAmt");
            this.getModel().setValue("totalamount", (Object)proTotalPerformAmt);
            DynamicObjectCollection budgetSplitEntryCol = proCloseBill.getDynamicObjectCollection("budgetsplitentry");
            int size = budgetSplitEntryCol.size();
            if (size == 0) {
                return;
            }
            int[] newEntryRowArr = this.getModel().batchCreateNewEntryRow("adjustdetailentry", size);
            int i = 0;
            IDataModel dataModel = this.getModel();
            for (int j : newEntryRowArr) {
                DynamicObject budgetSplitEntry = (DynamicObject)budgetSplitEntryCol.get(i++);
                DynamicObject undertakeOrg = budgetSplitEntry.getDynamicObject("splitundertakeorg");
                Date undertakePeriod = budgetSplitEntry.getDate("splitundertakeperiod");
                BigDecimal currentAmt = budgetSplitEntry.getBigDecimal("splitusedamt");
                dataModel.setValue("undertakeorg", (Object)undertakeOrg, j);
                dataModel.setValue("adjustbudgetitem", budgetSplitEntry.get("splitoutitem"), j);
                dataModel.setValue("adjustbudgetitemname", budgetSplitEntry.get("splitoutitemname"), j);
                dataModel.setValue("adjustprobudgetitem", budgetSplitEntry.get("splitprobudgetitem"), j);
                dataModel.setValue("undertakeperiod", (Object)undertakePeriod, j);
                dataModel.setValue("entryproname", budgetSplitEntry.get("splitproname"), j);
                dataModel.setValue("entrypronumber", budgetSplitEntry.get("splitpronumber"), j);
                dataModel.setValue("entryproid", budgetSplitEntry.get("splitproid"), j);
                dataModel.setValue("adjustcommon", budgetSplitEntry.get("splitcommon"), j);
                dataModel.setValue("beforeamt", (Object)currentAmt, j);
                dataModel.setValue("currentamt", (Object)currentAmt, j);
                BigDecimal radio = BigDecimal.ZERO;
                if (proTotalPerformAmt.compareTo(BigDecimal.ZERO) != 0) {
                    radio = currentAmt.divide(proTotalPerformAmt, 4, RoundingMode.HALF_UP);
                }
                dataModel.setValue("beforeratio", (Object)radio.multiply(new BigDecimal(100)), j);
                dataModel.setValue("currentratio", (Object)radio.multiply(new BigDecimal(100)), j);
                dataModel.setValue("thisnew", (Object)"0", j);
            }
        }
    }

    private DynamicObject getProCloseBill() {
        long projectId = this.getModel().getDataEntity().getLong("project_id");
        if (projectId == 0L) {
            return null;
        }
        QFilter projectFilter = new QFilter("project", "=", (Object)projectId);
        QFilter statusFilter = new QFilter("newstatus", "=", (Object)Long.parseLong(ProjectStatusEnum.FINANCIAL_CLOSE.getId()));
        DynamicObject proCloseBill = BusinessDataServiceHelper.loadSingle((String)"pmsc_projectexecstatus", (String)"budgetsplitentry,splittype,projectapplydate,splitoutitem,splitoutitemname,splitprobudgetitem,splitundertakeorg,splitundertakeperiod,splitproname,splitpronumber,splitproid,splitundertakeamt,splitusedamt,splitremindamt,splitcommon", (QFilter[])new QFilter[]{statusFilter, projectFilter});
        return proCloseBill;
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        super.beforeF7Select(e);
        String key = e.getProperty().getName();
        ListShowParameter param = (ListShowParameter)e.getFormShowParameter();
        if (StringUtils.equals((CharSequence)"adjustbudgetitem", (CharSequence)key)) {
            DynamicObjectCollection adjustDetailEntryCol = this.getModel().getEntryEntity("adjustdetailentry");
            Set adjustBudgetItemIdSet = adjustDetailEntryCol.stream().map(a -> a.get("adjustbudgetitem_id")).collect(Collectors.toSet());
            QFilter budgetItemIdFilter = new QFilter("id", "in", adjustBudgetItemIdSet);
            param.getListFilterParameter().getQFilters().add(budgetItemIdFilter);
        } else if (StringUtils.equals((CharSequence)"undertakeorg", (CharSequence)key)) {
            long currUserId = RequestContext.get().getCurrUserId();
            List allPermOrgs = ProjectPermissionHelper.getAllPermOrgs((String)String.valueOf(currUserId), (String)this.getView().getFormShowParameter().getAppId(), (String)"pmco_outbudgetadjust", (String)"view");
            if (allPermOrgs.size() > 0) {
                param.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)allPermOrgs));
            } else {
                param.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)0L));
            }
        }
    }
}

