/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmco.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.SubEntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.pmgt.pmbs.business.helper.ProBudgetControlHelper;
import kd.pmgt.pmbs.business.helper.ProjectHelper;
import kd.pmgt.pmbs.common.enums.BudgetSourceTypeEnum;
import kd.pmgt.pmbs.common.enums.ContractPayTypeEnum;
import kd.pmgt.pmbs.common.enums.ContractStatusEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.utils.CurrencyHelper;
import kd.pmgt.pmbs.common.utils.OpenPageUtils;
import kd.pmgt.pmbs.common.utils.ProjectPermissionHelper;
import kd.pmgt.pmbs.common.utils.SystemParamHelper;
import kd.pmgt.pmco.formplugin.base.AbstractPmcoBillPlugin;

public class PayApplyCostSplitBillPlugin
extends AbstractPmcoBillPlugin
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(PayApplyCostSplitBillPlugin.class);
    public static final String AUTO_GET_DATA = "autogetdata";
    public static final String SELECTCON = "selectcontract";
    public static final String NEWSUBENTRY = "newsubentry";
    public static final String DELETESUBENTRY = "deletesubentry";

    public void registerListener(EventObject e) {
        BasedataEdit contract;
        BasedataEdit costDimension;
        super.registerListener(e);
        BasedataEdit project = (BasedataEdit)this.getView().getControl("project");
        if (project != null) {
            project.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            project.addBeforeF7ViewDetailListener(beforeF7ViewDetailEvent -> {
                beforeF7ViewDetailEvent.setCancel(true);
                this.getView().showForm((FormShowParameter)ProjectHelper.getProjectDetailShowParameter((Object)beforeF7ViewDetailEvent.getPkId()));
            });
        }
        if ((costDimension = (BasedataEdit)this.getView().getControl("costdimension")) != null) {
            costDimension.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((contract = (BasedataEdit)this.getView().getControl("contract")) != null) {
            contract.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            contract.addBeforeF7ViewDetailListener(beforeF7ViewDetailEvent -> {
                beforeF7ViewDetailEvent.setCancel(true);
                this.getView().showForm((FormShowParameter)OpenPageUtils.buildBillShowParam((Object)beforeF7ViewDetailEvent.getPkId(), (String)"pmct_outcontract"));
            });
        }
        BasedataEdit proBudget = (BasedataEdit)this.getView().getControl("probudget");
        proBudget.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit costItem = (BasedataEdit)this.getView().getControl("costitem");
        costItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        SubEntryGrid costSplitDetails;
        super.afterBindData(e);
        boolean isPeriod = (Boolean)this.getModel().getValue("isperiod");
        FieldEdit isPeriodCtr = (FieldEdit)this.getControl("period");
        isPeriodCtr.setMustInput(isPeriod);
        Object parameter = SystemParamHelper.getSystemParameter((String)"mustinputcostitem", (String)"pmbs", (Long)OrgUnitServiceHelper.getRootOrgId());
        boolean mustInput = parameter == null || (Boolean)parameter != false;
        FieldEdit costDimension = (FieldEdit)this.getControl("costdimension");
        if (costDimension != null) {
            costDimension.setMustInput(mustInput);
        }
        if ((costSplitDetails = (SubEntryGrid)this.getView().getControl("costsplitdetails")) != null) {
            costSplitDetails.setMustInput("costitem", mustInput);
        }
    }

    public void afterLoadData(EventObject e) {
        String billStatus = (String)this.getModel().getValue("billstatus");
        if (!StringUtils.equals((CharSequence)StatusEnum.TEMPSAVE.getValue(), (CharSequence)billStatus)) {
            return;
        }
        DynamicObjectCollection costDetails = this.getModel().getEntryEntity("costdetails");
        if (costDetails.size() == 0) {
            return;
        }
        List<Long> contracts = costDetails.stream().map(o -> Long.parseLong(o.getDynamicObject("contract").getPkValue().toString())).collect(Collectors.toList());
        Map<Long, Map<String, Object>> conPayData = this.getConPayData(contracts);
        for (int i = 0; i < costDetails.size(); ++i) {
            DynamicObject costDetail = (DynamicObject)costDetails.get(i);
            DynamicObject contract = costDetail.getDynamicObject("contract");
            if (conPayData.isEmpty() || contract == null) continue;
            long contractId = Long.parseLong(contract.getPkValue().toString());
            Map<String, Object> conPay = conPayData.get(contractId);
            BigDecimal applyAmt = (BigDecimal)conPay.get("applyAmt");
            this.getModel().setValue("sumpayappamt", (Object)applyAmt, i);
            BigDecimal hisSplitAmt = costDetail.getBigDecimal("hissplitamt");
            BigDecimal curSplitAmt = costDetail.getBigDecimal("cursplitamt");
            this.getModel().setValue("residueamt", (Object)applyAmt.subtract(hisSplitAmt.add(curSplitAmt)), i);
        }
        this.updateControlMetadata();
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        super.beforeF7Select(e);
        String name = e.getProperty().getName();
        ListShowParameter param = (ListShowParameter)e.getFormShowParameter();
        switch (name) {
            case "costdimension": {
                Object orgObj = this.getModel().getValue("org");
                if (orgObj == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u7ec4\u7ec7\u3002", (String)"PayApplyCostSplitBillPlugin_5", (String)"pmgt-pmco-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                long currUserId = RequestContext.get().getCurrUserId();
                List allPermOrgList = ProjectPermissionHelper.getAllPermOrgsByPermItem((String)"15", (String)String.valueOf(currUserId), (String)"pmbs", (String)"pmbs_cost_dimension", (String)"47150e89000000ac");
                QFilter qFilter = BaseDataServiceHelper.getBaseDataFilter((String)"pmbs_cost_dimension", (List)allPermOrgList, (boolean)true);
                param.getListFilterParameter().getQFilters().add(qFilter);
                break;
            }
            case "probudget": {
                DynamicObject project = (DynamicObject)this.getModel().getValue("project");
                if (project == null) break;
                QFilter qFilter = new QFilter("project", "=", (Object)Long.parseLong(project.getPkValue().toString()));
                qFilter.and("leaf", "=", (Object)true);
                qFilter.and("sourcetype", "=", (Object)BudgetSourceTypeEnum.OUT.getValue());
                param.getListFilterParameter().getQFilters().add(qFilter);
                break;
            }
            case "costitem": {
                DynamicObject costDimension = (DynamicObject)this.getModel().getValue("costdimension");
                if (costDimension == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u7ef4\u5ea6\u3002", (String)"PayApplyCostSplitBillPlugin_6", (String)"pmgt-pmco-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                QFilter qFilter = new QFilter("costdimension", "=", (Object)Long.parseLong(costDimension.getPkValue().toString()));
                qFilter.and("isleaf", "=", (Object)true);
                param.getListFilterParameter().getQFilters().add(qFilter);
                break;
            }
            case "project": {
                QFilter qFilter = new QFilter("systemtype", "=", (Object)"PMGT");
                param.getListFilterParameter().getQFilters().add(qFilter);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        switch (propName) {
            case "project": {
                boolean isNew;
                try {
                    this.getModel().deleteEntryData("costdetails");
                    this.getModel().deleteEntryData("costsplitdetails");
                }
                catch (NullPointerException ex) {
                    StackTraceElement[] stackTraces = ex.getStackTrace();
                    StringBuilder sb = new StringBuilder();
                    for (StackTraceElement stackTrace : stackTraces) {
                        sb.append(stackTrace.toString()).append("\r\n");
                    }
                    logger.error(String.format("PayApplyCostSplitBillPlugin.propertyChanged,%s", sb.toString()));
                }
                this.getModel().setValue("costamount", (Object)BigDecimal.ZERO);
                DynamicObject pro = (DynamicObject)changeData.getNewValue();
                if (pro == null || !(isNew = ProBudgetControlHelper.checkIsNewProBudgetCtrl((Long)Long.parseLong(pro.getPkValue().toString())))) break;
                String tipMsg = String.format(ResManager.loadKDString((String)"%s\u9879\u76ee\u5df2\u7ecf\u6309\u6700\u65b0\u9884\u7b97\u63a7\u5236\u903b\u8f91\u8fdb\u884c\u9884\u7b97\u63a7\u5236\uff0c\u65e0\u9700\u8fdb\u884c\u5408\u540c\u7ed3\u7b97\u6210\u672c\u5f52\u96c6\u4e0e\u5206\u644a\u3002", (String)"PayApplyCostSplitBillPlugin_10", (String)"pmgt-pmco-formplugin", (Object[])new Object[0]), pro.getString("name"));
                this.getView().showTipNotification(tipMsg);
                this.getModel().setValue("project", null);
                break;
            }
            case "isperiod": {
                boolean isPeriod = (Boolean)this.getModel().getValue("isperiod");
                FieldEdit isPeriodCtr = (FieldEdit)this.getControl("period");
                isPeriodCtr.setMustInput(isPeriod);
                if (isPeriod) break;
                this.getModel().setValue("period", null);
                break;
            }
            case "splitamount": {
                int costDetailsCurRowIndex = this.getModel().getEntryCurrentRowIndex("costdetails");
                DynamicObject costDetail = this.getModel().getEntryRowEntity("costdetails", costDetailsCurRowIndex);
                if (costDetail == null) break;
                this.getModel().setValue("cursplitamt", (Object)this.setCurSplitAmt(costDetail), costDetailsCurRowIndex);
                this.updateControlMetadata();
                break;
            }
            case "cursplitamt": {
                this.updateControlMetadata();
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (key = formOperate.getOperateKey()) {
            case "autogetdata": {
                Object period;
                Object projectObj = this.getModel().getValue("project");
                if (projectObj == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9879\u76ee\u3002", (String)"PayApplyCostSplitBillPlugin_7", (String)"pmgt-pmco-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                Object costDimensionObj = this.getModel().getValue("costdimension");
                if (costDimensionObj == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u7ef4\u5ea6\u3002", (String)"PayApplyCostSplitBillPlugin_6", (String)"pmgt-pmco-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                boolean isPeriod = (Boolean)this.getModel().getValue("isperiod");
                if (isPeriod && (period = this.getModel().getValue("period")) == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u671f\u95f4\u3002", (String)"PayApplyCostSplitBillPlugin_8", (String)"pmgt-pmco-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                this.doAutoGetData();
                break;
            }
            case "selectcontract": {
                Set selectCons;
                Object period;
                Object projectObj = this.getModel().getValue("project");
                if (projectObj == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9879\u76ee\u3002", (String)"PayApplyCostSplitBillPlugin_7", (String)"pmgt-pmco-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                Object costDimensionObj = this.getModel().getValue("costdimension");
                if (costDimensionObj == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u7ef4\u5ea6\u3002", (String)"PayApplyCostSplitBillPlugin_6", (String)"pmgt-pmco-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                boolean isPeriod = (Boolean)this.getModel().getValue("isperiod");
                if (isPeriod && (period = this.getModel().getValue("period")) == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u671f\u95f4\u3002", (String)"PayApplyCostSplitBillPlugin_8", (String)"pmgt-pmco-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                ListShowParameter parameter = ShowFormHelper.createShowListForm((String)"pmct_outcontractf7", (boolean)true, (int)2);
                parameter.setShowUsed(true);
                parameter.setShowApproved(true);
                QFilter qFilter = new QFilter("isincost", "=", (Object)true);
                qFilter.and("contractpaycontrol", "=", (Object)"paycontrol");
                HashSet<String> contStatusNumSet = new HashSet<String>(4);
                contStatusNumSet.add(ContractStatusEnum.INDRAFT.getValue());
                contStatusNumSet.add(ContractStatusEnum.INAUDIT.getValue());
                contStatusNumSet.add(ContractStatusEnum.APPROVED.getValue());
                contStatusNumSet.add(ContractStatusEnum.CLOSED.getValue());
                QFilter contStatusFilter = new QFilter("number", "not in", contStatusNumSet);
                DynamicObject[] contStatus = BusinessDataServiceHelper.load((String)"pmct_contractstatus", (String)"id", (QFilter[])new QFilter[]{contStatusFilter});
                if (contStatus.length > 0) {
                    Set contStatusIdSet = Arrays.stream(contStatus).map(o -> Long.parseLong(o.getPkValue().toString())).collect(Collectors.toSet());
                    qFilter.and("contractstatus", "in", contStatusIdSet);
                }
                qFilter.and("id", "in", this.getContractsByPay());
                DynamicObjectCollection costDetails = this.getModel().getEntryEntity("costdetails");
                if (costDetails.size() > 0 && (selectCons = costDetails.stream().filter(o -> o.getDynamicObject("contract") != null).map(o -> Long.parseLong(o.getDynamicObject("contract").getPkValue().toString())).collect(Collectors.toSet())).size() > 0) {
                    qFilter.and("id", "not in", selectCons);
                }
                parameter.getListFilterParameter().getQFilters().add(qFilter);
                CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "pmct_outcontract");
                parameter.setCloseCallBack(callBack);
                this.getView().showForm((FormShowParameter)parameter);
                break;
            }
            case "newsubentry": {
                EntryGrid grid = (EntryGrid)this.getView().getControl("costdetails");
                int[] rows = grid.getEntryState().getSelectedRows();
                if (rows.length == 1) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u5408\u540c\u3002", (String)"PayApplyCostSplitBillPlugin_9", (String)"pmgt-pmco-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String key;
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (key = formOperate.getOperateKey()) {
            case "autogetdata": {
                this.updateControlMetadata();
                break;
            }
            case "newsubentry": {
                int costDetailsCurRowIndex = this.getModel().getEntryCurrentRowIndex("costsplitdetails");
                DynamicObject costDetail = this.getModel().getEntryRowEntity("costsplitdetails", costDetailsCurRowIndex);
                if (costDetail != null) {
                    DynamicObject costDimension = (DynamicObject)this.getModel().getValue("costdimension");
                    this.getModel().setValue("subcostdimension", (Object)costDimension, costDetailsCurRowIndex);
                }
                this.updateControlMetadata();
            }
            case "deletesubentry": {
                int costDetailsCurRowIndex = this.getModel().getEntryCurrentRowIndex("costdetails");
                DynamicObject costDetail = this.getModel().getEntryRowEntity("costdetails", costDetailsCurRowIndex);
                if (costDetail != null) {
                    this.getModel().setValue("cursplitamt", (Object)this.setCurSplitAmt(costDetail), costDetailsCurRowIndex);
                }
                this.updateControlMetadata();
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (StringUtils.equals((CharSequence)"pmct_outcontract", (CharSequence)actionId) && e.getReturnData() != null) {
            ListSelectedRowCollection returnData = (ListSelectedRowCollection)e.getReturnData();
            List<Long> contractIds = returnData.stream().map(o -> Long.parseLong(o.getPrimaryKeyValue().toString())).collect(Collectors.toList());
            DynamicObjectCollection costDetails = this.getModel().getEntryEntity("costdetails");
            this.updateCostDetails(costDetails, contractIds);
            this.getView().updateView("costdetails");
            EntryGrid grid = (EntryGrid)this.getView().getControl("costdetails");
            grid.selectRows(costDetails.size() - 1, true);
            this.updateControlMetadata();
        }
    }

    private void updateControlMetadata() {
        DynamicObject payApplyCost = this.getModel().getDataEntity(true);
        DynamicObjectCollection entries = payApplyCost.getDynamicObjectCollection("costdetails");
        if (entries.size() > 0) {
            ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>(10);
            for (int i = 0; i < entries.size(); ++i) {
                DynamicObject costDetail = (DynamicObject)entries.get(i);
                CellStyle cellStyle = new CellStyle();
                cellStyle.setRow(i);
                cellStyle.setFieldKey("residueamt");
                BigDecimal residueAmt = costDetail.getBigDecimal("residueamt");
                String foreColor = residueAmt.compareTo(BigDecimal.ZERO) < 0 ? "#FF0000" : "#000000";
                cellStyle.setForeColor(foreColor);
                cellStyles.add(cellStyle);
            }
            if (cellStyles.size() > 0) {
                EntryGrid entryGrid = (EntryGrid)this.getControl("costdetails");
                entryGrid.setCellStyle(cellStyles);
            }
        }
    }

    private Set<Long> getContractsByPay() {
        Set<Long> contractSet = new HashSet<Long>();
        Map<Long, Map<String, Object>> conPayData = this.getConPayData(null);
        if (!conPayData.isEmpty()) {
            Set<Map.Entry<Long, Map<String, Object>>> entries = conPayData.entrySet();
            contractSet = entries.stream().map(Map.Entry::getKey).collect(Collectors.toSet());
        }
        return contractSet;
    }

    private void doAutoGetData() {
        DynamicObjectCollection costDetails = this.getModel().getEntryEntity("costdetails");
        if (costDetails.size() > 0) {
            costDetails.clear();
        }
        this.updateCostDetails(costDetails, null);
        this.getView().updateView("costdetails");
        EntryGrid grid = (EntryGrid)this.getView().getControl("costdetails");
        grid.selectRows(0, true);
    }

    private void updateCostDetails(DynamicObjectCollection costDetails, List<Long> contracts) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject currency = CurrencyHelper.getCurrency((Long)Long.parseLong(org.getPkValue().toString()));
        DynamicObject costDimension = (DynamicObject)this.getModel().getValue("costdimension");
        DynamicObjectType dt = costDetails.getDynamicObjectType();
        Map<Long, Map<String, Object>> conPayData = this.getConPayData(contracts);
        if (!conPayData.isEmpty()) {
            Set<Map.Entry<Long, Map<String, Object>>> conPays = conPayData.entrySet();
            for (Map.Entry<Long, Map<String, Object>> conPay : conPays) {
                Object applyAmt;
                Object contAmt;
                DynamicObject conPayDetail = new DynamicObject(dt);
                DynamicObject contract = BusinessDataServiceHelper.loadSingle((Object)conPay.getKey(), (String)"pmct_outcontract");
                conPayDetail.set("contract", (Object)contract);
                Map<String, Object> payData = conPay.getValue();
                Object contCurrency = payData.get("contCurrency");
                if (contCurrency != null) {
                    conPayDetail.set("costcurrency", (Object)currency);
                }
                if ((contAmt = payData.get("contAmt")) != null) {
                    conPayDetail.set("conamount", contAmt);
                }
                if ((applyAmt = payData.get("applyAmt")) != null) {
                    conPayDetail.set("sumpayappamt", applyAmt);
                }
                BigDecimal conHisSplitAmt = this.getConHisSplitAmtByDimension(conPay.getKey());
                conPayDetail.set("hissplitamt", (Object)conHisSplitAmt);
                BigDecimal curSplitAmt = conPayDetail.getBigDecimal("sumpayappamt").subtract(conPayDetail.getBigDecimal("hissplitamt"));
                conPayDetail.set("cursplitamt", (Object)curSplitAmt);
                DynamicObjectCollection costSplits = conPayDetail.getDynamicObjectCollection("costsplitdetails");
                DynamicObjectType subDt = costSplits.getDynamicObjectType();
                Map<Long, Set<Long>> proBudgets = this.getProBudgetByContract(conPay.getKey());
                if (!proBudgets.isEmpty()) {
                    for (Map.Entry<Long, Set<Long>> proBudget : proBudgets.entrySet()) {
                        Set<Long> costItems = proBudget.getValue();
                        if (costItems == null || costItems.size() == 0) {
                            DynamicObject subDetail = new DynamicObject(subDt);
                            if (proBudget.getKey() == null) continue;
                            DynamicObject proBudgetObj = BusinessDataServiceHelper.loadSingle((Object)proBudget.getKey(), (String)"pmas_projectbudget");
                            subDetail.set("probudget", (Object)proBudgetObj);
                            subDetail.set("subcurrency", (Object)currency);
                            subDetail.set("subcostdimension", (Object)costDimension);
                            costSplits.add((Object)subDetail);
                            continue;
                        }
                        for (Long costItem : costItems) {
                            DynamicObject subDetail = new DynamicObject(subDt);
                            if (proBudget.getKey() != null) {
                                DynamicObject proBudgetObj = BusinessDataServiceHelper.loadSingle((Object)proBudget.getKey(), (String)"pmas_projectbudget");
                                subDetail.set("probudget", (Object)proBudgetObj);
                            }
                            DynamicObject costItemObj = BusinessDataServiceHelper.loadSingle((Object)costItem, (String)"pmbs_costitem");
                            subDetail.set("costitem", (Object)costItemObj);
                            subDetail.set("subcurrency", (Object)currency);
                            subDetail.set("subcostdimension", (Object)costDimension);
                            costSplits.add((Object)subDetail);
                        }
                    }
                    if (costSplits.size() > 0) {
                        ((DynamicObject)costSplits.get(0)).set("splitamount", (Object)curSplitAmt);
                    }
                }
                costDetails.add((Object)conPayDetail);
            }
        }
        this.getModel().updateEntryCache(costDetails);
    }

    private Map<Long, Set<Long>> getProBudgetByContract(Long contractId) {
        DynamicObject[] contractList;
        HashMap<Long, Set<Long>> proBudgetMap = new HashMap<Long, Set<Long>>(16);
        DynamicObject contract = BusinessDataServiceHelper.loadSingle((Object)contractId, (String)"pmct_outcontract");
        DynamicObject budgetItem = contract.getDynamicObject("budgetitem");
        if (budgetItem != null) {
            long budgetItemId = Long.parseLong(budgetItem.getPkValue().toString());
            proBudgetMap.put(budgetItemId, this.getCostItemsByProBudget(budgetItemId));
        }
        QFilter qFilter = new QFilter("contractid", "=", (Object)String.valueOf(contractId));
        if (budgetItem != null) {
            qFilter.and("listingbudgetitem", "!=", (Object)Long.parseLong(budgetItem.getPkValue().toString()));
        }
        if ((contractList = BusinessDataServiceHelper.load((String)"pmct_contractlist", (String)"listingbudgetitem", (QFilter[])new QFilter[]{qFilter})).length > 0) {
            for (DynamicObject list : contractList) {
                DynamicObject listBudgetItem = list.getDynamicObject("listingbudgetitem");
                if (listBudgetItem == null) continue;
                long budgetItemId = Long.parseLong(listBudgetItem.getPkValue().toString());
                proBudgetMap.put(budgetItemId, this.getCostItemsByProBudget(budgetItemId));
            }
        }
        return proBudgetMap;
    }

    private Set<Long> getCostItemsByProBudget(Long proBudgetId) {
        Object costDimensionObj;
        DynamicObject proBudget;
        DynamicObject budgetItem;
        DynamicObjectCollection costDetails;
        DynamicObject budgetMappingCost;
        Set<Long> costItems = new HashSet<Long>();
        QFilter qFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        Object projectObj = this.getModel().getValue("project");
        if (projectObj != null) {
            DynamicObject project = (DynamicObject)projectObj;
            qFilter.and("project", "=", (Object)Long.parseLong(project.getPkValue().toString()));
        }
        if ((budgetMappingCost = BusinessDataServiceHelper.loadSingle((String)"pmco_budgetmapcost", (String)"id", (QFilter[])new QFilter[]{qFilter})) != null && (costDetails = (budgetMappingCost = BusinessDataServiceHelper.loadSingle((Object)budgetMappingCost.getPkValue(), (String)"pmco_budgetmapcost")).getDynamicObjectCollection("costsplitdetails")).size() > 0) {
            costItems = costDetails.stream().filter(o -> Long.parseLong(o.getDynamicObject("probudget").getPkValue().toString()) == proBudgetId).map(o -> Long.parseLong(o.getDynamicObject("costitem").getPkValue().toString())).collect(Collectors.toSet());
        }
        if (costItems.size() == 0 && QueryServiceHelper.exists((String)"pmas_projectbudget", (Object)proBudgetId) && (budgetItem = (proBudget = BusinessDataServiceHelper.loadSingle((Object)proBudgetId, (String)"pmas_projectbudget")).getDynamicObject("budgetitem")) != null) {
            budgetItem = BusinessDataServiceHelper.loadSingle((Object)budgetItem.getPkValue(), (String)"pmbs_budgetitem");
            DynamicObjectCollection costItemCol = budgetItem.getDynamicObjectCollection("costitem");
            costItems = costItemCol.stream().map(o -> Long.parseLong(o.getDynamicObject("fbasedataid").getPkValue().toString())).collect(Collectors.toSet());
        }
        if ((costDimensionObj = this.getModel().getValue("costdimension")) != null && costItems.size() > 0) {
            DynamicObject costDimension = (DynamicObject)costDimensionObj;
            qFilter = new QFilter("id", "in", costItems);
            qFilter.and("costdimension", "=", (Object)Long.parseLong(costDimension.getPkValue().toString()));
            DynamicObject[] costItemObj = BusinessDataServiceHelper.load((String)"pmbs_costitem", (String)"id", (QFilter[])new QFilter[]{qFilter});
            if (costItemObj.length > 0) {
                costItems = Arrays.stream(costItemObj).map(o -> Long.parseLong(o.getPkValue().toString())).collect(Collectors.toSet());
            }
        }
        return costItems;
    }

    private BigDecimal getConHisSplitAmtByDimension(Long contractId) {
        BigDecimal conHisSplitAmt = BigDecimal.ZERO;
        DynamicObject costDimension = (DynamicObject)this.getModel().getValue("costdimension");
        QFilter qFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        qFilter.and("costdimension", "=", (Object)Long.parseLong(costDimension.getPkValue().toString()));
        qFilter.and("costdetails.contract", "=", (Object)contractId);
        DynamicObject[] payApplyCostSplits = BusinessDataServiceHelper.load((String)"pmco_payapplycostsplit", (String)String.join((CharSequence)",", "cursplitamt", "contract"), (QFilter[])new QFilter[]{qFilter});
        if (payApplyCostSplits.length > 0) {
            for (DynamicObject payApplyCostSplit : payApplyCostSplits) {
                DynamicObjectCollection costDetails = payApplyCostSplit.getDynamicObjectCollection("costdetails");
                if (costDetails.size() <= 0) continue;
                BigDecimal curSplitAmt = costDetails.stream().filter(o -> Long.parseLong(o.getDynamicObject("contract").getPkValue().toString()) == contractId).map(o -> o.getBigDecimal("cursplitamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                conHisSplitAmt = conHisSplitAmt.add(curSplitAmt);
            }
        }
        return conHisSplitAmt;
    }

    private Map<Long, Map<String, Object>> getConPayData(List<Long> contractIds) {
        DynamicObject[] applyPays;
        HashMap<Long, Map<String, Object>> contractMap = new HashMap<Long, Map<String, Object>>(16);
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        QFilter qFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        DynamicObject period = (DynamicObject)this.getModel().getValue("period");
        if (period != null) {
            qFilter.and("period", "=", (Object)Long.parseLong(period.getPkValue().toString()));
        }
        qFilter.and("project", "=", (Object)Long.parseLong(project.getPkValue().toString()));
        DynamicObject[] paymentApplies = BusinessDataServiceHelper.load((String)"pmct_paymentapply", (String)String.join((CharSequence)",", "paymenttype", "contcurrency", "entrycontract", "totaloftaxamount", "applyamount"), (QFilter[])new QFilter[]{qFilter});
        if (paymentApplies.length > 0) {
            for (DynamicObject paymentApply : paymentApplies) {
                DynamicObjectCollection entryEntity = paymentApply.getDynamicObjectCollection("entryentity");
                if (entryEntity.size() <= 0) continue;
                List conPayments = entryEntity.stream().filter(o -> o.getDynamicObject("entrycontract") != null).filter(o -> !StringUtils.equals((CharSequence)o.getString("paymenttype"), (CharSequence)ContractPayTypeEnum.PREPAYMENT.getValue())).collect(Collectors.toList());
                for (DynamicObject conPayment : conPayments) {
                    DynamicObject contract = conPayment.getDynamicObject("entrycontract");
                    Long contractId = Long.parseLong(contract.getPkValue().toString());
                    if (contractIds != null && !contractIds.contains(contractId) || !(contract = BusinessDataServiceHelper.loadSingle((Object)contractId, (String)"pmct_outcontract")).getBoolean("isincost") || "settlecontrol".equals(contract.getString("contractpaycontrol"))) continue;
                    HashMap<String, Object> conDataMap = (HashMap<String, Object>)contractMap.get(contractId);
                    if (conDataMap == null) {
                        conDataMap = new HashMap<String, Object>(16);
                    }
                    if (conPayment.getDynamicObject("contcurrency") != null) {
                        conDataMap.put("contCurrency", conPayment.getDynamicObject("contcurrency").getPkValue().toString());
                    }
                    conDataMap.put("contAmt", contract.getBigDecimal("totalamount"));
                    BigDecimal sumApplyAmt = BigDecimal.ZERO;
                    Object applyAmtObj = conDataMap.get("applyAmt");
                    if (applyAmtObj instanceof BigDecimal) {
                        sumApplyAmt = (BigDecimal)applyAmtObj;
                    }
                    sumApplyAmt = sumApplyAmt.add(conPayment.getBigDecimal("applyamount"));
                    conDataMap.put("applyAmt", sumApplyAmt);
                    contractMap.put(contractId, conDataMap);
                }
            }
        }
        qFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        qFilter.and("project", "=", (Object)Long.parseLong(project.getPkValue().toString()));
        if (contractIds != null && contractIds.size() > 0) {
            qFilter.and("contract", "in", contractIds);
        }
        if (period != null) {
            qFilter.and("period", "=", (Object)Long.parseLong(period.getPkValue().toString()));
        }
        if ((applyPays = BusinessDataServiceHelper.load((String)"pmct_applymentpay", (String)String.join((CharSequence)",", "contractcurrency", "contractamount", "contract", "paytype", "curpayamt"), (QFilter[])new QFilter[]{qFilter})).length > 0) {
            List applyPayList = Arrays.stream(applyPays).filter(o -> o.getDynamicObject("contract") != null).collect(Collectors.toList());
            for (DynamicObject applyPay : applyPayList) {
                DynamicObjectCollection payDetails;
                DynamicObject contract = applyPay.getDynamicObject("contract");
                long contractId = Long.parseLong(contract.getPkValue().toString());
                if (!(contract = BusinessDataServiceHelper.loadSingle((Object)contractId, (String)"pmct_outcontract")).getBoolean("isincost") || "settlecontrol".equals(contract.getString("contractpaycontrol"))) continue;
                HashMap<String, Object> conDataMap = (HashMap<String, Object>)contractMap.get(contractId);
                if (conDataMap == null) {
                    conDataMap = new HashMap<String, Object>(16);
                }
                if (applyPay.getDynamicObject("contractcurrency") != null) {
                    conDataMap.put("contCurrency", applyPay.getDynamicObject("contractcurrency").getPkValue().toString());
                }
                conDataMap.put("contAmt", contract.getBigDecimal("totalamount"));
                BigDecimal sumApplyAmt = BigDecimal.ZERO;
                Object applyAmtObj = conDataMap.get("applyAmt");
                if (applyAmtObj instanceof BigDecimal) {
                    sumApplyAmt = (BigDecimal)applyAmtObj;
                }
                if ((payDetails = applyPay.getDynamicObjectCollection("paydetailentry")).size() > 0) {
                    BigDecimal curPayAmt = payDetails.stream().filter(o -> !StringUtils.equals((CharSequence)o.getString("paytype"), (CharSequence)ContractPayTypeEnum.PREPAYMENT.getValue())).map(o -> o.getBigDecimal("curpayamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                    sumApplyAmt = sumApplyAmt.add(curPayAmt);
                }
                conDataMap.put("applyAmt", sumApplyAmt);
                contractMap.put(contractId, conDataMap);
            }
        }
        return contractMap;
    }

    private BigDecimal setCurSplitAmt(DynamicObject costDetail) {
        BigDecimal totalSplitAmt = BigDecimal.ZERO;
        DynamicObjectCollection costDetails = costDetail.getDynamicObjectCollection("costsplitdetails");
        if (costDetails.size() > 0) {
            totalSplitAmt = costDetails.stream().map(o -> o.getBigDecimal("splitamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        }
        return totalSplitAmt;
    }
}

