/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmco.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.ItemClassEdit;
import kd.bos.form.field.ItemClassTypeEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmco.formplugin.base.AbstractPmcoBillPlugin;
import org.apache.commons.lang3.StringUtils;

public class ProBudgetMappingEditPlugin
extends AbstractPmcoBillPlugin {
    private static final Log logger = LogFactory.getLog(ProBudgetMappingEditPlugin.class);
    private static final String PAGE_CACHE_MAPPING_DIM_ID = "mappingdimid";
    private static final String PAGE_CACHE_OLD_PROJECT_ID = "old_projectId";
    private static final String PAGE_CACHE_NEW_PROJECT_ID = "new_projectId";
    private static final String PAGE_CACHE_OLD_ORG_ID = "old_orgId";

    public void registerListener(EventObject e) {
        ItemClassEdit mappingValueEdit;
        BasedataEdit proBudgetEdit;
        super.registerListener(e);
        BasedataEdit projectEdit = (BasedataEdit)this.getControl("project");
        if (projectEdit != null) {
            projectEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((proBudgetEdit = (BasedataEdit)this.getControl("probudget")) != null) {
            proBudgetEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((mappingValueEdit = (ItemClassEdit)this.getControl("mappingvalue")) != null) {
            mappingValueEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null) {
            this.getPageCache().put(PAGE_CACHE_OLD_ORG_ID, org.getPkValue().toString());
        }
    }

    public void afterLoadData(EventObject e) {
        DynamicObject newMappingDim = (DynamicObject)this.getModel().getValue("mappingdim");
        this.setBudgetMappingType(newMappingDim);
        this.getView().updateView("mappingdimtype");
        DynamicObjectCollection budgetMappingEntities = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        for (DynamicObject budgetMappingEntity : budgetMappingEntities) {
            DynamicObject mappingValue = budgetMappingEntity.getDynamicObject("mappingvalue");
            if (mappingValue == null) {
                long mappingValueId = budgetMappingEntity.getLong("mappingvalue_id");
                DynamicObject mappingValueObject = BusinessDataServiceHelper.loadSingle((Object)mappingValueId, (String)newMappingDim.getString("number"));
                budgetMappingEntity.set("mappingvalue", (Object)mappingValueObject);
                continue;
            }
            budgetMappingEntity.set("mappingname", mappingValue.get(((BasedataEntityType)mappingValue.getDynamicObjectType()).getNameProperty()));
        }
        this.getView().updateView("entryentity");
    }

    public void beforeF7Select(BeforeF7SelectEvent args) {
        super.beforeF7Select(args);
        String key = args.getProperty().getName();
        ListShowParameter parameter = (ListShowParameter)args.getFormShowParameter();
        switch (key) {
            case "mappingvalue": {
                DynamicObjectCollection mappingEntry = this.getModel().getEntryEntity("entryentity");
                Set mappingValueIdSet = mappingEntry.stream().filter(dyn -> dyn.getDynamicObject("mappingvalue") != null).map(dyn -> dyn.getDynamicObject("mappingvalue").getLong("id")).collect(Collectors.toSet());
                ((ListShowParameter)args.getFormShowParameter()).setMultiSelect(true);
                QFilter selectedFilter = new QFilter("id", "not in", mappingValueIdSet);
                parameter.getListFilterParameter().getQFilters().add(selectedFilter);
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "mappingvalue"));
                break;
            }
            case "probudget": {
                DynamicObject project = (DynamicObject)this.getModel().getValue("project");
                if (project == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9879\u76ee\u3002", (String)"ProBudgetMappingEditPlugin_0", (String)"pmgt-pmco-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
                QFilter projectFilter = new QFilter("project", "=", project.getPkValue());
                QFilter emptyBudgetItemFilter = new QFilter("budgetitem", "=", (Object)0L);
                parameter.getListFilterParameter().getQFilters().add(projectFilter);
                parameter.getListFilterParameter().getQFilters().add(emptyBudgetItemFilter);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if ("mappingvalue".equals(e.getActionId())) {
            int currentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            ListSelectedRowCollection list = (ListSelectedRowCollection)e.getReturnData();
            if (list == null || list.isEmpty()) {
                return;
            }
            try {
                this.getModel().beginInit();
                this.getModel().setValue("mappingvalue", list.get(0).getPrimaryKeyValue(), currentRowIndex);
                this.getModel().setValue("mappingname", (Object)list.get(0).getName(), currentRowIndex);
                this.getModel().endInit();
            }
            catch (NullPointerException exception) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bbe\u7f6e\u591a\u7c7b\u522b\u57fa\u7840\u8d44\u6599\u7f13\u5b58\u5f02\u5e38\uff0c\u8bf7\u5728\u201c\u6620\u5c04\u7ef4\u5ea6\u7c7b\u578b\u201d\u5b57\u6bb5\u4e0b\u4e3b\u52a8\u914d\u7f6e\u201c\u591a\u7c7b\u522b\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u201d\u3002", (String)"ProBudgetMappingEditPlugin_1", (String)"pmgt-pmco-formplugin", (Object[])new Object[0]));
                logger.error((Throwable)exception);
                return;
            }
            DynamicObject rowEntity = this.getModel().getEntryRowEntity("entryentity", currentRowIndex);
            DynamicObject proBudget = rowEntity.getDynamicObject("probudget");
            this.getModel().beginInit();
            if (list.size() > 1) {
                for (int i = 1; i < list.size(); ++i) {
                    int insertIndex = this.getModel().insertEntryRow("entryentity", currentRowIndex + i);
                    this.getModel().setValue("mappingvalue", list.get(i).getPrimaryKeyValue(), insertIndex);
                    this.getModel().setValue("mappingname", (Object)list.get(i).getName(), insertIndex);
                    if (proBudget == null) continue;
                    this.getModel().setValue("probudget", (Object)proBudget, insertIndex);
                }
            }
            this.getModel().endInit();
            this.getView().updateView("entryentity");
        } else if (StringUtils.equals((CharSequence)e.getActionId(), (CharSequence)"selectPro") && e.getReturnData() != null) {
            ListSelectedRowCollection returnData = (ListSelectedRowCollection)e.getReturnData();
            ListSelectedRow selectedRow = returnData.get(0);
            this.getModel().setValue("project", selectedRow.getPrimaryKeyValue());
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        switch (callBackId) {
            case "mappingdim": {
                if (MessageBoxResult.Yes.equals((Object)result)) {
                    DynamicObject mappingDim = (DynamicObject)this.getModel().getValue("mappingdim");
                    this.changeMappingDim(mappingDim);
                    break;
                }
                String mappingDimId = this.getPageCache().get(PAGE_CACHE_MAPPING_DIM_ID);
                if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{mappingDimId})) break;
                this.getModel().beginInit();
                this.getModel().setValue("mappingdim", (Object)mappingDimId);
                this.getView().updateView("mappingdim");
                this.getModel().endInit();
                break;
            }
            case "project": {
                if (MessageBoxResult.Yes.equals((Object)result)) {
                    String newProjectId = this.getPageCache().get(PAGE_CACHE_NEW_PROJECT_ID);
                    String oldProjectId = this.getPageCache().get(PAGE_CACHE_OLD_PROJECT_ID);
                    if (!StringUtils.isBlank((CharSequence)newProjectId)) {
                        QFilter qFilter = new QFilter("project", "=", (Object)Long.parseLong(newProjectId));
                        DynamicObject auditBill = BusinessDataServiceHelper.loadSingle((String)"pmco_probudgetmapping", (String)"id", (QFilter[])new QFilter[]{qFilter});
                        if (auditBill != null) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b64\u9879\u76ee\u5df2\u5b58\u5728\u9879\u76ee\u9884\u7b97\u9879\u7684\u6620\u5c04\u6570\u636e\uff0c\u8bf7\u5728\u5df2\u6709\u8bb0\u5f55\u4e0a\u7f16\u8f91\u3002", (String)"ProBudgetMappingEditPlugin_2", (String)"pmgt-pmco-formplugin", (Object[])new Object[0]));
                            this.getModel().beginInit();
                            this.getModel().setValue("project", (Object)oldProjectId);
                            this.getView().updateView("project");
                            this.getModel().endInit();
                            break;
                        }
                        DynamicObjectCollection budgetMappingEntities = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
                        budgetMappingEntities.clear();
                        this.getView().updateView("entryentity");
                        break;
                    }
                    DynamicObjectCollection budgetMappingEntities = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
                    budgetMappingEntities.clear();
                    this.getView().updateView("entryentity");
                    break;
                }
                String projectId = this.getPageCache().get(PAGE_CACHE_OLD_PROJECT_ID);
                String orgId = this.getPageCache().get(PAGE_CACHE_OLD_ORG_ID);
                this.getModel().beginInit();
                this.getModel().setValue("project", (Object)projectId);
                this.getModel().setValue("org", (Object)orgId);
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{orgId})) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{"org"});
                }
                this.getView().updateView("project");
                this.getView().updateView("org");
                this.getModel().endInit();
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String propName = args.getProperty().getName();
        ChangeData changeData = args.getChangeSet()[0];
        Object oldValue = changeData.getOldValue();
        Object newValue = changeData.getNewValue();
        DynamicObjectCollection budgetMappingEntities = this.getModel().getEntryEntity("entryentity");
        switch (propName) {
            case "mappingdim": {
                if (!budgetMappingEntities.isEmpty()) {
                    if (oldValue != null) {
                        DynamicObject oldMappingDim = (DynamicObject)oldValue;
                        this.getPageCache().put(PAGE_CACHE_MAPPING_DIM_ID, oldMappingDim.getPkValue().toString());
                    }
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u7ef4\u5ea6\u6620\u5c04\u5c06\u6e05\u7a7a\u5206\u5f55\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ProBudgetMappingEditPlugin_3", (String)"pmgt-pmco-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("mappingdim", (IFormPlugin)this));
                    break;
                }
                DynamicObject newMappingDim = (DynamicObject)newValue;
                this.changeMappingDim(newMappingDim);
                break;
            }
            case "project": {
                DynamicObject project;
                QFilter qFilter;
                DynamicObject auditBill;
                DynamicObject oldProject = (DynamicObject)oldValue;
                DynamicObject newProject = (DynamicObject)newValue;
                if (oldValue != null && !budgetMappingEntities.isEmpty()) {
                    this.getPageCache().put(PAGE_CACHE_OLD_PROJECT_ID, oldProject.getPkValue().toString());
                    this.getPageCache().put(PAGE_CACHE_NEW_PROJECT_ID, newProject != null ? newProject.getPkValue().toString() : null);
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u9879\u76ee\u4f1a\u6e05\u7a7a\u9884\u7b97\u9879\u6620\u5c04\u5206\u5f55\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ProBudgetMappingEditPlugin_4", (String)"pmgt-pmco-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("project", (IFormPlugin)this));
                    break;
                }
                if (newValue != null && (auditBill = BusinessDataServiceHelper.loadSingle((String)"pmco_probudgetmapping", (String)"id", (QFilter[])new QFilter[]{qFilter = new QFilter("project", "=", (Object)Long.parseLong((project = (DynamicObject)newValue).getPkValue().toString()))})) != null && auditBill.getLong("id") != Long.parseLong(this.getModel().getValue("id").toString())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b64\u9879\u76ee\u5df2\u5b58\u5728\u9879\u76ee\u9884\u7b97\u9879\u7684\u6620\u5c04\u6570\u636e\uff0c\u8bf7\u5728\u5df2\u6709\u8bb0\u5f55\u4e0a\u7f16\u8f91\u3002", (String)"ProBudgetMappingEditPlugin_2", (String)"pmgt-pmco-formplugin", (Object[])new Object[0]));
                    this.getModel().setValue("project", (Object)oldProject);
                    this.getView().updateView("project");
                    break;
                }
                this.getPageCache().put(PAGE_CACHE_OLD_ORG_ID, this.getModel().getDataEntity().getDynamicObject("org").getPkValue().toString());
                break;
            }
            case "mappingvalue": {
                EntryGrid grid = (EntryGrid)this.getControl("entryentity");
                int[] selRows = grid.getSelectRows();
                if (newValue != null) {
                    DynamicObject baseData = (DynamicObject)newValue;
                    this.getModel().setValue("mappingname", (Object)baseData.getString(((BasedataEntityType)baseData.getDynamicObjectType()).getNameProperty()), selRows[0]);
                    break;
                }
                this.getModel().setValue("mappingvalue", null, selRows[0]);
                this.getModel().setValue("mappingname", null, selRows[0]);
                break;
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        BillShowParameter billShowParameter = (BillShowParameter)((BillView)e.getSource()).getFormShowParameter();
        int billStatus = billShowParameter.getBillStatus().getValue();
        if (billStatus == BillOperationStatus.VIEW.getValue() || billStatus == BillOperationStatus.SUBMIT.getValue() || billStatus == BillOperationStatus.AUDIT.getValue()) {
            e.setCheckDataChange(false);
        }
    }

    private void changeMappingDim(DynamicObject mappingDim) {
        if (mappingDim != null) {
            this.setBudgetMappingType(mappingDim);
        } else {
            ((ItemClassTypeEdit)this.getView().getControl("mappingdimtype")).setComboItems(null);
            this.getModel().setValue("mappingdimtype", null);
        }
        DynamicObjectCollection budgetMappingEntities = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        budgetMappingEntities.clear();
        this.getView().updateView("mappingdimtype");
        this.getView().updateView("entryentity");
    }

    private void setBudgetMappingType(DynamicObject mappingDim) {
        if (mappingDim != null) {
            ItemClassTypeEdit selectDimTypeFields = (ItemClassTypeEdit)this.getControl("mappingdimtype");
            ArrayList<ComboItem> propertyItems = new ArrayList<ComboItem>();
            ArrayList<String> baseEntityIds = new ArrayList<String>();
            String baseDataValue = String.valueOf(mappingDim.getPkValue());
            ComboItem comboItem = new ComboItem();
            comboItem.setId(baseDataValue);
            comboItem.setValue(baseDataValue);
            comboItem.setCaption(new LocaleString(mappingDim.getString("name")));
            propertyItems.add(comboItem);
            baseEntityIds.add(baseDataValue);
            selectDimTypeFields.setComboItems(propertyItems);
            ItemClassTypeProp prop = (ItemClassTypeProp)selectDimTypeFields.getProperty();
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)baseDataValue);
            prop.setItemType((DynamicObjectType)mainEntityType);
            prop.setBaseEntityIds(baseEntityIds);
            this.getModel().setValue("mappingdimtype", (Object)baseDataValue);
        }
    }
}

