/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmco.formplugin;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.business.helper.CostItemHelper;
import kd.pmgt.pmco.business.helper.ProCostAllocationHelper;
import kd.pmgt.pmco.formplugin.base.AbstractPmcoBillPlugin;
import org.apache.commons.lang3.StringUtils;

public class ProCostAllocationEditPlugin
extends AbstractPmcoBillPlugin
implements BeforeF7SelectListener,
HyperLinkClickListener {
    public static final String AUTO_GET_DATA = "autogetdata";
    public static final String CHANGE_PROJECT = "changeproject";

    public void registerListener(EventObject e) {
        EntryGrid costSourceEntityGrid;
        super.registerListener(e);
        BasedataEdit costItem = (BasedataEdit)this.getView().getControl("costitem");
        if (costItem != null) {
            costItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((costSourceEntityGrid = (EntryGrid)this.getView().getControl("costsourceentity")) != null) {
            costSourceEntityGrid.addHyperClickListener((HyperLinkClickListener)this);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        ProCostAllocationHelper.loadColorPaint((IFormView)this.getView());
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        ListShowParameter param = (ListShowParameter)e.getFormShowParameter();
        List qFilterList = param.getListFilterParameter().getQFilters();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"costitem")) {
            DynamicObject costDimension;
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("procostalldetail");
            DynamicObject proBudget = (DynamicObject)this.getModel().getValue("probudget", entryCurrentRowIndex);
            DynamicObject pro = (DynamicObject)this.getModel().getValue("project");
            if (pro != null && proBudget != null) {
                Set costItems;
                long projectBudgetId = Long.parseLong(proBudget.getPkValue().toString());
                DynamicObject costDimension2 = (DynamicObject)this.getModel().getValue("costdimension");
                if (costDimension2 != null && (costItems = CostItemHelper.getCostItemsByProBudget((Long)projectBudgetId, (Long)Long.parseLong(pro.getPkValue().toString()), (Long)Long.parseLong(costDimension2.getPkValue().toString()))).size() > 0) {
                    qFilterList.add(new QFilter("id", "in", (Object)costItems));
                    return;
                }
            }
            if ((costDimension = (DynamicObject)this.getModel().getValue("costdimension")) != null) {
                qFilterList.add(new QFilter("costdimension", "=", costDimension.getPkValue()));
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        ChangeData changeData = changeSet[0];
        int rowIndex = changeData.getRowIndex();
        Object newValue = changeData.getNewValue();
        Object oldValue = changeData.getOldValue();
        int parentRowIndex = changeData.getParentRowIndex();
        Object projectObj = this.getModel().getValue("project");
        Object costDimensionObj = this.getModel().getValue("costdimension");
        int entryEntitySize = this.getModel().getEntryEntity("procostalldetail").size();
        switch (propName) {
            case "costdimension": {
                if (projectObj == null) {
                    return;
                }
                if (costDimensionObj == null) {
                    return;
                }
                if (entryEntitySize > 0) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u66f4\u6362\u6210\u672c\u7ef4\u5ea6\u5c06\u6e05\u7a7a\u73b0\u6709\u6570\u636e\uff0c\u8bf7\u786e\u5b9a\u7ee7\u7eed\uff1f", (String)"ProCostAllocationEditPlugin_10", (String)"pmgt-pmco-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Wait, new ConfirmCallBackListener(AUTO_GET_DATA, (IFormPlugin)this));
                    break;
                }
                ProCostAllocationHelper.autoFetch((IFormView)this.getView());
                break;
            }
            case "period": {
                if (projectObj == null) {
                    return;
                }
                if (costDimensionObj == null) {
                    return;
                }
                if (entryEntitySize > 0) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u66f4\u6362\u671f\u95f4\u5c06\u6e05\u7a7a\u73b0\u6709\u6570\u636e\uff0c\u8bf7\u786e\u5b9a\u7ee7\u7eed\uff1f", (String)"ProCostAllocationEditPlugin_11", (String)"pmgt-pmco-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Wait, new ConfirmCallBackListener(AUTO_GET_DATA, (IFormPlugin)this));
                    break;
                }
                ProCostAllocationHelper.autoFetch((IFormView)this.getView());
                break;
            }
            case "project": {
                OrmLocaleValue billName = (OrmLocaleValue)this.getModel().getValue("billname");
                if (newValue != null) {
                    DynamicObject pro = (DynamicObject)newValue;
                    if (StringUtils.isEmpty((CharSequence)billName.getLocaleValue())) {
                        this.getModel().setValue("billname", (Object)ProCostAllocationHelper.createPlanName((DynamicObject)pro, (IFormView)this.getView()));
                    }
                    QFilter proFilter = new QFilter("pro", "=", pro.getPkValue());
                    DynamicObject proApproval = BusinessDataServiceHelper.loadSingle((String)"pmas_pro_approval", (QFilter[])new QFilter[]{proFilter});
                    if (proApproval != null) {
                        this.getModel().setValue("curreney", proApproval.get("currencyfield"));
                    }
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u66f4\u6362\u9879\u76ee\u5c06\u6e05\u7a7a\u73b0\u6709\u6570\u636e\uff0c\u8bf7\u786e\u5b9a\u7ee7\u7eed\uff1f", (String)"ProCostAllocationEditPlugin_12", (String)"pmgt-pmco-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Wait, new ConfirmCallBackListener(CHANGE_PROJECT, (IFormPlugin)this));
                break;
            }
            case "costamount": {
                ProCostAllocationHelper.calculateTotalCostAmt((IFormView)this.getView());
                break;
            }
            case "sourcesplitcost": {
                BigDecimal sourceRemindCost = (BigDecimal)this.getModel().getValue("sourceremindcost", rowIndex);
                if (sourceRemindCost.compareTo(BigDecimal.ZERO) < 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5269\u4f59\u91d1\u989d\u4e0d\u80fd\u4e3a\u8d1f\u6570\u3002", (String)"ProCostAllocationEditPlugin_0", (String)"pmgt-pmco-formplugin", (Object[])new Object[0]));
                    this.getModel().setValue("sourcesplitcost", oldValue, rowIndex);
                    return;
                }
                ProCostAllocationHelper.sumToParentEntry((int)parentRowIndex, (IFormView)this.getView());
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        String key = formOperate.getOperateKey();
        if (AUTO_GET_DATA.equals(key)) {
            Object projectObj = this.getModel().getValue("project");
            if (projectObj == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9879\u76ee\u3002", (String)"ProCostAllocationEditPlugin_3", (String)"pmgt-pmco-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            Object costDimensionObj = this.getModel().getValue("costdimension");
            if (costDimensionObj == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u7ef4\u5ea6\u3002", (String)"ProCostAllocationEditPlugin_4", (String)"pmgt-pmco-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            int entryEntitySize = this.getModel().getEntryEntity("procostalldetail").size();
            if (entryEntitySize > 0) {
                args.setCancel(true);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u81ea\u52a8\u53d6\u6570\u5c06\u6e05\u7a7a\u73b0\u6709\u6570\u636e\uff0c\u8bf7\u786e\u5b9a\u7ee7\u7eed\uff1f", (String)"ProCostAllocationEditPlugin_13", (String)"pmgt-pmco-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Wait, new ConfirmCallBackListener(AUTO_GET_DATA, (IFormPlugin)this));
            } else {
                ProCostAllocationHelper.autoFetch((IFormView)this.getView());
            }
        }
        ProCostAllocationHelper.loadColorPaint((IFormView)this.getView());
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        MessageBoxResult result = event.getResult();
        if (result.getValue() == MessageBoxResult.Cancel.getValue()) {
            return;
        }
        if (AUTO_GET_DATA.equals(callBackId)) {
            ProCostAllocationHelper.autoFetch((IFormView)this.getView());
        } else if (CHANGE_PROJECT.equals(callBackId)) {
            this.getModel().setValue("costdimension", null);
            DynamicObjectCollection proCostAllDetailEntries = this.getModel().getDataEntity(true).getDynamicObjectCollection("procostalldetail");
            for (DynamicObject proCostAllDetail : proCostAllDetailEntries) {
                DynamicObjectCollection sourceEntry = proCostAllDetail.getDynamicObjectCollection("costsourceentity");
                sourceEntry.clear();
            }
            proCostAllDetailEntries.clear();
            this.getView().updateView("procostalldetail");
            this.getView().updateView("costsourceentity");
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        String name = event.getFieldName();
        int rowIndex = event.getRowIndex();
        if (StringUtils.equals((CharSequence)name, (CharSequence)"sourcenumber")) {
            ProCostAllocationHelper.openOtherView((int)rowIndex, (IFormView)this.getView());
        }
    }
}

