/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmco.formplugin;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.AmountEdit;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pmgt.pmbs.business.helper.ProjectHelper;
import kd.pmgt.pmbs.business.helper.project.ProjectPermFilterHelper;
import kd.pmgt.pmbs.business.helper.project.ProjectTeamPermissionHelper;
import kd.pmgt.pmbs.common.enums.BudgetSourceTypeEnum;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;
import kd.pmgt.pmbs.common.enums.PerformAmountTypeEnum;
import kd.pmgt.pmbs.common.enums.ProjectStatusEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.param.PermCheckParam;
import kd.pmgt.pmbs.common.utils.CheckPermissionHelper;
import kd.pmgt.pmbs.common.utils.EcPeriodUtils;
import kd.pmgt.pmbs.common.utils.ProjectPermissionHelper;
import kd.pmgt.pmco.formplugin.base.AbstractPmcoBillPlugin;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.jetbrains.annotations.NotNull;

public class ProCostSplitEditPlugin
extends AbstractPmcoBillPlugin
implements BeforeF7SelectListener,
HyperLinkClickListener,
RowClickEventListener {
    private static final Log logger = LogFactory.getLog(ProCostSplitEditPlugin.class);
    private static final String PAY_DIRECTION = "paydirection";
    private static final String CHANGE_ORG = "changeOrg";
    private static final String BTN_AUTO_FETCH = "autofetch";

    @Override
    public void afterCreateNewData(EventObject arg0) {
        super.afterCreateNewData(arg0);
        DynamicObject period = EcPeriodUtils.getCurrentPeriod();
        if (period != null) {
            this.getModel().setValue("period", period.getPkValue());
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        AmountEdit costAmt = (AmountEdit)this.getControl("costamt");
        costAmt.setMustInput(true);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        boolean enableMultiPro = this.getModel().getDataEntity().getBoolean("enablemultipro");
        this.updateMetaDataByEnableMultiPro(enableMultiPro);
        String billStatus = (String)this.getModel().getValue("billstatus");
        boolean fromDatabase = this.getModel().getDataEntity().getDataEntityState().getFromDatabase();
        DynamicObjectCollection proCostSplitEntities = this.getModel().getDataEntity(true).getDynamicObjectCollection("procostsplitentry");
        if (StringUtils.equals((CharSequence)billStatus, (CharSequence)StatusEnum.TEMPSAVE.getValue()) && !fromDatabase) {
            Iterator copyProCostSplitEntries = new DynamicObjectCollection();
            for (DynamicObject proCostSplitEntity : proCostSplitEntities) {
                if (!proCostSplitEntity.getBoolean("needupdatebudget")) continue;
                copyProCostSplitEntries.add(proCostSplitEntity);
            }
            proCostSplitEntities.clear();
            proCostSplitEntities.addAll((Collection)((Object)copyProCostSplitEntries));
            BigDecimal totalCostAmt = proCostSplitEntities.stream().map(it -> it.getBigDecimal("costamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
            this.getModel().updateEntryCache(proCostSplitEntities);
            this.getModel().setValue("totalcostamt", (Object)totalCostAmt);
            this.getView().updateView("procostsplitentry");
            this.getView().updateView("costsourceentity");
        }
        if (!enableMultiPro) {
            for (DynamicObject proCostSplitEntity : proCostSplitEntities) {
                DynamicObject project = (DynamicObject)this.getModel().getValue("project");
                DynamicObject entryProject = proCostSplitEntity.getDynamicObject("entryproject");
                if (entryProject != null) continue;
                proCostSplitEntity.set("entryproject", (Object)project);
            }
        }
        this.enableCostEntry();
        boolean isDeductBudget = this.getModel().getDataEntity().getBoolean("isdeductbudget");
        this.getView().setEnable(Boolean.valueOf(isDeductBudget), new String[]{"newentry"});
        this.getView().setEnable(Boolean.valueOf(isDeductBudget), new String[]{"deleteentry"});
        this.getView().updateView("newentry");
        this.getView().updateView("deleteentry");
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        super.beforeF7Select(arg0);
        String propName = arg0.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
        switch (propName) {
            case "funditem": {
                this.beforeFundItemF7(showParameter);
                break;
            }
            case "budgetitem": {
                this.beforeBudgetItemF7(arg0, showParameter);
                break;
            }
        }
    }

    private void beforeFundItemF7(ListShowParameter showParameter) {
        QFilter filter = new QFilter(PAY_DIRECTION, "=", (Object)PayDirectionEnum.OUT.getValue().toUpperCase());
        showParameter.getListFilterParameter().getQFilters().add(filter);
    }

    private void beforeBudgetItemF7(BeforeF7SelectEvent arg0, ListShowParameter showParameter) {
        boolean enableMultiPro = this.getModel().getDataEntity().getBoolean("enablemultipro");
        DynamicObject project = enableMultiPro ? (DynamicObject)this.getModel().getValue("entryproject") : (DynamicObject)this.getModel().getValue("project");
        if (project == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9879\u76ee\u3002", (String)"ProCostSplitEditPlugin_36", (String)"pmgt-pmco-formplugin", (Object[])new Object[0]));
            arg0.setCancel(true);
            return;
        }
        QFilter filter = new QFilter("project", "=", project.getPkValue()).and("sourcetype", "!=", (Object)BudgetSourceTypeEnum.IN.getValue());
        showParameter.getListFilterParameter().getQFilters().add(filter);
    }

    @NotNull
    private List<Long> getOrgList() {
        ArrayList<Long> orgList = new ArrayList<Long>();
        Object org = this.getModel().getValue("org");
        if (org != null) {
            if (org instanceof DynamicObject) {
                orgList.add((Long)((DynamicObject)org).getPkValue());
            } else if (org instanceof DynamicObjectCollection) {
                DynamicObjectCollection orgs = (DynamicObjectCollection)org;
                for (DynamicObject o : orgs) {
                    DynamicObject o1 = o.getDynamicObject("fbasedataid");
                    orgList.add((Long)o1.getPkValue());
                }
            }
        }
        return orgList;
    }

    private List<DynamicObject> getProjectByOrg(List<Long> orgList) {
        ArrayList<String> excludeStatusIds = new ArrayList<String>();
        excludeStatusIds.add(ProjectStatusEnum.FINANCIAL_CLOSE.getId());
        logger.info("ProCostSplitEditPlugin#orgList: {}", orgList);
        DynamicObject[] filterProjects = ProjectPermissionHelper.getPermProjectByStatus(orgList, (boolean)true, (String)"pmas_pro_approval", (String)"view", (String[])excludeStatusIds.toArray(new String[0]));
        logger.info("ProCostSplitEditPlugin#filterProjects: {}", Arrays.stream(filterProjects).map(DataEntityBase::getPkValue).collect(Collectors.toSet()));
        return Arrays.stream(filterProjects).collect(Collectors.toList());
    }

    public void registerListener(EventObject e) {
        EntryGrid proCostSplitGrid;
        EntryGrid costSourceEntityGrid;
        BasedataEdit fundItemEdit;
        BasedataEdit budgetItemEdit;
        BasedataEdit entryProjectEdit;
        BasedataEdit projectEdit;
        super.registerListener(e);
        BasedataEdit entryOrgEdit = (BasedataEdit)this.getView().getControl("entryorg");
        if (entryOrgEdit != null) {
            entryOrgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((projectEdit = (BasedataEdit)this.getView().getControl("project")) != null) {
            projectEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            projectEdit.addBeforeF7ViewDetailListener(beforeF7ViewDetailEvent -> {
                beforeF7ViewDetailEvent.setCancel(true);
                this.getView().showForm((FormShowParameter)ProjectHelper.getProjectDetailShowParameter((Object)beforeF7ViewDetailEvent.getPkId()));
            });
        }
        if ((entryProjectEdit = (BasedataEdit)this.getView().getControl("entryproject")) != null) {
            entryProjectEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            entryProjectEdit.addBeforeF7ViewDetailListener(beforeF7ViewDetailEvent -> {
                beforeF7ViewDetailEvent.setCancel(true);
                this.getView().showForm((FormShowParameter)ProjectHelper.getProjectDetailShowParameter((Object)beforeF7ViewDetailEvent.getPkId()));
            });
        }
        if ((budgetItemEdit = (BasedataEdit)this.getView().getControl("budgetitem")) != null) {
            budgetItemEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((fundItemEdit = (BasedataEdit)this.getView().getControl("funditem")) != null) {
            fundItemEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((costSourceEntityGrid = (EntryGrid)this.getView().getControl("costsourceentity")) != null) {
            costSourceEntityGrid.addHyperClickListener((HyperLinkClickListener)this);
        }
        if ((proCostSplitGrid = (EntryGrid)this.getView().getControl("procostsplitentry")) != null) {
            proCostSplitGrid.addRowClickListener((RowClickEventListener)this);
        }
    }

    private void exportDetail() {
        int i;
        int rowCount = this.getModel().getEntryRowCount("procostsplitentry");
        if (rowCount <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5206\u5f55\u65e0\u6570\u636e\u3002", (String)"ProCostSplitEditPlugin_37", (String)"pmgt-pmco-formplugin", (Object[])new Object[0]));
            return;
        }
        XSSFWorkbook wb = new XSSFWorkbook();
        EntryGrid grid = (EntryGrid)this.getView().getControl("procostsplitentry");
        List items = grid.getItems();
        boolean enableMultiPro = this.getModel().getDataEntity().getBoolean("enablemultipro");
        items = !enableMultiPro ? items.stream().filter(item -> {
            FieldEdit column = (FieldEdit)item;
            String propertyName = column.getProperty().getName();
            return !StringUtils.equals((CharSequence)propertyName, (CharSequence)"entryorg") && !StringUtils.equals((CharSequence)propertyName, (CharSequence)"entryproject");
        }).filter(item -> !StringUtils.equals((CharSequence)item.getKey(), (CharSequence)"needupdatebudget")).collect(Collectors.toList()) : items.stream().filter(item -> !StringUtils.equals((CharSequence)item.getKey(), (CharSequence)"needupdatebudget")).collect(Collectors.toList());
        int size = items.size();
        String[] title = new String[size];
        String[] numbers = new String[size];
        int index = 0;
        for (Control item2 : items) {
            FieldEdit column = (FieldEdit)item2;
            numbers[index] = column.getKey();
            String titleStr = column.getProperty().getDisplayName().getLocaleValue();
            if (titleStr == null) {
                titleStr = "";
            }
            title[index] = titleStr;
            ++index;
        }
        String titleName = this.getTitleName();
        XSSFSheet sheet = wb.createSheet(titleName);
        XSSFCellStyle style = wb.createCellStyle();
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setFillForegroundColor(IndexedColors.YELLOW.getIndex());
        style.setAlignment(HorizontalAlignment.CENTER_SELECTION);
        XSSFCellStyle dataStyle = wb.createCellStyle();
        dataStyle.setAlignment(HorizontalAlignment.RIGHT);
        XSSFRow row = sheet.createRow(0);
        for (i = 0; i < size; ++i) {
            XSSFCell cell = row.createCell(i);
            cell.setCellValue(title[i]);
            cell.setCellStyle((CellStyle)style);
            sheet.setColumnWidth(i, 4024);
        }
        for (i = 0; i < rowCount; ++i) {
            XSSFRow cur = sheet.createRow(i + 1);
            int count = 0;
            while (count < numbers.length) {
                String cellValue;
                String number = numbers[count];
                XSSFCell dataCell = cur.createCell(count++);
                Object value = this.getModel().getValue(number, i);
                if (value != null) {
                    if (value instanceof DynamicObject) {
                        Object name = ((DynamicObject)value).get("name");
                        if (name instanceof LocaleString) {
                            cellValue = ((LocaleString)name).getLocaleValue();
                            if (cellValue == null) {
                                cellValue = "";
                            }
                        } else {
                            cellValue = name.toString();
                        }
                    } else if (value instanceof BigDecimal) {
                        cellValue = ((BigDecimal)value).setScale(2, 4).toPlainString();
                        if ("0E-10".equals(cellValue)) {
                            cellValue = "0.00";
                        }
                        dataCell.setCellStyle((CellStyle)dataStyle);
                    } else {
                        cellValue = value.toString();
                    }
                } else {
                    cellValue = "";
                }
                dataCell.setCellValue(cellValue);
            }
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            wb.write((OutputStream)os);
        }
        catch (IOException e) {
            logger.error((Throwable)e);
        }
        byte[] content = os.toByteArray();
        ByteArrayInputStream in = new ByteArrayInputStream(content);
        String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(this.getFileName(titleName), (InputStream)in, 5000);
        PermCheckParam permCheckParam = new PermCheckParam(url, this.getView().getEntityId(), this.getView().getFormShowParameter().getAppId(), "47150e89000000ac");
        CheckPermissionHelper.setFileUrlPermCheckParam((PermCheckParam)permCheckParam);
        this.getView().download(url);
        try {
            wb.close();
        }
        catch (IOException e) {
            logger.error((Throwable)e);
        }
    }

    @NotNull
    private String getTitleName() {
        boolean enableMultiPro = this.getModel().getDataEntity().getBoolean("enablemultipro");
        String titleName = !enableMultiPro ? ResManager.loadKDString((String)"\u9879\u76ee\u7efc\u5408\u6210\u672c\u5206\u644a\u660e\u7ec6", (String)"ProCostSplitEditPlugin_2", (String)"pmgt-pmco-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u591a\u9879\u76ee\u7efc\u5408\u6210\u672c\u5206\u644a\u660e\u7ec6", (String)"ProCostSplitEditPlugin_9", (String)"pmgt-pmco-formplugin", (Object[])new Object[0]);
        return titleName;
    }

    private String getFileName(String titleName) {
        Object billNumber = this.getModel().getValue("billno");
        if (billNumber != null) {
            return billNumber.toString() + titleName + ".xlsx";
        }
        return titleName + ".xlsx";
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        int rowCount = this.getModel().getEntryRowCount("procostsplitentry");
        int rowIndex = valueSet[0].getRowIndex();
        int parentRowIndex = valueSet[0].getParentRowIndex();
        Object oldValue = valueSet[0].getOldValue();
        switch (propertyName) {
            case "project": {
                this.changeProject();
                break;
            }
            case "enablemultipro": {
                this.changeEnableMultiPro(rowCount);
                this.buildSourceRowByProCostSplitEntities();
                this.selectFirstRow("procostsplitentry");
                break;
            }
            case "entryproject": {
                this.getModel().setValue("budgetitem", null);
                break;
            }
            case "budgetitem": {
                this.allowLeafBudgetItem();
                break;
            }
            case "funditem": 
            case "costamt": {
                this.calculateTotalCostAmt();
                break;
            }
            case "sourcesplitcost": {
                BigDecimal sourceRemindCost = (BigDecimal)this.getModel().getValue("sourceremindcost", rowIndex);
                if (sourceRemindCost.compareTo(BigDecimal.ZERO) < 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5269\u4f59\u91d1\u989d\u4e0d\u80fd\u4e3a\u8d1f\u6570\u3002", (String)"ProCostSplitEditPlugin_14", (String)"pmgt-pmco-formplugin", (Object[])new Object[0]));
                    this.getModel().setValue("sourcesplitcost", oldValue, rowIndex);
                    return;
                }
                this.sumToParentEntry(parentRowIndex);
                break;
            }
        }
    }

    private void buildSourceRowByProCostSplitEntities() {
        DynamicObjectCollection proCostSplitEntities = this.getModel().getDataEntity(true).getDynamicObjectCollection("procostsplitentry");
        for (int i = 0; i < proCostSplitEntities.size(); ++i) {
            this.buildRowSourceEntryByIndex(i);
        }
    }

    private void sumToParentEntry(int parentRowIndex) {
        BigDecimal totalAmount = BigDecimal.ZERO;
        DynamicObject parentRowEntity = this.getModel().getEntryRowEntity("procostsplitentry", parentRowIndex);
        if (parentRowEntity != null) {
            BigDecimal costAmt;
            DynamicObjectCollection childCollection = parentRowEntity.getDynamicObjectCollection("costsourceentity");
            if (childCollection != null && !childCollection.isEmpty()) {
                for (DynamicObject entry : childCollection) {
                    totalAmount = totalAmount.add(entry.getBigDecimal("sourcesplitcost"));
                }
            }
            if ((costAmt = parentRowEntity.getBigDecimal("costamt")).compareTo(totalAmount) != 0) {
                this.getModel().setValue("costamt", (Object)totalAmount, parentRowIndex);
            }
        }
    }

    private void changeEnableMultiPro(int rowCount) {
        this.getPageCache().put("changeType", "fromMultiPro");
        boolean enableMultiPro = this.getModel().getDataEntity().getBoolean("enablemultipro");
        this.updateMetaDataByEnableMultiPro(enableMultiPro);
        String titleName = this.getTitleName();
        this.getView().getFormShowParameter().setCaption(titleName);
        List<DynamicObject> proCostSplitEntry = IntStream.range(0, rowCount).boxed().map(i -> this.getModel().getEntryRowEntity("procostsplitentry", i.intValue())).collect(Collectors.toList());
        DynamicObjectCollection entries = new DynamicObjectCollection();
        if (enableMultiPro) {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            DynamicObject project = this.getModel().getDataEntity().getDynamicObject("project");
            if (org != null && project != null) {
                proCostSplitEntry.forEach(entry -> {
                    entry.set("entryorg", (Object)org);
                    entry.set("entryproject", (Object)project);
                    entries.add(entry);
                });
                if (proCostSplitEntry.isEmpty()) {
                    DynamicObjectType dynamicObjectType = this.getModel().getDataEntity().getDynamicObjectCollection("procostsplitentry").getDynamicObjectType();
                    DynamicObject entry2 = new DynamicObject(dynamicObjectType);
                    entry2.set("entryorg", (Object)org);
                    entry2.set("entryproject", (Object)project);
                    entry2.set("needupdatebudget", (Object)Boolean.TRUE);
                    entries.add((Object)entry2);
                }
            }
            this.getModel().beginInit();
            this.getModel().setValue("project", null);
            this.getView().updateView("project");
            this.getModel().endInit();
        } else {
            if (rowCount <= 0) {
                return;
            }
            int orgProjectCount = proCostSplitEntry.stream().filter(entry -> entry.getDynamicObject("entryorg") != null && entry.getDynamicObject("entryproject") != null).map(entry -> String.format("%s#%s", entry.getDynamicObject("entryorg").getPkValue(), entry.getDynamicObject("entryproject").getPkValue())).collect(Collectors.toSet()).size();
            if (orgProjectCount == 1) {
                DynamicObject entry3 = (DynamicObject)proCostSplitEntry.get(0);
                this.getModel().setValue("org", (Object)entry3.getDynamicObject("entryorg"));
                this.getModel().beginInit();
                this.getModel().setValue("project", (Object)entry3.getDynamicObject("entryproject"));
                this.getModel().endInit();
                proCostSplitEntry.forEach(it -> {
                    DynamicObject addNewObj = new DynamicObject(entry3.getDynamicObjectType());
                    addNewObj.set("funditem", (Object)it.getDynamicObject("funditem"));
                    addNewObj.set("budgetitem", (Object)it.getDynamicObject("budgetitem"));
                    addNewObj.set("costamt", (Object)it.getBigDecimal("costamt"));
                    addNewObj.set("entrycomment", (Object)it.getString("entrycomment"));
                    addNewObj.set("needupdatebudget", (Object)it.getString("needupdatebudget"));
                    entries.add((Object)addNewObj);
                });
            } else {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u8be5\u64cd\u4f5c\u5c06\u6e05\u7a7a\u5df2\u5f55\u5165\u7684\u5206\u644a\u660e\u7ec6\u6570\u636e\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ProCostSplitEditPlugin_38", (String)"pmgt-pmco-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CHANGE_ORG));
                return;
            }
        }
        if (entries.isEmpty()) {
            return;
        }
        this.getModel().updateEntryCache(entries);
        this.getView().updateView("procostsplitentry");
        this.enableCostEntry();
    }

    private void changeProject() {
        boolean enableMultiPro;
        DynamicObjectCollection proCostSplitEntries = this.getModel().getEntryEntity("procostsplitentry");
        if (proCostSplitEntries != null && !proCostSplitEntries.isEmpty()) {
            proCostSplitEntries.clear();
            this.getModel().updateEntryCache(proCostSplitEntries);
            this.getView().updateView("procostsplitentry");
        }
        if (!(enableMultiPro = this.getModel().getDataEntity().getBoolean("enablemultipro")) && !CollectionUtils.isEmpty((Collection)proCostSplitEntries)) {
            for (DynamicObject proCostSplitEntity : proCostSplitEntries) {
                DynamicObject project = (DynamicObject)this.getModel().getValue("project");
                proCostSplitEntity.set("entryproject", (Object)project);
            }
        }
        this.getModel().setValue("totalcostamt", null);
        this.getModel().setValue("isdeductbudget", (Object)true);
        this.getView().setEnable(Boolean.valueOf(true), new String[]{"newentry"});
        this.getView().setEnable(Boolean.valueOf(true), new String[]{"deleteentry"});
        this.getView().updateView("isdeductbudget");
        this.getView().updateView("newentry");
        this.getView().updateView("deleteentry");
    }

    private void allowLeafBudgetItem() {
        boolean isLeaf;
        DynamicObject row = this.getEntryRowEntity("procostsplitentry");
        DynamicObject budgetItem = row.getDynamicObject("budgetitem");
        if (budgetItem == null) {
            return;
        }
        Object budgetItemPk = budgetItem.getPkValue();
        QFilter parentFilter = new QFilter("parent", "=", budgetItemPk);
        DynamicObject[] entries = BusinessDataServiceHelper.load((String)"pmas_projectbudget", (String)"id", (QFilter[])new QFilter[]{parentFilter});
        boolean bl = isLeaf = entries == null || entries.length == 0;
        if (!isLeaf) {
            row.set("budgetitem", null);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u652f\u51fa\u9884\u7b97\u9879\u7684\u660e\u7ec6\u8282\u70b9\u6570\u636e\u3002", (String)"ProCostSplitEditPlugin_39", (String)"pmgt-pmco-formplugin", (Object[])new Object[0]));
        }
    }

    private DynamicObject getEntryRowEntity(String entryName) {
        int curIndex = this.getModel().getEntryCurrentRowIndex(entryName);
        return this.getModel().getEntryRowEntity(entryName, curIndex);
    }

    private void calculateTotalCostAmt() {
        DynamicObjectCollection proCostSplitEntryCol = this.getModel().getEntryEntity("procostsplitentry");
        BigDecimal outCostAmt = proCostSplitEntryCol.stream().filter(entry -> entry.getDynamicObject("funditem") == null || !StringUtils.equals((CharSequence)BudgetSourceTypeEnum.IN.getValue(), (CharSequence)entry.getDynamicObject("funditem").getString(PAY_DIRECTION))).map(entry -> entry.getBigDecimal("costamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal inCostAmt = proCostSplitEntryCol.stream().filter(entry -> entry.getDynamicObject("funditem") != null).filter(entry -> StringUtils.equals((CharSequence)"IN", (CharSequence)entry.getDynamicObject("funditem").getString(PAY_DIRECTION))).map(entry -> entry.getBigDecimal("costamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
        this.getModel().setValue("totalcostamt", (Object)outCostAmt.subtract(inCostAmt));
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if (callBackId.equals(CHANGE_ORG)) {
            if (MessageBoxResult.Yes.equals((Object)result)) {
                this.getModel().deleteEntryData("procostsplitentry");
                this.getModel().setValue("totalcostamt", null);
            } else {
                this.getModel().setValue("enablemultipro", (Object)true);
            }
        }
        if (StringUtils.equals((CharSequence)callBackId, (CharSequence)BTN_AUTO_FETCH) && MessageBoxResult.Yes.equals((Object)result)) {
            this.autoFetch();
        }
    }

    private void updateMetaDataByEnableMultiPro(boolean enableMultiPro) {
        if (enableMultiPro) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"entryorg", "entryproject"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"project"});
            BasedataEdit projectColumn = (BasedataEdit)this.getControl("project");
            projectColumn.setMustInput(false);
            BasedataEdit entryOrgColumn = (BasedataEdit)this.getControl("entryorg");
            entryOrgColumn.setMustInput(true);
            BasedataEdit entryProjectColumn = (BasedataEdit)this.getControl("entryproject");
            entryProjectColumn.setMustInput(true);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"project", "entryorg", "entryproject"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"project"});
            BasedataEdit projectColumn = (BasedataEdit)this.getControl("project");
            projectColumn.setMustInput(true);
            BasedataEdit entryOrgColumn = (BasedataEdit)this.getControl("entryorg");
            entryOrgColumn.setMustInput(false);
            BasedataEdit entryProjectColumn = (BasedataEdit)this.getControl("entryproject");
            entryProjectColumn.setMustInput(false);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String key = formOperate.getOperateKey();
        DynamicObject bill = this.getModel().getDataEntity(true);
        boolean enableMultiPro = bill.getBoolean("enablemultipro");
        switch (key) {
            case "save": 
            case "submit": {
                boolean isTeamPerm = ProjectPermFilterHelper.getTeamPermSysParam();
                if (!enableMultiPro || !isTeamPerm) break;
                long userId = RequestContext.get().getCurrUserId();
                String billFormId = this.getView().getEntityId();
                DynamicObjectCollection splitEntries = bill.getDynamicObjectCollection("procostsplitentry");
                if (splitEntries.size() <= 0) break;
                boolean hasPerm = true;
                for (DynamicObject splitEntry : splitEntries) {
                    Map permMap;
                    DynamicObject entryProject = splitEntry.getDynamicObject("entryproject");
                    if (entryProject == null || (permMap = ProjectTeamPermissionHelper.judgeIsHasProOpPerm((Long)Long.parseLong(entryProject.getPkValue().toString()), (String)billFormId, (String)key, (Long)userId)).get("noHasPerm") == null) continue;
                    this.getView().showTipNotification((String)permMap.get("noHasPerm"));
                    hasPerm = false;
                }
                if (hasPerm) break;
                args.setCancel(true);
                break;
            }
            case "exportdetail": {
                this.exportDetail();
                break;
            }
            case "autofetch": {
                DynamicObject project;
                if (!enableMultiPro && (project = (DynamicObject)this.getModel().getValue("project")) == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9879\u76ee\u3002", (String)"ProCostSplitEditPlugin_16", (String)"pmgt-pmco-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                DynamicObjectCollection proCostSplitEntries = this.getModel().getDataEntity(true).getDynamicObjectCollection("procostsplitentry");
                if (CollectionUtils.isNotEmpty((Collection)proCostSplitEntries)) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u672c\u64cd\u4f5c\u5c06\u6e05\u7a7a\u5df2\u5f55\u5165\u7684\u7efc\u5408\u6210\u672c\u5206\u644a\u660e\u7ec6\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ProCostSplitEditPlugin_41", (String)"pmgt-pmco-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(BTN_AUTO_FETCH));
                    break;
                }
                this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u52a0\u8f7d\u4e2d\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"ProCostSplitEditPlugin_42", (String)"pmgt-pmco-formplugin", (Object[])new Object[0])));
                this.autoFetch();
                this.getView().hideLoading();
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "submit": 
            case "unsubmit": 
            case "audit": 
            case "unaudit": {
                this.selectFirstRow("procostsplitentry");
                break;
            }
        }
    }

    private void autoFetch() {
        List<DynamicObject> projects;
        DynamicObjectCollection proCostSplitEntries = this.getModel().getDataEntity(true).getDynamicObjectCollection("procostsplitentry");
        proCostSplitEntries.clear();
        boolean enableMultiPro = this.getModel().getDataEntity().getBoolean("enablemultipro");
        if (enableMultiPro) {
            List<Long> orgList = this.getOrgList();
            projects = this.getProjectByOrg(orgList);
        } else {
            DynamicObject project = (DynamicObject)this.getModel().getValue("project");
            projects = Collections.singletonList(project);
        }
        for (DynamicObject project : projects) {
            QFilter performStatusFilter;
            project = BusinessDataServiceHelper.loadSingle((Object)project.getPkValue(), (String)"bd_project");
            QFilter projectFilter = new QFilter("project", "=", project.getPkValue());
            QFilter sourceTypeFilter = new QFilter("sourcetype", "=", (Object)BudgetSourceTypeEnum.OUT.getValue());
            String selectedProperties = "id, performentry.billid, performentry.billno, performentry.billname, performentry.billamt, performentry.performamttype, performentry.billstatus, performentry.billtype";
            QFilter performTypeFilter = new QFilter("performentry.performamttype", "=", (Object)PerformAmountTypeEnum.OTHER.getValue());
            DynamicObject[] projectBudgets = BusinessDataServiceHelper.load((String)"pmas_projectbudget", (String)selectedProperties, (QFilter[])new QFilter[]{projectFilter, performTypeFilter, sourceTypeFilter, performStatusFilter = new QFilter("performentry.billstatus", "=", (Object)StatusEnum.CHECKED.getValue())});
            if (projectBudgets != null && projectBudgets.length > 0) {
                List<DynamicObject> proCostSplitEntities = this.buildCostEntryByProject(project, projectBudgets);
                proCostSplitEntries.addAll(proCostSplitEntities);
                this.getView().updateView("procostsplitentry");
            }
            HashSet<Long> proBudgetIdSet = new HashSet<Long>(16);
            for (int i = 0; i < proCostSplitEntries.size(); ++i) {
                DynamicObject rowEntity = this.getModel().getEntryRowEntity("procostsplitentry", i);
                DynamicObject budgetItem = rowEntity.getDynamicObject("budgetitem");
                if (budgetItem != null) {
                    long budgetItemId = Long.parseLong(budgetItem.getPkValue().toString());
                    if (proBudgetIdSet.contains(budgetItemId)) {
                        DynamicObjectCollection costSourceEntity = rowEntity.getDynamicObjectCollection("costsourceentity");
                        for (DynamicObject costSource : costSourceEntity) {
                            costSource.set("sourcesplitcost", (Object)BigDecimal.ZERO);
                            BigDecimal amount = costSource.getBigDecimal("sourceamount");
                            BigDecimal splitedAmt = costSource.getBigDecimal("sourcesplitedcost");
                            costSource.set("sourceremindcost", (Object)amount.subtract(splitedAmt));
                        }
                    } else {
                        proBudgetIdSet.add(budgetItemId);
                        this.sumToParentEntry(i);
                    }
                }
                this.sumToParentEntry(i);
            }
            this.selectFirstRow("procostsplitentry");
        }
        if (proCostSplitEntries.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u5173\u8054\u6570\u636e\u3002", (String)"ProCostSplitEditPlugin_43", (String)"pmgt-pmco-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u81ea\u52a8\u53d6\u6570\u6210\u529f\u3002", (String)"ProCostSplitEditPlugin_25", (String)"pmgt-pmco-formplugin", (Object[])new Object[0]));
        }
        this.enableCostEntry();
        this.getView().updateView("procostsplitentry");
        proCostSplitEntries = this.getModel().getDataEntity(true).getDynamicObjectCollection("procostsplitentry");
        this.getModel().setValue("isdeductbudget", (Object)proCostSplitEntries.isEmpty());
        this.getView().updateView("isdeductbudget");
        this.getView().setEnable(Boolean.valueOf(proCostSplitEntries.isEmpty()), new String[]{"newentry"});
        this.getView().setEnable(Boolean.valueOf(proCostSplitEntries.isEmpty()), new String[]{"deleteentry"});
        this.getView().updateView("newentry");
        this.getView().updateView("deleteentry");
    }

    private void selectFirstRow(String entryFormId) {
        DynamicObjectCollection entities = this.getModel().getDataEntity(true).getDynamicObjectCollection(entryFormId);
        EntryGrid proCostSplitEntryControl = (EntryGrid)this.getView().getControl(entryFormId);
        if (!entities.isEmpty()) {
            proCostSplitEntryControl.selectRows(0);
            this.buildRowSourceEntryByIndex(0);
        }
    }

    protected void enableCostEntry() {
        DynamicObjectCollection proCostSplitEntries = this.getModel().getDataEntity(true).getDynamicObjectCollection("procostsplitentry");
        for (int i = 0; i < proCostSplitEntries.size(); ++i) {
            DynamicObject proCostSplitEntry = (DynamicObject)proCostSplitEntries.get(i);
            boolean needUpdateBudget = proCostSplitEntry.getBoolean("needupdatebudget");
            if (needUpdateBudget) continue;
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"entryorg", "entryproject", "funditem", "budgetitem", "costamt"});
        }
    }

    private List<DynamicObject> buildCostEntryByProject(DynamicObject project, DynamicObject[] projectBudgets) {
        ArrayList<DynamicObject> proCostSplitEntities = new ArrayList<DynamicObject>(16);
        for (DynamicObject projectBudget : projectBudgets) {
            List<DynamicObject> proCostSplitEntry = this.buildCostEntryByProjectBudget(project, projectBudget);
            for (DynamicObject proCostSplit : proCostSplitEntry) {
                DynamicObjectCollection costSourceEntities = proCostSplit.getDynamicObjectCollection("costsourceentity");
                if (CollectionUtils.isEmpty((Collection)costSourceEntities)) continue;
                proCostSplitEntities.add(proCostSplit);
            }
        }
        return proCostSplitEntities;
    }

    private List<DynamicObject> buildCostEntryByProjectBudget(DynamicObject project, DynamicObject projectBudget) {
        ArrayList<DynamicObject> proCostSplitEntries = new ArrayList<DynamicObject>();
        DynamicObjectType entryType = this.getModel().getDataEntity(true).getDynamicObjectCollection("procostsplitentry").getDynamicObjectType();
        DynamicObject proCostSplitEntry = new DynamicObject(entryType);
        proCostSplitEntry.set("entryorg", (Object)project.getDynamicObject("pmascreateorg"));
        proCostSplitEntry.set("entryproject", (Object)project);
        proCostSplitEntry.set("budgetitem", (Object)projectBudget);
        if (projectBudget != null) {
            this.buildSubCostSourceEntities(projectBudget, proCostSplitEntry);
        }
        proCostSplitEntries.add(proCostSplitEntry);
        return proCostSplitEntries;
    }

    private void buildSubCostSourceEntities(DynamicObject projectBudget, DynamicObject proCostSplitEntry) {
        DynamicObjectCollection performEntries = projectBudget.getDynamicObjectCollection("performentry");
        DynamicObjectCollection subCostSourceEntities = proCostSplitEntry.getDynamicObjectCollection("costsourceentity");
        subCostSourceEntities.clear();
        for (DynamicObject performEntry : performEntries) {
            if (!StringUtils.equals((CharSequence)performEntry.getString("billstatus"), (CharSequence)StatusEnum.CHECKED.getValue()) || !StringUtils.equals((CharSequence)performEntry.getString("performamttype"), (CharSequence)PerformAmountTypeEnum.OTHER.getValue()) || StringUtils.equals((CharSequence)performEntry.getDynamicObject("billtype").getPkValue().toString(), (CharSequence)"pmco_procostsplit")) continue;
            DynamicObject subCostSourceEntity = subCostSourceEntities.addNew();
            this.buildSubCostSourceEntity(projectBudget, performEntry, subCostSourceEntity);
            BigDecimal sourceSplitCost = subCostSourceEntity.getBigDecimal("sourcesplitcost");
            if (sourceSplitCost.compareTo(BigDecimal.ZERO) != 0) continue;
            subCostSourceEntities.remove((Object)subCostSourceEntity);
        }
    }

    private void buildSubCostSourceEntity(DynamicObject projectBudget, DynamicObject performEntry, DynamicObject subCostSourceEntity) {
        long sourceBillId = Long.parseLong(performEntry.getPkValue().toString());
        long currentBillId = Long.parseLong(this.getModel().getDataEntity().getPkValue().toString());
        String sql = "select tpp.fbillno billno from t_pmco_procostsplit tpp, t_pmco_procostsplitentry tppe, t_pmco_costsplitsubentry sub where tpp.fid = tppe.fid and tppe.fentryid = sub.fentryid and sub.fsourceid = " + sourceBillId + " and tpp.fid != " + currentBillId + " and tpp.fbillstatus != 'C'";
        List referenceBillNoList = (List)DB.query((DBRoute)new DBRoute(EntityMetadataCache.getDataEntityType((String)"pmco_procostsplit").getDBRouteKey()), (String)sql, rs -> {
            ArrayList<String> result = new ArrayList<String>(16);
            while (rs.next()) {
                result.add(rs.getObject("billno").toString());
            }
            return result;
        });
        StringBuilder tipMessageBuilder = new StringBuilder();
        if (!CollectionUtils.isEmpty((Collection)referenceBillNoList)) {
            String referenceBillNos = String.join((CharSequence)"\n", referenceBillNoList);
            tipMessageBuilder.append(String.format(ResManager.loadKDString((String)"\u8d39\u7528\u660e\u7ec6\u3010%1$s\u3011\uff0c\u6b63\u5728\u5355\u636e\uff1a%2$s\u7684\u5206\u644a\u6d41\u8f6c\u4e2d\uff0c\u672c\u6b21\u4e0d\u81ea\u52a8\u5bfc\u5165\u8d39\u7528\u6765\u6e90\u660e\u7ec6\u3002", (String)"ProCostSplitEditPlugin_44", (String)"pmgt-pmco-formplugin", (Object[])new Object[0]), performEntry.getString("billno"), referenceBillNos));
        }
        if (StringUtils.isNotEmpty((CharSequence)tipMessageBuilder.toString())) {
            this.getView().showTipNotification(tipMessageBuilder.toString());
            return;
        }
        subCostSourceEntity.set("sourceid", (Object)sourceBillId);
        subCostSourceEntity.set("sourcenumber", (Object)performEntry.getString("billno"));
        subCostSourceEntity.set("sourcename", (Object)performEntry.getString("billname"));
        subCostSourceEntity.set("sourcebudget", (Object)projectBudget);
        BigDecimal amount = performEntry.getBigDecimal("billamt");
        QFilter budgetItemFilter = new QFilter("entryproject.budgetitem", "=", projectBudget.getPkValue());
        QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        String selectedProperties = "id";
        DynamicObject[] splitedCostArray = BusinessDataServiceHelper.load((String)"pmco_procostsplit", (String)selectedProperties, (QFilter[])new QFilter[]{budgetItemFilter, billStatusFilter});
        BigDecimal splitedAmt = Arrays.stream(splitedCostArray).map(it -> BusinessDataServiceHelper.loadSingle((Object)it.getPkValue(), (String)"pmco_procostsplit")).map(it -> it.getDynamicObjectCollection("procostsplitentry")).flatMap(Collection::stream).map(it -> it.getDynamicObjectCollection("costsourceentity")).flatMap(Collection::stream).filter(it -> it.getLong("sourceid") == sourceBillId).map(it -> it.getBigDecimal("sourcesplitcost")).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (splitedAmt.compareTo(amount) >= 0) {
            return;
        }
        subCostSourceEntity.set("sourceamount", (Object)amount);
        subCostSourceEntity.set("sourcesplitedcost", (Object)splitedAmt);
        BigDecimal sourceRemindCost = amount.subtract(splitedAmt);
        subCostSourceEntity.set("sourcesplitcost", (Object)sourceRemindCost);
        subCostSourceEntity.set("sourceremindcost", (Object)amount.subtract(splitedAmt).subtract(sourceRemindCost));
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        if (StringUtils.equals((CharSequence)e.getEntryProp().getName(), (CharSequence)"procostsplitentry")) {
            this.calculateTotalCostAmt();
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        int insertRow = e.getRowDataEntities()[0].getRowIndex();
        String entryName = e.getEntryProp().getName();
        if (StringUtils.equals((CharSequence)entryName, (CharSequence)"procostsplitentry")) {
            this.getModel().setValue("needupdatebudget", (Object)true, insertRow);
            DynamicObject project = (DynamicObject)this.getModel().getValue("project");
            this.getModel().beginInit();
            this.getModel().setValue("entryproject", (Object)project, insertRow);
            this.getModel().endInit();
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        String name = event.getFieldName();
        int rowIndex = event.getRowIndex();
        if (StringUtils.equals((CharSequence)name, (CharSequence)"sourcenumber")) {
            this.openOtherView(rowIndex);
        }
    }

    private void openOtherView(int index) {
        String formId = null;
        long billId = 0L;
        DynamicObject row = this.getModel().getEntryRowEntity("costsourceentity", index);
        long sourceId = row.getLong("sourceid");
        QFilter performEntryIdFilter = new QFilter("performentry.id", "=", (Object)sourceId);
        DynamicObject projectBudget = BusinessDataServiceHelper.loadSingle((String)"pmas_projectbudget", (String)"performentry.billtype, performentry.billid", (QFilter[])performEntryIdFilter.toArray());
        if (projectBudget == null) {
            return;
        }
        DynamicObjectCollection performEntries = projectBudget.getDynamicObjectCollection("performentry");
        for (DynamicObject performEntry : performEntries) {
            if (Long.parseLong(performEntry.getPkValue().toString()) != sourceId) continue;
            formId = performEntry.getDynamicObject("billtype").getPkValue().toString();
            billId = performEntry.getLong("billid");
            break;
        }
        if (StringUtils.isEmpty(formId) || billId == 0L) {
            return;
        }
        HashMap map = new HashMap();
        BillShowParameter parameter = new BillShowParameter();
        parameter.setFormId(formId);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setPkId((Object)billId);
        parameter.setStatus(OperationStatus.VIEW);
        StyleCss css = new StyleCss();
        parameter.getOpenStyle().setInlineStyleCss(css);
        parameter.setCustomParams(map);
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void entryRowClick(RowClickEvent evt) {
        int clickRowIndex = evt.getRow();
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)"procostsplitentry")) {
            String billStatus = (String)this.getModel().getValue("billstatus");
            boolean fromDatabase = this.getModel().getDataEntity().getDataEntityState().getFromDatabase();
            if (StringUtils.equals((CharSequence)billStatus, (CharSequence)StatusEnum.TEMPSAVE.getValue()) && !fromDatabase) {
                this.buildRowSourceEntryByIndex(clickRowIndex);
            }
        }
    }

    private void buildRowSourceEntryByIndex(int currentRowIndex) {
        DynamicObject currentEntryRowEntity = (DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("procostsplitentry").get(currentRowIndex);
        if (!currentEntryRowEntity.getBoolean("needupdatebudget")) {
            DynamicObjectCollection costSourceEntities = currentEntryRowEntity.getDynamicObjectCollection("costsourceentity");
            if (!CollectionUtils.isEmpty((Collection)costSourceEntities)) {
                return;
            }
            DynamicObject projectBudget = currentEntryRowEntity.getDynamicObject("budgetitem");
            if (projectBudget != null && QueryServiceHelper.exists((String)"pmas_projectbudget", (Object)projectBudget.getPkValue())) {
                projectBudget = BusinessDataServiceHelper.loadSingle((Object)projectBudget.getPkValue(), (String)"pmas_projectbudget");
                this.buildSubCostSourceEntities(projectBudget, currentEntryRowEntity);
            }
            this.getView().updateView("costsourceentity");
            this.sumToParentEntry(currentRowIndex);
        }
    }
}

