/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmco.business.helper;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.business.helper.ProBudgetControlHelper;
import kd.pmgt.pmbs.common.enums.BudgetControlTargetEnum;
import kd.pmgt.pmbs.common.enums.BudgetControlTypeEnum;
import kd.pmgt.pmbs.common.enums.BudgetSourceTypeEnum;
import kd.pmgt.pmbs.common.enums.budgetreg.BillFieldTypeEnum;

public class BudgetDataInitHelper {
    public static boolean checkProject(DynamicObject project, IFormView view) {
        if (project == null) {
            return true;
        }
        QFilter projectFilter = new QFilter("project", "=", project.getPkValue());
        DynamicObject budgetDataInit = BusinessDataServiceHelper.loadSingle((String)"budget_data_init", (QFilter[])new QFilter[]{projectFilter});
        if (budgetDataInit != null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u9879\u76ee\u5df2\u7f16\u5236\u521d\u59cb\u5316\u5f55\u5165\u5355\u636e\uff0c\u8bf7\u5728\u539f\u5355\u636e\u4e0a\u4fee\u6539\u3002", (String)"BudgetDataInitHelper_0", (String)"pmgt-pmco-business", (Object[])new Object[0]));
            return false;
        }
        boolean hasProBudgetCtrl = ProBudgetControlHelper.checkIsNewProBudgetCtrl((Long)project.getLong("id"));
        QFilter isValidFilter = new QFilter("isvalid", "=", (Object)"1");
        QFilter budgetProjectFilter = new QFilter("project", "=", project.getPkValue());
        QFilter outBudgetItemFilter = new QFilter("sourcetype", "=", (Object)BudgetSourceTypeEnum.OUT.getValue());
        DynamicObject validBudget = BusinessDataServiceHelper.loadSingle((String)"pmas_budget", (QFilter[])new QFilter[]{isValidFilter, budgetProjectFilter, outBudgetItemFilter});
        if (!hasProBudgetCtrl || validBudget == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u9879\u76ee\u5c1a\u672a\u7f16\u5236\u9884\u7b97\u6216\u672a\u9884\u7b97\u5347\u7ea7\uff0c\u65e0\u6cd5\u521d\u59cb\u5316\u3002", (String)"BudgetDataInitHelper_1", (String)"pmgt-pmco-business", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public static void loadDataByProject(DynamicObject project, IFormView view) {
        IDataModel model = view.getModel();
        if (project == null) {
            model.setValue("projcetbugamt", (Object)BigDecimal.ZERO);
            model.setValue("prooutbudgetsumamt", (Object)BigDecimal.ZERO);
            model.setValue("proyearbudgetamt", (Object)BigDecimal.ZERO);
            model.setValue("outamount", (Object)BigDecimal.ZERO);
            model.setValue("initoccupyamt", (Object)BigDecimal.ZERO);
            model.setValue("inituseamt", (Object)BigDecimal.ZERO);
            model.setValue("budgetstage", null);
            model.setValue("year", null);
            model.deleteEntryData("treeentryentity");
        } else {
            QFilter tProjectFilter = new QFilter("tproject", "=", project.getPkValue());
            DynamicObject totalBudgetCtrl = BusinessDataServiceHelper.loadSingle((String)"pmas_totalbudgetctrl", (QFilter[])new QFilter[]{tProjectFilter});
            if (totalBudgetCtrl == null) {
                return;
            }
            model.setValue("projcetbugamt", (Object)totalBudgetCtrl.getBigDecimal("proappamt"));
            model.setValue("prooutbudgetsumamt", (Object)totalBudgetCtrl.getBigDecimal("tbudgetamt"));
            QFilter isValidFilter = new QFilter("isvalid", "=", (Object)"1");
            QFilter projectFilter = new QFilter("project", "=", project.getPkValue());
            QFilter outBudgetItemFilter = new QFilter("sourcetype", "=", (Object)BudgetSourceTypeEnum.OUT.getValue());
            DynamicObject validBudget = BusinessDataServiceHelper.loadSingle((String)"pmas_budget", (QFilter[])new QFilter[]{isValidFilter, projectFilter, outBudgetItemFilter});
            if (validBudget == null) {
                view.showTipNotification(ResManager.loadKDString((String)"\u9879\u76ee\u5c1a\u672a\u7f16\u5236\u9884\u7b97\u6216\u672a\u9884\u7b97\u5347\u7ea7\uff0c\u65e0\u6cd5\u521d\u59cb\u5316\u3002", (String)"BudgetDataInitHelper_1", (String)"pmgt-pmco-business", (Object[])new Object[0]));
                BudgetDataInitHelper.clearDataWithProjectYear(view);
                return;
            }
            model.setValue("year", validBudget.get("year"));
            model.deleteEntryData("treeentryentity");
            model.setValue("budgetstage", validBudget.get("budgetstage"));
            model.setValue("proyearbudgetamt", validBudget.get("totalyearamt"));
            model.setValue("outamount", validBudget.get("totalamount"));
            DynamicObjectCollection budgetEntry = validBudget.getDynamicObjectCollection("treeentryentity");
            DynamicObjectCollection budgetInitEntry = model.getEntryEntity("treeentryentity");
            HashMap<Long, Long> idMaps = new HashMap<Long, Long>(16);
            long[] ids = DB.genLongIds((String)"t_pmco_budget_init_entry", (int)budgetEntry.size());
            int i = 0;
            for (DynamicObject budget : budgetEntry) {
                DynamicObject initEntry = new DynamicObject(budgetInitEntry.getDynamicObjectType());
                Long pkValue = (Long)budget.getPkValue();
                idMaps.put(pkValue, ids[i]);
                model.getDataEntityType().getPrimaryKey().setValueFast((Object)initEntry, (Object)ids[i]);
                ++i;
                initEntry.set("seq", budget.get("seq"));
                initEntry.set("pid", budget.get("pid"));
                initEntry.set("probudgetitem", budget.get("projectbudgetitem"));
                initEntry.set("budgetamt", budget.get("itemtotalamount"));
                initEntry.set("yearbudgetamt", budget.get("budgetamount"));
                budgetInitEntry.add((Object)initEntry);
            }
            Iterator iterator = budgetInitEntry.iterator();
            while (iterator.hasNext()) {
                DynamicObject initEntry;
                Long aLong = (Long)idMaps.get((initEntry = (DynamicObject)iterator.next()).getLong("pid"));
                initEntry.set("pid", (Object)(aLong == null ? Long.valueOf(0L) : aLong));
            }
            TreeEntryGrid entryTree = (TreeEntryGrid)view.getControl("treeentryentity");
            entryTree.setCollapse(false);
            model.updateEntryCache(budgetInitEntry);
            view.updateView("treeentryentity");
            Set parentSet = budgetInitEntry.stream().map(dyn -> dyn.getLong("pid")).collect(Collectors.toSet());
            for (int index = 0; index < budgetInitEntry.size(); ++index) {
                DynamicObject initEntry = (DynamicObject)budgetInitEntry.get(index);
                long id = initEntry.getLong("id");
                if (parentSet.contains(id)) {
                    model.setValue("leaf", (Object)false, index);
                    view.setEnable(Boolean.FALSE, index, new String[]{"entryinitoccupyamt", "entryinituseamt"});
                    continue;
                }
                model.setValue("leaf", (Object)true, index);
                view.setEnable(Boolean.TRUE, index, new String[]{"entryinitoccupyamt", "entryinituseamt"});
            }
        }
    }

    public static void clearDataWithProjectYear(IFormView view) {
        IDataModel model = view.getModel();
        model.setValue("outamount", (Object)BigDecimal.ZERO);
        model.setValue("budgetstage", null);
        model.setValue("proyearbudgetamt", (Object)BigDecimal.ZERO);
        model.setValue("initoccupyamt", (Object)BigDecimal.ZERO);
        model.setValue("inituseamt", (Object)BigDecimal.ZERO);
        model.deleteEntryData("treeentryentity");
    }

    public static void collectInitAmt(String key, IFormView view) {
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)view.getControl("treeentryentity");
        int[] selectRows = treeEntryGrid.getSelectRows();
        DynamicObjectCollection entryEntity = view.getModel().getEntryEntity("treeentryentity");
        if (selectRows.length > 0) {
            BudgetDataInitHelper.updateParentAmt((DynamicObject)entryEntity.get(selectRows[0]), entryEntity, key, view);
        }
    }

    public static void updateParentAmt(DynamicObject row, DynamicObjectCollection treeEntryEntity, String amtName, IFormView view) {
        IDataModel model = view.getModel();
        long pid = row.getLong("pid");
        if (pid == 0L) {
            view.updateView("treeentryentity");
            return;
        }
        Optional<DynamicObject> optional = treeEntryEntity.stream().filter(dyn -> dyn.getLong("id") == pid).findFirst();
        if (optional.isPresent()) {
            DynamicObject parent = optional.get();
            BigDecimal childSummary = treeEntryEntity.stream().filter(dyn -> dyn.getLong("pid") == parent.getLong("id")).map(dyn -> dyn.getBigDecimal(amtName)).reduce(BigDecimal.ZERO, BigDecimal::add);
            model.beginInit();
            parent.set(amtName, (Object)childSummary);
            model.endInit();
            BudgetDataInitHelper.updateParentAmt(parent, treeEntryEntity, amtName, view);
        }
    }

    public static void autoSumInitAmount(IFormView view) {
        IDataModel model = view.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity("treeentryentity");
        BigDecimal initOccupyAmt = entryEntity.stream().filter(dyn -> dyn.getBoolean("leaf")).map(dyn -> dyn.getBigDecimal("entryinitoccupyamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal initUseAmt = entryEntity.stream().filter(dyn -> dyn.getBoolean("leaf")).map(dyn -> dyn.getBigDecimal("entryinituseamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
        model.setValue("initoccupyamt", (Object)initOccupyAmt);
        model.setValue("inituseamt", (Object)initUseAmt);
    }

    public static void updateBudgetCtrl(DynamicObject data, boolean isAdd) {
        DynamicObject project = data.getDynamicObject("project");
        QFilter tProjectFilter = new QFilter("tproject", "=", project.getPkValue());
        DynamicObject totalBudgetCtrl = BusinessDataServiceHelper.loadSingle((String)"pmas_totalbudgetctrl", (QFilter[])new QFilter[]{tProjectFilter});
        if (totalBudgetCtrl == null) {
            return;
        }
        BigDecimal initOccupyAmt = data.getBigDecimal("initoccupyamt");
        BigDecimal tOccupyAmt = totalBudgetCtrl.getBigDecimal("toccupyamt");
        BigDecimal initUseAmt = data.getBigDecimal("inituseamt");
        BigDecimal tUseAmt = totalBudgetCtrl.getBigDecimal("tusageamt");
        if (isAdd) {
            totalBudgetCtrl.set("toccupyamt", (Object)tOccupyAmt.add(initOccupyAmt));
            totalBudgetCtrl.set("tusageamt", (Object)tUseAmt.add(initUseAmt));
        } else {
            totalBudgetCtrl.set("toccupyamt", (Object)tOccupyAmt.subtract(initOccupyAmt));
            totalBudgetCtrl.set("tusageamt", (Object)tUseAmt.subtract(initUseAmt));
        }
        DynamicObjectCollection initEntry = data.getDynamicObjectCollection("treeentryentity");
        Map<Long, DynamicObject> budgetItemMap = initEntry.stream().collect(Collectors.toMap(dyn -> dyn.getDynamicObject("probudgetitem").getLong("id"), dyn -> dyn, (existing, replacement) -> existing));
        DynamicObjectCollection details = totalBudgetCtrl.getDynamicObjectCollection("tbudgetctrldetail");
        for (DynamicObject detail : details) {
            DynamicObject budget = detail.getDynamicObject("budget");
            Long budgetId = budget.getLong("id");
            if (!budgetItemMap.containsKey(budgetId)) continue;
            DynamicObject initData = budgetItemMap.get(budgetId);
            BigDecimal entryInitOccupyAmt = initData.getBigDecimal("entryinitoccupyamt");
            BigDecimal occupyAmt = detail.getBigDecimal("occupyamt");
            BigDecimal entryInitUseAmt = initData.getBigDecimal("entryinituseamt");
            BigDecimal useAmt = detail.getBigDecimal("usageamt");
            if (isAdd) {
                detail.set("occupyamt", (Object)occupyAmt.add(entryInitOccupyAmt));
                detail.set("usageamt", (Object)useAmt.add(entryInitUseAmt));
                continue;
            }
            detail.set("occupyamt", (Object)occupyAmt.subtract(entryInitOccupyAmt));
            detail.set("usageamt", (Object)useAmt.subtract(entryInitUseAmt));
        }
        SaveServiceHelper.update((DynamicObject)totalBudgetCtrl);
        QFilter projectFilter = new QFilter("yproject", "=", project.getPkValue());
        QFilter budgetTypeFilter = new QFilter("ybudgettype", "=", (Object)BudgetSourceTypeEnum.OUT.getValue());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
        Date billYear = data.getDate("year");
        int year = Integer.parseInt(sdf.format(billYear));
        QFilter yearFilter = new QFilter("YEAR(yyear)", "=", (Object)year);
        DynamicObject yearBudgetCtrl = BusinessDataServiceHelper.loadSingle((String)"pmas_ybudgetctrl", (QFilter[])new QFilter[]{budgetTypeFilter, projectFilter, yearFilter});
        if (yearBudgetCtrl == null) {
            return;
        }
        BigDecimal yUseAmt = yearBudgetCtrl.getBigDecimal("yusageamt");
        if (isAdd) {
            yearBudgetCtrl.set("yusageamt", (Object)yUseAmt.add(initUseAmt));
        } else {
            yearBudgetCtrl.set("yusageamt", (Object)yUseAmt.subtract(initUseAmt));
        }
        DynamicObjectCollection yearDetails = yearBudgetCtrl.getDynamicObjectCollection("ybudgetctrldetail");
        for (DynamicObject detail : yearDetails) {
            DynamicObject budget = detail.getDynamicObject("budget");
            Long budgetId = budget.getLong("id");
            if (!budgetItemMap.containsKey(budgetId)) continue;
            DynamicObject initData = budgetItemMap.get(budgetId);
            BigDecimal entryInitUseAmt = initData.getBigDecimal("entryinituseamt");
            BigDecimal useAmt = detail.getBigDecimal("usageamt");
            if (isAdd) {
                detail.set("usageamt", (Object)useAmt.add(entryInitUseAmt));
                continue;
            }
            detail.set("usageamt", (Object)useAmt.subtract(entryInitUseAmt));
        }
        SaveServiceHelper.update((DynamicObject)yearBudgetCtrl);
        if (isAdd) {
            BudgetDataInitHelper.logBudgetRecord(data);
        } else {
            BudgetDataInitHelper.invalidBudgetRecord(data);
        }
    }

    public static void logBudgetRecord(DynamicObject data) {
        Date bizDate = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(bizDate);
        int month = calendar.get(2) + 1;
        int quarter = (month - 1) / 3 + 1;
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"budget_data_init");
        DynamicObjectCollection entryEntity = data.getDynamicObjectCollection("treeentryentity");
        ArrayList<DynamicObject> budgetExeRecordList = new ArrayList<DynamicObject>();
        for (DynamicObject entity : entryEntity) {
            BigDecimal occupyAmt = entity.getBigDecimal("entryinitoccupyamt");
            BigDecimal useAmt = entity.getBigDecimal("entryinituseamt");
            if (occupyAmt.compareTo(BigDecimal.ZERO) > 0) {
                DynamicObject occupyBudgetExeRecord = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmas_budgetexerecord"));
                occupyBudgetExeRecord.set("optype", (Object)BudgetControlTargetEnum.BUDGETOCCUPY.getValue());
                occupyBudgetExeRecord.set("opaction", (Object)BillFieldTypeEnum.EXEC_OPERATION.getNumber());
                occupyBudgetExeRecord.set("budgettype", (Object)BudgetSourceTypeEnum.OUT.getValue());
                occupyBudgetExeRecord.set("project", data.get("project"));
                occupyBudgetExeRecord.set("probudget", entity.get("probudgetitem"));
                occupyBudgetExeRecord.set("controltype", (Object)BudgetControlTypeEnum.TAKEOPERATION.getValue());
                occupyBudgetExeRecord.set("year", (Object)calendar.getTime());
                occupyBudgetExeRecord.set("quarter", (Object)quarter);
                occupyBudgetExeRecord.set("month", (Object)month);
                occupyBudgetExeRecord.set("bizdate", (Object)bizDate);
                occupyBudgetExeRecord.set("bizbillmark", (Object)"budget_data_init");
                occupyBudgetExeRecord.set("bizbillname", (Object)dt.getDisplayName());
                occupyBudgetExeRecord.set("billid", data.getPkValue());
                occupyBudgetExeRecord.set("billno", data.get("billno"));
                occupyBudgetExeRecord.set("currency", data.get("currency"));
                occupyBudgetExeRecord.set("amount", (Object)entity.getBigDecimal("entryinitoccupyamt"));
                occupyBudgetExeRecord.set("oricurrency", data.get("currency"));
                occupyBudgetExeRecord.set("oriamount", (Object)entity.getBigDecimal("entryinitoccupyamt"));
                occupyBudgetExeRecord.set("org", data.get("org"));
                occupyBudgetExeRecord.set("bizuser", data.get("creator"));
                occupyBudgetExeRecord.set("optime", (Object)new Date());
                occupyBudgetExeRecord.set("iseffect", (Object)true);
                budgetExeRecordList.add(occupyBudgetExeRecord);
            }
            if (useAmt.compareTo(BigDecimal.ZERO) <= 0) continue;
            DynamicObject useBudgetExeRecord = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmas_budgetexerecord"));
            useBudgetExeRecord.set("optype", (Object)BudgetControlTargetEnum.BUDGETUSE.getValue());
            useBudgetExeRecord.set("opaction", (Object)BillFieldTypeEnum.EXEC_OPERATION.getNumber());
            useBudgetExeRecord.set("budgettype", (Object)BudgetSourceTypeEnum.OUT.getValue());
            useBudgetExeRecord.set("project", data.get("project"));
            useBudgetExeRecord.set("probudget", entity.get("probudgetitem"));
            useBudgetExeRecord.set("controltype", (Object)BudgetControlTypeEnum.EXECOPERATION.getValue());
            useBudgetExeRecord.set("year", (Object)calendar.getTime());
            useBudgetExeRecord.set("quarter", (Object)quarter);
            useBudgetExeRecord.set("month", (Object)month);
            useBudgetExeRecord.set("bizdate", (Object)bizDate);
            useBudgetExeRecord.set("bizbillmark", (Object)"budget_data_init");
            useBudgetExeRecord.set("bizbillname", (Object)dt.getDisplayName());
            useBudgetExeRecord.set("billid", data.getPkValue());
            useBudgetExeRecord.set("billno", data.get("billno"));
            useBudgetExeRecord.set("currency", data.get("currency"));
            useBudgetExeRecord.set("amount", (Object)entity.getBigDecimal("entryinituseamt"));
            useBudgetExeRecord.set("oricurrency", data.get("currency"));
            useBudgetExeRecord.set("oriamount", (Object)entity.getBigDecimal("entryinituseamt"));
            useBudgetExeRecord.set("org", data.get("org"));
            useBudgetExeRecord.set("bizuser", data.get("creator"));
            useBudgetExeRecord.set("optime", (Object)new Date());
            useBudgetExeRecord.set("iseffect", (Object)true);
            budgetExeRecordList.add(useBudgetExeRecord);
        }
        SaveServiceHelper.save((DynamicObject[])budgetExeRecordList.toArray(new DynamicObject[0]));
    }

    public static void invalidBudgetRecord(DynamicObject data) {
        DynamicObject[] recordList;
        QFilter billIdFilter = new QFilter("billid", "=", (Object)data.getPkValue().toString());
        QFilter effectFilter = new QFilter("iseffect", "=", (Object)true);
        for (DynamicObject record : recordList = BusinessDataServiceHelper.load((String)"pmas_budgetexerecord", (String)"iseffect", (QFilter[])new QFilter[]{billIdFilter, effectFilter})) {
            record.set("iseffect", (Object)false);
        }
        SaveServiceHelper.update((DynamicObject[])recordList);
    }
}

