/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmco.business.helper;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.pmgt.pmbs.business.budget.ProjectCloudFunctionHelper;
import kd.pmgt.pmbs.business.helper.ProBudgetControlHelper;
import kd.pmgt.pmbs.common.budget.BudgetParam;
import kd.pmgt.pmbs.common.budget.BudgetRegValue;
import kd.pmgt.pmbs.common.enums.BudgetControlTargetEnum;
import kd.pmgt.pmbs.common.enums.BudgetSourceTypeEnum;
import kd.pmgt.pmbs.common.enums.budgetreg.BillFieldTypeEnum;
import kd.pmgt.pmbs.common.thread.PmgtThreadPools;
import kd.pmgt.pmbs.mservice.budget.ProjectBudgetService;
import kd.pmgt.pmbs.mservice.impl.budget.ProjectBudgetServiceImpl;
import org.apache.commons.lang3.StringUtils;

public class BudgetDataRelHelper {
    private static final String ENTRY_BILL_NO_SELECT = "entry_bill_no_select";
    private static final String BILL_NO_CLOSE_CALL_BACK = "bill_no_close_call_back";

    public static String getExecuteOperationName(DynamicObject register, String operation) {
        DynamicObject[] bgControlBizRegArray;
        QFilter bizUnitIdFilter = new QFilter("bizunitid", "=", register.getPkValue());
        DynamicObject[] regData = BusinessDataServiceHelper.load((String)"pmbs_bgcontrolbizreg", (String)"", (QFilter[])new QFilter[]{bizUnitIdFilter});
        if (regData == null || regData.length == 0) {
            return null;
        }
        for (DynamicObject regInfo : bgControlBizRegArray = BusinessDataServiceHelper.load((Object[])Arrays.stream(regData).map(DataEntityBase::getPkValue).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmbs_bgcontrolbizreg"))) {
            String type = regInfo.getString("type");
            if (!operation.equals(type)) continue;
            return regInfo.getString("number");
        }
        return null;
    }

    public static int getCurrentRow(IFormView view) {
        EntryGrid grid = (EntryGrid)view.getControl("entryentity");
        int[] selectRows = grid.getSelectRows();
        if (selectRows.length > 0) {
            return selectRows[0];
        }
        return 0;
    }

    public static String getBillNameField(String formId) {
        String bizFieldRegKey = null;
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)formId);
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        for (IDataEntityProperty item : properties) {
            DynamicProperty property = (DynamicProperty)item;
            if (!Arrays.asList("billname", "name").contains(property.getName())) continue;
            bizFieldRegKey = property.getName();
            break;
        }
        return bizFieldRegKey;
    }

    public static boolean checkProject(DynamicObject project, IFormView view) {
        if (project == null) {
            return true;
        }
        boolean hasProBudgetCtrl = ProBudgetControlHelper.checkIsNewProBudgetCtrl((Long)project.getLong("id"));
        if (!hasProBudgetCtrl) {
            view.showTipNotification(ResManager.loadKDString((String)"\u9879\u76ee\u5c1a\u672a\u7f16\u5236\u9884\u7b97\uff0c\u65e0\u6cd5\u521d\u59cb\u5316\u3002", (String)"BudgetDataRelHelper_0", (String)"pmgt-pmco-business", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public static void autoSumAmount(IFormView view) {
        IDataModel model = view.getModel();
        BigDecimal occupyAmt = BigDecimal.ZERO;
        BigDecimal useAmt = BigDecimal.ZERO;
        DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
        for (DynamicObject entity : entryEntity) {
            String target = entity.getString("controltarget");
            BigDecimal amt = entity.getBigDecimal("amt");
            if (BudgetControlTargetEnum.BUDGETUSE.getValue().equals(target)) {
                useAmt = useAmt.add(amt);
                continue;
            }
            if (BudgetControlTargetEnum.BUDGETOCCUPY.getValue().equals(target)) {
                occupyAmt = occupyAmt.add(amt);
                continue;
            }
            useAmt = useAmt.add(amt);
            occupyAmt = occupyAmt.add(amt);
        }
        model.setValue("occupyamt", (Object)occupyAmt);
        model.setValue("useamt", (Object)useAmt);
    }

    public static void clearDataWithProjectYear(IFormView view) {
        view.getModel().setValue("outamount", (Object)BigDecimal.ZERO);
        view.getModel().setValue("budgetstage", null);
        view.getModel().setValue("proyearbudgetamt", (Object)BigDecimal.ZERO);
    }

    public static void loadDataByProject(DynamicObject project, IFormView view) {
        IDataModel model = view.getModel();
        if (project == null) {
            model.setValue("projcetbugamt", (Object)BigDecimal.ZERO);
            model.setValue("prooutbudgetsumamt", (Object)BigDecimal.ZERO);
            model.setValue("proyearbudgetamt", (Object)BigDecimal.ZERO);
            model.setValue("outamount", (Object)BigDecimal.ZERO);
            model.setValue("budgetstage", null);
            model.deleteEntryData("entryentity");
            model.setValue("occupyamt", (Object)BigDecimal.ZERO);
            model.setValue("useamt", (Object)BigDecimal.ZERO);
        } else {
            model.deleteEntryData("entryentity");
            model.setValue("occupyamt", (Object)BigDecimal.ZERO);
            model.setValue("useamt", (Object)BigDecimal.ZERO);
            QFilter tProjectFilter = new QFilter("tproject", "=", project.getPkValue());
            DynamicObject totalBudgetCtrl = BusinessDataServiceHelper.loadSingle((String)"pmas_totalbudgetctrl", (QFilter[])new QFilter[]{tProjectFilter});
            if (totalBudgetCtrl == null) {
                return;
            }
            model.setValue("projcetbugamt", (Object)totalBudgetCtrl.getBigDecimal("proappamt"));
            model.setValue("prooutbudgetsumamt", (Object)totalBudgetCtrl.getBigDecimal("tbudgetamt"));
            Object year = model.getValue("year");
            if (year == null) {
                BudgetDataRelHelper.clearDataWithProjectYear(view);
            } else {
                QFilter isValidFilter = new QFilter("isvalid", "=", (Object)"1");
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
                int yearInt = Integer.parseInt(sdf.format((Date)year));
                QFilter yearFilter = new QFilter("YEAR(year)", "=", (Object)yearInt);
                QFilter projectFilter = new QFilter("project", "=", project.getPkValue());
                QFilter outBudgetItemFilter = new QFilter("sourcetype", "=", (Object)BudgetSourceTypeEnum.OUT.getValue());
                DynamicObject validBudget = BusinessDataServiceHelper.loadSingle((String)"pmas_budget", (QFilter[])new QFilter[]{isValidFilter, projectFilter, outBudgetItemFilter, yearFilter});
                if (validBudget == null) {
                    BudgetDataRelHelper.clearDataWithProjectYear(view);
                    return;
                }
                model.setValue("budgetstage", validBudget.get("budgetstage"));
                model.setValue("proyearbudgetamt", validBudget.get("totalyearamt"));
                model.setValue("outamount", validBudget.get("totalamount"));
            }
        }
    }

    public static void selectBill(ClosedCallBackEvent event, IFormView view) {
        IDataModel model = view.getModel();
        int currentRowIndex = BudgetDataRelHelper.getCurrentRow(view);
        ListSelectedRowCollection list = (ListSelectedRowCollection)event.getReturnData();
        if (list == null || list.isEmpty()) {
            return;
        }
        view.getPageCache().put(BILL_NO_CLOSE_CALL_BACK, BILL_NO_CLOSE_CALL_BACK);
        model.setValue("entrybillpk", list.get(0).getPrimaryKeyValue(), currentRowIndex);
        model.setValue("entrybillno", (Object)list.get(0).getBillNo(), currentRowIndex);
        String billType = (String)model.getValue("billtype");
        String billNameField = BudgetDataRelHelper.getBillNameField(billType);
        DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)list.get(0).getPrimaryKeyValue(), (String)billType);
        if (billNameField != null) {
            model.setValue("entrybillname", (Object)bill.getString(billNameField), currentRowIndex);
        } else {
            model.setValue("entrybillname", (Object)list.get(0).getBillNo(), currentRowIndex);
        }
        ProjectBudgetServiceImpl projectBudgetService = new ProjectBudgetServiceImpl();
        BudgetParam budgetParam = projectBudgetService.initBudgetParam(bill, "submit");
        List budgetRegValues = budgetParam.getBudgetRegValues();
        if (!budgetRegValues.isEmpty()) {
            BudgetRegValue value = (BudgetRegValue)budgetRegValues.get(0);
            model.setValue("entrycurrency", (Object)value.getCurrencyValue(), currentRowIndex);
            BigDecimal sumAmount = budgetRegValues.stream().map(obj -> obj.getAmountValue()).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            model.setValue("amt", (Object)sumAmount, currentRowIndex);
            Object[] projectArray = budgetRegValues.stream().map(dyn -> dyn.getProjectValue().getPkValue()).toArray();
            model.setValue("billprojectlist", (Object)projectArray, currentRowIndex);
            model.setValue("entrydate", (Object)value.getBizDateValue(), currentRowIndex);
        }
        DynamicObject rowEntity = model.getEntryRowEntity("entryentity", currentRowIndex);
        DynamicObject register = rowEntity.getDynamicObject("budgetregist");
        if (list.size() > 1) {
            for (int i = 1; i < list.size(); ++i) {
                int insertIndex = model.insertEntryRow("entryentity", currentRowIndex + i);
                if (register != null) {
                    model.setValue("budgetregist", (Object)register, insertIndex);
                    String nextBillType = (String)model.getValue("billtype");
                    String nextBillNameField = BudgetDataRelHelper.getBillNameField(nextBillType);
                    bill = BusinessDataServiceHelper.loadSingle((Object)list.get(i).getPrimaryKeyValue(), (String)nextBillType);
                    if (billNameField != null) {
                        model.setValue("entrybillname", (Object)bill.getString(nextBillNameField), insertIndex);
                    } else {
                        model.setValue("entrybillname", (Object)list.get(i).getBillNo(), insertIndex);
                    }
                    budgetParam = projectBudgetService.initBudgetParam(bill, "submit");
                    budgetRegValues = budgetParam.getBudgetRegValues();
                    if (!budgetRegValues.isEmpty()) {
                        BudgetRegValue value = (BudgetRegValue)budgetRegValues.get(0);
                        model.setValue("entrycurrency", (Object)value.getCurrencyValue(), insertIndex);
                        BigDecimal sumAmount = budgetRegValues.stream().map(obj -> obj.getAmountValue()).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                        model.setValue("amt", (Object)sumAmount, insertIndex);
                        Object[] projectArray = budgetRegValues.stream().map(dyn -> dyn.getProjectValue().getPkValue()).toArray();
                        model.setValue("billprojectlist", (Object)projectArray, insertIndex);
                        model.setValue("entrydate", (Object)value.getBizDateValue(), insertIndex);
                    }
                }
                model.setValue("entrybillpk", list.get(i).getPrimaryKeyValue(), insertIndex);
                model.setValue("entrybillno", (Object)list.get(i).getBillNo(), insertIndex);
            }
        }
        view.getPageCache().remove(BILL_NO_CLOSE_CALL_BACK);
    }

    public static void clickBill(IFormView view, IFormPlugin plugin) {
        IDataModel model = view.getModel();
        int currentRow = BudgetDataRelHelper.getCurrentRow(view);
        String billType = (String)model.getValue("billtype", currentRow);
        DynamicObject regist = (DynamicObject)model.getValue("budgetregist", currentRow);
        String formulaJson = regist.getString("formulajson");
        String initStatus = regist.getString("initstatus");
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)(initStatus != null ? initStatus : ""));
        DynamicObjectCollection idList = QueryServiceHelper.query((String)billType, (String)"id", (QFilter[])new QFilter[]{statusFilter});
        Object[] pks = idList.stream().map(dyn -> dyn.get("id")).toArray();
        DynamicObject[] bills = BusinessDataServiceHelper.load((Object[])pks, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)billType));
        ProjectCloudFunctionHelper projectCloudFunctionHelper = new ProjectCloudFunctionHelper();
        List<DynamicObject> billList = Arrays.stream(bills).collect(Collectors.toList());
        Iterator iterator = billList.iterator();
        ProjectBudgetServiceImpl projectBudgetService = new ProjectBudgetServiceImpl();
        while (iterator.hasNext()) {
            DynamicObject entity = (DynamicObject)iterator.next();
            Boolean result = projectCloudFunctionHelper.checkFunctionCondition(formulaJson, entity);
            if (!Boolean.FALSE.equals(result)) continue;
            iterator.remove();
        }
        DynamicObject project = (DynamicObject)model.getValue("project");
        List<Long> allowPks = project != null ? BudgetDataRelHelper.getAllowProjectIdListByInitBudgetParam(billList, project) : billList.stream().map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
        DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
        List existPkList = entryEntity.stream().map(dyn -> dyn.getLong("entrybillpk")).collect(Collectors.toList());
        allowPks.removeAll(existPkList);
        QFilter idFilter = new QFilter("id", "in", allowPks);
        ListShowParameter lsp = ShowFormHelper.createShowListForm((String)billType, (boolean)false, (int)2);
        lsp.setCustomParam("entity", (Object)billType);
        lsp.setMultiSelect(true);
        lsp.getListFilterParameter().getQFilters().add(idFilter);
        CloseCallBack closeCallBack = new CloseCallBack(plugin, ENTRY_BILL_NO_SELECT);
        lsp.setCloseCallBack(closeCallBack);
        view.showForm((FormShowParameter)lsp);
    }

    public static List<Long> getAllowProjectIdListByInitBudgetParam(List<DynamicObject> billList, DynamicObject project) {
        if (billList != null && !billList.isEmpty()) {
            ProjectBudgetServiceImpl projectBudgetService = new ProjectBudgetServiceImpl();
            ArrayList<CompletableFuture<List>> futures = new ArrayList<CompletableFuture<List>>(16);
            int partitionSize = (billList.size() + 5) / 6;
            ArrayList<List<DynamicObject>> partitions = new ArrayList<List<DynamicObject>>(16);
            for (int i = 0; i < billList.size(); i += partitionSize) {
                partitions.add(billList.subList(i, Math.min(i + partitionSize, billList.size())));
            }
            for (List list : partitions) {
                CompletableFuture<List> future = CompletableFuture.supplyAsync(() -> {
                    ArrayList<Long> result = new ArrayList<Long>();
                    for (DynamicObject bill : partition) {
                        BudgetParam budgetParam = projectBudgetService.initBudgetParam(bill, "submit");
                        List budgetRegValues = budgetParam.getBudgetRegValues();
                        if (budgetRegValues.isEmpty()) continue;
                        for (BudgetRegValue budgetRegValue : budgetRegValues) {
                            DynamicObject projectValue = budgetRegValue.getProjectValue();
                            if (projectValue == null || project.getLong("id") != projectValue.getLong("id")) continue;
                            result.add(bill.getLong("id"));
                        }
                    }
                    return result;
                }, arg_0 -> ((ThreadPool)PmgtThreadPools.PROJECT_REPORT_POOL).execute(arg_0));
                futures.add(future);
            }
            ArrayList<Long> allResults = new ArrayList<Long>();
            for (CompletableFuture<List> future : futures) {
                try {
                    allResults.addAll(future.get());
                }
                catch (InterruptedException | ExecutionException e) {
                    return new ArrayList<Long>();
                }
            }
            return allResults;
        }
        return new ArrayList<Long>();
    }

    public static void linkClickBill(HyperLinkClickEvent event, IFormView view) {
        int rowIndex = event.getRowIndex();
        DynamicObject collectEntryObj = view.getModel().getEntryRowEntity("entryentity", rowIndex);
        String billType = collectEntryObj.getString("billtype");
        Long billId = collectEntryObj.getLong("entrybillpk");
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setPkId((Object)billId);
        showParameter.setFormId(billType);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.VIEW);
        view.showForm((FormShowParameter)showParameter);
    }

    public static void budgetReturn(ProjectBudgetService projectBudgetService, DynamicObject dataEntity) {
        DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("entryentity");
        for (DynamicObject entity : entryEntity) {
            Long pk = entity.getLong("entrybillpk");
            String billType = entity.getString("billtype");
            DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)pk, (String)billType);
            DynamicObject register = entity.getDynamicObject("budgetregist");
            String returnAndClearOperation = BudgetDataRelHelper.getExecuteOperationName(register, BillFieldTypeEnum.RETURNANDCLEAR_OPERATION.getNumber());
            if (!StringUtils.isNotBlank((CharSequence)returnAndClearOperation)) continue;
            projectBudgetService.updateBudget(bill, returnAndClearOperation);
            QFilter billFilter = new QFilter("billid", "=", (Object)pk.toString());
            DeleteServiceHelper.delete((String)"pmas_budgetexerecord", (QFilter[])new QFilter[]{billFilter});
        }
    }

    public static void budgetTakeAndExec(ProjectBudgetService projectBudgetService, DynamicObject dataEntity) {
        DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("entryentity");
        for (DynamicObject entity : entryEntity) {
            long pk = entity.getLong("entrybillpk");
            String billType = entity.getString("billtype");
            DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)pk, (String)billType);
            DynamicObject register = entity.getDynamicObject("budgetregist");
            String takeOperation = BudgetDataRelHelper.getExecuteOperationName(register, BillFieldTypeEnum.TAKE_OPERATION.getNumber());
            String execOperation = BudgetDataRelHelper.getExecuteOperationName(register, BillFieldTypeEnum.EXEC_OPERATION.getNumber());
            if (!StringUtils.isNotBlank((CharSequence)takeOperation) || !StringUtils.isNotBlank((CharSequence)execOperation)) continue;
            projectBudgetService.updateBudget(bill, takeOperation);
            projectBudgetService.updateBudget(bill, execOperation);
        }
    }
}

