/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmco.business.helper;

import java.math.BigDecimal;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.pmgt.pmbs.business.helper.CostItemHelper;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.utils.CurrencyHelper;
import kd.pmgt.pmbs.common.utils.SystemParamHelper;

public class ContractCostHelper {
    public static boolean judgeCondition(IFormView view) {
        DynamicObject costDimension;
        boolean mustInput;
        DynamicObject project = (DynamicObject)view.getModel().getValue("project");
        DynamicObject period = (DynamicObject)view.getModel().getValue("period");
        if (project == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9879\u76ee\u3002", (String)"ContractCostHelper_0", (String)"pmgt-pmco-business", (Object[])new Object[0]));
            return false;
        }
        if (period == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u671f\u95f4\u3002", (String)"ContractCostHelper_1", (String)"pmgt-pmco-business", (Object[])new Object[0]));
            return false;
        }
        Object parameter = SystemParamHelper.getSystemParameter((String)"mustinputcostitem", (String)"pmbs", (Long)OrgUnitServiceHelper.getRootOrgId());
        boolean bl = mustInput = parameter == null || (Boolean)parameter != false;
        if (mustInput && (costDimension = (DynamicObject)view.getModel().getValue("costdimension")) == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6210\u672c\u7ef4\u5ea6\u3002", (String)"ContractCostHelper_2", (String)"pmgt-pmco-business", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public static QFilter[] getSettleInfoFilter(IDataModel model) {
        DynamicObject project = (DynamicObject)model.getValue("project");
        DynamicObject period = (DynamicObject)model.getValue("period");
        QFilter projectFilter = new QFilter("project", "=", project.getPkValue());
        QFilter periodFilter = new QFilter("enddate", "<=", (Object)period.getDate("enddate"));
        QFilter commonFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        QFilter payDirectionFilter = new QFilter("paydirection", "=", (Object)"out");
        QFilter isInCostFilter = new QFilter("contract.isincost", "=", (Object)Boolean.TRUE);
        return new QFilter[]{projectFilter, periodFilter, commonFilter, payDirectionFilter, isInCostFilter};
    }

    public static void loadSettleInfo(IFormView view) {
        IDataModel model = view.getModel();
        QFilter[] qFilters = ContractCostHelper.getSettleInfoFilter(model);
        DynamicObject[] settleInfoCols = BusinessDataServiceHelper.load((String)"pmct_outcontract_settle", (String)"billno, billstatus, creator, auditor, modifier, auditdate, createtime, modifytime, billname, contattr, org, project, period, begindate, enddate, conttotaloftaxamount, taxrate, ismultirate, ismulticurrency, isonlist, description, isvoucher, currency, stdcurrency, exratetable, exchangedate, exchangerate, radiofield, radiofield1, showcurrency, caloftaxamt, notcaloftaxamt, settleoftaxamount, totalcaloftaxamt, totalnotcaloftaxamt, totalsettleoftaxamount, totalplanpayoftaxamt, totalrealpayoftaxamt, stdcaloftaxamt, stdnotcaloftaxamt, stdsettleoftaxamount, stdtotalcaloftaxamt, stdtotalnotcaloftaxamt, stdtotalsettleoftaxamount, stdtotalplanpayoftaxamt, stdtotalrealpayoftaxamt, calofamt, notcalofamt, settleamount, totalcalofamt, totalnotcalofamt, totalsettleofamount, totalplanpayofamt, totalrealpayofamt, stdcalofamt, stdnotcalofamt, stdsettleamount, stdtotalcalofamt, stdtotalnotcalofamt, stdtotalsettleofamount, stdtotalplanpayofamt, stdtotalrealpayofamt, caltaxamt, notcaltaxamt, taxamount, totalcaltaxamt, totalnotcaltaxamt, totalsettletaxamount, totalplanpaytaxamt, totalrealpaytaxamt, stdcaltaxamt, stdnotcaltaxamt, stdtaxamount, stdtotalcaltaxamt, stdtotalnotcaltaxamt, stdtotalsettletaxamount, stdtotalplanpaytaxamt, stdtotalrealpaytaxamt, imageno, bizaccountorg, fiaccountorg, contract, paydirection, contpartb, suptotalcaloftaxamt, suptotalnotcaloftaxamt, suptotalsettleoftaxamt, suptotalplanpayoftaxamt, suptotalrealpayoftaxamt, stdsuptotalcaloftaxamt, stdsuptotalnotcaloftaxamt, stdsuptotalsettleoftaxamt, stdsuptplanpayoftaxamt, stdsuptrealpayoftaxamt, suptotalcalofamt, suptotalnotcalofamt, suptotalsettleofamt, suptotalplanpayofamt, suptotalrealpayofamt, stdsuptotalcalofamt, stdsuptotalnotcalofamt, stdsuptotalsettleofamt, stdsuptotalplanpayofamt, stdsuptotalrealpayofamt, suptotalcaltaxamt, suptotalnotcaltaxamt, suptotalsettletaxamt, suptotalplanpaytaxamt, suptotalrealpaytaxamt, stdsuptotalcaltaxamt, stdsuptotalnotcaltaxamt, stdsuptotalsettletaxamt, stdsuptplanpaytaxamt, stdsuptrealpaytaxamt", (QFilter[])qFilters);
        model.deleteEntryData("entryentity");
        model.deleteEntryData("subentryentity");
        if (settleInfoCols == null || settleInfoCols.length <= 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u65e0\u5173\u8054\u6570\u636e\u3002", (String)"ContractCostHelper_3", (String)"pmgt-pmco-business", (Object[])new Object[0]));
            return;
        }
        view.updateView("entryentity");
        HashMap<Long, BigDecimal> hisSplitAmtMap = ContractCostHelper.getHisSplitAmt(model);
        model.beginInit();
        for (DynamicObject settleObj : settleInfoCols) {
            DynamicObject info = BusinessDataServiceHelper.loadSingle((Object)settleObj.getPkValue(), (String)"pmct_outcontract_settle");
            DynamicObject contract = info.getDynamicObject("contract");
            if (contract != null && !StringUtils.equals((CharSequence)(contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_outcontract")).getString("contractpaycontrol"), (CharSequence)"settlecontrol")) continue;
            boolean isMultiCurrency = info.getBoolean("ismulticurrency");
            BigDecimal hisSplitAmt = BigDecimal.ZERO;
            if (hisSplitAmtMap != null && hisSplitAmtMap.containsKey(Long.parseLong(info.getPkValue().toString()))) {
                hisSplitAmt = hisSplitAmtMap.get(Long.parseLong(info.getPkValue().toString()));
            }
            BigDecimal settleAmount = info.getBigDecimal("settleamount");
            BigDecimal exchangeRate = BigDecimal.ONE;
            if (isMultiCurrency) {
                DynamicObject currency = info.getDynamicObject("currency");
                DynamicObject stdCurrency = info.getDynamicObject("stdcurrency");
                DynamicObject exRateTable = info.getDynamicObject("exratetable");
                exchangeRate = info.getBigDecimal("exchangerate");
                DynamicObject thisCurrency = model.getDataEntity().getDynamicObject("currency");
                if (currency != null && thisCurrency != null) {
                    if (stdCurrency.getPkValue().equals(thisCurrency.getPkValue())) {
                        settleAmount = settleAmount.multiply(exchangeRate);
                    } else if (currency.getPkValue().equals(thisCurrency.getPkValue())) {
                        exchangeRate = BigDecimal.ONE;
                    } else {
                        exchangeRate = CurrencyHelper.getExChangeRate((Long)currency.getLong("id"), (Long)stdCurrency.getLong("id"), (Long)exRateTable.getLong("id"), (Date)Date.from(Instant.now()));
                        settleAmount = settleAmount.multiply(exchangeRate);
                    }
                }
            }
            if (hisSplitAmt.compareTo(info.getBigDecimal("settleamount")) == 0) continue;
            int index = model.createNewEntryRow("entryentity");
            model.setValue("contract", info.get("contract"), index);
            model.setValue("contractnumber", info.get("contract.billno"), index);
            model.setValue("settlenumber", info.get("billno"), index);
            model.setValue("settleid", info.getPkValue(), index);
            model.setValue("settleperiod", info.get("period"), index);
            model.setValue("settleamount", (Object)settleAmount, index);
            model.setValue("settlesplitamount", (Object)hisSplitAmt, index);
            model.setValue("entrycomment", info.get("description"), index);
            List<DynamicObject> collection = ContractCostHelper.autoGetSplitData(info);
            if (collection != null && !collection.isEmpty()) {
                ContractCostHelper.loadItemInfo(index, info.getString("billno"), collection, model);
            } else {
                DynamicObjectCollection itemEntryCol = info.getDynamicObjectCollection("itementry");
                model.setEntryCurrentRowIndex("entryentity", index);
                model.deleteEntryData("subentryentity");
                for (DynamicObject dynamicObject : itemEntryCol) {
                    DynamicObject budget = dynamicObject.getDynamicObject("paybudgetitem");
                    Set costItems = new HashSet();
                    if (budget != null) {
                        if (model.getValue("costdimension") != null) {
                            DynamicObject costDimension = (DynamicObject)model.getValue("costdimension");
                            DynamicObject project = (DynamicObject)model.getValue("project");
                            long outBudgetId = Long.parseLong(budget.getPkValue().toString());
                            long projectId = Long.parseLong(project.getPkValue().toString());
                            long costDimensionId = Long.parseLong(costDimension.getPkValue().toString());
                            costItems = CostItemHelper.getCostItemsByProBudget((Long)outBudgetId, (Long)projectId, (Long)costDimensionId);
                        }
                        if (costItems.size() > 0) {
                            for (Long costItem : costItems) {
                                int row = model.createNewEntryRow("subentryentity");
                                model.setValue("subsettlenumber", (Object)info.getString("billno"), row);
                                model.setValue("listingname", (Object)dynamicObject.getDynamicObject("payitem").getString("name"), row);
                                model.setValue("budgetitem", (Object)budget, row);
                                DynamicObject costItemObj = BusinessDataServiceHelper.loadSingle((Object)costItem, (String)"pmbs_costitem");
                                model.setValue("costitem", (Object)costItemObj, row);
                            }
                        }
                    }
                    if (budget != null && costItems.size() != 0) continue;
                    int newEntryRow = model.createNewEntryRow("subentryentity");
                    model.setValue("subsettlenumber", (Object)info.getString("billno"), newEntryRow);
                    model.setValue("listingname", (Object)dynamicObject.getDynamicObject("payitem").getString("name"), newEntryRow);
                }
            }
            BigDecimal curSplitAmt = settleAmount.subtract(hisSplitAmt).multiply(exchangeRate);
            DynamicObject rowEntity = model.getEntryRowEntity("entryentity", index);
            if (rowEntity.getDynamicObjectCollection("subentryentity").size() > 0) {
                model.setValue("amount", (Object)curSplitAmt, 0);
            }
            model.setValue("splitamount", (Object)curSplitAmt, index);
            BigDecimal unSplitAmt = settleAmount.subtract(hisSplitAmt).subtract(curSplitAmt);
            model.setValue("unsplitamount", (Object)unSplitAmt, index);
        }
        model.endInit();
        view.updateView("entryentity");
        view.updateView("subentryentity");
    }

    public static void loadItemInfo(int index, String settleNumber, List<DynamicObject> collection, IDataModel model) {
        model.setEntryCurrentRowIndex("entryentity", index);
        model.deleteEntryData("subentryentity");
        DynamicObject project = (DynamicObject)model.getValue("project");
        if (collection == null || collection.size() == 0) {
            int newEntryRow = model.createNewEntryRow("subentryentity");
            model.setValue("subsettlenumber", (Object)settleNumber, newEntryRow);
        } else {
            for (DynamicObject info : collection) {
                DynamicObject outBudget = info.getDynamicObject("outbudget");
                Set costItems = new HashSet();
                if (outBudget != null) {
                    if (model.getValue("costdimension") != null) {
                        DynamicObject costDimension = (DynamicObject)model.getValue("costdimension");
                        long outBudgetId = Long.parseLong(outBudget.getPkValue().toString());
                        long projectId = Long.parseLong(project.getPkValue().toString());
                        long costDimensionId = Long.parseLong(costDimension.getPkValue().toString());
                        costItems = CostItemHelper.getCostItemsByProBudget((Long)outBudgetId, (Long)projectId, (Long)costDimensionId);
                    }
                    if (costItems.size() > 0) {
                        for (Long costItem : costItems) {
                            int row = model.createNewEntryRow("subentryentity");
                            model.setValue("subsettlenumber", (Object)settleNumber, row);
                            model.setValue("listingname", (Object)info.getString("listingname"), row);
                            model.setValue("budgetitem", (Object)info.getDynamicObject("outbudget"), row);
                            DynamicObject costItemObj = BusinessDataServiceHelper.loadSingle((Object)costItem, (String)"pmbs_costitem");
                            model.setValue("costitem", (Object)costItemObj, row);
                        }
                    }
                }
                if (outBudget != null && costItems.size() != 0) continue;
                int row = model.createNewEntryRow("subentryentity");
                model.setValue("subsettlenumber", (Object)settleNumber, row);
                model.setValue("listingname", (Object)info.getString("listingname"), row);
            }
        }
    }

    public static void setCostAmt(IDataModel model) {
        BigDecimal costAmt = ContractCostHelper.sumAmount("entryentity", "splitamount", model);
        model.setValue("costamount", (Object)costAmt);
    }

    public static BigDecimal sumAmount(String entryKey, String columnName, IDataModel model) {
        BigDecimal totalAmt = BigDecimal.ZERO;
        int index = model.getEntryRowCount(entryKey);
        for (int i = 0; i < index; ++i) {
            BigDecimal splitAmt = (BigDecimal)model.getValue(columnName, i);
            totalAmt = totalAmt.add(splitAmt);
        }
        return totalAmt;
    }

    public static QFilter[] getSplitInfoFilter(IDataModel model) {
        DynamicObject project = (DynamicObject)model.getValue("project");
        DynamicObject period = (DynamicObject)model.getValue("period");
        QFilter projectFilter = new QFilter("project", "=", project.getPkValue());
        QFilter periodFilter = new QFilter("period.enddate", "<=", (Object)period.getDate("enddate"));
        QFilter commonFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        Object costDimensionObj = model.getValue("costdimension");
        if (costDimensionObj != null) {
            DynamicObject costDimension = (DynamicObject)costDimensionObj;
            commonFilter.and("costdimension", "=", (Object)Long.parseLong(costDimension.getPkValue().toString()));
        }
        return new QFilter[]{projectFilter, periodFilter, commonFilter};
    }

    public static HashMap<Long, BigDecimal> getHisSplitAmt(IDataModel model) {
        String selectPro = "entryentity.splitamount,entryentity.settleid";
        QFilter[] qFilters = ContractCostHelper.getSplitInfoFilter(model);
        DynamicObject[] contCostCols = BusinessDataServiceHelper.load((String)"pmco_contractcost", (String)selectPro, (QFilter[])qFilters);
        if (contCostCols == null || contCostCols.length <= 0) {
            return null;
        }
        List dynamicObjects = Arrays.stream(contCostCols).filter(e -> !e.getPkValue().equals(model.getDataEntity().getPkValue())).collect(Collectors.toList());
        HashMap<Long, BigDecimal> map = new HashMap<Long, BigDecimal>();
        for (DynamicObject contCost : dynamicObjects) {
            DynamicObjectCollection entries = contCost.getDynamicObjectCollection("entryentity");
            if (entries == null || entries.size() <= 0) continue;
            for (DynamicObject settleInfo : entries) {
                Long settleId = settleInfo.getLong("settleid");
                BigDecimal splitAmt = settleInfo.getBigDecimal("splitamount");
                if (map.containsKey(settleId)) {
                    BigDecimal rs = map.get(settleId).add(splitAmt);
                    map.put(settleId, rs);
                    continue;
                }
                map.put(settleId, splitAmt);
            }
        }
        return map;
    }

    public static void calUnSplitAmt(int index, IDataModel model) {
        BigDecimal settleAmt = (BigDecimal)model.getValue("settleamount", index);
        BigDecimal settleSplitAmt = (BigDecimal)model.getValue("settlesplitamount", index);
        BigDecimal splitAmt = (BigDecimal)model.getValue("splitamount", index);
        BigDecimal unSplitAmt = settleAmt.subtract(settleSplitAmt).subtract(splitAmt);
        model.setValue("unsplitamount", (Object)unSplitAmt, index);
    }

    public static List<DynamicObject> autoGetSplitData(DynamicObject object) {
        DynamicObject info = BusinessDataServiceHelper.loadSingle((Object)object.getPkValue(), (String)"pmct_outcontract_settle");
        DynamicObjectCollection listmodelentry = info.getDynamicObjectCollection("listmodelentry");
        DynamicObjectCollection itementry = info.getDynamicObjectCollection("itementry");
        boolean isOnList = info.getBoolean("isonlist");
        if (listmodelentry == null || listmodelentry.size() <= 0 || !isOnList) {
            return null;
        }
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        block8: for (int i = 0; i < listmodelentry.size() && listmodelentry.get(i) != null; ++i) {
            String cmptype;
            switch (cmptype = ((DynamicObject)listmodelentry.get(i)).getString("cmptype")) {
                case "(+)": {
                    list.addAll((Collection<DynamicObject>)((DynamicObject)listmodelentry.get(i)).getDynamicObjectCollection("listentry"));
                    continue block8;
                }
                case "(-)": {
                    DynamicObjectCollection listentry = ((DynamicObject)listmodelentry.get(i)).getDynamicObjectCollection("listentry");
                    for (Iterator dynamicObject : listentry) {
                        dynamicObject.set("thisamount", BigDecimal.ZERO.subtract(dynamicObject.getBigDecimal("thisamount")));
                    }
                    list.addAll((Collection<DynamicObject>)((DynamicObject)listmodelentry.get(i)).getDynamicObjectCollection("listentry"));
                    continue block8;
                }
            }
        }
        block10: for (DynamicObject dynamicObject : itementry) {
            DynamicObject payitem = dynamicObject.getDynamicObject("payitem");
            String direction = payitem.getString("direction");
            BigDecimal amount = dynamicObject.getBigDecimal("amount");
            DynamicObject paybudgetitem = dynamicObject.getDynamicObject("paybudgetitem");
            for (DynamicObject model : listmodelentry) {
                for (DynamicObject settleList : model.getDynamicObjectCollection("listentry")) {
                    if (!dynamicObject.getPkValue().equals(settleList.getLong("payitemid"))) continue;
                    continue block10;
                }
            }
            if (StringUtils.equals((CharSequence)"02", (CharSequence)direction)) continue;
            if (StringUtils.equals((CharSequence)"01", (CharSequence)direction)) {
                amount = BigDecimal.ZERO.subtract(amount);
            }
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)"pmct_outcontract_settle");
            EntityType listentry = (EntityType)type.getAllEntities().get("listentry");
            DynamicObject dy = new DynamicObject((DynamicObjectType)listentry);
            dy.set("thisamount", (Object)amount);
            dy.set("outbudget", (Object)paybudgetitem);
            dy.set("listingname", (Object)String.format(ResManager.loadKDString((String)"\u652f\u4ed8\u9879\uff1a%s", (String)"ContractCostHelper_4", (String)"pmgt-pmco-business", (Object[])new Object[0]), payitem.getString("name")));
            list.add(dy);
        }
        return list;
    }
}

