/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmco.business.helper;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.TextProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pmgt.pmbs.business.helper.CostItemHelper;
import kd.pmgt.pmbs.business.helper.ProBudgetControlHelper;
import kd.pmgt.pmbs.common.enums.BudgetControlTargetEnum;
import kd.pmgt.pmbs.common.enums.BudgetControlTypeEnum;
import kd.pmgt.pmbs.common.enums.BudgetSourceTypeEnum;
import kd.pmgt.pmbs.common.enums.PerformAmountTypeEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.enums.budgetreg.BillFieldTypeEnum;
import kd.pmgt.pmbs.common.utils.DateUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ProCostAllocationHelper {
    public static void openOtherView(int index, IFormView formView) {
        IDataModel model = formView.getModel();
        String formId = null;
        Long billId = null;
        DynamicObject row = model.getEntryRowEntity("costsourceentity", index);
        long sourceId = row.getLong("sourceid");
        DynamicObject sourceBudget = row.getDynamicObject("sourcebudget");
        if (sourceBudget == null) {
            return;
        }
        DynamicObject pro = (sourceBudget = BusinessDataServiceHelper.loadSingle((Object)sourceBudget.getPkValue(), (String)"pmas_projectbudget")).getDynamicObject("project");
        if (pro == null) {
            return;
        }
        boolean isNew = ProBudgetControlHelper.checkIsNewProBudgetCtrl((Long)((Long)pro.getPkValue()));
        if (isNew) {
            DynamicObject performRecord = BusinessDataServiceHelper.loadSingle((Object)sourceId, (String)"pmas_budgetexerecord");
            formId = performRecord.getString("bizbillmark");
            billId = Long.parseLong(performRecord.getString("billid"));
        } else {
            QFilter performEntryIdFilter = new QFilter("performentry.id", "=", (Object)sourceId);
            DynamicObject projectBudget = BusinessDataServiceHelper.loadSingle((String)"pmas_projectbudget", (String)"performentry.billtype, performentry.billid", (QFilter[])performEntryIdFilter.toArray());
            if (projectBudget == null) {
                return;
            }
            DynamicObjectCollection performEntries = projectBudget.getDynamicObjectCollection("performentry");
            for (DynamicObject performEntry : performEntries) {
                if (Long.parseLong(performEntry.getPkValue().toString()) != sourceId) continue;
                formId = performEntry.getDynamicObject("billtype").getPkValue().toString();
                billId = performEntry.getLong("billid");
                break;
            }
        }
        if (StringUtils.isEmpty((CharSequence)formId)) {
            return;
        }
        boolean exists = QueryServiceHelper.exists((String)formId, (Object)billId);
        if (!exists) {
            return;
        }
        BillShowParameter parameter = new BillShowParameter();
        parameter.setFormId(formId);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setPkId((Object)billId);
        parameter.setStatus(OperationStatus.VIEW);
        formView.showForm((FormShowParameter)parameter);
    }

    public static void colorPaint(int row, Map<Long, Boolean> colorCache, IFormView formView) {
        EntryGrid proCostDetailControl = (EntryGrid)formView.getControl("procostalldetail");
        DynamicObject projectBudget = (DynamicObject)formView.getModel().getValue("probudget", row);
        if (projectBudget == null) {
            proCostDetailControl.setRowBackcolor("#ffffff", new int[]{row});
            return;
        }
        long projectBudgetId = Long.parseLong(projectBudget.getPkValue().toString());
        Boolean toPaintRed = colorCache.getOrDefault(projectBudgetId, false);
        if (!toPaintRed.booleanValue()) {
            proCostDetailControl.setRowBackcolor("#ffffff", new int[]{row});
        }
    }

    public static void loadColorPaint(IFormView formView) {
        IDataModel model = formView.getModel();
        int entryRowCount = model.getEntryRowCount("procostalldetail");
        HashMap<Long, Boolean> colorCache = new HashMap<Long, Boolean>();
        for (int row = 0; row < entryRowCount; ++row) {
            long projectBudgetId = 0L;
            DynamicObject projectBudget = (DynamicObject)model.getValue("probudget", row);
            if (projectBudget != null) {
                projectBudgetId = Long.parseLong(projectBudget.getPkValue().toString());
            }
            DynamicObject costDimension = (DynamicObject)model.getValue("costdimension");
            DynamicObject project = (DynamicObject)model.getValue("project");
            Set costItems = CostItemHelper.getCostItemsByProBudget((Long)projectBudgetId, (Long)Long.parseLong(project.getPkValue().toString()), (Long)Long.parseLong(costDimension.getPkValue().toString()));
            if (costItems.size() > 1) {
                colorCache.put(projectBudgetId, true);
            }
            ProCostAllocationHelper.colorPaint(row, colorCache, formView);
        }
    }

    public static void selectFirstRow(String entryFormId, IFormView formView) {
        IDataModel model = formView.getModel();
        DynamicObjectCollection entities = model.getDataEntity(true).getDynamicObjectCollection(entryFormId);
        EntryGrid proCostSplitEntryControl = (EntryGrid)formView.getControl(entryFormId);
        if (!entities.isEmpty()) {
            proCostSplitEntryControl.selectRows(0);
        }
    }

    public static void buildOldProSubCostSourceEntity(DynamicObject projectBudget, DynamicObject performEntry, DynamicObject subCostSourceEntity, IFormView formView) {
        IDataModel model = formView.getModel();
        long sourceBillId = Long.parseLong(performEntry.getPkValue().toString());
        long currentBillId = Long.parseLong(model.getDataEntity().getPkValue().toString());
        subCostSourceEntity.set("sourceid", (Object)sourceBillId);
        subCostSourceEntity.set("sourcenumber", (Object)performEntry.getString("billno"));
        subCostSourceEntity.set("sourcename", (Object)performEntry.getString("billname"));
        subCostSourceEntity.set("sourcebudget", (Object)projectBudget);
        BigDecimal amount = performEntry.getBigDecimal("billamt");
        QFilter budgetItemFilter = new QFilter("procostalldetail.probudget", "=", projectBudget.getPkValue());
        QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        DynamicObject costDimension = (DynamicObject)model.getValue("costdimension");
        QFilter costDimensionFilter = new QFilter("costdimension", "=", costDimension.getPkValue());
        String selectedProperties = "id,procostalldetail.probudget,billstatus,costdimension";
        DynamicObject[] splitCostArray = BusinessDataServiceHelper.load((String)"pmco_procostallocation", (String)selectedProperties, (QFilter[])new QFilter[]{budgetItemFilter, billStatusFilter, costDimensionFilter});
        Object[] splitCostIds = Arrays.stream(splitCostArray).map(DataEntityBase::getPkValue).toArray();
        MainEntityType splitCostDt = EntityMetadataCache.getDataEntityType((String)"pmco_procostallocation");
        splitCostArray = BusinessDataServiceHelper.load((Object[])splitCostIds, (DynamicObjectType)splitCostDt);
        BigDecimal splitedAmt = Arrays.stream(splitCostArray).map(it -> it.getDynamicObjectCollection("procostalldetail")).flatMap(Collection::stream).map(it -> it.getDynamicObjectCollection("costsourceentity")).flatMap(Collection::stream).filter(it -> it.getLong("sourceid") == sourceBillId).map(it -> it.getBigDecimal("sourcesplitcost")).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (splitedAmt.compareTo(amount) >= 0) {
            return;
        }
        subCostSourceEntity.set("sourceamount", (Object)amount);
        subCostSourceEntity.set("sourcesplitedcost", (Object)splitedAmt);
        BigDecimal sourceRemindCost = amount.subtract(splitedAmt);
        subCostSourceEntity.set("sourcesplitcost", (Object)sourceRemindCost);
        subCostSourceEntity.set("sourceremindcost", (Object)amount.subtract(splitedAmt).subtract(sourceRemindCost));
    }

    public static void buildNewProSubCostSourceEntity(DynamicObject projectBudget, DynamicObject budgetExeRecord, DynamicObject subCostSourceEntity, IFormView formView) {
        IDataModel model = formView.getModel();
        long sourceBillId = Long.parseLong(budgetExeRecord.getPkValue().toString());
        long currentBillId = Long.parseLong(model.getDataEntity().getPkValue().toString());
        subCostSourceEntity.set("sourceid", (Object)sourceBillId);
        subCostSourceEntity.set("sourcenumber", (Object)budgetExeRecord.getString("billno"));
        subCostSourceEntity.set("sourcename", (Object)budgetExeRecord.getString("billname"));
        subCostSourceEntity.set("sourcebudget", (Object)projectBudget);
        BigDecimal amount = budgetExeRecord.getBigDecimal("amount");
        QFilter budgetItemFilter = new QFilter("procostalldetail.probudget", "=", projectBudget.getPkValue());
        QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        DynamicObject costDimension = (DynamicObject)model.getValue("costdimension");
        QFilter costDimensionFilter = new QFilter("costdimension", "=", costDimension.getPkValue());
        String selectedProperties = "id,procostalldetail.probudget,billstatus,costdimension";
        DynamicObject[] splitCostArray = BusinessDataServiceHelper.load((String)"pmco_procostallocation", (String)selectedProperties, (QFilter[])new QFilter[]{budgetItemFilter, billStatusFilter, costDimensionFilter});
        Object[] splitCostIds = Arrays.stream(splitCostArray).map(DataEntityBase::getPkValue).toArray();
        MainEntityType splitCostDt = EntityMetadataCache.getDataEntityType((String)"pmco_procostallocation");
        splitCostArray = BusinessDataServiceHelper.load((Object[])splitCostIds, (DynamicObjectType)splitCostDt);
        BigDecimal splitedAmt = Arrays.stream(splitCostArray).map(it -> it.getDynamicObjectCollection("procostalldetail")).flatMap(Collection::stream).map(it -> it.getDynamicObjectCollection("costsourceentity")).flatMap(Collection::stream).filter(it -> it.getLong("sourceid") == sourceBillId).map(it -> it.getBigDecimal("sourcesplitcost")).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (splitedAmt.compareTo(amount) >= 0) {
            return;
        }
        subCostSourceEntity.set("sourceamount", (Object)amount);
        subCostSourceEntity.set("sourcesplitedcost", (Object)splitedAmt);
        BigDecimal sourceRemindCost = amount.subtract(splitedAmt);
        subCostSourceEntity.set("sourcesplitcost", (Object)sourceRemindCost);
        subCostSourceEntity.set("sourceremindcost", (Object)amount.subtract(splitedAmt).subtract(sourceRemindCost));
    }

    public static String createPlanName(DynamicObject project, IFormView formView) {
        String name = project.getString("name");
        SimpleDateFormat sdf = new SimpleDateFormat("MMdd");
        String formatDate = sdf.format(new Date());
        String billName = String.format(ResManager.loadKDString((String)"%1$s\u6210\u672c\u5206\u644a%2$s", (String)"ProCostAllocationHelper_0", (String)"pmgt-pmco-business", (Object[])new Object[0]), name, formatDate);
        IDataEntityProperty billNameProperty = formView.getModel().getDataEntityType().findProperty("billname");
        int limitLength = ((TextProp)billNameProperty).getMaxLenth();
        if (billName.length() > limitLength) {
            billName = billName.substring(0, limitLength);
            formView.showTipNotification(String.format(ResManager.loadKDString((String)"\u540d\u79f0\u8d85\u51fa\u4e86\u6700\u5927\u957f\u5ea6%s\uff0c\u5df2\u81ea\u52a8\u622a\u53d6\u3002", (String)"ProCostAllocationHelper_1", (String)"pmgt-pmco-business", (Object[])new Object[0]), limitLength));
        }
        return billName;
    }

    public static void buildNewProSubCostSourceEntities(DynamicObject projectBudget, DynamicObject proCostSplitEntry, List<DynamicObject> budgetExeRecords, IFormView formView) {
        IDataModel model = formView.getModel();
        DynamicObjectCollection subCostSourceEntities = proCostSplitEntry.getDynamicObjectCollection("costsourceentity");
        subCostSourceEntities.clear();
        DynamicObject period = (DynamicObject)model.getValue("period");
        for (DynamicObject budgetExeRecord : budgetExeRecords) {
            budgetExeRecord = BusinessDataServiceHelper.loadSingle((Object)budgetExeRecord.getPkValue(), (String)"pmas_budgetexerecord");
            if (period != null) {
                Date lastDate = period.getDate("enddate");
                Date bizDate = budgetExeRecord.getDate("bizdate");
                if (DateUtil.compareByDay((Date)bizDate, (Date)lastDate) > 0) continue;
            }
            DynamicObject subCostSourceEntity = subCostSourceEntities.addNew();
            ProCostAllocationHelper.buildNewProSubCostSourceEntity(projectBudget, budgetExeRecord, subCostSourceEntity, formView);
            BigDecimal sourceSplitCost = subCostSourceEntity.getBigDecimal("sourcesplitcost");
            if (sourceSplitCost.compareTo(BigDecimal.ZERO) != 0) continue;
            subCostSourceEntities.remove((Object)subCostSourceEntity);
        }
    }

    public static void calculateTotalCostAmt(IFormView formView) {
        IDataModel model = formView.getModel();
        DynamicObjectCollection proCostSplitEntryCol = model.getEntryEntity("procostalldetail");
        BigDecimal costAmountSum = proCostSplitEntryCol.stream().map(entry -> entry.getBigDecimal("costamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        model.setValue("costamountsum", (Object)costAmountSum);
    }

    public static void sumToParentEntry(int parentRowIndex, IFormView formView) {
        IDataModel model = formView.getModel();
        BigDecimal totalAmount = BigDecimal.ZERO;
        DynamicObject parentRowEntity = model.getEntryRowEntity("procostalldetail", parentRowIndex);
        if (parentRowEntity != null) {
            BigDecimal costAmt;
            DynamicObjectCollection childCollection = parentRowEntity.getDynamicObjectCollection("costsourceentity");
            if (childCollection != null && !childCollection.isEmpty()) {
                for (DynamicObject entry : childCollection) {
                    totalAmount = totalAmount.add(entry.getBigDecimal("sourcesplitcost"));
                }
            }
            if ((costAmt = parentRowEntity.getBigDecimal("costamount")).compareTo(totalAmount) != 0) {
                model.setValue("costamount", (Object)totalAmount, parentRowIndex);
            }
        }
    }

    public static void buildOldProSubCostSourceEntities(DynamicObject projectBudget, DynamicObject proCostSplitEntry, IFormView formView) {
        IDataModel model = formView.getModel();
        DynamicObjectCollection performEntries = projectBudget.getDynamicObjectCollection("performentry");
        DynamicObjectCollection subCostSourceEntities = proCostSplitEntry.getDynamicObjectCollection("costsourceentity");
        subCostSourceEntities.clear();
        DynamicObject period = (DynamicObject)model.getValue("period");
        for (DynamicObject performEntry : performEntries) {
            if (!StringUtils.equals((CharSequence)performEntry.getString("billstatus"), (CharSequence)StatusEnum.CHECKED.getValue())) continue;
            if (period != null) {
                Date lastDate = period.getDate("enddate");
                Date billAuditDate = performEntry.getDate("billauditdate");
                if (DateUtil.compareByDay((Date)billAuditDate, (Date)lastDate) > 0) continue;
            }
            if (StringUtils.equals((CharSequence)performEntry.getDynamicObject("billtype").getPkValue().toString(), (CharSequence)"pmco_procostallocation")) continue;
            DynamicObject subCostSourceEntity = subCostSourceEntities.addNew();
            ProCostAllocationHelper.buildOldProSubCostSourceEntity(projectBudget, performEntry, subCostSourceEntity, formView);
            BigDecimal sourceSplitCost = subCostSourceEntity.getBigDecimal("sourcesplitcost");
            if (sourceSplitCost.compareTo(BigDecimal.ZERO) != 0) continue;
            subCostSourceEntities.remove((Object)subCostSourceEntity);
        }
    }

    public static List<DynamicObject> buildCostEntryByNewProjectBudget(DynamicObject project, DynamicObject projectBudget, List<DynamicObject> performRecords, Map<Long, Boolean> colorCache, IFormView formView) {
        IDataModel model = formView.getModel();
        ArrayList<DynamicObject> proCostSplitEntries = new ArrayList<DynamicObject>();
        DynamicObjectType entryType = model.getDataEntity(true).getDynamicObjectCollection("procostalldetail").getDynamicObjectType();
        Set costItems = new HashSet();
        if (projectBudget != null) {
            long projectBudgetId = Long.parseLong(projectBudget.getPkValue().toString());
            DynamicObject costDimension = (DynamicObject)model.getValue("costdimension");
            if (costDimension != null) {
                costItems = CostItemHelper.getCostItemsByProBudget((Long)projectBudgetId, (Long)Long.parseLong(project.getPkValue().toString()), (Long)Long.parseLong(costDimension.getPkValue().toString()));
                if (costItems.size() > 1) {
                    Optional first = costItems.stream().findFirst();
                    Long costItem = (Long)first.get();
                    DynamicObject proCostSplitEntry = new DynamicObject(entryType);
                    proCostSplitEntry.set("probudget", (Object)projectBudget);
                    DynamicObject costItemObj = BusinessDataServiceHelper.loadSingle((Object)costItem, (String)"pmbs_costitem");
                    proCostSplitEntry.set("costitem", (Object)costItemObj);
                    ProCostAllocationHelper.buildNewProSubCostSourceEntities(projectBudget, proCostSplitEntry, performRecords, formView);
                    proCostSplitEntries.add(proCostSplitEntry);
                    colorCache.put(projectBudgetId, true);
                } else if (costItems.size() == 1) {
                    Optional first = costItems.stream().findFirst();
                    Long costItem = (Long)first.get();
                    DynamicObject proCostSplitEntry = new DynamicObject(entryType);
                    proCostSplitEntry.set("probudget", (Object)projectBudget);
                    DynamicObject costItemObj = BusinessDataServiceHelper.loadSingle((Object)costItem, (String)"pmbs_costitem");
                    proCostSplitEntry.set("costitem", (Object)costItemObj);
                    ProCostAllocationHelper.buildNewProSubCostSourceEntities(projectBudget, proCostSplitEntry, performRecords, formView);
                    proCostSplitEntries.add(proCostSplitEntry);
                }
            }
        }
        if (costItems.size() == 0) {
            DynamicObject proCostSplitEntry = new DynamicObject(entryType);
            proCostSplitEntry.set("probudget", (Object)projectBudget);
            if (projectBudget != null) {
                ProCostAllocationHelper.buildNewProSubCostSourceEntities(projectBudget, proCostSplitEntry, performRecords, formView);
            }
            proCostSplitEntries.add(proCostSplitEntry);
        }
        return proCostSplitEntries;
    }

    public static List<DynamicObject> buildCostEntryByNewProject(DynamicObject project, Set<DynamicObject> projectBudgets, Map<DynamicObject, List<DynamicObject>> proBudgetToPerformRecords, Map<Long, Boolean> colorCache, IFormView formView) {
        ArrayList<DynamicObject> proCostSplitEntities = new ArrayList<DynamicObject>(16);
        for (DynamicObject projectBudget : projectBudgets) {
            List<DynamicObject> performRecords = proBudgetToPerformRecords.get(projectBudget);
            List<DynamicObject> proCostSplitEntry = ProCostAllocationHelper.buildCostEntryByNewProjectBudget(project, projectBudget, performRecords, colorCache, formView);
            for (DynamicObject proCostSplit : proCostSplitEntry) {
                DynamicObjectCollection costSourceEntities = proCostSplit.getDynamicObjectCollection("costsourceentity");
                if (CollectionUtils.isEmpty((Collection)costSourceEntities)) continue;
                proCostSplitEntities.add(proCostSplit);
            }
        }
        return proCostSplitEntities;
    }

    public static List<DynamicObject> buildCostEntryByOldProjectBudget(DynamicObject project, DynamicObject projectBudget, Map<Long, Boolean> colorCache, IFormView formView) {
        IDataModel model = formView.getModel();
        ArrayList<DynamicObject> proCostSplitEntries = new ArrayList<DynamicObject>();
        DynamicObjectType entryType = model.getDataEntity(true).getDynamicObjectCollection("procostalldetail").getDynamicObjectType();
        Set costItems = new HashSet();
        if (projectBudget != null) {
            long projectBudgetId = Long.parseLong(projectBudget.getPkValue().toString());
            DynamicObject costDimension = (DynamicObject)model.getValue("costdimension");
            if (costDimension != null) {
                costItems = CostItemHelper.getCostItemsByProBudget((Long)projectBudgetId, (Long)Long.parseLong(project.getPkValue().toString()), (Long)Long.parseLong(costDimension.getPkValue().toString()));
                if (costItems.size() > 1) {
                    Optional first = costItems.stream().findFirst();
                    Long costItem = (Long)first.get();
                    DynamicObject proCostSplitEntry = new DynamicObject(entryType);
                    proCostSplitEntry.set("probudget", (Object)projectBudget);
                    DynamicObject costItemObj = BusinessDataServiceHelper.loadSingle((Object)costItem, (String)"pmbs_costitem");
                    proCostSplitEntry.set("costitem", (Object)costItemObj);
                    ProCostAllocationHelper.buildOldProSubCostSourceEntities(projectBudget, proCostSplitEntry, formView);
                    proCostSplitEntries.add(proCostSplitEntry);
                    colorCache.put(projectBudgetId, true);
                } else if (costItems.size() == 1) {
                    Optional first = costItems.stream().findFirst();
                    Long costItem = (Long)first.get();
                    DynamicObject proCostSplitEntry = new DynamicObject(entryType);
                    proCostSplitEntry.set("probudget", (Object)projectBudget);
                    DynamicObject costItemObj = BusinessDataServiceHelper.loadSingle((Object)costItem, (String)"pmbs_costitem");
                    proCostSplitEntry.set("costitem", (Object)costItemObj);
                    ProCostAllocationHelper.buildOldProSubCostSourceEntities(projectBudget, proCostSplitEntry, formView);
                    proCostSplitEntries.add(proCostSplitEntry);
                }
            }
        }
        if (costItems.size() == 0) {
            DynamicObject proCostSplitEntry = new DynamicObject(entryType);
            proCostSplitEntry.set("probudget", (Object)projectBudget);
            if (projectBudget != null) {
                ProCostAllocationHelper.buildOldProSubCostSourceEntities(projectBudget, proCostSplitEntry, formView);
            }
            proCostSplitEntries.add(proCostSplitEntry);
        }
        return proCostSplitEntries;
    }

    public static List<DynamicObject> buildCostEntryByOldProject(DynamicObject project, DynamicObject[] projectBudgets, Map<Long, Boolean> colorCache, IFormView formView) {
        ArrayList<DynamicObject> proCostSplitEntities = new ArrayList<DynamicObject>(16);
        for (DynamicObject projectBudget : projectBudgets) {
            List<DynamicObject> proCostSplitEntry = ProCostAllocationHelper.buildCostEntryByOldProjectBudget(project, projectBudget, colorCache, formView);
            for (DynamicObject proCostSplit : proCostSplitEntry) {
                DynamicObjectCollection costSourceEntities = proCostSplit.getDynamicObjectCollection("costsourceentity");
                if (CollectionUtils.isEmpty((Collection)costSourceEntities)) continue;
                proCostSplitEntities.add(proCostSplit);
            }
        }
        return proCostSplitEntities;
    }

    public static void autoFetch(IFormView formView) {
        IDataModel model = formView.getModel();
        DynamicObject project = (DynamicObject)model.getValue("project");
        if (project == null) {
            return;
        }
        DynamicObjectCollection proCostAllDetailEntries = model.getDataEntity(true).getDynamicObjectCollection("procostalldetail");
        proCostAllDetailEntries.clear();
        boolean isNew = ProBudgetControlHelper.checkIsNewProBudgetCtrl((Long)((Long)project.getPkValue()));
        HashMap<Long, Boolean> colorCache = new HashMap<Long, Boolean>();
        if (isNew) {
            project = BusinessDataServiceHelper.loadSingle((Object)project.getPkValue(), (String)"bd_project");
            QFilter proFilter = new QFilter("project", "=", project.getPkValue());
            HashSet<String> ctrlOpType = new HashSet<String>(2);
            ctrlOpType.add(BudgetControlTargetEnum.BUDGETOCCUPYANDUSE.getValue());
            ctrlOpType.add(BudgetControlTargetEnum.BUDGETUSE.getValue());
            QFilter opTypeFilter = new QFilter("optype", "in", ctrlOpType);
            QFilter controlTypeFilter = new QFilter("controltype", "=", (Object)BudgetControlTypeEnum.EXECOPERATION.getValue());
            QFilter opActionFilter = new QFilter("opaction", "=", (Object)BillFieldTypeEnum.EXEC_OPERATION.getNumber());
            QFilter IsEffectFilter = new QFilter("iseffect", "=", (Object)true);
            String selectProperties = String.join((CharSequence)",", "optype", "opaction", "bizbillname", "probudget", "project", "controltype", "iseffect", "bizbillmark", "billno", "billname", "oriamount", "oricurrency", "currency", "amount", "bizuser", "optime", "billid");
            DynamicObject[] performRecords = BusinessDataServiceHelper.load((String)"pmas_budgetexerecord", (String)selectProperties, (QFilter[])new QFilter[]{opTypeFilter, controlTypeFilter, opActionFilter, IsEffectFilter, proFilter}, (String)"optime desc");
            Map<DynamicObject, List<DynamicObject>> proBudgetToPerformRecords = Arrays.stream(performRecords).collect(Collectors.groupingBy(performRecord -> performRecord.getDynamicObject("probudget"), Collectors.toList()));
            Set<DynamicObject> budgetSet = proBudgetToPerformRecords.keySet();
            if (budgetSet.size() > 0) {
                List<DynamicObject> proCostSplitEntities = ProCostAllocationHelper.buildCostEntryByNewProject(project, budgetSet, proBudgetToPerformRecords, colorCache, formView);
                proCostAllDetailEntries.addAll(proCostSplitEntities);
            }
        } else {
            QFilter performStatusFilter;
            project = BusinessDataServiceHelper.loadSingle((Object)project.getPkValue(), (String)"bd_project");
            QFilter projectFilter = new QFilter("project", "=", project.getPkValue());
            QFilter sourceTypeFilter = new QFilter("sourcetype", "=", (Object)BudgetSourceTypeEnum.OUT.getValue());
            String selectedProperties = "id, performentry.billid, performentry.billno, performentry.billname, performentry.billamt, performentry.performamttype, performentry.billstatus, performentry.billtype";
            QFilter performTypeFilter = new QFilter("performentry.performamttype", "=", (Object)PerformAmountTypeEnum.OTHER.getValue());
            DynamicObject[] projectBudgets = BusinessDataServiceHelper.load((String)"pmas_projectbudget", (String)selectedProperties, (QFilter[])new QFilter[]{projectFilter, performTypeFilter, sourceTypeFilter, performStatusFilter = new QFilter("performentry.billstatus", "=", (Object)StatusEnum.CHECKED.getValue())});
            if (projectBudgets != null && projectBudgets.length > 0) {
                List<DynamicObject> proCostSplitEntities = ProCostAllocationHelper.buildCostEntryByOldProject(project, projectBudgets, colorCache, formView);
                proCostAllDetailEntries.addAll(proCostSplitEntities);
            }
        }
        formView.updateView("procostalldetail");
        int entryRowCount = model.getEntryRowCount("procostalldetail");
        for (int row = 0; row < entryRowCount; ++row) {
            ProCostAllocationHelper.sumToParentEntry(row, formView);
            ProCostAllocationHelper.colorPaint(row, colorCache, formView);
        }
        if (proCostAllDetailEntries.size() == 0) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u6b64\u9879\u76ee\u672a\u83b7\u53d6\u5230\u4efb\u4f55\u6570\u636e\uff0c\u8bf7\u6362\u5176\u4ed6\u9879\u76ee\u8bd5\u8bd5\u3002", (String)"ProCostAllocationHelper_2", (String)"pmgt-pmco-business", (Object[])new Object[0]));
        }
        ProCostAllocationHelper.selectFirstRow("procostalldetail", formView);
    }
}

