/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmco.business.helper;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.business.helper.ProBudgetControlHelper;
import kd.pmgt.pmbs.common.enums.PerformAmountTypeEnum;
import kd.pmgt.pmbs.common.utils.budget.BudgetValidateAndUpdateHelper;
import kd.pmgt.pmbs.common.utils.budget.BudgetValidateInfo;
import kd.pmgt.pmbs.common.utils.budget.PerformBillInfo;
import kd.pmgt.pmbs.common.utils.budget.PerformBillInfoBuilder;
import kd.pmgt.pmbs.common.utils.budget.ProjectBudgetUpdateHelper;

public class ProCostSplitBudgetHelper {
    private static final Log logger = LogFactory.getLog(ProCostSplitBudgetHelper.class);

    public static BudgetValidateInfo validateBudget(ExtendedDataEntity dataEntity, String operateKey) {
        BudgetValidateInfo validateInfo = null;
        DynamicObject date = dataEntity.getDataEntity();
        Map<String, BigDecimal> proBudgetAmountMap = ProCostSplitBudgetHelper.getProBudgetAmount(dataEntity.getDataEntity(), true);
        logger.info("ProCostSplitBudgetHelper#updateBudget#validateBudget: {}", proBudgetAmountMap);
        if (proBudgetAmountMap.isEmpty()) {
            return null;
        }
        switch (operateKey) {
            case "submit": {
                validateInfo = BudgetValidateAndUpdateHelper.validateBudgetAmountOnSubmit(proBudgetAmountMap, (String)"0", (PerformAmountTypeEnum)PerformAmountTypeEnum.OTHER);
                break;
            }
            case "unsubmit": {
                validateInfo = BudgetValidateAndUpdateHelper.validateBudgetAmountOnUnSubmit(proBudgetAmountMap, (String)"0", (PerformAmountTypeEnum)PerformAmountTypeEnum.OTHER);
                break;
            }
            case "audit": {
                validateInfo = BudgetValidateAndUpdateHelper.validateBudgetAmountOnAuditAndUnaudit(proBudgetAmountMap, (String)"0", (long)Long.parseLong(date.getPkValue().toString()), (String)"pmco_procostsplit", (PerformAmountTypeEnum)PerformAmountTypeEnum.OTHER, (boolean)false);
                break;
            }
            case "unaudit": {
                validateInfo = BudgetValidateAndUpdateHelper.validateBudgetAmountOnAuditAndUnaudit(proBudgetAmountMap, (String)"0", (long)Long.parseLong(date.getPkValue().toString()), (String)"pmco_procostsplit", (PerformAmountTypeEnum)PerformAmountTypeEnum.OTHER, (boolean)true);
                break;
            }
        }
        return validateInfo;
    }

    public static void updateProBudget(DynamicObject dataEntity, String operateKey) {
        Map<String, BigDecimal> proBudgetAmountMap = ProCostSplitBudgetHelper.getProBudgetAmount(dataEntity, false);
        logger.info("ProCostSplitBudgetHelper#updateBudget#updateProBudget: {}", proBudgetAmountMap);
        if (proBudgetAmountMap.isEmpty()) {
            return;
        }
        long billId = Long.parseLong(dataEntity.getPkValue().toString());
        String billNo = dataEntity.getString("billno");
        String billName = dataEntity.getString("billname");
        DynamicObject creator = dataEntity.getDynamicObject("creator");
        Date createTime = dataEntity.getDate("createtime");
        DynamicObject currency = dataEntity.getDynamicObject("currency");
        switch (operateKey) {
            case "submit": {
                PerformBillInfo billInfo = new PerformBillInfoBuilder().formBillId("pmco_procostsplit").id(billId).billNo(billNo).billName(billName).creator(creator).createDate(createTime).contractCurrency(currency).amountType(PerformAmountTypeEnum.OTHER).build();
                ProjectBudgetUpdateHelper.updateBudgetOnSubmit(proBudgetAmountMap, proBudgetAmountMap, (PerformBillInfo)billInfo);
                break;
            }
            case "unsubmit": {
                PerformBillInfo billInfo = new PerformBillInfoBuilder().formBillId("pmco_procostsplit").id(billId).amountType(PerformAmountTypeEnum.OTHER).build();
                ProjectBudgetUpdateHelper.updateBudgetOnUnsubmit(proBudgetAmountMap, proBudgetAmountMap, (PerformBillInfo)billInfo);
                break;
            }
            case "audit": {
                DynamicObject auditor = BusinessDataServiceHelper.loadSingle((Object)RequestContext.get().getCurrUserId(), (String)"bos_user");
                PerformBillInfo billInfo = new PerformBillInfoBuilder().formBillId("pmco_procostsplit").id(billId).billNo(billNo).billName(billName).creator(creator).createDate(createTime).auditor(auditor).auditDate(new Date()).contractCurrency(currency).amountType(PerformAmountTypeEnum.OTHER).build();
                ProjectBudgetUpdateHelper.updateBudgetOnAudit(proBudgetAmountMap, proBudgetAmountMap, (PerformBillInfo)billInfo);
                break;
            }
            case "unaudit": {
                ProjectBudgetUpdateHelper.updateBudgetOnUnaudit(proBudgetAmountMap, proBudgetAmountMap, (String)"pmco_procostsplit", (long)billId, null, (PerformAmountTypeEnum)PerformAmountTypeEnum.OTHER);
                break;
            }
        }
    }

    private static Map<String, BigDecimal> getProBudgetAmount(DynamicObject data, boolean isValidator) {
        HashMap<String, BigDecimal> proBudgetAmountMap = new HashMap<String, BigDecimal>(16);
        boolean enableMultiPro = data.getBoolean("enablemultipro");
        DynamicObjectCollection entries = data.getDynamicObjectCollection("procostsplitentry");
        for (DynamicObject entry : entries) {
            boolean needUpdate;
            DynamicObject budget;
            boolean budgetCtrl;
            DynamicObject project = !enableMultiPro ? data.getDynamicObject("project") : entry.getDynamicObject("entryproject");
            if (project == null || (budgetCtrl = ProBudgetControlHelper.checkIsNewProBudgetCtrl((Long)Long.valueOf(project.getPkValue().toString())))) continue;
            boolean isProCostControl = ProBudgetControlHelper.checkIsProCostControl((DynamicObject)project);
            if (isValidator && !isProCostControl || (budget = entry.getDynamicObject("budgetitem")) == null || !(needUpdate = entry.getBoolean("needupdatebudget"))) continue;
            BigDecimal proBudgetAmount = (BigDecimal)proBudgetAmountMap.get(budget.getPkValue().toString());
            if (proBudgetAmount == null) {
                proBudgetAmount = BigDecimal.ZERO;
            }
            proBudgetAmountMap.put(budget.getPkValue().toString(), entry.getBigDecimal("costamt").add(proBudgetAmount));
        }
        return proBudgetAmountMap;
    }
}

