/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.opplugin;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.business.helper.ProBudgetControlHelper;
import kd.pmgt.pmbs.common.enums.ContractStatusEnum;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;
import kd.pmgt.pmbs.common.enums.PerformAmountTypeEnum;
import kd.pmgt.pmbs.common.utils.CurrencyHelper;
import kd.pmgt.pmbs.common.utils.budget.BudgetValidateAndUpdateHelper;
import kd.pmgt.pmbs.common.utils.budget.PerformBillInfo;
import kd.pmgt.pmbs.common.utils.budget.PerformBillInfoBuilder;
import kd.pmgt.pmct.opplugin.validator.ContStatusChangeValidator;

public class ContStatusChangeOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("contract");
        e.getFieldKeys().add("newstatus");
        e.getFieldKeys().add("oldstatus");
        e.getFieldKeys().add("pmct_statuschange");
        e.getFieldKeys().add("currency");
        e.getFieldKeys().add("createtime");
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("creator");
        e.getFieldKeys().add("auditor");
        e.getFieldKeys().add("auditdate");
        e.getFieldKeys().add("apptaxamount");
        e.getFieldKeys().add("entryentity");
        e.getFieldKeys().add("itemsubamount");
        e.getFieldKeys().add("budgetitem");
        e.getFieldKeys().add("itemappamount");
        e.getFieldKeys().add("appamount");
        e.getFieldKeys().add("apptaxamount");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String operationKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        switch (operationKey) {
            case "audit": {
                for (DynamicObject data : dataEntities) {
                    DynamicObject object = data.getDynamicObject("contract");
                    DynamicObject contract = BusinessDataServiceHelper.loadSingle((Object)object.getPkValue(), (String)"pmct_contracttpl");
                    DynamicObject newStatus = data.getDynamicObject("newstatus");
                    contract.set("contractstatus", (Object)newStatus);
                    if (ContractStatusEnum.CLOSED.getValue().equals(newStatus.getString("number"))) {
                        contract.set("appamount", (Object)data.getBigDecimal("appamount"));
                        contract.set("apptaxamount", (Object)data.getBigDecimal("apptaxamount"));
                    }
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{contract});
                }
                this.updateBudgetData(dataEntities, operationKey);
                break;
            }
            case "unaudit": {
                for (DynamicObject data : dataEntities) {
                    DynamicObject object = data.getDynamicObject("contract");
                    DynamicObject contract = BusinessDataServiceHelper.loadSingle((Object)object.getPkValue(), (String)"pmct_contracttpl");
                    contract.set("contractstatus", (Object)data.getDynamicObject("oldstatus"));
                    DynamicObject newStatus = data.getDynamicObject("newstatus");
                    if (ContractStatusEnum.CLOSED.getValue().equals(newStatus.getString("number"))) {
                        contract.set("appamount", (Object)BigDecimal.ZERO);
                        contract.set("apptaxamount", (Object)BigDecimal.ZERO);
                    }
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{contract});
                }
                this.updateBudgetData(dataEntities, operationKey);
                break;
            }
            case "submit": 
            case "unsubmit": {
                this.updateBudgetData(dataEntities, operationKey);
                break;
            }
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new ContStatusChangeValidator());
    }

    protected void updateBudgetData(DynamicObject[] entities, String operationKey) {
        for (DynamicObject bill : entities) {
            PerformBillInfo billInfo;
            Map<String, BigDecimal> projectAmountMap;
            DynamicObject contract = bill.getDynamicObject("contract");
            String statusChangeName = "";
            if (PayDirectionEnum.OUT.getValue().equals(contract.getString("paydirection"))) {
                contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_outcontract");
                statusChangeName = "pmct_statuschange";
            } else {
                contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_incontract");
                statusChangeName = "pmct_instatuschange";
            }
            Set<Object> proIdSet = this.getProIdSet(bill);
            if (proIdSet.isEmpty()) {
                return;
            }
            if (PayDirectionEnum.OUT.getValue().equals(contract.getString("paydirection"))) {
                proIdSet = proIdSet.stream().map(Object::toString).map(Long::valueOf).filter(proId -> !ProBudgetControlHelper.checkIsNewProBudgetCtrl((Long)proId)).collect(Collectors.toSet());
            }
            if ((projectAmountMap = this.buildBudgetAmountMap(bill, proIdSet)).isEmpty()) continue;
            Map<String, BigDecimal> contractAmountMap = this.buildBudgetAmountMap(bill, BigDecimal.ONE);
            if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"submit")) {
                billInfo = new PerformBillInfoBuilder().formBillId(statusChangeName).billNo(bill.getString("billno")).creator(bill.getDynamicObject("creator")).createDate(bill.getDate("createtime")).id(bill.getLong("id")).contractId(contract.getPkValue().toString()).amountType(PerformAmountTypeEnum.CONTRACT).build();
                BudgetValidateAndUpdateHelper.updateBudgetOnSubmit(projectAmountMap, contractAmountMap, (PerformBillInfo)billInfo);
                continue;
            }
            if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"unsubmit")) {
                billInfo = new PerformBillInfoBuilder().formBillId(statusChangeName).id(bill.getLong("id")).contractId(contract.getPkValue().toString()).amountType(PerformAmountTypeEnum.CONTRACT).build();
                BudgetValidateAndUpdateHelper.updateBudgetOnUnsubmit(projectAmountMap, contractAmountMap, (PerformBillInfo)billInfo);
                continue;
            }
            if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"audit")) {
                billInfo = new PerformBillInfoBuilder().formBillId(statusChangeName).billNo(bill.getString("billno")).creator(bill.getDynamicObject("creator")).createDate(bill.getDate("createtime")).auditor(bill.getDynamicObject("auditor")).auditDate(bill.getDate("auditdate")).id(bill.getLong("id")).contractId(contract.getPkValue().toString()).amountType(PerformAmountTypeEnum.CONTRACT).build();
                BudgetValidateAndUpdateHelper.updateBudgetOnAudit(projectAmountMap, contractAmountMap, (PerformBillInfo)billInfo);
                continue;
            }
            if (!StringUtils.equals((CharSequence)operationKey, (CharSequence)"unaudit")) continue;
            BudgetValidateAndUpdateHelper.updateBudgetOnUnaudit(projectAmountMap, contractAmountMap, (String)statusChangeName, (long)bill.getLong("id"), (String)contract.getPkValue().toString(), (PerformAmountTypeEnum)PerformAmountTypeEnum.CONTRACT);
        }
    }

    protected BigDecimal getExchangeRate(DynamicObject contract, DynamicObject project) {
        DynamicObject exRateTable;
        DynamicObject org = project.getDynamicObject("org");
        DynamicObject proCurrency = project.getDynamicObject("currencyfield");
        DynamicObject contractCurrency = contract.getDynamicObject("currency");
        DynamicObject stdCurrency = contract.getDynamicObject("stdcurrency");
        if (proCurrency != null && contractCurrency != null && proCurrency.getPkValue().equals(contractCurrency.getPkValue())) {
            return BigDecimal.ONE;
        }
        if (proCurrency != null && stdCurrency != null && proCurrency.getPkValue().equals(stdCurrency.getPkValue())) {
            return contract.getBigDecimal("exchangerate");
        }
        BigDecimal exchangeRate = BigDecimal.ONE;
        if (org != null && proCurrency != null && contractCurrency != null && (exRateTable = CurrencyHelper.getExRateTable((Long)org.getLong("id"))) != null) {
            exchangeRate = CurrencyHelper.getExChangeRate((Long)contractCurrency.getLong("id"), (Long)proCurrency.getLong("id"), (Long)exRateTable.getLong("id"), (Date)contract.getDate("createtime"));
        }
        return exchangeRate;
    }

    protected Map<String, BigDecimal> buildBudgetAmountMap(DynamicObject bill, BigDecimal exchangeRate) {
        HashMap<String, BigDecimal> budgetAmountMap = new HashMap<String, BigDecimal>();
        DynamicObjectCollection entryentity = bill.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entryentity) {
            BigDecimal amount = entry.getBigDecimal("itemsubamount").negate();
            DynamicObject budget = entry.getDynamicObject("budgetitem");
            if (budget == null || amount == null || amount.compareTo(BigDecimal.ZERO) == 0) continue;
            BigDecimal budgetAmount = (BigDecimal)budgetAmountMap.get(budget.getPkValue().toString());
            if (budgetAmount == null) {
                budgetAmount = BigDecimal.ZERO;
            }
            budgetAmountMap.put(budget.getPkValue().toString(), budgetAmount.add(amount.multiply(exchangeRate)));
        }
        return budgetAmountMap;
    }

    private Set<Object> getProIdSet(DynamicObject bill) {
        HashSet<Object> proIdSet = new HashSet<Object>(1);
        DynamicObject contract = bill.getDynamicObject("contract");
        boolean multipartSettlement = (contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_contracttpl")).getBoolean("multipartsettlement");
        if (multipartSettlement) {
            DynamicObjectCollection entryEntity = bill.getDynamicObjectCollection("entryentity");
            proIdSet = new HashSet(entryEntity.size());
            for (DynamicObject entry : entryEntity) {
                DynamicObject budgetItem = entry.getDynamicObject("budgetitem");
                DynamicObject budgetProject = budgetItem.getDynamicObject("project");
                proIdSet.add(budgetProject.getPkValue());
            }
        } else {
            DynamicObject contPro = contract.getDynamicObject("project");
            if (contPro != null) {
                proIdSet.add(contPro.getPkValue());
            }
        }
        return proIdSet;
    }

    protected Map<String, BigDecimal> buildBudgetAmountMap(DynamicObject bill, Set<Object> proIdSet) {
        DynamicObject[] proApps = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"pro,org,currencyfield", (QFilter[])new QFilter[]{new QFilter("pro", "in", proIdSet)});
        DynamicObject contract = bill.getDynamicObject("contract");
        contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_outcontract");
        HashMap<Object, BigDecimal> exchangeRateMap = new HashMap<Object, BigDecimal>(16);
        if (proApps != null && proApps.length > 0) {
            for (DynamicObject proApp : proApps) {
                BigDecimal exchangeRate = BudgetValidateAndUpdateHelper.getExchangeRate((DynamicObject)contract, (DynamicObject)proApp);
                DynamicObject pro = proApp.getDynamicObject("pro");
                exchangeRateMap.put(pro.getPkValue(), exchangeRate);
            }
        } else {
            for (Object e : proIdSet) {
                exchangeRateMap.put(e, BigDecimal.ONE);
            }
        }
        DynamicObjectCollection entryentity = bill.getDynamicObjectCollection("entryentity");
        HashMap<String, BigDecimal> hashMap = new HashMap<String, BigDecimal>(entryentity.size());
        for (DynamicObject entry : entryentity) {
            BigDecimal amount = entry.getBigDecimal("itemsubamount").negate();
            DynamicObject budget = entry.getDynamicObject("budgetitem");
            DynamicObject project = budget.getDynamicObject("project");
            if (!proIdSet.contains(project.getPkValue()) || budget == null || amount == null || amount.compareTo(BigDecimal.ZERO) == 0) continue;
            BigDecimal budgetAmount = (BigDecimal)hashMap.get(budget.getPkValue().toString());
            if (budgetAmount == null) {
                budgetAmount = BigDecimal.ZERO;
            }
            if (!exchangeRateMap.containsKey(project.getPkValue())) continue;
            hashMap.put(budget.getPkValue().toString(), budgetAmount.add(amount.multiply((BigDecimal)exchangeRateMap.get(project.getPkValue()))));
        }
        return hashMap;
    }
}

