/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.opplugin;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.common.enums.PerformAmountTypeEnum;
import kd.pmgt.pmbs.common.utils.CurrencyHelper;
import kd.pmgt.pmbs.common.utils.budget.BudgetValidateAndUpdateHelper;
import kd.pmgt.pmbs.common.utils.budget.PerformBillInfo;
import kd.pmgt.pmbs.common.utils.budget.PerformBillInfoBuilder;
import kd.pmgt.pmct.opplugin.validator.InContractBudgetValidator;

public class InContractBudgetOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("budgetitem");
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("originaloftaxamount");
        e.getFieldKeys().add("project");
        e.getFieldKeys().add("currency");
        e.getFieldKeys().add("stdcurrency");
        e.getFieldKeys().add("exchangerate");
        e.getFieldKeys().add("createtime");
        e.getFieldKeys().add("isonlist");
        e.getFieldKeys().add("listmodelentry");
        e.getFieldKeys().add("cmptype");
        e.getFieldKeys().add("sublistentry");
        e.getFieldKeys().add("listingbudgetitem");
        e.getFieldKeys().add("oftax");
        e.getFieldKeys().add("isleaf");
        e.getFieldKeys().add("budgetitem");
        e.getFieldKeys().add("originaloftaxamount");
        e.getFieldKeys().add("openedcontract");
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("billname");
        e.getFieldKeys().add("creator");
        e.getFieldKeys().add("auditor");
        e.getFieldKeys().add("auditdate");
        e.getFieldKeys().add("id");
        e.getFieldKeys().add("incontpayplanentry");
        e.getFieldKeys().add("payamount");
        e.getFieldKeys().add("customer");
        e.getFieldKeys().add("paytype");
        e.getFieldKeys().add("paymethod");
        e.getFieldKeys().add("payway");
        e.getFieldKeys().add("paypercent");
        e.getFieldKeys().add("planpaytime");
        e.getFieldKeys().add("remarks");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new InContractBudgetValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String operationKey = e.getOperationKey();
        DynamicObject[] entities = e.getDataEntities();
        if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"submit") || StringUtils.equals((CharSequence)operationKey, (CharSequence)"unsubmit") || StringUtils.equals((CharSequence)operationKey, (CharSequence)"audit") || StringUtils.equals((CharSequence)operationKey, (CharSequence)"unaudit")) {
            this.updateBudgetData(entities, operationKey);
        }
    }

    protected void updateBudgetData(DynamicObject[] entities, String operationKey) {
        block12: for (DynamicObject bill : entities) {
            DynamicObject project = bill.getDynamicObject("project");
            boolean isOpenedContract = bill.getBoolean("openedcontract");
            boolean multiPartSettlement = bill.getBoolean("multipartsettlement");
            if (project == null || isOpenedContract || multiPartSettlement) continue;
            DynamicObject[] proApp = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"org,currencyfield", (QFilter[])new QFilter[]{new QFilter("pro", "=", project.getPkValue())});
            if (proApp == null || proApp.length == 0) {
                return;
            }
            DynamicObject projectApproval = proApp[0];
            Map<String, BigDecimal> projectAmountMap = this.buildBudgetAmountMap(bill, this.getExchangeRate(bill, projectApproval));
            Map<String, BigDecimal> contractAmountMap = this.buildBudgetAmountMap(bill, BigDecimal.ONE);
            switch (operationKey) {
                case "submit": {
                    PerformBillInfo billInfo = new PerformBillInfoBuilder().formBillId("pmct_incontract").billNo(bill.getString("billno")).billName(bill.getString("billname")).creator(bill.getDynamicObject("creator")).createDate(bill.getDate("createtime")).id(bill.getLong("id")).contractId(bill.getString("id")).amountType(PerformAmountTypeEnum.CONTRACT).contractCurrency(bill.getDynamicObject("currency")).build();
                    BudgetValidateAndUpdateHelper.updateBudgetOnSubmit(projectAmountMap, contractAmountMap, (PerformBillInfo)billInfo);
                    continue block12;
                }
                case "unsubmit": {
                    PerformBillInfo billInfo = new PerformBillInfoBuilder().formBillId("pmct_incontract").id(bill.getLong("id")).contractId(bill.getString("id")).amountType(PerformAmountTypeEnum.CONTRACT).build();
                    BudgetValidateAndUpdateHelper.updateBudgetOnUnsubmit(projectAmountMap, contractAmountMap, (PerformBillInfo)billInfo);
                    continue block12;
                }
                case "audit": {
                    PerformBillInfo billInfo = new PerformBillInfoBuilder().formBillId("pmct_incontract").billNo(bill.getString("billno")).billName(bill.getString("billname")).creator(bill.getDynamicObject("creator")).createDate(bill.getDate("createtime")).auditor(bill.getDynamicObject("auditor")).auditDate(bill.getDate("auditdate")).id(bill.getLong("id")).contractId(bill.getString("id")).amountType(PerformAmountTypeEnum.CONTRACT).build();
                    BudgetValidateAndUpdateHelper.updateBudgetOnAudit(projectAmountMap, contractAmountMap, (PerformBillInfo)billInfo);
                    continue block12;
                }
                case "unaudit": {
                    BudgetValidateAndUpdateHelper.updateBudgetOnUnaudit(projectAmountMap, contractAmountMap, (String)"pmct_incontract", (long)bill.getLong("id"), (String)bill.getString("id"), (PerformAmountTypeEnum)PerformAmountTypeEnum.CONTRACT);
                    continue block12;
                }
            }
        }
    }

    protected BigDecimal getExchangeRate(DynamicObject contract, DynamicObject project) {
        DynamicObject exRateTable;
        DynamicObject org = project.getDynamicObject("org");
        DynamicObject proCurrency = project.getDynamicObject("currencyfield");
        DynamicObject contractCurrency = contract.getDynamicObject("currency");
        DynamicObject stdCurrency = contract.getDynamicObject("stdcurrency");
        if (proCurrency != null && contractCurrency != null && proCurrency.getPkValue().equals(contractCurrency.getPkValue())) {
            return BigDecimal.ONE;
        }
        if (proCurrency != null && stdCurrency != null && proCurrency.getPkValue().equals(stdCurrency.getPkValue())) {
            return contract.getBigDecimal("exchangerate");
        }
        BigDecimal exchangeRate = BigDecimal.ONE;
        if (org != null && proCurrency != null && contractCurrency != null && (exRateTable = CurrencyHelper.getExRateTable((Long)org.getLong("id"))) != null) {
            exchangeRate = CurrencyHelper.getExChangeRate((Long)contractCurrency.getLong("id"), (Long)proCurrency.getLong("id"), (Long)exRateTable.getLong("id"), (Date)contract.getDate("createtime"));
        }
        return exchangeRate;
    }

    protected Map<String, BigDecimal> buildBudgetAmountMap(DynamicObject bill, BigDecimal exchangeRate) {
        HashMap<String, BigDecimal> budgetAmountMap = new HashMap<String, BigDecimal>();
        boolean isOnList = bill.getBoolean("isonlist");
        if (isOnList) {
            DynamicObjectCollection listModelEntries = bill.getDynamicObjectCollection("listmodelentry");
            for (DynamicObject listModelEntry : listModelEntries) {
                DynamicObjectCollection listEntry = listModelEntry.getDynamicObjectCollection("sublistentry");
                String cmpType = listModelEntry.getString("cmptype");
                BigDecimal coefficient = BigDecimal.ONE;
                if ("(0)".equals(cmpType)) continue;
                if ("(-)".equals(cmpType)) {
                    coefficient = BigDecimal.valueOf(-1L);
                }
                for (DynamicObject list : listEntry) {
                    DynamicObject budget = list.getDynamicObject("listingbudgetitem");
                    BigDecimal amount = list.getBigDecimal("oftax").multiply(coefficient);
                    if (!list.getBoolean("isleaf") || budget == null || amount == null || amount.compareTo(BigDecimal.ZERO) == 0) continue;
                    BigDecimal budgetAmount = (BigDecimal)budgetAmountMap.get(budget.getPkValue().toString());
                    if (budgetAmount == null) {
                        budgetAmount = BigDecimal.ZERO;
                    }
                    budgetAmountMap.put(budget.getPkValue().toString(), budgetAmount.add(amount.multiply(exchangeRate)));
                }
            }
        } else {
            DynamicObject budget = bill.getDynamicObject("budgetitem");
            BigDecimal amount = bill.getBigDecimal("originaloftaxamount");
            if (budget != null && amount != null && amount.compareTo(BigDecimal.ZERO) != 0) {
                BigDecimal budgetAmount = BigDecimal.ZERO;
                budgetAmountMap.put(budget.getPkValue().toString(), budgetAmount.add(amount.multiply(exchangeRate)));
            }
        }
        return budgetAmountMap;
    }
}

