/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.business.helper.ContractCollectItemHelper;
import kd.pmgt.pmbs.business.helper.ContractHelper;
import kd.pmgt.pmbs.business.service.ContractCollectItemService;
import kd.pmgt.pmbs.common.enums.ContractStatusEnum;
import kd.pmgt.pmbs.common.enums.PayPlanSourceEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmct.opplugin.validator.ContractValidator;

public class InContractOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fields = e.getFieldKeys();
        fields.add("parta");
        fields.add("billno");
        fields.add("org");
        fields.add("contractstatus");
        fields.add("originalamount");
        fields.add("originaloftaxamount");
        fields.add("totaloftaxamount");
        fields.add("totalamount");
        fields.add("openedcontract");
        fields.add("signdate");
        fields.add("signaddress");
        fields.add("signaddressdetail");
        fields.add("auditassign");
        fields.add("partaperson");
        fields.add("partaphone");
        fields.add("partbperson");
        fields.add("partbphone");
        fields.add("partotherperson");
        fields.add("partotherphone");
        fields.add("paydirection");
        fields.add("auditassign");
        fields.add("signdate");
        fields.add("multipartsettlement");
        fields.add("modelname");
        fields.add("sysnumber");
        fields.add("incontpayplanentry");
        fields.add("incontpayplanentry.seq");
        fields.add("currency");
        fields.add("ismulticurrency");
        fields.add("exchangedate");
        fields.add("exchangerate");
        fields.add("exratetable");
        fields.add("customer");
        fields.add("paytype");
        fields.add("paymethod");
        fields.add("payway");
        fields.add("paypercent");
        fields.add("payamount");
        fields.add("planpaytime");
        fields.add("remarks");
        fields.add("conplanitemid");
        fields.add("contorgscope");
        fields.add("nodesetting");
        fields.add("nodesettingsource");
        fields.add("ctrlstrategy");
        fields.add("contproscope");
        fields.add("taxrate");
        fields.add("avgtaxrate");
        fields.add("lsttaxrate");
        fields.add("lstavgtaxrate");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String operateKey = e.getOperationKey();
        DynamicObject[] contractBillCols = e.getDataEntities();
        if ("save".equals(operateKey)) {
            ORM orm = ORM.create();
            ArrayList<DynamicObject> consignList = new ArrayList<DynamicObject>(contractBillCols.length);
            for (DynamicObject contractBill : contractBillCols) {
                DynamicObject contStatusObj;
                QFilter contStatusFilter;
                contractBill.set("totalamount", contractBill.get("originalamount"));
                contractBill.set("totaloftaxamount", contractBill.get("originaloftaxamount"));
                if (StatusEnum.UNCHECKED.getValue().equals(contractBill.getString("billstatus"))) {
                    contStatusFilter = new QFilter("number", "=", (Object)ContractStatusEnum.INAUDIT.getValue());
                    contStatusObj = BusinessDataServiceHelper.loadSingle((String)"pmct_contractstatus", (String)"id", (QFilter[])new QFilter[]{contStatusFilter});
                    contractBill.set("contractstatus", (Object)contStatusObj);
                    continue;
                }
                if (!StatusEnum.CHECKED.getValue().equals(contractBill.getString("billstatus"))) continue;
                if (contractBill.getBoolean("auditassign")) {
                    contStatusFilter = new QFilter("number", "=", (Object)ContractStatusEnum.RUNNING.getValue());
                    contStatusObj = BusinessDataServiceHelper.loadSingle((String)"pmct_contractstatus", (String)"id", (QFilter[])new QFilter[]{contStatusFilter});
                    contractBill.set("contractstatus", (Object)contStatusObj);
                    this.updateSignContractInfo(contractBill, consignList);
                    continue;
                }
                contStatusFilter = new QFilter("number", "=", (Object)ContractStatusEnum.APPROVED.getValue());
                contStatusObj = BusinessDataServiceHelper.loadSingle((String)"pmct_contractstatus", (String)"id", (QFilter[])new QFilter[]{contStatusFilter});
                contractBill.set("contractstatus", (Object)contStatusObj);
            }
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"pmct_contsign");
            consignList.forEach(arg_0 -> InContractOp.lambda$beginOperationTransaction$0(orm, (DynamicObjectType)dt, arg_0));
            SaveServiceHelper.save((DynamicObject[])consignList.toArray(new DynamicObject[0]));
        } else if ("submit".equals(operateKey)) {
            for (DynamicObject contractBill : contractBillCols) {
                QFilter contStatusFilter = new QFilter("number", "=", (Object)ContractStatusEnum.INAUDIT.getValue());
                DynamicObject contStatusObj = BusinessDataServiceHelper.loadSingle((String)"pmct_contractstatus", (String)"id", (QFilter[])new QFilter[]{contStatusFilter});
                contractBill.set("contractstatus", (Object)contStatusObj);
                contractBill.set("totalamount", contractBill.get("originalamount"));
                contractBill.set("totaloftaxamount", contractBill.get("originaloftaxamount"));
                ContractHelper.updateContractListData((DynamicObject)contractBill);
            }
        } else if ("unsubmit".equals(operateKey)) {
            for (DynamicObject contractBill : contractBillCols) {
                QFilter contStatusFilter = new QFilter("number", "=", (Object)ContractStatusEnum.INDRAFT.getValue());
                DynamicObject contStatusObj = BusinessDataServiceHelper.loadSingle((String)"pmct_contractstatus", (String)"id", (QFilter[])new QFilter[]{contStatusFilter});
                contractBill.set("contractstatus", (Object)contStatusObj);
                SaveServiceHelper.save((IDataEntityType)contractBill.getDynamicObjectType(), (Object[])new DynamicObject[]{contractBill});
            }
        } else if ("audit".equals(operateKey)) {
            ArrayList<DynamicObject> consignList = new ArrayList<DynamicObject>(1);
            for (DynamicObject contractBill : contractBillCols) {
                contractBill = BusinessDataServiceHelper.loadSingle((Object)contractBill.getPkValue(), (DynamicObjectType)contractBill.getDynamicObjectType());
                QFilter contStatusFilter = new QFilter("number", "=", (Object)ContractStatusEnum.APPROVED.getValue());
                DynamicObject contStatusObj = BusinessDataServiceHelper.loadSingle((String)"pmct_contractstatus", (String)"id", (QFilter[])new QFilter[]{contStatusFilter});
                contractBill.set("contractstatus", (Object)contStatusObj);
                contractBill.set("lsttaxrate", contractBill.get("taxrate"));
                contractBill.set("lstavgtaxrate", contractBill.get("avgtaxrate"));
                if (contractBill.getBoolean("auditassign")) {
                    contStatusFilter = new QFilter("number", "=", (Object)ContractStatusEnum.RUNNING.getValue());
                    contStatusObj = BusinessDataServiceHelper.loadSingle((String)"pmct_contractstatus", (String)"id", (QFilter[])new QFilter[]{contStatusFilter});
                    contractBill.set("contractstatus", (Object)contStatusObj);
                }
                this.updateSignContractInfo(contractBill, consignList);
                new ContractCollectItemHelper().doSave(contractBill, PayPlanSourceEnum.CONTRACT);
                SaveServiceHelper.save((IDataEntityType)contractBill.getDynamicObjectType(), (Object[])new DynamicObject[]{contractBill});
                ContractHelper.updateContractListData((DynamicObject)contractBill);
            }
            SaveServiceHelper.save((DynamicObject[])consignList.toArray(new DynamicObject[0]));
        } else if ("unaudit".equals(operateKey)) {
            DynamicObject[] consignList = contractBillCols;
            int n = consignList.length;
            for (int i = 0; i < n; ++i) {
                DynamicObject contractBillCol;
                DynamicObject contractBill = contractBillCol = consignList[i];
                contractBill = BusinessDataServiceHelper.loadSingle((Object)contractBill.getPkValue(), (DynamicObjectType)contractBill.getDynamicObjectType());
                QFilter contStatusFilter = new QFilter("number", "=", (Object)ContractStatusEnum.INDRAFT.getValue());
                DynamicObject contStatusObj = BusinessDataServiceHelper.loadSingle((String)"pmct_contractstatus", (String)"id", (QFilter[])new QFilter[]{contStatusFilter});
                contractBill.set("contractstatus", (Object)contStatusObj);
                if (contractBill.getBoolean("auditassign")) {
                    contractBill.set("signaddress", null);
                    contractBill.set("signaddressdetail", null);
                    contractBill.set("partaperson", null);
                    contractBill.set("partaphone", null);
                    contractBill.set("partbperson", null);
                    contractBill.set("partbphone", null);
                    contractBill.set("partotherperson", null);
                    contractBill.set("partotherphone", null);
                }
                new ContractCollectItemService().delete(contractBill);
                DynamicObjectCollection inComePlanEntry = contractBill.getDynamicObjectCollection("incontpayplanentry");
                if (inComePlanEntry.size() > 0) {
                    for (DynamicObject plan : inComePlanEntry) {
                        plan.set("conplanitemid", (Object)0L);
                    }
                }
                SaveServiceHelper.save((IDataEntityType)contractBill.getDynamicObjectType(), (Object[])new DynamicObject[]{contractBill});
            }
        } else if (StringUtils.equals((CharSequence)"dounsign", (CharSequence)operateKey)) {
            ArrayList<DynamicObject> contList = new ArrayList<DynamicObject>(1);
            for (DynamicObject contractBill : contractBillCols) {
                contractBill = BusinessDataServiceHelper.loadSingle((Object)contractBill.getPkValue(), (DynamicObjectType)contractBill.getDynamicObjectType());
                QFilter contStatusFilter = new QFilter("number", "=", (Object)ContractStatusEnum.APPROVED.getValue());
                DynamicObject contStatusObj = BusinessDataServiceHelper.loadSingle((String)"pmct_contractstatus", (String)"id", (QFilter[])new QFilter[]{contStatusFilter});
                contractBill.set("contractstatus", (Object)contStatusObj);
                contractBill.set("signdate", null);
                contractBill.set("signaddress", null);
                contractBill.set("signaddressdetail", null);
                contractBill.set("partaperson", null);
                contractBill.set("partaphone", null);
                contractBill.set("partbperson", null);
                contractBill.set("partbphone", null);
                contractBill.set("partotherperson", null);
                contractBill.set("partotherphone", null);
                contList.add(contractBill);
            }
            SaveServiceHelper.save((DynamicObject[])contList.toArray(new DynamicObject[0]));
        }
    }

    private void updateSignContractInfo(DynamicObject contractBill, List<DynamicObject> consignList) {
        QFilter qFilter = new QFilter("contract", "=", contractBill.getPkValue());
        DynamicObject newdata = BusinessDataServiceHelper.loadSingle((String)"pmct_contsign", (QFilter[])new QFilter[]{qFilter});
        if (newdata == null) {
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"pmct_contsign");
            newdata = new DynamicObject((DynamicObjectType)dt);
            ORM orm = ORM.create();
            newdata.set("id", (Object)orm.genLongId((IDataEntityType)dt));
            newdata.set("contract", contractBill.getPkValue());
            newdata.set("billstatus", (Object)StatusEnum.TEMPSAVE.getValue());
        }
        newdata.set("signdate", contractBill.get("signdate"));
        newdata.set("signaddress", contractBill.get("signaddress"));
        newdata.set("signaddressdetail", contractBill.get("signaddressdetail"));
        newdata.set("partaperson", contractBill.get("partaperson"));
        newdata.set("partaphone", contractBill.get("partaphone"));
        newdata.set("partbperson", contractBill.get("partbperson"));
        newdata.set("partbphone", contractBill.get("partbphone"));
        newdata.set("partotherperson", contractBill.get("partotherperson"));
        newdata.set("partotherphone", contractBill.get("partotherphone"));
        newdata.set("modifytime", (Object)new Date());
        newdata.set("createtime", (Object)new Date());
        newdata.set("creator", contractBill.get("creator"));
        newdata.set("modifier", contractBill.get("modifier"));
        consignList.add(newdata);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        List validators = e.getValidators();
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                block13: {
                    String key;
                    block12: {
                        ExtendedDataEntity[] dataEntities;
                        key = this.getOperateKey();
                        if (!StringUtils.equals((CharSequence)"submit", (CharSequence)key)) break block12;
                        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                            BigDecimal exchangeRate;
                            Date signDate;
                            DynamicObject inContractBill = dataEntity.getDataEntity();
                            DynamicObject contractType = inContractBill.getDynamicObject("contracttype");
                            contractType = BusinessDataServiceHelper.loadSingle((Object)contractType.getPkValue(), (String)"pmct_conttype");
                            boolean auditAssign = inContractBill.getBoolean("auditassign");
                            if (auditAssign && (signDate = inContractBill.getDate("signdate")) == null) {
                                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u7b7e\u7ea6\u65e5\u671f\u201d\u3002", (String)"InContractOp_16", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                            }
                            DynamicObjectCollection listModelEntry = inContractBill.getDynamicObjectCollection("listmodelentry");
                            for (DynamicObject listModelEntryObj : listModelEntry) {
                                HashSet<String> sysNumSet = new HashSet<String>();
                                DynamicObjectCollection subListEntry = listModelEntryObj.getDynamicObjectCollection("sublistentry");
                                for (DynamicObject subListEntryObj : subListEntry) {
                                    String sysNumber = subListEntryObj.getString("sysnumber");
                                    if (!StringUtils.isNotEmpty((CharSequence)sysNumber)) continue;
                                    if (!sysNumSet.contains(sysNumber)) {
                                        sysNumSet.add(sysNumber);
                                        continue;
                                    }
                                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6e05\u5355\u6a21\u677f\u201c%1$s\u201d\u4e2d\u7684\u7cfb\u7edf\u7f16\u7801\u201c%2$s\u201d\u5df2\u5b58\u5728\u3002", (String)"InContractOp_17", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), listModelEntryObj.getString("modelname"), sysNumber));
                                }
                            }
                            boolean openContract = inContractBill.getBoolean("openedcontract");
                            DynamicObjectCollection inContPayPlanEntries = inContractBill.getDynamicObjectCollection("incontpayplanentry");
                            if (inContractBill.getBoolean("multipartsettlement") && inContractBill.getDynamicObjectCollection("contorgscope").isEmpty() && inContractBill.getDynamicObjectCollection("contproscope").isEmpty()) {
                                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u672c\u5408\u540c\u7684\u9002\u7528\u7ec4\u7ec7\u6216\u9879\u76ee\u3002", (String)"InContractOp_18", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                            }
                            BigDecimal originalOfTaxAmount = inContractBill.getBigDecimal("originaloftaxamount");
                            BigDecimal totalPayAmount = inContPayPlanEntries.stream().map(entry -> entry.getBigDecimal("payamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                            if (!openContract && !inContPayPlanEntries.isEmpty() && totalPayAmount.compareTo(originalOfTaxAmount) != 0) {
                                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff0c\u6536\u6b3e\u8ba1\u5212\u542b\u7a0e\u91d1\u989d\u5408\u8ba1\u4e0d\u7b49\u4e8e\u542b\u7a0e\u5408\u540c\u603b\u91d1\u989d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"InContractOp_3", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                            }
                            if (!inContractBill.getBoolean("ismulticurrency")) continue;
                            if (inContractBill.getDynamicObject("exratetable") == null) {
                                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6c47\u7387\u8868\u201d\u3002", (String)"InContractOp_8", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                            }
                            if (inContractBill.getDynamicObject("currency") == null) {
                                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u7b7e\u7ea6\u5e01\u79cd\u201d\u3002", (String)"InContractOp_9", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                            }
                            if ((exchangeRate = inContractBill.getBigDecimal("exchangerate")) == null || BigDecimal.ZERO.compareTo(exchangeRate) == 0) {
                                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6c47\u7387\u201d\u3002", (String)"InContractOp_10", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                            }
                            if (inContractBill.getDate("exchangedate") != null) continue;
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6c47\u7387\u65e5\u671f\u201d\u3002", (String)"InContractOp_11", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                        }
                        break block13;
                    }
                    if (!StringUtils.equals((CharSequence)"unaudit", (CharSequence)key) && !"dounsign".equals(key)) break block13;
                    this.checkContractCollectItem();
                    if (StringUtils.equals((CharSequence)"unaudit", (CharSequence)key)) {
                        ExtendedDataEntity[] dataEntities;
                        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                            QFilter orgQFilter;
                            DynamicObject inContractBill = dataEntity.getDataEntity();
                            String billNo = inContractBill.getString("billno");
                            QFilter billNoQFilter = new QFilter("textfield1", "=", (Object)billNo);
                            boolean isInvoiceExist = QueryServiceHelper.exists((String)"sim_original_bill", (QFilter[])new QFilter[]{billNoQFilter, orgQFilter = new QFilter("orgid", "=", inContractBill.getDynamicObject("org").getPkValue())});
                            if (!isInvoiceExist) continue;
                            this.addWarningMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5408\u540c\u5df2\u5b58\u5728\u5f00\u7968\u7533\u8bf7\u8bb0\u5f55\uff0c\u53cd\u5ba1\u6838\u53ef\u80fd\u4f1a\u5bf9\u8d22\u52a1\u505a\u8d26\u4ea7\u751f\u5f71\u54cd\u3002", (String)"InContractOp_15", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), billNo));
                        }
                    }
                }
            }

            private void checkContractCollectItem() {
                ExtendedDataEntity[] dataEntities;
                for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                    DynamicObject inContractBill = dataEntity.getDataEntity();
                    DynamicObjectCollection inContPayPlanEntries = inContractBill.getDynamicObjectCollection("incontpayplanentry");
                    if (inContPayPlanEntries.isEmpty()) {
                        QFilter autoGeneratedFilter;
                        QFilter collectedAmtFilter;
                        QFilter contractPkFilter = new QFilter("sourcebill", "=", inContractBill.getPkValue());
                        DynamicObject[] contractCollectItems = BusinessDataServiceHelper.load((String)"pmbs_contractcollectitem", (String)"id", (QFilter[])new QFilter[]{contractPkFilter, collectedAmtFilter = new QFilter("collectedcomamt", ">", (Object)BigDecimal.ZERO), autoGeneratedFilter = new QFilter("autogenerated", "=", (Object)true)});
                        if (contractCollectItems == null || contractCollectItems.length <= 0) continue;
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u5931\u8d25\uff0c\u8be5\u5408\u540c\u5df2\u7ecf\u53d1\u751f\u6536\u6b3e\u3002", (String)"InContractOp_4", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    for (int i = 0; i < inContPayPlanEntries.size(); ++i) {
                        QFilter collectedAmtFilter;
                        DynamicObject contPayPlan = (DynamicObject)inContPayPlanEntries.get(i);
                        QFilter contractPkFilter = new QFilter("sourcebill", "=", contPayPlan.getPkValue());
                        DynamicObject[] contractCollectItems = BusinessDataServiceHelper.load((String)"pmbs_contractcollectitem", (String)"id", (QFilter[])new QFilter[]{contractPkFilter, collectedAmtFilter = new QFilter("collectedcomamt", ">", (Object)BigDecimal.ZERO)});
                        if (contractCollectItems == null || contractCollectItems.length <= 0) continue;
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u5931\u8d25\uff0c\u7b2c%s\u884c\u6536\u6b3e\u8ba1\u5212\u5df2\u7ecf\u53d1\u751f\u6536\u6b3e\u3002", (String)"InContractOp_5", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), i + 1));
                    }
                }
            }
        });
        boolean isAddValid = false;
        for (AbstractValidator val : validators) {
            String key = val.getOperateKey();
            if (!"unaudit".equals(key) && !"dounsign".equals(key)) continue;
            isAddValid = true;
        }
        if (isAddValid) {
            e.getValidators().add(new ContractValidator());
        }
    }

    private static /* synthetic */ void lambda$beginOperationTransaction$0(ORM orm, DynamicObjectType dt, DynamicObject consign) {
        if (consign.getPkValue() == null) {
            consign.set("id", (Object)orm.genLongId((IDataEntityType)dt));
        }
    }
}

