/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.opplugin;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.business.helper.ProBudgetControlHelper;
import kd.pmgt.pmbs.common.enums.PerformAmountTypeEnum;
import kd.pmgt.pmbs.common.utils.CurrencyHelper;
import kd.pmgt.pmbs.common.utils.budget.BudgetValidateAndUpdateHelper;
import kd.pmgt.pmbs.common.utils.budget.PerformBillInfo;
import kd.pmgt.pmbs.common.utils.budget.PerformBillInfoBuilder;
import kd.pmgt.pmct.common.enums.DirectionEnum;
import kd.pmgt.pmct.opplugin.validator.OutContSettleBudgetValidator;

public class OutContSettleBudgetOp
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(OutContSettleBudgetOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("id");
        e.getFieldKeys().add("contract");
        e.getFieldKeys().add("project");
        e.getFieldKeys().add("pmct_outcontract_settle");
        e.getFieldKeys().add("currency");
        e.getFieldKeys().add("stdcurrency");
        e.getFieldKeys().add("exchangerate");
        e.getFieldKeys().add("createtime");
        e.getFieldKeys().add("itementry");
        e.getFieldKeys().add("payitemdetailentry");
        e.getFieldKeys().add("detailpayitem");
        e.getFieldKeys().add("oftaxamount");
        e.getFieldKeys().add("paybudgetitem");
        e.getFieldKeys().add("payitem");
        e.getFieldKeys().add("detailoftaxamt");
        e.getFieldKeys().add("detailbudgetitem");
        e.getFieldKeys().add("listmodelentry");
        e.getFieldKeys().add("cmptype");
        e.getFieldKeys().add("listentry");
        e.getFieldKeys().add("outbudget");
        e.getFieldKeys().add("thisoftaxmount");
        e.getFieldKeys().add("isonlist");
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("billname");
        e.getFieldKeys().add("creator");
        e.getFieldKeys().add("auditor");
        e.getFieldKeys().add("auditdate");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new OutContSettleBudgetValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String operationKey = e.getOperationKey();
        DynamicObject[] entities = e.getDataEntities();
        if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"submit") || StringUtils.equals((CharSequence)operationKey, (CharSequence)"unsubmit") || StringUtils.equals((CharSequence)operationKey, (CharSequence)"audit") || StringUtils.equals((CharSequence)operationKey, (CharSequence)"unaudit")) {
            this.updateBudgetData(entities, operationKey);
        }
    }

    protected void updateBudgetData(DynamicObject[] entities, String operationKey) {
        for (DynamicObject bill : entities) {
            PerformBillInfo billInfo;
            DynamicObject contract = bill.getDynamicObject("contract");
            DynamicObject project = bill.getDynamicObject("project");
            contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_outcontract");
            if (project == null) continue;
            DynamicObject[] proApp = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"org,currencyfield", (QFilter[])new QFilter[]{new QFilter("pro", "=", project.getPkValue())});
            if (proApp == null || proApp.length == 0) {
                return;
            }
            boolean isNew = ProBudgetControlHelper.checkIsNewProBudgetCtrl((Long)((Long)project.getPkValue()));
            if (isNew) continue;
            Map<String, BigDecimal> projectAmountMap = this.buildBudgetAmountMap(bill, this.getExchangeRate(bill, proApp[0]));
            Map<String, BigDecimal> contractAmountMap = this.buildBudgetAmountMap(bill, BigDecimal.ONE);
            log.info("updateBudgetData projectAmountMap:{},contractAmountMap:{}", projectAmountMap, contractAmountMap);
            if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"submit")) {
                billInfo = new PerformBillInfoBuilder().formBillId("pmct_outcontract_settle").billNo(bill.getString("billno")).billName(bill.getString("billname")).creator(bill.getDynamicObject("creator")).createDate(bill.getDate("createtime")).id(bill.getLong("id")).contractId(contract.getPkValue().toString()).contractCurrency(bill.getDynamicObject("currency")).amountType(PerformAmountTypeEnum.SETTLE).build();
                BudgetValidateAndUpdateHelper.updateBudgetOnSubmit(projectAmountMap, contractAmountMap, (PerformBillInfo)billInfo);
                continue;
            }
            if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"unsubmit")) {
                billInfo = new PerformBillInfoBuilder().formBillId("pmct_outcontract_settle").id(bill.getLong("id")).contractId(contract.getPkValue().toString()).amountType(PerformAmountTypeEnum.SETTLE).build();
                BudgetValidateAndUpdateHelper.updateBudgetOnUnsubmit(projectAmountMap, contractAmountMap, (PerformBillInfo)billInfo);
                continue;
            }
            if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"audit")) {
                billInfo = new PerformBillInfoBuilder().formBillId("pmct_outcontract_settle").billNo(bill.getString("billno")).billName(bill.getString("billname")).creator(bill.getDynamicObject("creator")).createDate(bill.getDate("createtime")).auditor(bill.getDynamicObject("auditor")).auditDate(bill.getDate("auditdate")).id(bill.getLong("id")).contractId(contract.getPkValue().toString()).amountType(PerformAmountTypeEnum.SETTLE).build();
                BudgetValidateAndUpdateHelper.updateBudgetOnAudit(projectAmountMap, contractAmountMap, (PerformBillInfo)billInfo);
                continue;
            }
            if (!StringUtils.equals((CharSequence)operationKey, (CharSequence)"unaudit")) continue;
            BudgetValidateAndUpdateHelper.updateBudgetOnUnaudit(projectAmountMap, contractAmountMap, (String)"pmct_outcontract_settle", (long)bill.getLong("id"), (String)contract.getPkValue().toString(), (PerformAmountTypeEnum)PerformAmountTypeEnum.SETTLE);
        }
    }

    protected BigDecimal getExchangeRate(DynamicObject bill, DynamicObject project) {
        DynamicObject exRateTable;
        DynamicObject org = project.getDynamicObject("org");
        DynamicObject proCurrency = project.getDynamicObject("currencyfield");
        DynamicObject contractCurrency = bill.getDynamicObject("currency");
        DynamicObject stdCurrency = bill.getDynamicObject("stdcurrency");
        if (proCurrency != null && contractCurrency != null && proCurrency.getPkValue().equals(contractCurrency.getPkValue())) {
            return BigDecimal.ONE;
        }
        if (proCurrency != null && stdCurrency != null && proCurrency.getPkValue().equals(stdCurrency.getPkValue())) {
            return bill.getBigDecimal("exchangerate");
        }
        BigDecimal exchangeRate = BigDecimal.ONE;
        if (org != null && proCurrency != null && contractCurrency != null && (exRateTable = CurrencyHelper.getExRateTable((Long)org.getLong("id"))) != null) {
            exchangeRate = CurrencyHelper.getExChangeRate((Long)contractCurrency.getLong("id"), (Long)proCurrency.getLong("id"), (Long)exRateTable.getLong("id"), (Date)bill.getDate("createtime"));
        }
        return exchangeRate;
    }

    protected Map<String, BigDecimal> buildBudgetAmountMap(DynamicObject bill, BigDecimal exchangeRate) {
        HashMap<String, BigDecimal> budgetAmountMap = new HashMap<String, BigDecimal>();
        DynamicObjectCollection itemEntry = bill.getDynamicObjectCollection("itementry");
        for (DynamicObject item : itemEntry) {
            DynamicObject budget = item.getDynamicObject("paybudgetitem");
            if (budget == null) continue;
            BigDecimal budgetAmount = (BigDecimal)budgetAmountMap.get(String.valueOf(budget.getPkValue()));
            if (budgetAmount == null) {
                budgetAmount = BigDecimal.ZERO;
            }
            String direction = item.getDynamicObject("payitem").getString("direction");
            BigDecimal ofTaxAmount = item.getBigDecimal("oftaxamount").multiply(exchangeRate);
            if (DirectionEnum.ADD.getValue().equals(direction)) {
                budgetAmountMap.put(String.valueOf(budget.getPkValue()), budgetAmount.add(ofTaxAmount));
                continue;
            }
            if (!DirectionEnum.SUB.getValue().equals(direction)) continue;
            budgetAmountMap.put(String.valueOf(budget.getPkValue()), budgetAmount.subtract(ofTaxAmount));
        }
        return budgetAmountMap;
    }
}

