/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.business.helper.ContractHelper;
import kd.pmgt.pmbs.business.helper.ContractPayItemHelper;
import kd.pmgt.pmbs.common.enums.AgreementStatusEnum;
import kd.pmgt.pmbs.common.enums.ContractStatusEnum;
import kd.pmgt.pmbs.common.enums.PayPlanSourceEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmct.opplugin.validator.ContractValidator;

public class OutContractOp
extends AbstractOperationServicePlugIn {
    private static final String OPERATION_DOUNSIGN = "dounsign";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fields = e.getFieldKeys();
        fields.add("contractstatus");
        fields.add("originalamount");
        fields.add("originaloftaxamount");
        fields.add("totaloftaxamount");
        fields.add("totalamount");
        fields.add("signdate");
        fields.add("signaddress");
        fields.add("signaddressdetail");
        fields.add("auditassign");
        fields.add("partaperson");
        fields.add("partaphone");
        fields.add("partbperson");
        fields.add("partbphone");
        fields.add("partotherperson");
        fields.add("partotherphone");
        fields.add("strategicagreement");
        fields.add("contracttype");
        fields.add("org");
        fields.add("bidresult");
        fields.add("partb");
        fields.add("project");
        fields.add("outcontpayplanentry");
        fields.add("ismulticontract");
        fields.add("conplanitemid");
        fields.add("paydirection");
        fields.add("electronicsign");
        fields.add("multipartsettlement");
        fields.add("outcontpayplanentry.seq");
        fields.add("auditassign");
        fields.add("signdate");
        fields.add("contorgscope");
        fields.add("contproscope");
        fields.add("signdate");
        fields.add("modelname");
        fields.add("sysnumber");
        fields.add("ismulticurrency");
        fields.add("currency");
        fields.add("exratetable");
        fields.add("exchangerate");
        fields.add("exchangedate");
        fields.add("ctrlstrategy");
        fields.add("nodesettingsource");
        fields.add("nodesetting");
        fields.add("taxrate");
        fields.add("avgtaxrate");
        fields.add("lsttaxrate");
        fields.add("lstavgtaxrate");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String operateKey = e.getOperationKey();
        DynamicObject[] billEntities = e.getDataEntities();
        switch (operateKey) {
            case "save": {
                this.beginSaveOperation(billEntities);
                break;
            }
            case "submit": {
                this.beginSubmitOperation(billEntities);
                break;
            }
            case "unsubmit": {
                this.beginUnsubmitOperation(billEntities);
                break;
            }
            case "audit": {
                this.beginAuditOperation(billEntities);
                break;
            }
            case "unaudit": {
                this.beginUnauditOperation(billEntities);
                break;
            }
            case "dounsign": {
                this.beginDoUnSignOperation(billEntities);
                break;
            }
            case "delete": {
                this.beginDeleteOperation(billEntities);
                break;
            }
        }
    }

    protected void beginSaveOperation(DynamicObject[] billEntities) {
        ORM orm = ORM.create();
        ArrayList<DynamicObject> consignList = new ArrayList<DynamicObject>(billEntities.length);
        for (DynamicObject contractBill : billEntities) {
            DynamicObject contStatusObj;
            QFilter contStatusFilter;
            contractBill.set("totalamount", contractBill.get("originalamount"));
            contractBill.set("totaloftaxamount", contractBill.get("originaloftaxamount"));
            if (StatusEnum.UNCHECKED.getValue().equals(contractBill.getString("billstatus"))) {
                contStatusFilter = new QFilter("number", "=", (Object)ContractStatusEnum.INAUDIT.getValue());
                contStatusObj = BusinessDataServiceHelper.loadSingle((String)"pmct_contractstatus", (String)"id", (QFilter[])new QFilter[]{contStatusFilter});
                contractBill.set("contractstatus", (Object)contStatusObj);
            } else if (StatusEnum.CHECKED.getValue().equals(contractBill.getString("billstatus"))) {
                if (contractBill.getBoolean("auditassign")) {
                    contStatusFilter = new QFilter("number", "=", (Object)ContractStatusEnum.RUNNING.getValue());
                    contStatusObj = BusinessDataServiceHelper.loadSingle((String)"pmct_contractstatus", (String)"id", (QFilter[])new QFilter[]{contStatusFilter});
                    contractBill.set("contractstatus", (Object)contStatusObj);
                    this.updateSignContractInfo(contractBill, consignList);
                } else {
                    contStatusFilter = new QFilter("number", "=", (Object)ContractStatusEnum.APPROVED.getValue());
                    contStatusObj = BusinessDataServiceHelper.loadSingle((String)"pmct_contractstatus", (String)"id", (QFilter[])new QFilter[]{contStatusFilter});
                    contractBill.set("contractstatus", (Object)contStatusObj);
                }
            }
            this.setBidMessage(orm, contractBill);
        }
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"pmct_contsign");
        consignList.forEach(arg_0 -> OutContractOp.lambda$beginSaveOperation$0(orm, (DynamicObjectType)dt, arg_0));
        SaveServiceHelper.save((DynamicObject[])consignList.toArray(new DynamicObject[0]));
    }

    protected void beginSubmitOperation(DynamicObject[] billEntities) {
        ORM orm = ORM.create();
        for (DynamicObject contractBill : billEntities) {
            contractBill.set("totalamount", contractBill.get("originalamount"));
            contractBill.set("totaloftaxamount", contractBill.get("originaloftaxamount"));
            QFilter contStatusFilter = new QFilter("number", "=", (Object)ContractStatusEnum.INAUDIT.getValue());
            DynamicObject contStatusObj = BusinessDataServiceHelper.loadSingle((String)"pmct_contractstatus", (String)"id", (QFilter[])new QFilter[]{contStatusFilter});
            this.setBidMessage(orm, contractBill);
            contractBill.set("contractstatus", (Object)contStatusObj);
            ContractHelper.updateContractListData((DynamicObject)contractBill);
        }
    }

    protected void beginUnsubmitOperation(DynamicObject[] billEntities) {
        for (DynamicObject contractBill : billEntities) {
            QFilter contStatusFilter = new QFilter("number", "=", (Object)ContractStatusEnum.INDRAFT.getValue());
            DynamicObject contStatusObj = BusinessDataServiceHelper.loadSingle((String)"pmct_contractstatus", (String)"id", (QFilter[])new QFilter[]{contStatusFilter});
            contractBill.set("contractstatus", (Object)contStatusObj);
            SaveServiceHelper.save((IDataEntityType)contractBill.getDynamicObjectType(), (Object[])new DynamicObject[]{contractBill});
        }
    }

    protected void beginAuditOperation(DynamicObject[] billEntities) {
        ArrayList<DynamicObject> consignList = new ArrayList<DynamicObject>(1);
        for (DynamicObject contractBill : billEntities) {
            contractBill = BusinessDataServiceHelper.loadSingle((Object)contractBill.getPkValue(), (DynamicObjectType)contractBill.getDynamicObjectType());
            QFilter contStatusFilter = new QFilter("number", "=", (Object)ContractStatusEnum.APPROVED.getValue());
            DynamicObject contStatusObj = BusinessDataServiceHelper.loadSingle((String)"pmct_contractstatus", (String)"id", (QFilter[])new QFilter[]{contStatusFilter});
            contractBill.set("contractstatus", (Object)contStatusObj);
            contractBill.set("lsttaxrate", contractBill.get("taxrate"));
            contractBill.set("lstavgtaxrate", contractBill.get("avgtaxrate"));
            if (contractBill.getBoolean("auditassign")) {
                contStatusFilter = new QFilter("number", "=", (Object)ContractStatusEnum.RUNNING.getValue());
                contStatusObj = BusinessDataServiceHelper.loadSingle((String)"pmct_contractstatus", (String)"id", (QFilter[])new QFilter[]{contStatusFilter});
                contractBill.set("contractstatus", (Object)contStatusObj);
            }
            this.updateSignContractInfo(contractBill, consignList);
            SaveServiceHelper.save((IDataEntityType)contractBill.getDynamicObjectType(), (Object[])new DynamicObject[]{contractBill});
            ContractPayItemHelper.save((DynamicObject)contractBill, (PayPlanSourceEnum)PayPlanSourceEnum.CONTRACT);
            SaveServiceHelper.update((DynamicObject)contractBill);
            ContractHelper.updateContractListData((DynamicObject)contractBill);
        }
        SaveServiceHelper.save((DynamicObject[])consignList.toArray(new DynamicObject[0]));
    }

    protected void beginUnauditOperation(DynamicObject[] billEntities) {
        for (DynamicObject contractBill : billEntities) {
            contractBill = BusinessDataServiceHelper.loadSingle((Object)contractBill.getPkValue(), (DynamicObjectType)contractBill.getDynamicObjectType());
            QFilter contStatusFilter = new QFilter("number", "=", (Object)ContractStatusEnum.INDRAFT.getValue());
            DynamicObject contStatusObj = BusinessDataServiceHelper.loadSingle((String)"pmct_contractstatus", (String)"id", (QFilter[])new QFilter[]{contStatusFilter});
            contractBill.set("contractstatus", (Object)contStatusObj);
            ContractPayItemHelper.delete((DynamicObject)contractBill);
            DynamicObjectCollection payPlanEntry = contractBill.getDynamicObjectCollection("outcontpayplanentry");
            if (payPlanEntry.size() > 0) {
                for (DynamicObject plan : payPlanEntry) {
                    plan.set("conplanitemid", (Object)0L);
                }
            }
            SaveServiceHelper.save((IDataEntityType)contractBill.getDynamicObjectType(), (Object[])new DynamicObject[]{contractBill});
        }
    }

    protected void beginDoUnSignOperation(DynamicObject[] billEntities) {
        ArrayList<DynamicObject> contList = new ArrayList<DynamicObject>(billEntities.length);
        for (DynamicObject contractBill : billEntities) {
            contractBill = BusinessDataServiceHelper.loadSingle((Object)contractBill.getPkValue(), (DynamicObjectType)contractBill.getDynamicObjectType());
            QFilter contStatusFilter = new QFilter("number", "=", (Object)ContractStatusEnum.APPROVED.getValue());
            DynamicObject contStatusObj = BusinessDataServiceHelper.loadSingle((String)"pmct_contractstatus", (String)"id", (QFilter[])new QFilter[]{contStatusFilter});
            contractBill.set("contractstatus", (Object)contStatusObj);
            contractBill.set("signdate", null);
            contractBill.set("signaddress", null);
            contractBill.set("signaddressdetail", null);
            contractBill.set("partaperson", null);
            contractBill.set("partaphone", null);
            contractBill.set("partbperson", null);
            contractBill.set("partbphone", null);
            contractBill.set("partotherperson", null);
            contractBill.set("partotherphone", null);
            contList.add(contractBill);
        }
        SaveServiceHelper.save((DynamicObject[])contList.toArray(new DynamicObject[0]));
    }

    protected void beginDeleteOperation(DynamicObject[] billEntities) {
        for (DynamicObject contractBill : billEntities) {
            contractBill = BusinessDataServiceHelper.loadSingle((Object)contractBill.getPkValue(), (DynamicObjectType)contractBill.getDynamicObjectType());
            DynamicObjectCollection bidResultEntry = contractBill.getDynamicObjectCollection("bidresult");
            ArrayList<Object> bidId = new ArrayList<Object>(10);
            for (DynamicObject bidResult : bidResultEntry) {
                if (bidResult == null) continue;
                bidId.add(bidResult.get("fbasedataid_id"));
            }
            DynamicObject[] bids = BusinessDataServiceHelper.load((Object[])bidId.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmbs_bidmessage"));
            if (bids == null || bids.length == 0) {
                return;
            }
            block2: for (DynamicObject bid : bids) {
                DynamicObjectCollection contractEntry = bid.getDynamicObjectCollection("contractcode");
                for (DynamicObject dy : contractEntry) {
                    if (dy == null || !dy.get("fbasedataid_id").equals(contractBill.getPkValue())) continue;
                    contractEntry.remove((Object)dy);
                    continue block2;
                }
            }
            SaveServiceHelper.save((DynamicObject[])bids);
        }
    }

    public boolean setBidMessage(ORM orm, DynamicObject contractBill) {
        QFilter projectFilter;
        QFilter statusFilter;
        DynamicObject supplierIdent;
        QFilter contractCodeFilter = new QFilter("contractcode.fbasedataid_id", "in", contractBill.getPkValue());
        DynamicObject[] bidEntry = BusinessDataServiceHelper.load((String)"pmbs_bidmessage", (String)"contractcode", (QFilter[])new QFilter[]{contractCodeFilter});
        if (bidEntry != null && bidEntry.length > 0) {
            block0: for (DynamicObject bidResult : bidEntry) {
                if (bidResult == null) continue;
                DynamicObjectCollection outContractEntry = bidResult.getDynamicObjectCollection("contractcode");
                for (Object outContract : outContractEntry) {
                    if (outContract == null || !outContract.get("fbasedataid_id").equals(contractBill.getPkValue())) continue;
                    outContractEntry.remove(outContract);
                    continue block0;
                }
            }
            SaveServiceHelper.save((DynamicObject[])bidEntry);
        }
        DynamicObjectCollection bidResultEntry = contractBill.getDynamicObjectCollection("bidresult");
        DynamicObject project = contractBill.getDynamicObject("project");
        if (!bidResultEntry.isEmpty() && (supplierIdent = BusinessDataServiceHelper.loadSingle((String)"pmfs_supplierident", (String)"id", (QFilter[])new QFilter[]{statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue()), projectFilter = new QFilter("project.id", "=", project.getPkValue())})) != null) {
            ArrayList<Object> bidIdList = new ArrayList<Object>(10);
            for (DynamicObject bidResult : bidResultEntry) {
                if (bidResult == null) continue;
                bidIdList.add(bidResult.get("fbasedataid_id"));
            }
            DynamicObject[] bids = BusinessDataServiceHelper.load((Object[])bidIdList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmbs_bidmessage"));
            if (bids == null || bids.length == 0) {
                return true;
            }
            boolean flag = true;
            for (DynamicObject bid : bids) {
                DynamicObjectCollection contractEntry = bid.getDynamicObjectCollection("contractcode");
                for (DynamicObject dy : contractEntry) {
                    if (dy == null || !dy.get("fbasedataid_id").equals(contractBill.getPkValue())) continue;
                    flag = false;
                    break;
                }
                if (!flag) continue;
                DynamicObjectType dt = contractEntry.getDynamicObjectType();
                DynamicObject object = new DynamicObject(dt);
                object.set("pkid", (Object)orm.genLongId((IDataEntityType)dt));
                object.set("fbasedataid", (Object)contractBill);
                object.set("fbasedataid_id", contractBill.getPkValue());
                contractEntry.add((Object)object);
            }
            SaveServiceHelper.save((DynamicObject[])bids);
        }
        return false;
    }

    private void updateSignContractInfo(DynamicObject contractBill, List<DynamicObject> consignList) {
        QFilter qFilter = new QFilter("contract", "=", contractBill.getPkValue());
        DynamicObject newdata = BusinessDataServiceHelper.loadSingle((String)"pmct_contsign", (QFilter[])new QFilter[]{qFilter});
        if (newdata == null) {
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"pmct_contsign");
            newdata = new DynamicObject((DynamicObjectType)dt);
            ORM orm = ORM.create();
            newdata.set("id", (Object)orm.genLongId((IDataEntityType)dt));
            newdata.set("contract", contractBill.getPkValue());
            newdata.set("billstatus", (Object)StatusEnum.TEMPSAVE.getValue());
        }
        newdata.set("signdate", contractBill.get("signdate"));
        newdata.set("signaddress", contractBill.get("signaddress"));
        newdata.set("signaddressdetail", contractBill.get("signaddressdetail"));
        newdata.set("partaperson", contractBill.get("partaperson"));
        newdata.set("partaphone", contractBill.get("partaphone"));
        newdata.set("partbperson", contractBill.get("partbperson"));
        newdata.set("partbphone", contractBill.get("partbphone"));
        newdata.set("partotherperson", contractBill.get("partotherperson"));
        newdata.set("partotherphone", contractBill.get("partotherphone"));
        newdata.set("modifytime", (Object)new Date());
        newdata.set("createtime", (Object)new Date());
        newdata.set("creator", contractBill.get("creator"));
        newdata.set("modifier", contractBill.get("modifier"));
        consignList.add(newdata);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        List validators = e.getValidators();
        e.getValidators().add(new ContractSubmitValidator());
        boolean isAddValid = false;
        for (AbstractValidator val : validators) {
            String key = val.getOperateKey();
            if (!"unaudit".equals(key) && !OPERATION_DOUNSIGN.equals(key)) continue;
            isAddValid = true;
        }
        if (isAddValid) {
            e.getValidators().add(new ContractValidator());
        }
    }

    private static /* synthetic */ void lambda$beginSaveOperation$0(ORM orm, DynamicObjectType dt, DynamicObject consign) {
        if (consign.getPkValue() == null) {
            consign.set("id", (Object)orm.genLongId((IDataEntityType)dt));
        }
    }

    static class ContractSubmitValidator
    extends AbstractValidator {
        ContractSubmitValidator() {
        }

        public void validate() {
            block17: {
                String key;
                block16: {
                    ExtendedDataEntity[] dataEntities;
                    key = this.getOperateKey();
                    if (!StringUtils.equals((CharSequence)"submit", (CharSequence)key)) break block16;
                    for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                        BigDecimal exchangeRate;
                        Object strategicAgreement;
                        Date signDate;
                        DynamicObject outContractBill = dataEntity.getDataEntity();
                        boolean auditAssign = outContractBill.getBoolean("auditassign");
                        if (auditAssign && (signDate = outContractBill.getDate("signdate")) == null) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u7b7e\u7ea6\u65e5\u671f\u201d\u3002", (String)"OutContractOp_14", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                        }
                        boolean isOpenedContract = outContractBill.getBoolean("openedcontract");
                        DynamicObjectCollection outContPayPlanEntries = outContractBill.getDynamicObjectCollection("outcontpayplanentry");
                        BigDecimal originalOfTaxAmount = outContractBill.getBigDecimal("originaloftaxamount");
                        BigDecimal totalPayAmount = outContPayPlanEntries.stream().map(entry -> entry.getBigDecimal("payamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                        if (!outContPayPlanEntries.isEmpty() && !isOpenedContract && totalPayAmount.compareTo(originalOfTaxAmount) != 0) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff0c\u4ed8\u6b3e\u8ba1\u5212\u542b\u7a0e\u91d1\u989d\u5408\u8ba1\u4e0d\u7b49\u4e8e\u542b\u7a0e\u5408\u540c\u603b\u91d1\u989d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OutContractOp_3", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                            continue;
                        }
                        DynamicObjectCollection bidEntry = outContractBill.getDynamicObjectCollection("bidresult");
                        if (bidEntry != null && !bidEntry.isEmpty()) {
                            DynamicObject partB = outContractBill.getDynamicObject("partb");
                            for (DynamicObject bidResult : bidEntry) {
                                DynamicObject bid;
                                DynamicObject succeedBidder;
                                if (bidResult == null || (succeedBidder = (bid = BusinessDataServiceHelper.loadSingle((Object)bidResult.get("fbasedataid_id"), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmbs_bidmessage"))).getDynamicObject("succeedbidder")) == null || succeedBidder.getPkValue().equals(partB.getPkValue())) continue;
                                this.addWarningMessage(dataEntity, ResManager.loadKDString((String)"\u5408\u540c\u4e59\u65b9\u4e0e\u62db\u6807\u7ed3\u679c\u4e0d\u540c\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u63d0\u4ea4\u3002", (String)"OutContractOp_12", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                                break;
                            }
                        }
                        if ((strategicAgreement = outContractBill.get("strategicagreement")) == null) {
                            QFilter effectingFilter;
                            QFilter contractTypeFilter;
                            Object contractTypeId = outContractBill.get("contracttype_id");
                            Object orgId = outContractBill.get("org_id");
                            Iterator orgFilter = new QFilter("orgscopeentry.scopeorg", "=", orgId);
                            boolean exists = QueryServiceHelper.exists((String)"pmct_strategicagreement", (QFilter[])new QFilter[]{orgFilter, contractTypeFilter = new QFilter("agreementtype", "=", contractTypeId), effectingFilter = new QFilter("agreementstate", "=", (Object)AgreementStatusEnum.EFFECTING.getValue())});
                            if (exists) {
                                this.addWarningMessage(dataEntity, ResManager.loadKDString((String)"\u672c\u9879\u5185\u5bb9\u5c5e\u4e8e\u6218\u7565\u534f\u8bae\u8303\u7574\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u4e0d\u6309\u6218\u7565\u534f\u8bae\u6267\u884c\u3002", (String)"OutContractOp_13", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                            }
                        }
                        if (outContractBill.getBoolean("multipartsettlement") && outContractBill.getDynamicObjectCollection("contorgscope").isEmpty() && outContractBill.getDynamicObjectCollection("contproscope").isEmpty()) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u672c\u5408\u540c\u7684\u9002\u7528\u7ec4\u7ec7\u6216\u9879\u76ee\u3002", (String)"OutContractOp_15", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                        }
                        DynamicObjectCollection listModelEntry = outContractBill.getDynamicObjectCollection("listmodelentry");
                        for (DynamicObject listModelEntryObj : listModelEntry) {
                            HashSet<String> sysNumSet = new HashSet<String>();
                            DynamicObjectCollection subListEntry = listModelEntryObj.getDynamicObjectCollection("sublistentry");
                            for (DynamicObject subListEntryObj : subListEntry) {
                                String sysNumber = subListEntryObj.getString("sysnumber");
                                if (!StringUtils.isNotEmpty((CharSequence)sysNumber)) continue;
                                if (!sysNumSet.contains(sysNumber)) {
                                    sysNumSet.add(sysNumber);
                                    continue;
                                }
                                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6e05\u5355\u6a21\u677f\u201c%1$s\u201d\u4e2d\u7684\u7cfb\u7edf\u7f16\u7801\u201c%2$s\u201d\u5df2\u5b58\u5728\u3002", (String)"OutContractOp_16", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), listModelEntryObj.getString("modelname"), sysNumber));
                            }
                        }
                        if (!outContractBill.getBoolean("ismulticurrency")) continue;
                        if (outContractBill.getDynamicObject("exratetable") == null) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6c47\u7387\u8868\u201d\u3002", (String)"OutContractOp_7", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                        }
                        if (outContractBill.getDynamicObject("currency") == null) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u7b7e\u7ea6\u5e01\u79cd\u201d\u3002", (String)"OutContractOp_8", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                        }
                        if ((exchangeRate = outContractBill.getBigDecimal("exchangerate")) == null || BigDecimal.ZERO.compareTo(exchangeRate) == 0) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6c47\u7387\u201d\u3002", (String)"OutContractOp_9", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                        }
                        if (outContractBill.getDate("exchangedate") != null) continue;
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6c47\u7387\u65e5\u671f\u201d\u3002", (String)"OutContractOp_10", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                    }
                    break block17;
                }
                if (!StringUtils.equals((CharSequence)"audit", (CharSequence)key)) break block17;
                block4: for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObject bill = dataEntity.getDataEntity();
                    DynamicObjectCollection bidEntry = bill.getDynamicObjectCollection("bidresult");
                    if (bidEntry == null || bidEntry.isEmpty()) continue;
                    DynamicObject partB = bill.getDynamicObject("partb");
                    for (DynamicObject bidResult : bidEntry) {
                        DynamicObject bid;
                        DynamicObject succeedBidder;
                        if (bidResult == null || (succeedBidder = (bid = BusinessDataServiceHelper.loadSingle((Object)bidResult.get("fbasedataid_id"), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmbs_bidmessage"))).getDynamicObject("succeedbidder")) == null || succeedBidder.getPkValue().equals(partB.getPkValue())) continue;
                        this.addWarningMessage(dataEntity, ResManager.loadKDString((String)"\u5408\u540c\u4e59\u65b9\u4e0e\u62db\u6807\u7ed3\u679c\u4e0d\u7b26\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"OutContractOp_17", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                        continue block4;
                    }
                }
            }
        }
    }
}

