/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.opplugin;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.business.helper.ContractPayItemHelper;
import kd.pmgt.pmbs.common.enums.ContractControlEnum;
import kd.pmgt.pmbs.common.enums.ContractPayItemSourceEnum;
import kd.pmgt.pmbs.common.enums.DefaultEnum;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;
import kd.pmgt.pmbs.common.enums.PayPlanSourceEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.utils.TypeUtils;
import kd.pmgt.pmct.business.helper.ContractRelationBillValidateHelper;
import kd.pmgt.pmct.business.helper.FundPlanChangeHelper;
import kd.pmgt.pmct.business.helper.UnAuditHelper;
import kd.pmgt.pmct.business.model.ContractValidateResult;
import kd.pmgt.pmct.opplugin.validator.ContractRelationBillUnAuditValidator;

public class OutContractRevisionOp
extends AbstractOperationServicePlugIn {
    protected FundPlanChangeHelper fundPlanChangeHelper = new FundPlanChangeHelper();
    public static final String OPERATION_AUDIT = "audit";
    public static final String OPERATION_UNAUDIT = "unaudit";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("revisionoftaxamount");
        e.getFieldKeys().add("contract");
        e.getFieldKeys().add("project");
        e.getFieldKeys().add("currency");
        e.getFieldKeys().add("stdcurrency");
        e.getFieldKeys().add("exchangerate");
        e.getFieldKeys().add("createtime");
        e.getFieldKeys().add("isbasedonlist");
        e.getFieldKeys().add("kapianentry");
        e.getFieldKeys().add("entryentity");
        e.getFieldKeys().add("superlistingid");
        e.getFieldKeys().add("newlistingid");
        e.getFieldKeys().add("subchangetype");
        e.getFieldKeys().add("hsbgje");
        e.getFieldKeys().add("oftax");
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("billname");
        e.getFieldKeys().add("creator");
        e.getFieldKeys().add("auditor");
        e.getFieldKeys().add("auditdate");
        e.getFieldKeys().add("id");
        e.getFieldKeys().add("latestamountoftax");
        e.getFieldKeys().add("conplanitemid");
        e.getFieldKeys().add("changepayplanentry");
        e.getFieldKeys().add("supplier");
        e.getFieldKeys().add("paytype");
        e.getFieldKeys().add("payfeq");
        e.getFieldKeys().add("payway");
        e.getFieldKeys().add("paypercent");
        e.getFieldKeys().add("payamountoftax");
        e.getFieldKeys().add("planpaytime");
        e.getFieldKeys().add("seq");
        e.getFieldKeys().add("remarks");
        e.getFieldKeys().add("srcamountoftax");
        e.getFieldKeys().add("nodesetting");
        e.getFieldKeys().add("ctrlstrategy");
        e.getFieldKeys().add("nodesettingsource");
        e.getFieldKeys().add("taskcompletestate");
        e.getFieldKeys().add("qty");
        e.getFieldKeys().add("biangengsl");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        super.beginOperationTransaction(e);
        String operationKey = e.getOperationKey();
        block8: for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            switch (operationKey) {
                case "audit": {
                    ContractPayItemHelper.save((DynamicObject)dataEntity, (PayPlanSourceEnum)PayPlanSourceEnum.MODIFY);
                    this.createFundPlanChangeObj(dataEntity);
                    continue block8;
                }
                case "unaudit": {
                    this.rollBackContractPayItem(dataEntity);
                    continue block8;
                }
            }
        }
    }

    private void rollBackContractPayItem(DynamicObject dataEntity) {
        DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)dataEntity.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_outcontractrevision"));
        DynamicObjectCollection payPlanEntry = bill.getDynamicObjectCollection("changepayplanentry");
        UnAuditHelper.updateLastVersionData((DynamicObject)bill, (DynamicObjectCollection)payPlanEntry);
    }

    private void createFundPlanChangeObj(DynamicObject dataEntity) {
        DynamicObject curOutRevision = BusinessDataServiceHelper.loadSingle((Object)dataEntity.getPkValue(), (String)"pmct_outcontractrevision");
        DynamicObject contract = curOutRevision.getDynamicObject("contract");
        QFilter contractFilter = new QFilter("contract", "=", contract.getPkValue());
        QFilter autogenFilter = new QFilter("autogenerated", "=", (Object)DefaultEnum.NO.getValue());
        QFilter sourceFilter = new QFilter("source", "=", (Object)ContractPayItemSourceEnum.PAYPLAN.getValue());
        DynamicObject[] payItems = BusinessDataServiceHelper.load((String)"pmbs_contractpayitem", (String)"", (QFilter[])new QFilter[]{contractFilter, autogenFilter, sourceFilter});
        if (payItems.length > 0) {
            this.generateFundPlanChangeObj(curOutRevision);
        }
    }

    private void generateFundPlanChangeObj(DynamicObject curOutRevision) {
        Object sourceId = curOutRevision.getPkValue();
        Object contractId = ((DynamicObject)curOutRevision.get("contract")).getPkValue();
        String changeType = PayPlanSourceEnum.MODIFY.getValue();
        DynamicObjectCollection customEntries = curOutRevision.getDynamicObjectCollection("changepayplanentry");
        DynamicObject fundPlanChangeObj = this.fundPlanChangeHelper.buildFundPlanChangeEntry(sourceId, contractId, changeType, (DynamicObject[])customEntries.toArray((Object[])new DynamicObject[0]), "pmct_outcontractrevision", true);
        fundPlanChangeObj.set("sourcebillid", curOutRevision.getPkValue());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{fundPlanChangeObj});
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new ContractRelationBillUnAuditValidator());
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                String key = this.getOperateKey();
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    DynamicObject contract = dataEntity.getDataEntity().getDynamicObject("contract");
                    if (contract == null) continue;
                    if (StringUtils.equals((CharSequence)"submit", (CharSequence)key)) {
                        this.validateListing(dataEntity);
                        this.checkContractPayItem(dataEntity);
                        continue;
                    }
                    if (!StringUtils.equals((CharSequence)OutContractRevisionOp.OPERATION_UNAUDIT, (CharSequence)key)) continue;
                    this.validatePaymentApplyAmount(dataEntity);
                    this.validateSettleAmount(dataEntity);
                }
                if (StringUtils.equals((CharSequence)"submit", (CharSequence)key)) {
                    this.validateContractRealAmount(dataEntities);
                }
            }

            private void validateContractRealAmount(ExtendedDataEntity[] dataEntities) {
                Set contractIds = Arrays.stream(dataEntities).filter(o -> o.getDataEntity().getDynamicObject("contract") != null).map(o -> o.getDataEntity().getDynamicObject("contract").getPkValue()).collect(Collectors.toSet());
                DynamicObject[] contracts = BusinessDataServiceHelper.load((Object[])contractIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_outcontract"));
                Set contractTypeIds = Arrays.stream(contracts).filter(o -> o.getDynamicObject("contracttype") != null).map(o -> o.getDynamicObject("contracttype").getPkValue()).collect(Collectors.toSet());
                DynamicObject[] contractTypes = BusinessDataServiceHelper.load((Object[])contractTypeIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_conttype"));
                Map<Object, DynamicObject> contractMap = Arrays.stream(contracts).collect(Collectors.toMap(DataEntityBase::getPkValue, o -> o));
                Map<Object, DynamicObject> contractTypeMap = Arrays.stream(contractTypes).collect(Collectors.toMap(DataEntityBase::getPkValue, o -> o));
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    BigDecimal settleAmount;
                    BigDecimal latestAmount;
                    BigDecimal applyAmount;
                    int compareResult;
                    boolean isOpenContract;
                    DynamicObject contract = dataEntity.getDataEntity().getDynamicObject("contract");
                    if (contract == null || !contractMap.containsKey(contract.getPkValue()) || (contract = contractMap.get(contract.getPkValue())) == null || contract.getDynamicObject("contracttype") == null || !contractTypeMap.containsKey(contract.getDynamicObject("contracttype").getPkValue()) || (isOpenContract = contract.getBoolean("openedcontract"))) continue;
                    DynamicObject contType = contractTypeMap.get(contract.getDynamicObject("contracttype").getPkValue());
                    String applyAmountControl = contType.getString("ammountcontrolapply");
                    String settleAmountControl = contType.getString("ammountcontrolsettle");
                    if (!ContractControlEnum.NOTCONTROL.getValue().equals(applyAmountControl) && (compareResult = (applyAmount = contract.getBigDecimal("totalapplyoftaxamount")).compareTo(latestAmount = dataEntity.getDataEntity().getBigDecimal("latestamountoftax"))) > 0) {
                        if (ContractControlEnum.REMINDCONTROL.getValue().equals(applyAmountControl)) {
                            this.addWarningMessage(dataEntity, ResManager.loadKDString((String)"\u6700\u65b0\u5408\u540c\u542b\u7a0e\u603b\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e\u5408\u540c\u7d2f\u8ba1\u4ed8\u6b3e\u7533\u8bf7\u91d1\u989d\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"OutContractRevisionOp_6", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                        } else if (ContractControlEnum.STRICTCONTROL.getValue().equals(applyAmountControl)) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6700\u65b0\u5408\u540c\u542b\u7a0e\u603b\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e\u5408\u540c\u7d2f\u8ba1\u4ed8\u6b3e\u7533\u8bf7\u91d1\u989d\u3002", (String)"OutContractRevisionOp_7", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                        }
                    }
                    if (ContractControlEnum.NOTCONTROL.getValue().equals(settleAmountControl) || (compareResult = (settleAmount = contract.getBigDecimal("totalsettleoftaxamount")).compareTo(latestAmount = dataEntity.getDataEntity().getBigDecimal("latestamountoftax"))) <= 0) continue;
                    if (ContractControlEnum.REMINDCONTROL.getValue().equals(applyAmountControl)) {
                        this.addWarningMessage(dataEntity, ResManager.loadKDString((String)"\u6700\u65b0\u5408\u540c\u542b\u7a0e\u603b\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e\u5408\u540c\u7d2f\u8ba1\u7ed3\u7b97\u91d1\u989d\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"OutContractRevisionOp_8", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    if (!ContractControlEnum.STRICTCONTROL.getValue().equals(applyAmountControl)) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6700\u65b0\u5408\u540c\u542b\u7a0e\u603b\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e\u5408\u540c\u7d2f\u8ba1\u7ed3\u7b97\u91d1\u989d\u3002", (String)"OutContractRevisionOp_9", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                }
            }

            private void checkContractPayItem(ExtendedDataEntity dataEntity) {
                DynamicObject curDataEntity = dataEntity.getDataEntity();
                DynamicObjectCollection changePayPlanEntry = curDataEntity.getDynamicObjectCollection("changepayplanentry");
                DynamicObject contract = curDataEntity.getDynamicObject("contract");
                contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_outcontract");
                boolean isOpenedContract = contract.getBoolean("openedcontract");
                if (!changePayPlanEntry.isEmpty()) {
                    ContractValidateResult result;
                    BigDecimal latestAmountOfTax = (BigDecimal)dataEntity.getValue("latestamountoftax");
                    if (!isOpenedContract && (result = ContractRelationBillValidateHelper.checkOriginalOfTaxAmount((DynamicObject)curDataEntity.getDynamicObject("currency"), (BigDecimal)latestAmountOfTax, (DynamicObjectCollection)changePayPlanEntry, (String)PayDirectionEnum.OUT.getValue())).error()) {
                        this.addErrorMessage(dataEntity, result.getMsg());
                        return;
                    }
                    result = ContractRelationBillValidateHelper.checkPayAmount((DynamicObjectCollection)changePayPlanEntry);
                    if (result.error()) {
                        this.addErrorMessage(dataEntity, result.getMsg().substring(0, result.getMsg().length() - 1));
                    }
                }
            }

            private void validateListing(ExtendedDataEntity dataEntity) {
                DynamicObject contractAddition = dataEntity.getDataEntity();
                int index = 1;
                DynamicObjectCollection cardEntryEntity = contractAddition.getDynamicObjectCollection("kapianentry");
                for (DynamicObject cardEntryObj : cardEntryEntity) {
                    int subchangetype;
                    int i;
                    DynamicObjectCollection entryCollection = cardEntryObj.getDynamicObjectCollection("entryentity");
                    HashSet<Long> superListingIds = new HashSet<Long>(16);
                    for (i = 0; i < entryCollection.size(); ++i) {
                        DynamicObject listingEntryObj = (DynamicObject)entryCollection.get(i);
                        subchangetype = TypeUtils.nullToInt((Object)listingEntryObj.get("subchangetype"));
                        if (subchangetype != 2 && subchangetype != 3) continue;
                        long superListingId = listingEntryObj.getLong("superlistingid");
                        superListingIds.add(superListingId);
                    }
                    for (i = 0; i < entryCollection.size(); ++i) {
                        long listingId;
                        DynamicObject dynamicObject2 = (DynamicObject)entryCollection.get(i);
                        subchangetype = TypeUtils.nullToInt((Object)dynamicObject2.get("subchangetype"));
                        if (subchangetype != 3 || superListingIds.contains(listingId = dynamicObject2.getLong("newlistingid"))) continue;
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u6e05\u5355\u7b2c%1$s\u4e2a\u5361\u7247\uff0c\u7b2c%2$s\u884c\u4e3a\u975e\u660e\u7ec6\u6e05\u5355\u8282\u70b9\uff0c\u9700\u8981\u5efa\u7acb\u4e0b\u7ea7\u660e\u7ec6\u8282\u70b9\u3002", (String)"OutContractRevisionOp_1", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), index, i + 1));
                    }
                    ++index;
                }
            }

            private void validatePaymentApplyAmount(ExtendedDataEntity dataEntity) {
                BigDecimal originAmount;
                DynamicObject contract = dataEntity.getDataEntity().getDynamicObject("contract");
                DynamicObject contractType = contract.getDynamicObject("contracttype");
                DynamicObject contType = BusinessDataServiceHelper.loadSingle((Object)contractType.getPkValue(), (String)"pmct_conttype");
                String amountControl = contType.getString("ammountcontrolapply");
                if (ContractControlEnum.NOTCONTROL.getValue().equals(amountControl)) {
                    return;
                }
                QFilter contractFilter = new QFilter("entryentity.entrycontract", "in", contract.getPkValue());
                QFilter statusFilter = new QFilter("billstatus", "in", (Object)new String[]{StatusEnum.UNCHECKED.getValue(), StatusEnum.CHECKED.getValue()});
                DynamicObjectCollection amountList = QueryServiceHelper.query((String)"pmct_paymentapply", (String)"entryentity.applyoftaxamount", (QFilter[])new QFilter[]{contractFilter, statusFilter});
                BigDecimal applyAmount = amountList.stream().map(dyn -> dyn.getBigDecimal("entryentity.applyoftaxamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                int compareResult = applyAmount.compareTo(originAmount = dataEntity.getDataEntity().getBigDecimal("srcamountoftax"));
                if (compareResult > 0) {
                    if (ContractControlEnum.REMINDCONTROL.getValue().equals(amountControl)) {
                        this.addWarningMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u64cd\u4f5c\u4f1a\u5bfc\u81f4\u5408\u540c\u7684\u7d2f\u8ba1\u5e94\u4ed8\u542b\u7a0e\u91d1\u989d\u8d85\u51fa\u542b\u7a0e\u5408\u540c\u603b\u91d1\u989d\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"OutContractRevisionOp_2", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                    } else if (ContractControlEnum.STRICTCONTROL.getValue().equals(amountControl)) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u64cd\u4f5c\u4f1a\u5bfc\u81f4\u5408\u540c\u7684\u7d2f\u8ba1\u5e94\u4ed8\u542b\u7a0e\u91d1\u989d\u8d85\u51fa\u542b\u7a0e\u5408\u540c\u603b\u91d1\u989d\u3002", (String)"OutContractRevisionOp_3", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                    }
                }
            }

            private void validateSettleAmount(ExtendedDataEntity dataEntity) {
                BigDecimal originAmount;
                DynamicObject contract = dataEntity.getDataEntity().getDynamicObject("contract");
                DynamicObject contractType = contract.getDynamicObject("contracttype");
                DynamicObject contType = BusinessDataServiceHelper.loadSingle((Object)contractType.getPkValue(), (String)"pmct_conttype");
                String amountControl = contType.getString("ammountcontrolsettle");
                if (ContractControlEnum.NOTCONTROL.getValue().equals(amountControl)) {
                    return;
                }
                QFilter contractFilter = new QFilter("contract", "in", contract.getPkValue());
                QFilter statusFilter = new QFilter("billstatus", "in", (Object)new String[]{StatusEnum.UNCHECKED.getValue(), StatusEnum.CHECKED.getValue()});
                DynamicObjectCollection amountList = QueryServiceHelper.query((String)"pmct_outcontract_settle", (String)"settleoftaxamount", (QFilter[])new QFilter[]{contractFilter, statusFilter});
                BigDecimal settleAmount = amountList.stream().map(dyn -> dyn.getBigDecimal("settleoftaxamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                int compareResult = settleAmount.compareTo(originAmount = dataEntity.getDataEntity().getBigDecimal("srcamountoftax"));
                if (compareResult > 0) {
                    if (ContractControlEnum.REMINDCONTROL.getValue().equals(amountControl)) {
                        this.addWarningMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u64cd\u4f5c\u4f1a\u5bfc\u81f4\u5408\u540c\u7684\u7d2f\u8ba1\u7ed3\u7b97\u542b\u7a0e\u91d1\u989d\u8d85\u51fa\u542b\u7a0e\u5408\u540c\u603b\u91d1\u989d\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"OutContractRevisionOp_4", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                    } else if (ContractControlEnum.STRICTCONTROL.getValue().equals(amountControl)) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u64cd\u4f5c\u4f1a\u5bfc\u81f4\u5408\u540c\u7684\u7d2f\u8ba1\u7ed3\u7b97\u542b\u7a0e\u91d1\u989d\u8d85\u51fa\u542b\u7a0e\u5408\u540c\u603b\u91d1\u989d\u3002", (String)"OutContractRevisionOp_5", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                    }
                }
            }
        });
    }
}

