/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.opplugin.addition;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.business.helper.ContractCollectItemHelper;
import kd.pmgt.pmbs.common.enums.DefaultEnum;
import kd.pmgt.pmbs.common.enums.PayPlanSourceEnum;
import kd.pmgt.pmbs.common.enums.PerformAmountTypeEnum;
import kd.pmgt.pmbs.common.utils.CurrencyHelper;
import kd.pmgt.pmbs.common.utils.NumberHelper;
import kd.pmgt.pmbs.common.utils.budget.BudgetValidateAndUpdateHelper;
import kd.pmgt.pmbs.common.utils.budget.PerformBillInfo;
import kd.pmgt.pmbs.common.utils.budget.PerformBillInfoBuilder;
import kd.pmgt.pmct.business.helper.IncomePlanChangeHelper;
import kd.pmgt.pmct.business.helper.UnAuditHelper;
import kd.pmgt.pmct.opplugin.validator.ContractRelationBillUnAuditValidator;

public class InContractAdditionOp
extends AbstractOperationServicePlugIn {
    protected IncomePlanChangeHelper fundPlanChangeHelper = new IncomePlanChangeHelper();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("addamountoftax");
        e.getFieldKeys().add("contract");
        e.getFieldKeys().add("project");
        e.getFieldKeys().add("currency");
        e.getFieldKeys().add("stdcurrency");
        e.getFieldKeys().add("exchangerate");
        e.getFieldKeys().add("createtime");
        e.getFieldKeys().add("isbasedonlist");
        e.getFieldKeys().add("cardentry");
        e.getFieldKeys().add("entryentity");
        e.getFieldKeys().add("subaddtype");
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("billname");
        e.getFieldKeys().add("creator");
        e.getFieldKeys().add("auditor");
        e.getFieldKeys().add("auditdate");
        e.getFieldKeys().add("id");
        e.getFieldKeys().add("latestamountoftax");
        e.getFieldKeys().add("conplanitemid");
        e.getFieldKeys().add("incomeamountoftax");
        e.getFieldKeys().add("cardentry");
        e.getFieldKeys().add("entryentity");
        e.getFieldKeys().add("amount");
        e.getFieldKeys().add("listingbudgetitem");
        e.getFieldKeys().add("contract");
        e.getFieldKeys().add("creator");
        e.getFieldKeys().add("createtime");
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("billname");
        e.getFieldKeys().add("addamount");
        e.getFieldKeys().add("budgetitem");
        e.getFieldKeys().add("addamountoftax");
        e.getFieldKeys().add("cardentry");
        e.getFieldKeys().add("superlistingid");
        e.getFieldKeys().add("newlistingid");
        e.getFieldKeys().add("subaddtype");
        e.getFieldKeys().add("listnumber");
        e.getFieldKeys().add("listname");
        e.getFieldKeys().add("qty");
        e.getFieldKeys().add("price");
        e.getFieldKeys().add("currency");
        e.getFieldKeys().add("subtaxrate");
        e.getFieldKeys().add("rateobj");
        e.getFieldKeys().add("materiel");
        e.getFieldKeys().add("measureunit");
        e.getFieldKeys().add("qty");
        e.getFieldKeys().add("price");
        e.getFieldKeys().add("amount");
        e.getFieldKeys().add("parentlisting");
        e.getFieldKeys().add("sysnum");
        e.getFieldKeys().add("listingbudgetitem");
        e.getFieldKeys().add("changeamountoftax");
        e.getFieldKeys().add("oftax");
        e.getFieldKeys().add("cmptype");
        e.getFieldKeys().add("incomeplanentry");
        e.getFieldKeys().add("nodesetting");
        e.getFieldKeys().add("nodesettingsource");
        e.getFieldKeys().add("ctrlstrategy");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String operationKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"audit")) {
            for (DynamicObject dataEntity : dataEntities) {
                this.handleIncomeItem(dataEntity);
            }
        } else if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"unaudit")) {
            for (DynamicObject dataEntity : dataEntities) {
                DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)dataEntity.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_inaddagreement"));
                DynamicObject contract = bill.getDynamicObject("contract");
                contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_incontract"));
                DynamicObjectCollection planEntry = bill.getDynamicObjectCollection("incomeplanentry");
                UnAuditHelper.updateLastVersionData((DynamicObject)bill, (DynamicObjectCollection)planEntry);
            }
        }
        if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"submit") || StringUtils.equals((CharSequence)operationKey, (CharSequence)"unsubmit") || StringUtils.equals((CharSequence)operationKey, (CharSequence)"audit") || StringUtils.equals((CharSequence)operationKey, (CharSequence)"unaudit")) {
            this.updateBudgetData(dataEntities, operationKey);
        }
    }

    protected void updateBudgetData(DynamicObject[] entities, String operationKey) {
        for (DynamicObject bill : entities) {
            PerformBillInfo billInfo;
            DynamicObject contract = bill.getDynamicObject("contract");
            DynamicObject project = contract.getDynamicObject("project");
            contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_incontract");
            boolean isOpenedContract = contract.getBoolean("openedcontract");
            boolean isMultiContract = contract.getBoolean("ismulticontract");
            if (project == null || isOpenedContract || isMultiContract) continue;
            DynamicObject[] proApp = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)String.join((CharSequence)",", "org", "currencyfield"), (QFilter[])new QFilter[]{new QFilter("pro", "=", project.getPkValue())});
            if (proApp == null || proApp.length == 0) {
                return;
            }
            Map<String, BigDecimal> projectAmountMap = this.buildBudgetAmountMap(bill, this.getExchangeRate(bill, proApp[0]));
            Map<String, BigDecimal> contractAmountMap = this.buildBudgetAmountMap(bill, BigDecimal.ONE);
            if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"submit")) {
                billInfo = new PerformBillInfoBuilder().formBillId("pmct_inaddagreement").billNo(bill.getString("billno")).billName(bill.getString("billname")).creator(bill.getDynamicObject("creator")).createDate(bill.getDate("createtime")).id(bill.getLong("id")).contractId(contract.getPkValue().toString()).contractCurrency(bill.getDynamicObject("currency")).amountType(PerformAmountTypeEnum.CONTRACT).build();
                BudgetValidateAndUpdateHelper.updateBudgetOnSubmit(projectAmountMap, contractAmountMap, (PerformBillInfo)billInfo);
                continue;
            }
            if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"unsubmit")) {
                billInfo = new PerformBillInfoBuilder().formBillId("pmct_inaddagreement").id(bill.getLong("id")).contractId(contract.getPkValue().toString()).amountType(PerformAmountTypeEnum.CONTRACT).build();
                BudgetValidateAndUpdateHelper.updateBudgetOnUnsubmit(projectAmountMap, contractAmountMap, (PerformBillInfo)billInfo);
                continue;
            }
            if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"audit")) {
                billInfo = new PerformBillInfoBuilder().formBillId("pmct_inaddagreement").billNo(bill.getString("billno")).billName(bill.getString("billname")).creator(bill.getDynamicObject("creator")).createDate(bill.getDate("createtime")).auditor(bill.getDynamicObject("auditor")).auditDate(bill.getDate("auditdate")).id(bill.getLong("id")).contractId(contract.getPkValue().toString()).amountType(PerformAmountTypeEnum.CONTRACT).build();
                BudgetValidateAndUpdateHelper.updateBudgetOnAudit(projectAmountMap, contractAmountMap, (PerformBillInfo)billInfo);
                continue;
            }
            if (!StringUtils.equals((CharSequence)operationKey, (CharSequence)"unaudit")) continue;
            BudgetValidateAndUpdateHelper.updateBudgetOnUnaudit(projectAmountMap, contractAmountMap, (String)"pmct_inaddagreement", (long)bill.getLong("id"), (String)contract.getPkValue().toString(), (PerformAmountTypeEnum)PerformAmountTypeEnum.CONTRACT);
        }
    }

    protected BigDecimal getExchangeRate(DynamicObject bill, DynamicObject project) {
        DynamicObject exRateTable;
        DynamicObject org = project.getDynamicObject("org");
        DynamicObject proCurrency = project.getDynamicObject("currencyfield");
        DynamicObject contractCurrency = bill.getDynamicObject("currency");
        DynamicObject stdCurrency = bill.getDynamicObject("stdcurrency");
        if (proCurrency != null && contractCurrency != null && proCurrency.getPkValue().equals(contractCurrency.getPkValue())) {
            return BigDecimal.ONE;
        }
        if (proCurrency != null && stdCurrency != null && proCurrency.getPkValue().equals(stdCurrency.getPkValue())) {
            return bill.getBigDecimal("exchangerate");
        }
        BigDecimal exchangeRate = BigDecimal.ONE;
        if (org != null && proCurrency != null && contractCurrency != null && (exRateTable = CurrencyHelper.getExRateTable((Long)org.getLong("id"))) != null) {
            exchangeRate = CurrencyHelper.getExChangeRate((Long)contractCurrency.getLong("id"), (Long)proCurrency.getLong("id"), (Long)exRateTable.getLong("id"), (Date)bill.getDate("createtime"));
        }
        return exchangeRate;
    }

    protected Map<String, BigDecimal> buildBudgetAmountMap(DynamicObject bill, BigDecimal exchangeRate) {
        HashMap<String, BigDecimal> budgetAmountMap = new HashMap<String, BigDecimal>();
        boolean isOnList = bill.getDynamicObject("contract").getBoolean("isonlist");
        if (isOnList) {
            DynamicObjectCollection listModelEntries = bill.getDynamicObjectCollection("cardentry");
            for (DynamicObject listModelEntry : listModelEntries) {
                DynamicObjectCollection listEntry = listModelEntry.getDynamicObjectCollection("entryentity");
                String cmpType = listModelEntry.getString("cmptype");
                BigDecimal coefficient = BigDecimal.ONE;
                if ("(0)".equals(cmpType)) continue;
                if ("(-)".equals(cmpType)) {
                    coefficient = BigDecimal.valueOf(-1L);
                }
                for (DynamicObject list : listEntry) {
                    BigDecimal amount;
                    DynamicObject budget = list.getDynamicObject("listingbudgetitem");
                    String changeType = list.getString("subaddtype");
                    if (budget != null && (StringUtils.equals((CharSequence)"0", (CharSequence)changeType) || StringUtils.equals((CharSequence)"1", (CharSequence)changeType))) {
                        amount = list.getBigDecimal("changeamountoftax").multiply(coefficient);
                        if (amount == null || amount.compareTo(BigDecimal.ZERO) == 0) continue;
                        this.addBudgetAmount(exchangeRate, budgetAmountMap, budget, amount);
                        continue;
                    }
                    if (budget == null || !StringUtils.equals((CharSequence)"2", (CharSequence)changeType) || (amount = list.getBigDecimal("oftax").multiply(coefficient)) == null || amount.compareTo(BigDecimal.ZERO) == 0) continue;
                    this.addBudgetAmount(exchangeRate, budgetAmountMap, budget, amount);
                }
            }
        } else {
            DynamicObject budget = bill.getDynamicObject("budgetitem");
            BigDecimal amount = bill.getBigDecimal("addamountoftax");
            if (budget != null && amount != null && amount.compareTo(BigDecimal.ZERO) != 0) {
                this.addBudgetAmount(exchangeRate, budgetAmountMap, budget, amount);
            }
        }
        return budgetAmountMap;
    }

    protected void addBudgetAmount(BigDecimal exchangeRate, Map<String, BigDecimal> budgetAmountMap, DynamicObject budget, BigDecimal amount) {
        BigDecimal budgetAmount = budgetAmountMap.get(budget.getPkValue().toString());
        if (budgetAmount == null) {
            budgetAmount = BigDecimal.ZERO;
        }
        budgetAmountMap.put(budget.getPkValue().toString(), budgetAmount.add(amount.multiply(exchangeRate)));
    }

    public void handleIncomeItem(DynamicObject dataEntity) {
        DynamicObject curInAddition = BusinessDataServiceHelper.loadSingle((Object)dataEntity.getPkValue(), (String)"pmct_inaddagreement");
        DynamicObject contract = curInAddition.getDynamicObject("contract");
        QFilter contractFilter = new QFilter("contract", "=", contract.getPkValue());
        QFilter autogenFilter = new QFilter("autogenerated", "=", (Object)DefaultEnum.NO.getValue());
        DynamicObject[] incomeItems = BusinessDataServiceHelper.load((String)"pmbs_contractcollectitem", (String)"", (QFilter[])new QFilter[]{contractFilter, autogenFilter});
        if (incomeItems.length > 0) {
            this.generateFundPlanChangeObj(curInAddition);
        }
        new ContractCollectItemHelper().doSave(dataEntity, PayPlanSourceEnum.ADDITION);
    }

    private void generateFundPlanChangeObj(DynamicObject curInAddition) {
        Object sourceId = curInAddition.getPkValue();
        Object contractId = ((DynamicObject)curInAddition.get("contract")).getPkValue();
        String changeType = PayPlanSourceEnum.ADDITION.getValue();
        DynamicObjectCollection customEntries = curInAddition.getDynamicObjectCollection("incomeplanentry");
        DynamicObject fundPlanChangeObj = this.fundPlanChangeHelper.buildFundPlanChangeEntry(sourceId, contractId, changeType, (DynamicObject[])customEntries.toArray((Object[])new DynamicObject[0]), "pmct_inaddagreement", true);
        fundPlanChangeObj.set("sourcebillid", curInAddition.getPkValue());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{fundPlanChangeObj});
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new ContractRelationBillUnAuditValidator());
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities;
                for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                    String key = this.getOperateKey();
                    if (!StringUtils.equals((CharSequence)"submit", (CharSequence)key)) continue;
                    String visible = (String)this.getOption().getVariables().get("visible");
                    if (!Boolean.TRUE.toString().equals(visible)) continue;
                    this.checkContractCollectItem(dataEntity);
                    this.checkLatestAmtOfTax(dataEntity);
                }
            }

            private void checkLatestAmtOfTax(ExtendedDataEntity dataEntity) {
                QFilter autoGenFilter;
                DynamicObject inConAddition = dataEntity.getDataEntity();
                QFilter contractFilter = new QFilter("contract", "=", inConAddition.getDynamicObject("contract").getPkValue());
                if (!QueryServiceHelper.exists((String)"pmbs_contractcollectitem", (QFilter[])new QFilter[]{contractFilter, autoGenFilter = new QFilter("autogenerated", "=", (Object)DefaultEnum.NO.getValue())})) {
                    return;
                }
                BigDecimal sumEntryAmt = BigDecimal.ZERO;
                BigDecimal latestAmtOfTax = inConAddition.getBigDecimal("latestamountoftax");
                DynamicObjectCollection incomePlanEntryColl = inConAddition.getDynamicObjectCollection("incomeplanentry");
                if (!incomePlanEntryColl.isEmpty()) {
                    for (DynamicObject planEntry : incomePlanEntryColl) {
                        sumEntryAmt = sumEntryAmt.add(planEntry.getBigDecimal("incomeamountoftax"));
                    }
                    if (null != latestAmtOfTax && latestAmtOfTax.compareTo(sumEntryAmt) != 0) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff0c\u6536\u6b3e\u8ba1\u5212\u542b\u7a0e\u91d1\u989d\u5408\u8ba1\u4e0d\u7b49\u4e8e\u542b\u7a0e\u5408\u540c\u603b\u91d1\u989d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"InContractAdditionOp_2", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                    }
                }
            }

            private void checkContractCollectItem(ExtendedDataEntity dataEntity) {
                DynamicObject curDataEntity = dataEntity.getDataEntity();
                DynamicObjectCollection planEntrys = curDataEntity.getDynamicObjectCollection("incomeplanentry");
                for (int i = 0; i < planEntrys.size(); ++i) {
                    BigDecimal appliedComAmt;
                    DynamicObject incomeItem;
                    DynamicObject planEntry = (DynamicObject)planEntrys.get(i);
                    Long incomeItemId = planEntry.getLong("conplanitemid");
                    if (incomeItemId == 0L || NumberHelper.compareValue((Object)(incomeItem = BusinessDataServiceHelper.loadSingle((Object)incomeItemId, (String)"pmbs_contractcollectitem")), (Object)(appliedComAmt = incomeItem.getBigDecimal("appliedcomamt"))) >= 0) continue;
                    this.addWarningMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u8ba1\u5212\u7b2c%s\u9879\uff0c\u542b\u7a0e\u91d1\u989d\u5c0f\u4e8e\u8be5\u9879\u5df2\u8bf7\u6b3e\u91d1\u989d\uff08\u542b\u5728\u9014\uff09\u3002", (String)"InContractAdditionOp_4", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), i + 1));
                    break;
                }
            }
        });
    }
}

