/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.opplugin.addition;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.business.helper.ContractPayItemHelper;
import kd.pmgt.pmbs.business.helper.ProBudgetControlHelper;
import kd.pmgt.pmbs.common.enums.ContractControlEnum;
import kd.pmgt.pmbs.common.enums.ContractPayItemSourceEnum;
import kd.pmgt.pmbs.common.enums.DefaultEnum;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;
import kd.pmgt.pmbs.common.enums.PayPlanSourceEnum;
import kd.pmgt.pmbs.common.enums.PerformAmountTypeEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.utils.CurrencyHelper;
import kd.pmgt.pmbs.common.utils.NumberHelper;
import kd.pmgt.pmbs.common.utils.budget.BudgetValidateAndUpdateHelper;
import kd.pmgt.pmbs.common.utils.budget.PerformBillInfo;
import kd.pmgt.pmbs.common.utils.budget.PerformBillInfoBuilder;
import kd.pmgt.pmct.business.helper.ContractRelationBillValidateHelper;
import kd.pmgt.pmct.business.helper.FundPlanChangeHelper;
import kd.pmgt.pmct.business.helper.UnAuditHelper;
import kd.pmgt.pmct.business.model.ContractValidateResult;
import kd.pmgt.pmct.opplugin.addition.OutContractAdditionValidator;
import kd.pmgt.pmct.opplugin.validator.ContractRelationBillUnAuditValidator;

public class OutContractAdditionOp
extends AbstractOperationServicePlugIn {
    protected FundPlanChangeHelper fundPlanChangeHelper = new FundPlanChangeHelper();
    public static final String OPERATION_AUDIT = "audit";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("addamountoftax");
        e.getFieldKeys().add("contract");
        e.getFieldKeys().add("project");
        e.getFieldKeys().add("currency");
        e.getFieldKeys().add("stdcurrency");
        e.getFieldKeys().add("exchangerate");
        e.getFieldKeys().add("createtime");
        e.getFieldKeys().add("isbasedonlist");
        e.getFieldKeys().add("cardentry");
        e.getFieldKeys().add("entryentity");
        e.getFieldKeys().add("subaddtype");
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("billname");
        e.getFieldKeys().add("creator");
        e.getFieldKeys().add("auditor");
        e.getFieldKeys().add("auditdate");
        e.getFieldKeys().add("id");
        e.getFieldKeys().add("latestamountoftax");
        e.getFieldKeys().add("conplanitemid");
        e.getFieldKeys().add("payamountoftax");
        e.getFieldKeys().add("cmptype");
        e.getFieldKeys().add("oftax");
        e.getFieldKeys().add("budgetitem");
        e.getFieldKeys().add("listingbudgetitem");
        e.getFieldKeys().add("changeamountoftax");
        e.getFieldKeys().add("superlistingid");
        e.getFieldKeys().add("newlistingid");
        e.getFieldKeys().add("srcamountoftax");
        e.getFieldKeys().add("changeqty");
        e.getFieldKeys().add("qty");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        block4: {
            DynamicObject[] dataEntities;
            String operationKey;
            block3: {
                super.beginOperationTransaction(e);
                operationKey = e.getOperationKey();
                dataEntities = e.getDataEntities();
                if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"submit") || StringUtils.equals((CharSequence)operationKey, (CharSequence)"unsubmit") || StringUtils.equals((CharSequence)operationKey, (CharSequence)OPERATION_AUDIT) || StringUtils.equals((CharSequence)operationKey, (CharSequence)"unaudit")) {
                    this.updateBudgetData(dataEntities, operationKey);
                }
                if (!StringUtils.equals((CharSequence)operationKey, (CharSequence)OPERATION_AUDIT)) break block3;
                for (DynamicObject dataEntity : dataEntities) {
                    this.handlePayItem(dataEntity);
                }
                break block4;
            }
            if (!StringUtils.equals((CharSequence)operationKey, (CharSequence)"unaudit")) break block4;
            for (DynamicObject dataEntity : dataEntities) {
                DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)dataEntity.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_outaddagreement"));
                DynamicObject contract = bill.getDynamicObject("contract");
                contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_outcontract"));
                DynamicObjectCollection payPlanEntry = bill.getDynamicObjectCollection("payplanentry");
                UnAuditHelper.updateLastVersionData((DynamicObject)bill, (DynamicObjectCollection)payPlanEntry);
            }
        }
    }

    protected void updateBudgetData(DynamicObject[] entities, String operationKey) {
        for (DynamicObject bill : entities) {
            PerformBillInfo billInfo;
            DynamicObject contract = bill.getDynamicObject("contract");
            DynamicObject project = contract.getDynamicObject("project");
            contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_outcontract");
            boolean isOpenedContract = contract.getBoolean("openedcontract");
            boolean multiPartSettlement = contract.getBoolean("multipartsettlement");
            if (project == null || isOpenedContract || multiPartSettlement) continue;
            DynamicObject[] proApp = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"org,currencyfield", (QFilter[])new QFilter[]{new QFilter("pro", "=", project.getPkValue())});
            if (proApp == null || proApp.length == 0) {
                return;
            }
            boolean isNew = ProBudgetControlHelper.checkIsNewProBudgetCtrl((Long)((Long)project.getPkValue()));
            if (isNew) continue;
            Map<String, BigDecimal> projectAmountMap = this.buildBudgetAmountMap(bill, this.getExchangeRate(bill, proApp[0]));
            Map<String, BigDecimal> contractAmountMap = this.buildBudgetAmountMap(bill, BigDecimal.ONE);
            if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"submit")) {
                billInfo = new PerformBillInfoBuilder().formBillId("pmct_outaddagreement").billNo(bill.getString("billno")).billName(bill.getString("billname")).creator(bill.getDynamicObject("creator")).createDate(bill.getDate("createtime")).id(bill.getLong("id")).contractId(contract.getPkValue().toString()).contractCurrency(bill.getDynamicObject("currency")).amountType(PerformAmountTypeEnum.CONTRACT).build();
                BudgetValidateAndUpdateHelper.updateBudgetOnSubmit(projectAmountMap, contractAmountMap, (PerformBillInfo)billInfo);
                continue;
            }
            if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"unsubmit")) {
                billInfo = new PerformBillInfoBuilder().formBillId("pmct_outaddagreement").id(bill.getLong("id")).contractId(contract.getPkValue().toString()).amountType(PerformAmountTypeEnum.CONTRACT).build();
                BudgetValidateAndUpdateHelper.updateBudgetOnUnsubmit(projectAmountMap, contractAmountMap, (PerformBillInfo)billInfo);
                continue;
            }
            if (StringUtils.equals((CharSequence)operationKey, (CharSequence)OPERATION_AUDIT)) {
                billInfo = new PerformBillInfoBuilder().formBillId("pmct_outaddagreement").billNo(bill.getString("billno")).billName(bill.getString("billname")).creator(bill.getDynamicObject("creator")).createDate(bill.getDate("createtime")).auditor(bill.getDynamicObject("auditor")).auditDate(bill.getDate("auditdate")).id(bill.getLong("id")).contractId(contract.getPkValue().toString()).amountType(PerformAmountTypeEnum.CONTRACT).build();
                BudgetValidateAndUpdateHelper.updateBudgetOnAudit(projectAmountMap, contractAmountMap, (PerformBillInfo)billInfo);
                continue;
            }
            if (!StringUtils.equals((CharSequence)operationKey, (CharSequence)"unaudit")) continue;
            BudgetValidateAndUpdateHelper.updateBudgetOnUnaudit(projectAmountMap, contractAmountMap, (String)"pmct_outaddagreement", (long)bill.getLong("id"), (String)contract.getPkValue().toString(), (PerformAmountTypeEnum)PerformAmountTypeEnum.CONTRACT);
        }
    }

    protected BigDecimal getExchangeRate(DynamicObject bill, DynamicObject project) {
        DynamicObject exRateTable;
        DynamicObject org = project.getDynamicObject("org");
        DynamicObject proCurrency = project.getDynamicObject("currencyfield");
        DynamicObject contractCurrency = bill.getDynamicObject("currency");
        DynamicObject stdCurrency = bill.getDynamicObject("stdcurrency");
        if (proCurrency != null && contractCurrency != null && proCurrency.getPkValue().equals(contractCurrency.getPkValue())) {
            return BigDecimal.ONE;
        }
        if (proCurrency != null && stdCurrency != null && proCurrency.getPkValue().equals(stdCurrency.getPkValue())) {
            return bill.getBigDecimal("exchangerate");
        }
        BigDecimal exchangeRate = BigDecimal.ONE;
        if (org != null && proCurrency != null && contractCurrency != null && (exRateTable = CurrencyHelper.getExRateTable((Long)org.getLong("id"))) != null) {
            exchangeRate = CurrencyHelper.getExChangeRate((Long)contractCurrency.getLong("id"), (Long)proCurrency.getLong("id"), (Long)exRateTable.getLong("id"), (Date)bill.getDate("createtime"));
        }
        return exchangeRate;
    }

    protected Map<String, BigDecimal> buildBudgetAmountMap(DynamicObject bill, BigDecimal exchangeRate) {
        HashMap<String, BigDecimal> budgetAmountMap = new HashMap<String, BigDecimal>();
        boolean isOnList = bill.getDynamicObject("contract").getBoolean("isonlist");
        if (isOnList) {
            DynamicObjectCollection listModelEntries = bill.getDynamicObjectCollection("cardentry");
            for (DynamicObject listModelEntry : listModelEntries) {
                DynamicObjectCollection listEntry = listModelEntry.getDynamicObjectCollection("entryentity");
                String cmpType = listModelEntry.getString("cmptype");
                BigDecimal coefficient = BigDecimal.ONE;
                if ("(0)".equals(cmpType)) continue;
                if ("(-)".equals(cmpType)) {
                    coefficient = BigDecimal.valueOf(-1L);
                }
                for (DynamicObject list : listEntry) {
                    BigDecimal amount;
                    DynamicObject budget = list.getDynamicObject("listingbudgetitem");
                    String changeType = list.getString("subaddtype");
                    if (budget != null && (StringUtils.equals((CharSequence)"0", (CharSequence)changeType) || StringUtils.equals((CharSequence)"1", (CharSequence)changeType))) {
                        amount = list.getBigDecimal("changeamountoftax").multiply(coefficient);
                        if (amount == null || amount.compareTo(BigDecimal.ZERO) == 0) continue;
                        this.addBudgetAmount(exchangeRate, budgetAmountMap, budget, amount);
                        continue;
                    }
                    if (budget == null || !StringUtils.equals((CharSequence)"2", (CharSequence)changeType) || (amount = list.getBigDecimal("oftax").multiply(coefficient)) == null || amount.compareTo(BigDecimal.ZERO) == 0) continue;
                    this.addBudgetAmount(exchangeRate, budgetAmountMap, budget, amount);
                }
            }
        } else {
            DynamicObject budget = bill.getDynamicObject("budgetitem");
            BigDecimal amount = bill.getBigDecimal("addamountoftax");
            if (budget != null && amount != null && amount.compareTo(BigDecimal.ZERO) != 0) {
                this.addBudgetAmount(exchangeRate, budgetAmountMap, budget, amount);
            }
        }
        return budgetAmountMap;
    }

    protected void addBudgetAmount(BigDecimal exchangeRate, Map<String, BigDecimal> budgetAmountMap, DynamicObject budget, BigDecimal amount) {
        BigDecimal budgetAmount = budgetAmountMap.get(budget.getPkValue().toString());
        if (budgetAmount == null) {
            budgetAmount = BigDecimal.ZERO;
        }
        budgetAmountMap.put(budget.getPkValue().toString(), budgetAmount.add(amount.multiply(exchangeRate)));
    }

    public void handlePayItem(DynamicObject dataEntity) {
        DynamicObject curOutAddition = BusinessDataServiceHelper.loadSingle((Object)dataEntity.getPkValue(), (String)"pmct_outaddagreement");
        DynamicObject contract = curOutAddition.getDynamicObject("contract");
        QFilter contractFilter = new QFilter("contract", "=", contract.getPkValue());
        QFilter autogenFilter = new QFilter("autogenerated", "=", (Object)DefaultEnum.NO.getValue());
        QFilter sourceFilter = new QFilter("source", "=", (Object)ContractPayItemSourceEnum.PAYPLAN.getValue());
        DynamicObject[] payItems = BusinessDataServiceHelper.load((String)"pmbs_contractpayitem", (String)"", (QFilter[])new QFilter[]{contractFilter, autogenFilter, sourceFilter});
        if (payItems.length > 0) {
            this.generateFundPlanChangeObj(curOutAddition);
        }
        ContractPayItemHelper.save((DynamicObject)curOutAddition, (PayPlanSourceEnum)PayPlanSourceEnum.ADDITION);
    }

    private void generateFundPlanChangeObj(DynamicObject curOutAddition) {
        Object sourceId = curOutAddition.getPkValue();
        Object contractId = ((DynamicObject)curOutAddition.get("contract")).getPkValue();
        String changeType = PayPlanSourceEnum.ADDITION.getValue();
        DynamicObjectCollection customEntries = curOutAddition.getDynamicObjectCollection("payplanentry");
        DynamicObject fundPlanChangeObj = this.fundPlanChangeHelper.buildFundPlanChangeEntry(sourceId, contractId, changeType, (DynamicObject[])customEntries.toArray((Object[])new DynamicObject[0]), "pmct_outaddagreement", true);
        fundPlanChangeObj.set("sourcebillid", curOutAddition.getPkValue());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{fundPlanChangeObj});
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new OutContractAdditionValidator());
        e.getValidators().add(new ContractRelationBillUnAuditValidator());
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                String key = this.getOperateKey();
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    if (StringUtils.equals((CharSequence)"submit", (CharSequence)key)) {
                        this.checkContractPayItem(dataEntity);
                        continue;
                    }
                    if (!StringUtils.equals((CharSequence)"unaudit", (CharSequence)key)) continue;
                    this.validatePaymentApplyAmount(dataEntity);
                    this.validateSettleAmount(dataEntity);
                }
                if (StringUtils.equals((CharSequence)"submit", (CharSequence)key)) {
                    this.validateContractRealAmount(dataEntities);
                }
            }

            private void checkContractPayItem(ExtendedDataEntity dataEntity) {
                DynamicObject curDataEntity = dataEntity.getDataEntity();
                DynamicObject contract = curDataEntity.getDynamicObject("contract");
                contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_outcontract");
                boolean isOpenedContract = contract.getBoolean("openedcontract");
                DynamicObjectCollection changePayPlanEntry = curDataEntity.getDynamicObjectCollection("payplanentry");
                if (!changePayPlanEntry.isEmpty()) {
                    ContractValidateResult result;
                    BigDecimal latestAmountOfTax = (BigDecimal)dataEntity.getValue("latestamountoftax");
                    if (!isOpenedContract && (result = ContractRelationBillValidateHelper.checkOriginalOfTaxAmount((BigDecimal)latestAmountOfTax, (DynamicObjectCollection)changePayPlanEntry, (String)PayDirectionEnum.OUT.getValue())).error()) {
                        this.addErrorMessage(dataEntity, result.getMsg());
                        return;
                    }
                    result = ContractRelationBillValidateHelper.checkPayAmount((DynamicObjectCollection)changePayPlanEntry);
                    if (result.error()) {
                        this.addErrorMessage(dataEntity, result.getMsg());
                    }
                }
            }

            private void validatePaymentApplyAmount(ExtendedDataEntity dataEntity) {
                DynamicObject contract = dataEntity.getDataEntity().getDynamicObject("contract");
                DynamicObject contractType = contract.getDynamicObject("contracttype");
                if (contractType != null) {
                    BigDecimal originAmount;
                    DynamicObject contType = BusinessDataServiceHelper.loadSingle((Object)contractType.getPkValue(), (String)"pmct_conttype");
                    String amountControl = contType.getString("ammountcontrolapply");
                    if (ContractControlEnum.NOTCONTROL.getValue().equals(amountControl)) {
                        return;
                    }
                    QFilter contractFilter = new QFilter("entryentity.entrycontract", "in", contract.getPkValue());
                    QFilter statusFilter = new QFilter("billstatus", "in", (Object)new String[]{StatusEnum.UNCHECKED.getValue(), StatusEnum.CHECKED.getValue()});
                    DynamicObjectCollection amountList = QueryServiceHelper.query((String)"pmct_paymentapply", (String)"entryentity.applyoftaxamount", (QFilter[])new QFilter[]{contractFilter, statusFilter});
                    BigDecimal applyAmount = amountList.stream().map(dyn -> dyn.getBigDecimal("entryentity.applyoftaxamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                    int compareResult = applyAmount.compareTo(originAmount = dataEntity.getDataEntity().getBigDecimal("srcamountoftax"));
                    if (compareResult > 0) {
                        if (ContractControlEnum.REMINDCONTROL.getValue().equals(amountControl)) {
                            this.addWarningMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u64cd\u4f5c\u4f1a\u5bfc\u81f4\u5408\u540c\u7684\u7d2f\u8ba1\u5e94\u4ed8\u542b\u7a0e\u91d1\u989d\u8d85\u51fa\u542b\u7a0e\u5408\u540c\u603b\u91d1\u989d\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"OutContractAdditionOp_0", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                        } else if (ContractControlEnum.STRICTCONTROL.getValue().equals(amountControl)) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u64cd\u4f5c\u4f1a\u5bfc\u81f4\u5408\u540c\u7684\u7d2f\u8ba1\u5e94\u4ed8\u542b\u7a0e\u91d1\u989d\u8d85\u51fa\u542b\u7a0e\u5408\u540c\u603b\u91d1\u989d\u3002", (String)"OutContractAdditionOp_1", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                        }
                    }
                }
            }

            private void validateSettleAmount(ExtendedDataEntity dataEntity) {
                DynamicObject contract = dataEntity.getDataEntity().getDynamicObject("contract");
                DynamicObject contractType = contract.getDynamicObject("contracttype");
                if (contractType != null) {
                    BigDecimal originAmount;
                    DynamicObject contType = BusinessDataServiceHelper.loadSingle((Object)contractType.getPkValue(), (String)"pmct_conttype");
                    String amountControl = contType.getString("ammountcontrolsettle");
                    if (ContractControlEnum.NOTCONTROL.getValue().equals(amountControl)) {
                        return;
                    }
                    QFilter contractFilter = new QFilter("contract", "in", contract.getPkValue());
                    QFilter statusFilter = new QFilter("billstatus", "in", (Object)new String[]{StatusEnum.UNCHECKED.getValue(), StatusEnum.CHECKED.getValue()});
                    DynamicObjectCollection amountList = QueryServiceHelper.query((String)"pmct_outcontract_settle", (String)"settleoftaxamount", (QFilter[])new QFilter[]{contractFilter, statusFilter});
                    BigDecimal settleAmount = amountList.stream().map(dyn -> dyn.getBigDecimal("settleoftaxamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                    int compareResult = settleAmount.compareTo(originAmount = dataEntity.getDataEntity().getBigDecimal("srcamountoftax"));
                    if (compareResult > 0) {
                        if (ContractControlEnum.REMINDCONTROL.getValue().equals(amountControl)) {
                            this.addWarningMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u64cd\u4f5c\u4f1a\u5bfc\u81f4\u5408\u540c\u7684\u7d2f\u8ba1\u7ed3\u7b97\u542b\u7a0e\u91d1\u989d\u8d85\u51fa\u542b\u7a0e\u5408\u540c\u603b\u91d1\u989d\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"OutContractAdditionOp_2", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                        } else if (ContractControlEnum.STRICTCONTROL.getValue().equals(amountControl)) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u64cd\u4f5c\u4f1a\u5bfc\u81f4\u5408\u540c\u7684\u7d2f\u8ba1\u7ed3\u7b97\u542b\u7a0e\u91d1\u989d\u8d85\u51fa\u542b\u7a0e\u5408\u540c\u603b\u91d1\u989d\u3002", (String)"OutContractAdditionOp_3", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                        }
                    }
                }
            }

            private void validateContractRealAmount(ExtendedDataEntity[] dataEntities) {
                Set contractIds = Arrays.stream(dataEntities).filter(o -> o.getDataEntity().getDynamicObject("contract") != null).map(o -> o.getDataEntity().getDynamicObject("contract").getPkValue()).collect(Collectors.toSet());
                DynamicObject[] contracts = BusinessDataServiceHelper.load((Object[])contractIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_outcontract"));
                Set contractTypeIds = Arrays.stream(contracts).filter(o -> o.getDynamicObject("contracttype") != null).map(o -> o.getDynamicObject("contracttype").getPkValue()).collect(Collectors.toSet());
                DynamicObject[] contractTypes = BusinessDataServiceHelper.load((Object[])contractTypeIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_conttype"));
                Map<Object, DynamicObject> contractMap = Arrays.stream(contracts).collect(Collectors.toMap(DataEntityBase::getPkValue, o -> o));
                Map<Object, DynamicObject> contractTypeMap = Arrays.stream(contractTypes).collect(Collectors.toMap(DataEntityBase::getPkValue, o -> o));
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    BigDecimal settleAmount;
                    BigDecimal latestAmount;
                    BigDecimal applyAmount;
                    int compareResult;
                    boolean isOpenContract;
                    DynamicObject contract = dataEntity.getDataEntity().getDynamicObject("contract");
                    if (contract == null || !contractMap.containsKey(contract.getPkValue()) || (contract = contractMap.get(contract.getPkValue())) == null || contract.getDynamicObject("contracttype") == null || !contractTypeMap.containsKey(contract.getDynamicObject("contracttype").getPkValue()) || (isOpenContract = contract.getBoolean("openedcontract"))) continue;
                    DynamicObject contType = contractTypeMap.get(contract.getDynamicObject("contracttype").getPkValue());
                    String applyAmountControl = contType.getString("ammountcontrolapply");
                    String settleAmountControl = contType.getString("ammountcontrolsettle");
                    if (!ContractControlEnum.NOTCONTROL.getValue().equals(applyAmountControl) && (compareResult = (applyAmount = contract.getBigDecimal("totalapplyoftaxamount")).compareTo(latestAmount = dataEntity.getDataEntity().getBigDecimal("latestamountoftax"))) > 0) {
                        if (ContractControlEnum.REMINDCONTROL.getValue().equals(applyAmountControl)) {
                            this.addWarningMessage(dataEntity, ResManager.loadKDString((String)"\u6700\u65b0\u5408\u540c\u542b\u7a0e\u603b\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e\u5408\u540c\u7d2f\u8ba1\u4ed8\u6b3e\u7533\u8bf7\u91d1\u989d\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"OutContractAdditionOp_4", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                        } else if (ContractControlEnum.STRICTCONTROL.getValue().equals(applyAmountControl)) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6700\u65b0\u5408\u540c\u542b\u7a0e\u603b\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e\u5408\u540c\u7d2f\u8ba1\u4ed8\u6b3e\u7533\u8bf7\u91d1\u989d\u3002", (String)"OutContractAdditionOp_5", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                        }
                    }
                    if (ContractControlEnum.NOTCONTROL.getValue().equals(settleAmountControl) || (compareResult = (settleAmount = contract.getBigDecimal("totalsettleoftaxamount")).compareTo(latestAmount = dataEntity.getDataEntity().getBigDecimal("latestamountoftax"))) <= 0) continue;
                    if (ContractControlEnum.REMINDCONTROL.getValue().equals(applyAmountControl)) {
                        this.addWarningMessage(dataEntity, ResManager.loadKDString((String)"\u6700\u65b0\u5408\u540c\u542b\u7a0e\u603b\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e\u5408\u540c\u7d2f\u8ba1\u7ed3\u7b97\u91d1\u989d\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"OutContractAdditionOp_6", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    if (!ContractControlEnum.STRICTCONTROL.getValue().equals(applyAmountControl)) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6700\u65b0\u5408\u540c\u542b\u7a0e\u603b\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e\u5408\u540c\u7d2f\u8ba1\u7ed3\u7b97\u91d1\u989d\u3002", (String)"OutContractAdditionOp_7", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                }
            }
        });
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities;
                for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                    String key = this.getOperateKey();
                    if (!StringUtils.equals((CharSequence)"save", (CharSequence)key) && !StringUtils.equals((CharSequence)"submit", (CharSequence)key)) continue;
                    this.validateQtyExtend(dataEntity);
                }
            }

            private void validateQtyExtend(ExtendedDataEntity dataEntity) {
                DynamicObject contractAddition = dataEntity.getDataEntity();
                DynamicObjectCollection cardEntryEntity = contractAddition.getDynamicObjectCollection("cardentry");
                int index = 1;
                for (DynamicObject cardEntryObj : cardEntryEntity) {
                    DynamicObjectCollection entryCollection = cardEntryObj.getDynamicObjectCollection("entryentity");
                    for (int i = 0; i < entryCollection.size(); ++i) {
                        BigDecimal qty;
                        BigDecimal curChangeQty;
                        DynamicObject row = (DynamicObject)entryCollection.get(i);
                        String subChangeType = row.getString("subaddtype");
                        if (!StringUtils.equals((CharSequence)subChangeType, (CharSequence)"0") || NumberHelper.compareValue((Object)(curChangeQty = row.getBigDecimal("changeqty")).add(qty = row.getBigDecimal("qty")), (Object)BigDecimal.ZERO) >= 0) continue;
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u4e2a\u5361\u7247\u6e05\u5355\uff0c\u7b2c%2$s\u884c\uff1a\u201c\u53d8\u66f4\u6570\u91cf\u201d\u4e0d\u80fd\u5c0f\u4e8e\u201c\u6570\u91cf\u201d\u7684\u8d1f\u503c\uff08-%3$s\uff09\u3002", (String)"OutContractAdditionOp_8", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), index, i + 1, qty.toString()));
                    }
                    ++index;
                }
            }
        });
    }
}

