/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.opplugin.agreement;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.common.enums.AgreementSrouceEnum;
import kd.pmgt.pmbs.common.enums.AgreementStatusEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmct.opplugin.base.AbstractPmctOperationServicePlugin;
import kd.pmgt.pmct.opplugin.validator.StrategicAgreementValidator;

public class StrategicAgreementOpPlugin
extends AbstractPmctOperationServicePlugin {
    private static final Log logger = LogFactory.getLog(StrategicAgreementOpPlugin.class);
    private static final String[] fields = new String[]{"pmct_strategicagreement", "billno", "agreementbillfrom", "billstatus", "modifytime", "renew", "agreementvaliddate", "agreementexpiredate", "agreementdelaydate", "agreementstate", "version", "sourcebill", "previousbill", "agreementamount", "verifyvalid", "islatest", "contractdate", "renewstatement", "agreementdelaydate", "agreementoridate", "reneworgscope", "resetadaptescope", "orgchangedstatement", "renewpartbscope", "resetpartbscope", "reneworgscope", "detailpricestatement", "adaptescope", "orgscopeentry", "scopeorg", "partbscope", "partbscopeentry", "supplier", "pricedetailentry", "listnumber", "pricewithtax", "renewpricescope", "isleaf", "isagreementamount", "issign"};

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        Arrays.stream(fields).limit(fields.length).forEach(s -> e.getFieldKeys().add(s));
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new StrategicAgreementValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) throws KDBizException {
        String AgreementStatus;
        Date agreementExpireDate;
        DynamicObject dataEntry;
        int i;
        String operationKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        if ("submit".equals(operationKey)) {
            for (i = 0; i < dataEntities.length; ++i) {
                dataEntry = dataEntities[i];
                boolean reNew = dataEntry.getBoolean("renew");
                String invalidStatement = dataEntry.getString("invalidstatement");
                if (reNew && StringUtils.isBlank((CharSequence)invalidStatement)) {
                    agreementExpireDate = dataEntry.getDate("agreementexpiredate");
                    Date agreementDelayDate = dataEntry.getDate("agreementdelaydate");
                    if (agreementExpireDate != null && null != agreementDelayDate && agreementDelayDate.compareTo(agreementExpireDate) <= 0) {
                        e.setCancelOperation(false);
                        throw new KDBizException(ResManager.loadKDString((String)"\u534f\u8bae\u5ef6\u8fdf\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u539f\u534f\u8bae\u7ed3\u675f\u65e5\u671f\u3002", (String)"StrategicAgreementOpPlugin_2", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                    }
                }
                dataEntry.set("agreementstate", (Object)AgreementStatusEnum.PENDING.getValue());
            }
        }
        if ("unsubmit".equals(operationKey)) {
            for (i = 0; i < dataEntities.length; ++i) {
                dataEntry = dataEntities[i];
                dataEntry.set("agreementstate", (Object)AgreementStatusEnum.DRAFT.getValue());
            }
            SaveServiceHelper.save((DynamicObject[])dataEntities);
        }
        if ("audit".equals(operationKey)) {
            for (i = 0; i < dataEntities.length; ++i) {
                dataEntry = dataEntities[i];
                int verifyValid = dataEntry.getBoolean("verifyvalid");
                Date agreementValidDate = dataEntry.getDate("agreementvaliddate");
                agreementExpireDate = dataEntry.getDate("agreementexpiredate");
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                if (dataEntry.getBoolean("renew")) {
                    Date delayDate;
                    agreementExpireDate = delayDate = dataEntry.getDate("agreementdelaydate");
                    dataEntry.set("agreementexpiredate", (Object)delayDate);
                }
                Date auditDate = dataEntry.getDate("auditdate");
                String agreementBillFrom = dataEntry.getString("agreementbillfrom");
                String billStatus = (String)dataEntry.get("billstatus");
                if (StatusEnum.CHECKED.getValue().equals(billStatus) && verifyValid != 0) {
                    dataEntry.set("issign", (Object)true);
                }
                if (!AgreementSrouceEnum.CANCEL.getValue().equals(agreementBillFrom)) {
                    DynamicObject[] outContracts;
                    BigDecimal version;
                    dataEntry.set("agreementstate", (Object)AgreementStatusEnum.APPROVAL.getValue());
                    boolean isSign = dataEntry.getBoolean("issign");
                    if (Boolean.TRUE.equals(isSign)) {
                        try {
                            agreementValidDate = df.parse(df.format(agreementValidDate));
                            agreementExpireDate = df.parse(df.format(agreementExpireDate));
                            auditDate = df.parse(df.format(auditDate));
                        }
                        catch (ParseException parseException) {
                            logger.error((Throwable)parseException);
                        }
                        if (auditDate != null && auditDate.compareTo(agreementValidDate) < 0) {
                            dataEntry.set("agreementstate", (Object)AgreementStatusEnum.UNEFFECT.getValue());
                        } else if (auditDate != null && auditDate.compareTo(agreementValidDate) >= 0 && auditDate.compareTo(agreementExpireDate) <= 0) {
                            dataEntry.set("agreementstate", (Object)AgreementStatusEnum.EFFECTING.getValue());
                        } else {
                            dataEntry.set("agreementstate", (Object)AgreementStatusEnum.EXPIRE.getValue());
                        }
                    }
                    if (null == (version = (BigDecimal)dataEntry.get("version")) || BigDecimal.ZERO.compareTo(version) == 0) {
                        dataEntry.set("version", (Object)new BigDecimal(1));
                    }
                    dataEntry.set("islatest", (Object)Boolean.TRUE);
                    DynamicObject previousBillF7 = dataEntry.getDynamicObject("previousbill");
                    if (null == previousBillF7) continue;
                    DynamicObject previousBill = BusinessDataServiceHelper.loadSingle((Object)previousBillF7.getPkValue(), (String)"pmct_strategicagreement");
                    previousBill.set("islatest", (Object)Boolean.FALSE);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{previousBill});
                    if (!AgreementSrouceEnum.CHANGED.getValue().equals(agreementBillFrom)) continue;
                    QFilter qFilter = new QFilter("strategicagreement", "=", previousBillF7.getPkValue());
                    for (DynamicObject contract : outContracts = BusinessDataServiceHelper.load((String)"pmct_outcontract", (String)"strategicagreement", (QFilter[])new QFilter[]{qFilter})) {
                        contract.set("strategicagreement", dataEntry.getPkValue());
                    }
                    if (outContracts.length <= 0) continue;
                    SaveServiceHelper.save((DynamicObject[])outContracts);
                    continue;
                }
                dataEntry.set("agreementstate", (Object)AgreementStatusEnum.CANCEL.getValue());
                DynamicObject previousBillF7 = dataEntry.getDynamicObject("previousbill");
                if (null == previousBillF7) continue;
                DynamicObject previousBill = BusinessDataServiceHelper.loadSingle((Object)previousBillF7.getPkValue(), (String)"pmct_strategicagreement");
                previousBill.set("agreementstate", (Object)AgreementStatusEnum.CANCEL.getValue());
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{previousBill});
            }
            SaveServiceHelper.update((DynamicObject[])dataEntities);
        } else if ("unaudit".equals(operationKey)) {
            for (DynamicObject dataEntity : dataEntities) {
                dataEntity.set("agreementstate", (Object)AgreementStatusEnum.DRAFT.getValue());
                dataEntity.set("issign", (Object)false);
                Date agreementSourceDate = dataEntity.getDate("agreementoridate");
                if (agreementSourceDate == null) continue;
                dataEntity.set("agreementexpiredate", (Object)agreementSourceDate);
            }
        } else if ("signup".equals(operationKey)) {
            for (i = 0; i < dataEntities.length; ++i) {
                dataEntry = dataEntities[i];
                String billStatus = (String)dataEntry.get("billstatus");
                AgreementStatus = (String)dataEntry.get("agreementstate");
                Date agreementValidDate = dataEntry.getDate("agreementvaliddate");
                Date agreementExpireDate2 = dataEntry.getDate("agreementexpiredate");
                Date modifyTime = dataEntry.getDate("modifytime");
                if (!StatusEnum.CHECKED.getValue().equals(billStatus) || !AgreementStatusEnum.APPROVAL.getValue().equals(AgreementStatus)) continue;
                if (modifyTime.compareTo(agreementValidDate) >= 0 && modifyTime.compareTo(agreementExpireDate2) <= 0) {
                    dataEntry.set("agreementstate", (Object)AgreementStatusEnum.EFFECTING.getValue());
                } else if (modifyTime.compareTo(agreementValidDate) < 0) {
                    dataEntry.set("agreementstate", (Object)AgreementStatusEnum.UNEFFECT.getValue());
                } else {
                    dataEntry.set("agreementstate", (Object)AgreementStatusEnum.EXPIRE.getValue());
                }
                dataEntry.set("issign", (Object)true);
            }
            SaveServiceHelper.update((DynamicObject[])dataEntities);
        } else if ("unsignup".equals(operationKey)) {
            for (i = 0; i < dataEntities.length; ++i) {
                dataEntry = dataEntities[i];
                String billStatus = (String)dataEntry.get("billstatus");
                AgreementStatus = (String)dataEntry.get("agreementstate");
                Long pkValue = (Long)dataEntry.getPkValue();
                if (this.checkReferenced(pkValue)) {
                    e.setCancelOperation(true);
                    throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u6218\u7565\u534f\u8bae\u5df2\u88ab\u540e\u7eed\u4e1a\u52a1\u5f15\u7528\uff0c\u65e0\u6cd5\u53cd\u7b7e\u8ba2\uff0c\u8bf7\u5220\u9664\u4e0e\u672c\u534f\u8bae\u76f8\u5173\u5355\u636e\u3002", (String)"StrategicAgreementOpPlugin_3", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                }
                if (!AgreementStatusEnum.EFFECTING.getValue().equals(AgreementStatus) && !AgreementStatusEnum.UNEFFECT.getValue().equals(AgreementStatus) && !AgreementStatusEnum.EXPIRE.getValue().equals(AgreementStatus)) continue;
                dataEntry.set("agreementstate", (Object)AgreementStatusEnum.APPROVAL.getValue());
                dataEntry.set("issign", (Object)false);
            }
            SaveServiceHelper.update((DynamicObject[])dataEntities);
        } else if ("invalid".equals(operationKey)) {
            for (i = 0; i < dataEntities.length; ++i) {
                dataEntry = dataEntities[i];
                dataEntry.set("agreementstate", (Object)AgreementStatusEnum.CANCEL.getValue());
            }
            SaveServiceHelper.update((DynamicObject[])dataEntities);
        } else if ("delete".equals(operationKey)) {
            for (i = 0; i < dataEntities.length; ++i) {
                dataEntry = dataEntities[i];
                DynamicObject previousBillF7 = dataEntry.getDynamicObject("previousbill");
                if (null == previousBillF7) continue;
                DynamicObject previousBill = BusinessDataServiceHelper.loadSingle((Object)previousBillF7.getPkValue(), (String)"pmct_strategicagreement");
                previousBill.set("islatest", (Object)Boolean.TRUE);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{previousBill});
            }
            SaveServiceHelper.update((DynamicObject[])dataEntities);
        }
    }

    protected boolean checkReferenced(Long pkValue) {
        DynamicObject[] agreementsOutContract = BusinessDataServiceHelper.load((String)"pmct_outcontract", (String)"strategicagreement", (QFilter[])new QFilter("strategicagreement", "in", (Object)pkValue).toArray());
        return agreementsOutContract.length > 0;
    }
}

