/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.opplugin.apply;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.business.helper.ContractHelper;
import kd.pmgt.pmbs.business.helper.ContractPayItemHelper;
import kd.pmgt.pmbs.common.enums.ContractControlEnum;
import kd.pmgt.pmbs.common.enums.ContractPayTypeEnum;
import kd.pmgt.pmbs.common.enums.InvoiceSellerParamEnum;
import kd.pmgt.pmct.business.helper.InvoiceHelper;

public class ApplyPaymentOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("contract");
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("contractamount");
        e.getFieldKeys().add("curpaytotal");
        e.getFieldKeys().add("totalsettleoftaxamount");
        e.getFieldKeys().add("applypaytotal");
        e.getFieldKeys().add("invoiceentry");
        e.getFieldKeys().add("invoice");
        e.getFieldKeys().add("isupdateinvoice");
        e.getFieldKeys().add("totalapplyoftaxamount");
        e.getFieldKeys().add("totalsettleamt");
        e.getFieldKeys().add("supplier");
        e.getFieldKeys().add("paytype");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String operationKey = e.getOperationKey();
        ArrayList<DynamicObject> contractList = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> invoiceList = new ArrayList<DynamicObject>(10);
        if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"audit")) {
            for (DynamicObject dataEntity : e.getDataEntities()) {
                DynamicObject contract = (DynamicObject)dataEntity.get("contract");
                DynamicObject outContract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_outcontract");
                BigDecimal totalApplyOfTaxAmount = outContract.getBigDecimal("totalapplyoftaxamount");
                BigDecimal curPayTotal = dataEntity.getBigDecimal("curpaytotal");
                outContract.set("totalapplyoftaxamount", (Object)totalApplyOfTaxAmount.add(curPayTotal));
                BigDecimal totalApplyAmount = outContract.getBigDecimal("totalapplyamount");
                BigDecimal applyPayTotal = dataEntity.getBigDecimal("applypaytotal");
                outContract.set("totalapplyamount", (Object)totalApplyAmount.add(applyPayTotal));
                contractList.add(outContract);
                DynamicObjectCollection invoiceEntry = dataEntity.getDynamicObjectCollection("invoiceentry");
                for (DynamicObject invoiceEntryObj : invoiceEntry) {
                    DynamicObject invoiceObj = invoiceEntryObj.getDynamicObject("invoice");
                    if ((invoiceObj = BusinessDataServiceHelper.loadSingle((Object)invoiceObj.getPkValue(), (String)"pmct_ininvoice")) != null && !invoiceObj.getBoolean("isused")) {
                        invoiceObj.set("isused", (Object)true);
                    }
                    invoiceList.add(invoiceObj);
                }
            }
            SaveServiceHelper.save((DynamicObject[])contractList.toArray(new DynamicObject[contractList.size()]));
            SaveServiceHelper.save((DynamicObject[])invoiceList.toArray(new DynamicObject[invoiceList.size()]));
        } else if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"unaudit")) {
            for (DynamicObject dataEntity : e.getDataEntities()) {
                DynamicObject contract = (DynamicObject)dataEntity.get("contract");
                DynamicObject outContract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_outcontract");
                BigDecimal totalApplyOfTaxAmount = outContract.getBigDecimal("totalapplyoftaxamount");
                BigDecimal totalApplyAmount = outContract.getBigDecimal("totalapplyamount");
                BigDecimal curPayTotal = dataEntity.getBigDecimal("curpaytotal");
                BigDecimal applyPayTotal = dataEntity.getBigDecimal("applypaytotal");
                outContract.set("totalapplyoftaxamount", (Object)totalApplyOfTaxAmount.subtract(curPayTotal));
                outContract.set("totalapplyamount", (Object)totalApplyAmount.subtract(applyPayTotal));
                contractList.add(outContract);
                DynamicObjectCollection invoiceEntry = dataEntity.getDynamicObjectCollection("invoiceentry");
                for (DynamicObject invoiceEntryObj : invoiceEntry) {
                    DynamicObject invoiceObj = invoiceEntryObj.getDynamicObject("invoice");
                    if (!InvoiceHelper.checkIsQuoteByCheckApplyPay((DynamicObject)(invoiceObj = BusinessDataServiceHelper.loadSingle((Object)invoiceObj.getPkValue(), (String)"pmct_ininvoice")), (String)dataEntity.getPkValue().toString())) {
                        invoiceObj.set("isused", (Object)false);
                    }
                    invoiceList.add(invoiceObj);
                }
            }
            SaveServiceHelper.save((DynamicObject[])contractList.toArray(new DynamicObject[contractList.size()]));
            SaveServiceHelper.save((DynamicObject[])invoiceList.toArray(new DynamicObject[invoiceList.size()]));
        } else if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"delete")) {
            for (DynamicObject dataEntity : e.getDataEntities()) {
                DynamicObjectCollection invoiceEntry = dataEntity.getDynamicObjectCollection("invoiceentry");
                if (invoiceEntry.isEmpty()) {
                    return;
                }
                BigDecimal invoiceTotalOfTaxAmount = BigDecimal.ZERO;
                BigDecimal invoiceTotalAmount = BigDecimal.ZERO;
                invoiceList = new ArrayList(10);
                for (DynamicObject rowEntity : invoiceEntry) {
                    DynamicObject invoice = rowEntity.getDynamicObject("invoice");
                    String invoiceSourceId = (invoice = BusinessDataServiceHelper.loadSingle((Object)invoice.getPkValue(), (String)"pmct_ininvoice")).getString("invoicesourceid");
                    if (StringUtils.isNotBlank((CharSequence)invoiceSourceId)) {
                        InvoiceHelper.deleteInvoice((DynamicObject)invoice, (String)dataEntity.getPkValue().toString());
                        continue;
                    }
                    boolean isUpdateInvoice = rowEntity.getBoolean("isupdateinvoice");
                    if (isUpdateInvoice) {
                        invoice.set("isclaimed", (Object)Boolean.FALSE);
                        invoice.set("contract", null);
                        invoice.set("project", null);
                        invoice.set("connecttype", (Object)"null");
                        invoiceTotalOfTaxAmount = invoiceTotalOfTaxAmount.add(invoice.getBigDecimal("totaloftaxamount"));
                        invoiceTotalAmount = invoiceTotalAmount.add(invoice.getBigDecimal("totalamount"));
                    }
                    invoiceList.add(invoice);
                }
                DynamicObject contract = dataEntity.getDynamicObject("contract");
                if (contract != null) {
                    contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_outcontract");
                    BigDecimal invoiceTaxAmount = contract.getBigDecimal("totalinvoiceoftaxamount");
                    BigDecimal invoiceAmount = contract.getBigDecimal("totalinvoiceamount");
                    contract.set("totalinvoiceoftaxamount", (Object)invoiceTaxAmount.subtract(invoiceTotalOfTaxAmount));
                    contract.set("totalinvoiceamount", (Object)invoiceAmount.subtract(invoiceTotalAmount));
                    SaveServiceHelper.update((DynamicObject)contract);
                }
                SaveServiceHelper.save((DynamicObject[])invoiceList.toArray(new DynamicObject[invoiceList.size()]));
            }
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        String operationKey = e.getOperationKey();
        if ("submit".equals(operationKey) || "unsubmit".equals(operationKey) || "audit".equals(operationKey) || "unaudit".equals(operationKey)) {
            DynamicObject[] dataEntities;
            for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
                DynamicObject payApplyObj = BusinessDataServiceHelper.loadSingle((Object)dataEntity.getPkValue(), (String)"pmct_applymentpay");
                DynamicObjectCollection entryColl = payApplyObj.getDynamicObjectCollection("paydetailentry");
                List<DynamicObject> entries = entryColl.stream().filter(entry -> null != entry.get("payitem")).collect(Collectors.toList());
                ContractPayItemHelper.doUpdate((DynamicObject)payApplyObj, (DynamicObject[])entries.toArray(new DynamicObject[0]), (String)operationKey);
            }
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities;
                String key = this.getOperateKey();
                if (StringUtils.equals((CharSequence)key, (CharSequence)"submit") && (dataEntities = this.getDataEntities()) != null && dataEntities.length > 0) {
                    for (ExtendedDataEntity dataEntity : dataEntities) {
                        DynamicObject bill = dataEntity.getDataEntity();
                        DynamicObject org = bill.getDynamicObject("org");
                        if (org == null) {
                            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u4e1a\u52a1\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ApplyPaymentOp_13", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                            return;
                        }
                        boolean projectCostControl = this.isProjectCostControl(bill);
                        if (projectCostControl) {
                            DynamicObjectCollection entryEntity = bill.getDynamicObjectCollection("splitentry");
                            BigDecimal curSplitTotalAmount = BigDecimal.ZERO;
                            for (DynamicObject entry : entryEntity) {
                                BigDecimal curSplitAmount = entry.getBigDecimal("cursplitamt");
                                if (curSplitAmount.compareTo(BigDecimal.ZERO) == 0) continue;
                                curSplitTotalAmount = curSplitTotalAmount.add(curSplitAmount);
                            }
                            BigDecimal curPayTotal = bill.getBigDecimal("curpaytotal");
                            if (curPayTotal.compareTo(curSplitTotalAmount) != 0) {
                                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff0c\u201c\u4ed8\u6b3e\u7533\u8bf7\u5206\u644a\u201d\u7684\u201c\u672c\u6b21\u4ed8\u6b3e\u7533\u8bf7\u5206\u644a\u91d1\u989d\u201d\u603b\u8ba1\u5e94\u7b49\u4e8e\u672c\u5355\u201c\u672c\u6b21\u4ed8\u6b3e\u91d1\u989d\u603b\u989d(\u542b\u7a0e)\u201d\u3002", (String)"ApplyPaymentOp_14", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                                return;
                            }
                        }
                        if (this.contTypeControlValidate(dataEntity, bill)) {
                            return;
                        }
                        DynamicObject supplier = bill.getDynamicObject("supplier");
                        DynamicObjectCollection invoices = bill.getDynamicObjectCollection("invoiceentry");
                        if (supplier == null || invoices.isEmpty()) continue;
                        List<Long> suppliers = Collections.singletonList(Long.parseLong(supplier.getPkValue().toString()));
                        String invoiceSellerParam = ContractHelper.getInvoiceSellerParam();
                        if (!InvoiceSellerParamEnum.REMINDCTRL.getValue().equals(invoiceSellerParam) && !InvoiceSellerParamEnum.STRICTCTRL.getValue().equals(invoiceSellerParam)) continue;
                        String errorTip = InvoiceHelper.checkConSupplier(suppliers, (DynamicObject)org);
                        if (StringUtils.isNotBlank((CharSequence)errorTip)) {
                            this.addMessage(dataEntity, errorTip);
                            return;
                        }
                        errorTip = InvoiceHelper.checkInvoiceSeller((Long)suppliers.get(0), (DynamicObjectCollection)invoices, (Long)Long.parseLong(org.getPkValue().toString()));
                        if (!StringUtils.isNotBlank((CharSequence)errorTip)) continue;
                        if (InvoiceSellerParamEnum.STRICTCTRL.getValue().equals(invoiceSellerParam)) {
                            this.addMessage(dataEntity, errorTip);
                            return;
                        }
                        if (!InvoiceSellerParamEnum.REMINDCTRL.getValue().equals(invoiceSellerParam)) continue;
                        this.addWarningMessage(dataEntity, errorTip);
                    }
                }
            }

            private boolean isProjectCostControl(DynamicObject bill) {
                DynamicObject[] proApps;
                DynamicObject project = bill.getDynamicObject("project");
                DynamicObject contract = bill.getDynamicObject("contract");
                contract = BusinessDataServiceHelper.loadSingle((String)"pmct_outcontract", (String)"multipartsettlement", (QFilter[])new QFilter[]{new QFilter("id", "=", contract.getPkValue())});
                DynamicObjectCollection entryEntity = bill.getDynamicObjectCollection("splitentry");
                if (entryEntity.isEmpty()) {
                    return false;
                }
                boolean multipartSettlement = contract.getBoolean("multipartsettlement");
                if (multipartSettlement) {
                    if (project != null) {
                        DynamicObject[] proApps2 = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"projectcostcontrol", (QFilter[])new QFilter[]{new QFilter("pro", "=", project.getPkValue())});
                        if (proApps2 != null && proApps2.length > 0 && proApps2[0].getBoolean("projectcostcontrol")) {
                            return true;
                        }
                    } else {
                        DynamicObject[] proApps3;
                        HashSet<Object> proIdSet = new HashSet<Object>();
                        for (DynamicObject entry : entryEntity) {
                            DynamicObject budgetItem = entry.getDynamicObject("bugdetitem");
                            DynamicObject budgetProject = budgetItem.getDynamicObject("project");
                            proIdSet.add(budgetProject.getPkValue());
                        }
                        for (DynamicObject proApp : proApps3 = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"projectcostcontrol", (QFilter[])new QFilter[]{new QFilter("pro", "in", proIdSet)})) {
                            boolean projectCostControl = proApp.getBoolean("projectcostcontrol");
                            if (!projectCostControl) continue;
                            return true;
                        }
                    }
                } else if (project != null && (proApps = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"projectcostcontrol", (QFilter[])new QFilter[]{new QFilter("pro", "=", project.getPkValue())})) != null && proApps.length > 0 && proApps[0].getBoolean("projectcostcontrol")) {
                    return true;
                }
                return false;
            }

            private boolean contTypeControlValidate(ExtendedDataEntity dataEntity, DynamicObject bill) {
                int compare;
                QFilter filter;
                DynamicObject contract = bill.getDynamicObject("contract");
                Long contractID = (Long)contract.get("id");
                DynamicObject contractType = contract.getDynamicObject("contracttype");
                contractType = BusinessDataServiceHelper.loadSingle((Object)contractType.getPkValue(), (String)"pmct_conttype");
                String settleControlApplyParam = contractType.getString("settlecontrolapply");
                String amountControlApplyParam = contractType.getString("ammountcontrolapply");
                if (!ContractControlEnum.NOTCONTROL.getValue().equals(settleControlApplyParam) || !ContractControlEnum.NOTCONTROL.getValue().equals(amountControlApplyParam)) {
                    QFilter payFilter;
                    DynamicObject[] payments;
                    filter = new QFilter("billstatus", "=", (Object)"B");
                    filter.and(new QFilter("contract.id", "=", (Object)contractID)).and("id", "not in", bill.getPkValue());
                    DynamicObject[] applyS = BusinessDataServiceHelper.load((String)"pmct_applymentpay", (String)"billno", (QFilter[])new QFilter[]{filter});
                    boolean flag = false;
                    if (applyS != null && applyS.length > 0) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff0c\u8be5\u5408\u540c\u5df2\u6709\u672a\u5ba1\u6838\u7684\u4ed8\u6b3e\u7533\u8bf7\u5355(\u5355\u5408\u540c)\uff0c\u8bf7\u5148\u5ba1\u6838%s\u5355\u636e\u3002", (String)"ApplyPaymentOp_7", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), applyS[0].getString("billno")));
                        flag = true;
                    }
                    if ((payments = BusinessDataServiceHelper.load((String)"pmct_paymentapply", (String)"billno", (QFilter[])new QFilter[]{payFilter = new QFilter("billstatus", "=", (Object)"B")})) != null && payments.length > 0) {
                        block0: for (DynamicObject payment : payments) {
                            DynamicObjectCollection contractEntry = (payment = BusinessDataServiceHelper.loadSingle((Object)payment.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_paymentapply"))).getDynamicObjectCollection("entryentity");
                            if (contractEntry == null || contractEntry.size() <= 0) continue;
                            for (DynamicObject object : contractEntry) {
                                DynamicObject entryContract = object.getDynamicObject("entrycontract");
                                if (!contract.getPkValue().equals(entryContract.getPkValue())) continue;
                                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff0c\u8be5\u5408\u540c\u5df2\u6709\u672a\u5ba1\u6838\u7684\u4ed8\u6b3e\u7533\u8bf7\u5355\uff0c\u8bf7\u5148\u5ba1\u6838%s\u5355\u636e\u3002", (String)"ApplyPaymentOp_8", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), payment.getString("billno")));
                                flag = true;
                                continue block0;
                            }
                        }
                    }
                    if (flag) {
                        return true;
                    }
                }
                filter = new QFilter("billstatus", "=", (Object)"C");
                filter.and(new QFilter("contract.id", "=", (Object)contractID));
                DynamicObject[] finalAudited = BusinessDataServiceHelper.load((String)"pmct_outfinalsettle", (String)"apptaxamount", (QFilter[])new QFilter[]{filter});
                if (finalAudited.length > 0) {
                    if (ContractControlEnum.REMINDCONTROL.getValue().equals(settleControlApplyParam)) {
                        compare = ApplyPaymentOp.this.finalSettleCompare(bill, finalAudited[0]);
                        if (compare < 0) {
                            this.addWarningMessage(dataEntity, ResManager.loadKDString((String)"\u7d2f\u8ba1\u7533\u8bf7\u91d1\u989d\u5df2\u8d85\u8fc7\u5408\u540c\u51b3\u7b97\u91d1\u989d\u3002", (String)"ApplyPaymentOp_10", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                        }
                    } else if (ContractControlEnum.STRICTCONTROL.getValue().equals(settleControlApplyParam) && (compare = ApplyPaymentOp.this.finalSettleCompare(bill, finalAudited[0])) < 0) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u7d2f\u8ba1\u7533\u8bf7\u91d1\u989d\u5df2\u8d85\u8fc7\u5408\u540c\u51b3\u7b97\u91d1\u989d\u3002", (String)"ApplyPaymentOp_10", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                    }
                } else if (ContractControlEnum.REMINDCONTROL.getValue().equals(settleControlApplyParam)) {
                    compare = ApplyPaymentOp.this.settleCompare(bill);
                    if (compare < 0) {
                        this.addWarningMessage(dataEntity, ResManager.loadKDString((String)"\u7d2f\u8ba1\u7533\u8bf7\u91d1\u989d\u5df2\u8d85\u8fc7\u7d2f\u8ba1\u7ed3\u7b97\u91d1\u989d\u3002", (String)"ApplyPaymentOp_11", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                    }
                } else if (ContractControlEnum.STRICTCONTROL.getValue().equals(settleControlApplyParam) && (compare = ApplyPaymentOp.this.settleCompare(bill)) < 0) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u7d2f\u8ba1\u7533\u8bf7\u91d1\u989d\u5df2\u8d85\u8fc7\u7d2f\u8ba1\u7ed3\u7b97\u91d1\u989d\u3002", (String)"ApplyPaymentOp_11", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                }
                if (ContractControlEnum.REMINDCONTROL.getValue().equals(amountControlApplyParam)) {
                    compare = ApplyPaymentOp.this.amountCompare(bill);
                    if (compare < 0) {
                        this.addWarningMessage(dataEntity, ResManager.loadKDString((String)"\u7d2f\u8ba1\u7533\u8bf7\u91d1\u989d\u5df2\u8d85\u8fc7\u5408\u540c\u603b\u91d1\u989d\u3002", (String)"ApplyPaymentOp_12", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                    }
                } else if (ContractControlEnum.STRICTCONTROL.getValue().equals(amountControlApplyParam) && (compare = ApplyPaymentOp.this.amountCompare(bill)) < 0) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u7d2f\u8ba1\u7533\u8bf7\u91d1\u989d\u5df2\u8d85\u8fc7\u5408\u540c\u603b\u91d1\u989d\u3002", (String)"ApplyPaymentOp_12", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                }
                return false;
            }
        });
    }

    private int finalSettleCompare(DynamicObject bill, DynamicObject finalSettle) {
        BigDecimal appTaxAmount = finalSettle.getBigDecimal("apptaxamount");
        BigDecimal curPayTotal = bill.getBigDecimal("curpaytotal");
        BigDecimal totalApplyOfTaxAmount = bill.getBigDecimal("totalapplyoftaxamount");
        return appTaxAmount.compareTo(curPayTotal.add(totalApplyOfTaxAmount));
    }

    protected int amountCompare(DynamicObject bill) {
        BigDecimal contractAmount = bill.getBigDecimal("contractamount");
        BigDecimal curPayTotal = bill.getBigDecimal("curpaytotal");
        BigDecimal totalApplyOfTaxAmount = bill.getBigDecimal("totalapplyoftaxamount");
        int compare = contractAmount.compareTo(curPayTotal.add(totalApplyOfTaxAmount));
        return compare;
    }

    protected int settleCompare(DynamicObject bill) {
        BigDecimal totalSettleOfTaxAmount = bill.getBigDecimal("totalsettleamt");
        BigDecimal curPayTotal = BigDecimal.ZERO;
        DynamicObjectCollection payDetailEntry = bill.getDynamicObjectCollection("paydetailentry");
        for (DynamicObject payDetail : payDetailEntry) {
            if (ContractPayTypeEnum.PREPAYMENT.getValue().equals(payDetail.getString("paytype"))) continue;
            curPayTotal = curPayTotal.add(payDetail.getBigDecimal("curpayamtoftax"));
        }
        BigDecimal totalApplyOfTaxAmount = bill.getDynamicObject("contract").getBigDecimal("totalapplyoftaxamount");
        int compare = totalSettleOfTaxAmount.compareTo(curPayTotal.add(totalApplyOfTaxAmount));
        return compare;
    }
}

