/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.opplugin.contclaim;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.business.helper.ProBudgetControlHelper;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;
import kd.pmgt.pmbs.common.enums.PerformAmountTypeEnum;
import kd.pmgt.pmbs.common.utils.CurrencyHelper;
import kd.pmgt.pmbs.common.utils.TypeUtils;
import kd.pmgt.pmbs.common.utils.budget.BudgetValidateAndUpdateHelper;
import kd.pmgt.pmbs.common.utils.budget.BudgetValidateInfo;
import kd.pmgt.pmct.business.helper.ContractRelationBillValidateHelper;
import kd.pmgt.pmct.business.model.ContractValidateResult;

public class ContractClaimValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities;
        String key = this.getOperateKey();
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            DynamicObject contract = dataEntity.getDataEntity().getDynamicObject("contract");
            if (contract == null) continue;
            String payDirection = dataEntity.getDataEntity().getString("paydirection");
            if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"submit")) {
                this.validateListing(dataEntity);
                String visible = (String)this.getOption().getVariables().get("visible");
                if (PayDirectionEnum.OUT.getValue().equals(payDirection)) {
                    this.validBudget(dataEntity, key);
                    this.checkContractPayItem(dataEntity);
                    continue;
                }
                if (!Boolean.TRUE.toString().equals(visible)) continue;
                this.validateIncomePlan(dataEntity);
                continue;
            }
            if (!StringUtils.equals((CharSequence)key, (CharSequence)"unsubmit") && !StringUtils.equals((CharSequence)key, (CharSequence)"audit") && !StringUtils.equals((CharSequence)key, (CharSequence)"unaudit") || !PayDirectionEnum.OUT.getValue().equals(payDirection)) continue;
            this.validBudget(dataEntity, key);
        }
    }

    protected void validateIncomePlan(ExtendedDataEntity dataEntity) {
        DynamicObject inContractClaim = dataEntity.getDataEntity();
        DynamicObjectCollection incomePlanEntry = inContractClaim.getDynamicObjectCollection("claimincomeplanentry");
        boolean isNeedSettle = inContractClaim.getBoolean("isneedsettle");
        if (!incomePlanEntry.isEmpty() && isNeedSettle) {
            BigDecimal afterOfTaxAmount;
            ContractValidateResult result;
            boolean openedContract;
            DynamicObject contract = inContractClaim.getDynamicObject("contract");
            boolean bl = openedContract = null != contract.getDynamicObjectType().getProperty("openedcontract") ? contract.getBoolean("openedcontract") : Boolean.FALSE.booleanValue();
            if (!openedContract && (result = ContractRelationBillValidateHelper.checkOriginalOfTaxAmount((BigDecimal)(afterOfTaxAmount = (BigDecimal)dataEntity.getValue("afteroftaxamount")), (DynamicObjectCollection)incomePlanEntry, (String)PayDirectionEnum.IN.getValue())).error()) {
                this.addErrorMessage(dataEntity, result.getMsg());
                return;
            }
            result = ContractRelationBillValidateHelper.checkCollectAmount((DynamicObjectCollection)incomePlanEntry);
            if (result.error()) {
                this.addWarningMessage(dataEntity, result.getMsg().substring(0, result.getMsg().length() - 1));
            }
        }
    }

    protected void validatePayPlan(ExtendedDataEntity dataEntity) {
    }

    private void validBudget(ExtendedDataEntity dataEntity, String key) {
        DynamicObject claimBill = dataEntity.getDataEntity();
        DynamicObject contract = claimBill.getDynamicObject("contract");
        DynamicObject project = contract.getDynamicObject("project");
        contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_outcontract");
        boolean isOpenedContract = contract.getBoolean("openedcontract");
        boolean multiPartSettlement = contract.getBoolean("multipartsettlement");
        if (project != null && !isOpenedContract && !multiPartSettlement) {
            String payDirection = dataEntity.getDataEntity().getString("paydirection");
            boolean isNew = ProBudgetControlHelper.checkIsNewProBudgetCtrl((Long)((Long)project.getPkValue()));
            if (isNew && PayDirectionEnum.OUT.getValue().equals(payDirection)) {
                return;
            }
            DynamicObject[] proApp = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"projectcostcontrol,org,currencyfield", (QFilter[])new QFilter[]{new QFilter("pro", "=", project.getPkValue())});
            if (proApp != null && proApp.length > 0 && proApp[0].getBoolean("projectcostcontrol")) {
                Map<String, BigDecimal> budgetAmountMap = this.buildBudgetAmountMap(claimBill, this.getExchangeRate(claimBill, proApp[0]));
                BudgetValidateInfo validateInfo = null;
                if (StringUtils.equals((CharSequence)"submit", (CharSequence)key)) {
                    validateInfo = BudgetValidateAndUpdateHelper.validateBudgetAmountOnSubmit(budgetAmountMap, (String)contract.getPkValue().toString(), (PerformAmountTypeEnum)PerformAmountTypeEnum.CONTRACT);
                } else if (StringUtils.equals((CharSequence)"unsubmit", (CharSequence)key)) {
                    validateInfo = BudgetValidateAndUpdateHelper.validateBudgetAmountOnUnSubmit(budgetAmountMap, (String)contract.getPkValue().toString(), (PerformAmountTypeEnum)PerformAmountTypeEnum.CONTRACT);
                } else if (StringUtils.equals((CharSequence)"audit", (CharSequence)key)) {
                    validateInfo = BudgetValidateAndUpdateHelper.validateBudgetAmountOnAuditAndUnaudit(budgetAmountMap, (String)contract.getPkValue().toString(), (long)claimBill.getLong("id"), (String)"pmct_outclaimbill", (PerformAmountTypeEnum)PerformAmountTypeEnum.CONTRACT, (boolean)false);
                } else if (StringUtils.equals((CharSequence)"unaudit", (CharSequence)key)) {
                    validateInfo = BudgetValidateAndUpdateHelper.validateBudgetAmountOnAuditAndUnaudit(budgetAmountMap, (String)contract.getPkValue().toString(), (long)claimBill.getLong("id"), (String)"pmct_outclaimbill", (PerformAmountTypeEnum)PerformAmountTypeEnum.CONTRACT, (boolean)true);
                }
                this.analysisValidateInfo(dataEntity, validateInfo, proApp[0].getDynamicObject("currencyfield"));
            }
        }
    }

    protected void analysisValidateInfo(ExtendedDataEntity dataEntity, BudgetValidateInfo validateInfo, DynamicObject currency) {
        if (validateInfo != null) {
            boolean outOfControl = validateInfo.isOutOfControl();
            boolean outOfRemind = validateInfo.isOutOfRemind();
            Map resultMap = validateInfo.getResultMap();
            if (resultMap != null && !resultMap.isEmpty()) {
                int amtPrecision = 2;
                if (currency != null) {
                    amtPrecision = currency.getInt("amtprecision");
                }
                for (Map.Entry resultEntry : resultMap.entrySet()) {
                    DynamicObject originalBudget = (DynamicObject)resultEntry.getKey();
                    DynamicObject validateBudget = (DynamicObject)resultEntry.getValue();
                    if (originalBudget.getPkValue().equals(validateBudget.getPkValue())) {
                        if (outOfControl) {
                            this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9884\u7b97\u9879\u201c%s\u201d\u7684\u7d2f\u8ba1\u91d1\u989d\u5df2\u7ecf\u8d85\u51fa\u63a7\u5236\u9650\u989d\u3002", (String)"ContractClaimValidator_36", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), originalBudget.getString("name")));
                            continue;
                        }
                        if (!outOfRemind) continue;
                        this.addWarningMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9884\u7b97\u9879\u201c%1$s\u201d\u7684\u7d2f\u8ba1\u91d1\u989d\u5df2\u7ecf\u8fbe\u5230%2$s\uff0c\u9884\u7b97\u91d1\u989d\u662f%3$s\u3002", (String)"ContractClaimValidator_37", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), originalBudget.getString("name"), originalBudget.getBigDecimal("occupyamt").setScale(amtPrecision, RoundingMode.DOWN).toString(), originalBudget.getBigDecimal("budgetamount").setScale(amtPrecision, RoundingMode.DOWN).toString()));
                        continue;
                    }
                    if (outOfControl) {
                        this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9884\u7b97\u9879\u201c%1$s\u201d\u7684\u4e0a\u7ea7\u9884\u7b97\u9879\u201c%2$s\u201d\u7684\u7d2f\u8ba1\u91d1\u989d\u5df2\u7ecf\u8d85\u51fa\u63a7\u5236\u9650\u989d\u3002", (String)"ContractClaimValidator_38", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), originalBudget.getString("name"), validateBudget.getString("name")));
                        continue;
                    }
                    if (!outOfRemind) continue;
                    this.addWarningMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9884\u7b97\u9879\u201c%1$s\u201d\u7684\u4e0a\u7ea7\u9884\u7b97\u9879\u201c%2$s\u201d\u7684\u7d2f\u8ba1\u91d1\u989d\u5df2\u7ecf\u8fbe\u5230%3$s\uff0c\u9884\u7b97\u91d1\u989d\u662f%4$s\u3002", (String)"ContractClaimValidator_39", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), originalBudget.getString("name"), validateBudget.getString("name"), validateBudget.getBigDecimal("occupyamt").setScale(amtPrecision, RoundingMode.DOWN).toString(), validateBudget.getBigDecimal("budgetamount").setScale(amtPrecision, RoundingMode.DOWN).toString()));
                }
            }
        }
    }

    protected BigDecimal getExchangeRate(DynamicObject bill, DynamicObject project) {
        DynamicObject exRateTable;
        DynamicObject org = project.getDynamicObject("org");
        DynamicObject proCurrency = project.getDynamicObject("currencyfield");
        DynamicObject contractCurrency = bill.getDynamicObject("currency");
        DynamicObject stdCurrency = bill.getDynamicObject("stdcurrency");
        if (proCurrency != null && contractCurrency != null && proCurrency.getPkValue().equals(contractCurrency.getPkValue())) {
            return BigDecimal.ONE;
        }
        if (proCurrency != null && stdCurrency != null && proCurrency.getPkValue().equals(stdCurrency.getPkValue())) {
            return bill.getBigDecimal("exchangerate");
        }
        BigDecimal exchangeRate = BigDecimal.ONE;
        if (org != null && proCurrency != null && contractCurrency != null && (exRateTable = CurrencyHelper.getExRateTable((Long)org.getLong("id"))) != null) {
            exchangeRate = CurrencyHelper.getExChangeRate((Long)contractCurrency.getLong("id"), (Long)proCurrency.getLong("id"), (Long)exRateTable.getLong("id"), (Date)bill.getDate("createtime"));
        }
        return exchangeRate;
    }

    protected Map<String, BigDecimal> buildBudgetAmountMap(DynamicObject bill, BigDecimal exchangeRate) {
        HashMap<String, BigDecimal> budgetAmountMap = new HashMap<String, BigDecimal>();
        boolean isOnList = bill.getDynamicObject("contract").getBoolean("isonlist");
        boolean isNeedSettle = bill.getBoolean("isneedsettle");
        if (isOnList && isNeedSettle) {
            DynamicObjectCollection listModelEntries = bill.getDynamicObjectCollection("kapianentry");
            for (DynamicObject listModelEntry : listModelEntries) {
                DynamicObjectCollection listEntry = listModelEntry.getDynamicObjectCollection("entryentity");
                String cmpType = listModelEntry.getString("cmptype");
                BigDecimal coefficient = BigDecimal.ONE;
                if ("(0)".equals(cmpType)) continue;
                if ("(-)".equals(cmpType)) {
                    coefficient = BigDecimal.valueOf(-1L);
                }
                for (DynamicObject list : listEntry) {
                    BigDecimal amount;
                    DynamicObject budget = list.getDynamicObject("listingbudgetitem");
                    String changeType = list.getString("subclaimtype");
                    if (budget != null && (StringUtils.equals((CharSequence)"0", (CharSequence)changeType) || StringUtils.equals((CharSequence)"1", (CharSequence)changeType))) {
                        amount = list.getBigDecimal("thisafteroftaxamount").multiply(coefficient);
                        if (amount == null || amount.compareTo(BigDecimal.ZERO) == 0) continue;
                        this.addBudgetAmount(exchangeRate, budgetAmountMap, budget, amount);
                        continue;
                    }
                    if (budget == null || !StringUtils.equals((CharSequence)"2", (CharSequence)changeType) || (amount = list.getBigDecimal("oftax").multiply(coefficient)) == null || amount.compareTo(BigDecimal.ZERO) == 0) continue;
                    this.addBudgetAmount(exchangeRate, budgetAmountMap, budget, amount);
                }
            }
        } else {
            DynamicObject budget = bill.getDynamicObject("budgetitem");
            BigDecimal amount = bill.getBigDecimal("claimoftaxamount");
            if (budget != null && amount != null && amount.compareTo(BigDecimal.ZERO) != 0) {
                this.addBudgetAmount(exchangeRate, budgetAmountMap, budget, amount);
            }
        }
        return budgetAmountMap;
    }

    protected void addBudgetAmount(BigDecimal exchangeRate, Map<String, BigDecimal> budgetAmountMap, DynamicObject budget, BigDecimal amount) {
        BigDecimal budgetAmount = budgetAmountMap.get(budget.getPkValue().toString());
        if (budgetAmount == null) {
            budgetAmount = BigDecimal.ZERO;
        }
        budgetAmountMap.put(budget.getPkValue().toString(), budgetAmount.add(amount.multiply(exchangeRate)));
    }

    private void validateListing(ExtendedDataEntity dataEntity) {
        DynamicObject contractAddition = dataEntity.getDataEntity();
        int index = 1;
        DynamicObjectCollection cardEntryEntity = contractAddition.getDynamicObjectCollection("kapianentry");
        for (DynamicObject cardEntryObj : cardEntryEntity) {
            int subchangetype;
            int i;
            DynamicObjectCollection entryCollection = cardEntryObj.getDynamicObjectCollection("entryentity");
            HashSet<Long> superListingIds = new HashSet<Long>(16);
            for (i = 0; i < entryCollection.size(); ++i) {
                DynamicObject listingEntryObj = (DynamicObject)entryCollection.get(i);
                subchangetype = TypeUtils.nullToInt((Object)listingEntryObj.get("subclaimtype"));
                if (subchangetype != 2 && subchangetype != 3) continue;
                long superListingId = listingEntryObj.getLong("superlistingid");
                superListingIds.add(superListingId);
            }
            for (i = 0; i < entryCollection.size(); ++i) {
                long listingId;
                DynamicObject dynamicObject2 = (DynamicObject)entryCollection.get(i);
                subchangetype = TypeUtils.nullToInt((Object)dynamicObject2.get("subclaimtype"));
                if (subchangetype != 3 || superListingIds.contains(listingId = dynamicObject2.getLong("newlistingid"))) continue;
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u6e05\u5355\u7b2c%1$s\u4e2a\u5361\u7247\uff0c\u7b2c%2$s\u884c\u4e3a\u975e\u660e\u7ec6\u6e05\u5355\u8282\u70b9\uff0c\u9700\u8981\u5efa\u7acb\u4e0b\u7ea7\u660e\u7ec6\u8282\u70b9\u3002", (String)"ContractClaimValidator_9", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), index, i + 1));
            }
            ++index;
        }
    }

    private void checkContractPayItem(ExtendedDataEntity dataEntity) {
        DynamicObject curDataEntity = dataEntity.getDataEntity();
        DynamicObject contract = curDataEntity.getDynamicObject("contract");
        contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_outcontract");
        boolean isOpenedContract = contract.getBoolean("openedcontract");
        DynamicObjectCollection changePayPlanEntry = curDataEntity.getDynamicObjectCollection("claimpayplanentry");
        if (!changePayPlanEntry.isEmpty()) {
            ContractValidateResult result;
            BigDecimal latestAmountOfTax = (BigDecimal)dataEntity.getValue("afteroftaxamount");
            if (!isOpenedContract && (result = ContractRelationBillValidateHelper.checkOriginalOfTaxAmount((BigDecimal)latestAmountOfTax, (DynamicObjectCollection)changePayPlanEntry, (String)PayDirectionEnum.OUT.getValue())).error()) {
                this.addErrorMessage(dataEntity, result.getMsg());
                return;
            }
            result = ContractRelationBillValidateHelper.checkPayAmount((DynamicObjectCollection)changePayPlanEntry);
            if (result.error()) {
                this.addErrorMessage(dataEntity, result.getMsg());
            }
        }
    }
}

