/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.opplugin.contpref;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.pmgt.pmbs.business.helper.ContractCollectItemHelper;
import kd.pmgt.pmbs.business.helper.ContractPayItemHelper;
import kd.pmgt.pmbs.common.enums.PayPlanSourceEnum;
import kd.pmgt.pmct.opplugin.AbstractReverseWritingPmctContractOp;

public class ContractPerformOp
extends AbstractReverseWritingPmctContractOp {
    private static final String PERFORMANCEISSUE = "PERFORMANCEISSUE";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("contract");
        e.getFieldKeys().add("name");
        e.getFieldKeys().add("entryentity");
        e.getFieldKeys().add("amount");
        e.getFieldKeys().add("isclaim");
        e.getFieldKeys().add("issettle");
        e.getFieldKeys().add("paydirection");
        e.getFieldKeys().add("createtime");
        e.getFieldKeys().add("creator");
        e.getFieldKeys().add("modifier");
        e.getFieldKeys().add("modifytime");
        e.getFieldKeys().add("modifytime");
        e.getFieldKeys().add("isneedsettle");
        e.getFieldKeys().add("contpayitem");
        e.getFieldKeys().add("budgetitem");
        e.getFieldKeys().add("entryentity.seq");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                String operateKey = this.getOperateKey();
                if (StringUtils.equals((CharSequence)"unaudit", (CharSequence)operateKey)) {
                    for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
                        QFilter reimbursedFilter;
                        QFilter performFilter;
                        DynamicObject contractPerform = extendedDataEntity.getDataEntity();
                        String formId = contractPerform.getDataEntityType().getName();
                        ArrayList<Long> performId = new ArrayList<Long>(10);
                        DynamicObjectCollection performEntry = contractPerform.getDynamicObjectCollection("entryentity");
                        if (performEntry == null || performEntry.size() <= 0) continue;
                        for (DynamicObject perform : performEntry) {
                            BigDecimal amount = perform.getBigDecimal("amount");
                            if (amount.compareTo(BigDecimal.ZERO) == 0) continue;
                            performId.add(Long.valueOf(perform.getPkValue().toString()));
                        }
                        DynamicObject contract = contractPerform.getDynamicObject("contract");
                        QFilter contractFilter = new QFilter("contract.id", "=", contract.getPkValue());
                        if (StringUtils.equals((CharSequence)"pmct_outperformrecords", (CharSequence)formId)) {
                            performFilter = new QFilter("performentryid", "in", (Object)performId.toArray());
                            reimbursedFilter = new QFilter("reimbursedcomamt", "!=", (Object)BigDecimal.ZERO).or("paidcomamt", "!=", (Object)BigDecimal.ZERO);
                            DynamicObject[] contractPayItems = BusinessDataServiceHelper.load((String)"pmbs_contractpayitem", (String)String.join((CharSequence)",", "performentryid", "reimbursedcomamt", "paidcomamt"), (QFilter[])new QFilter[]{performFilter, contractFilter, reimbursedFilter});
                            int flag = 1;
                            HashSet<Integer> paidIndex = new HashSet<Integer>(16);
                            HashSet<Integer> reimbursedIndex = new HashSet<Integer>(16);
                            if (contractPayItems != null && contractPayItems.length > 0) {
                                for (DynamicObject perform : performEntry) {
                                    DynamicObject[] dynamicObjectArray = contractPayItems;
                                    int n = dynamicObjectArray.length;
                                    for (int i = 0; i < n; ++i) {
                                        DynamicObject contractPayItem = dynamicObjectArray[i];
                                        if (perform == null || contractPayItem.get("performentryid") == null || !perform.getPkValue().equals(contractPayItem.get("performentryid"))) continue;
                                        if (BigDecimal.ZERO.compareTo(contractPayItem.getBigDecimal("reimbursedcomamt")) != 0) {
                                            reimbursedIndex.add(flag);
                                        }
                                        if (BigDecimal.ZERO.compareTo(contractPayItem.getBigDecimal("paidcomamt")) == 0) break;
                                        paidIndex.add(flag);
                                        break;
                                    }
                                    ++flag;
                                }
                            }
                            if (reimbursedIndex.size() > 0) {
                                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u5931\u8d25\uff0c\u7b2c%s\u884c\u4e8b\u52a1\u8bb0\u5f55\u5df2\u7ecf\u53d1\u751f\u62a5\u9500\u3002", (String)"ContractPerformOp_1", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), Arrays.toString(reimbursedIndex.toArray()).replace('[', ' ').replace(']', ' ')));
                            }
                            if (paidIndex.size() <= 0) continue;
                            this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u5931\u8d25\uff0c\u7b2c%s\u884c\u4e8b\u52a1\u8bb0\u5f55\u5df2\u7ecf\u53d1\u751f\u4ed8\u6b3e\u3002", (String)"ContractPerformOp_2", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), Arrays.toString(paidIndex.toArray()).replace('[', ' ').replace(']', ' ')));
                            continue;
                        }
                        performFilter = new QFilter("sourcebill", "in", (Object)performId.toArray());
                        reimbursedFilter = new QFilter("collectedcomamt", "!=", (Object)BigDecimal.ZERO);
                        DynamicObject[] contractCollectItems = BusinessDataServiceHelper.load((String)"pmbs_contractcollectitem", (String)String.join((CharSequence)",", "sourcebill", "collectedcomamt"), (QFilter[])new QFilter[]{performFilter, contractFilter, reimbursedFilter});
                        if (contractCollectItems == null || contractCollectItems.length <= 0) continue;
                        HashSet<Integer> collectIndex = new HashSet<Integer>(16);
                        int flag = 1;
                        for (DynamicObject perform : performEntry) {
                            for (DynamicObject contractCollectItem : contractCollectItems) {
                                if (perform == null || contractCollectItem.getString("sourcebill") == null || !perform.getPkValue().equals(contractCollectItem.get("sourcebill")) || BigDecimal.ZERO.compareTo(contractCollectItem.getBigDecimal("collectedcomamt")) == 0) continue;
                                collectIndex.add(flag);
                                break;
                            }
                            ++flag;
                        }
                        if (collectIndex.size() <= 0) continue;
                        this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u5931\u8d25\uff0c\u7b2c%s\u884c\u4e8b\u52a1\u8bb0\u5f55\u5df2\u7ecf\u53d1\u751f\u6536\u6b3e\u3002", (String)"ContractPerformOp_3", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), Arrays.toString(collectIndex.toArray()).replace('[', ' ').replace(']', ' ')));
                    }
                }
            }
        });
    }

    @Override
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String operationKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        switch (operationKey) {
            case "audit": {
                this.doAudit(dataEntities);
                break;
            }
            case "unaudit": {
                this.doUnAudit(dataEntities);
                break;
            }
        }
    }

    @Override
    public void reverseWritingToContract(String operationKey, DynamicObject source) {
    }

    protected void doUnAudit(DynamicObject[] dataEntities) {
        for (DynamicObject dataEntity : dataEntities) {
            this.deleteContractPayItems(dataEntity);
        }
    }

    protected void deleteContractPayItems(DynamicObject contractPerform) {
        ArrayList<Long> performId = new ArrayList<Long>(10);
        DynamicObjectCollection performEntry = contractPerform.getDynamicObjectCollection("entryentity");
        if (performEntry != null && !performEntry.isEmpty()) {
            for (DynamicObject perform : performEntry) {
                BigDecimal amount = perform.getBigDecimal("amount");
                if (amount.compareTo(BigDecimal.ZERO) == 0) continue;
                performId.add(Long.valueOf(perform.getPkValue().toString()));
            }
            DynamicObject contract = contractPerform.getDynamicObject("contract");
            QFilter contractFilter = new QFilter("contract.id", "=", contract.getPkValue());
            String formId = contractPerform.getDataEntityType().getName();
            if (StringUtils.equals((CharSequence)"pmct_outperformrecords", (CharSequence)formId)) {
                contractFilter.and("performentryid", "in", (Object)performId.toArray());
                DeleteServiceHelper.delete((String)"pmbs_contractpayitem", (QFilter[])new QFilter[]{contractFilter});
            } else {
                contractFilter.and("sourcebill", "in", (Object)performId.toArray());
                DeleteServiceHelper.delete((String)"pmbs_contractcollectitem", (QFilter[])new QFilter[]{contractFilter});
            }
        }
    }

    protected void doAudit(DynamicObject[] dataEntities) {
        for (DynamicObject contractPerform : dataEntities) {
            String formId = contractPerform.getDataEntityType().getName();
            DynamicObject contract = contractPerform.getDynamicObject("contract");
            if (StringUtils.equals((CharSequence)"pmct_outperformrecords", (CharSequence)formId)) {
                ContractPayItemHelper.save((DynamicObject)contractPerform, (PayPlanSourceEnum)PayPlanSourceEnum.PERFORM, (Object)contract.getPkValue());
                continue;
            }
            new ContractCollectItemHelper().doSave(contractPerform, PayPlanSourceEnum.PERFORM, contract.getPkValue());
        }
    }
}

