/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.opplugin.contpref;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.common.enums.PerformAmountTypeEnum;
import kd.pmgt.pmbs.common.utils.CurrencyHelper;
import kd.pmgt.pmbs.common.utils.budget.BudgetValidateAndUpdateHelper;
import kd.pmgt.pmbs.common.utils.budget.PerformBillInfo;
import kd.pmgt.pmbs.common.utils.budget.PerformBillInfoBuilder;
import kd.pmgt.pmct.opplugin.AbstractReverseWritingPmctContractOp;
import kd.pmgt.pmct.opplugin.contpref.PerformValidator;

public class InContractPerformOp
extends AbstractReverseWritingPmctContractOp {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("contract");
        e.getFieldKeys().add("entryentity");
        e.getFieldKeys().add("amount");
        e.getFieldKeys().add("isclaim");
        e.getFieldKeys().add("issettle");
        e.getFieldKeys().add("paydirection");
        e.getFieldKeys().add("name");
        e.getFieldKeys().add("createtime");
        e.getFieldKeys().add("creator");
        e.getFieldKeys().add("modifier");
        e.getFieldKeys().add("modifytime");
        e.getFieldKeys().add("modifytime");
        e.getFieldKeys().add("isneedsettle");
        e.getFieldKeys().add("contpayitem");
        e.getFieldKeys().add("budgetitem");
    }

    @Override
    public void reverseWritingToContract(String opKey, DynamicObject performRecords) {
        DynamicObject contract = BusinessDataServiceHelper.loadSingle((Object)performRecords.getDynamicObject("contract").getPkValue(), (String)"pmct_incontract", (String)"performtaxamount");
        if (StringUtils.equalsIgnoreCase((CharSequence)"audit", (CharSequence)opKey)) {
            BigDecimal amount = this.getTotalPerformTaxAmount(performRecords);
            contract.set("performtaxamount", (Object)amount);
        } else {
            contract.set("performtaxamount", (Object)BigDecimal.ZERO);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{contract});
    }

    private BigDecimal getTotalPerformTaxAmount(DynamicObject source) {
        DynamicObjectCollection entry = source.getDynamicObjectCollection("entryentity");
        BigDecimal amount = BigDecimal.ZERO;
        for (DynamicObject row : entry) {
            if (row.getBoolean("isclaim")) continue;
            DynamicObject contractPayItem = row.getDynamicObject("contpayitem");
            if (contractPayItem != null) {
                String direction = contractPayItem.getString("direction");
                if ("00".equals(direction)) {
                    amount = amount.add(row.getBigDecimal("amount"));
                    continue;
                }
                if (!"01".equals(direction)) continue;
                amount = amount.subtract(row.getBigDecimal("amount"));
                continue;
            }
            amount = amount.add(row.getBigDecimal("amount"));
        }
        return amount;
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new PerformValidator());
        e.addValidator(new AbstractValidator(){

            public void validate() {
                String operateKey = this.getOperateKey();
                if (StringUtils.equals((CharSequence)"submit", (CharSequence)operateKey)) {
                    for (int i = 0; i < this.getDataEntities().length; ++i) {
                        DynamicObject[] proApp;
                        DynamicObject contract = this.dataEntities[i].getDataEntity().getDynamicObject("contract");
                        boolean projectCostControl = false;
                        if (!Objects.nonNull(contract)) continue;
                        DynamicObject project = contract.getDynamicObject("project");
                        if (project != null && (proApp = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"projectcostcontrol", (QFilter[])new QFilter[]{new QFilter("pro", "=", project.getPkValue())})) != null && proApp.length > 0) {
                            projectCostControl = proApp[0].getBoolean("projectcostcontrol");
                        }
                        DynamicObjectCollection entryCollection = this.dataEntities[i].getDataEntity().getDynamicObjectCollection("entryentity");
                        HashSet<Integer> reimbursedIndex = new HashSet<Integer>(16);
                        for (int j = 0; j < entryCollection.size(); ++j) {
                            DynamicObject entry = (DynamicObject)entryCollection.get(j);
                            boolean isNeedSettle = entry.getBoolean("isneedsettle");
                            DynamicObject contPayItem = entry.getDynamicObject("contpayitem");
                            if (!isNeedSettle || contPayItem != null) continue;
                            reimbursedIndex.add(j + 1);
                        }
                        if (reimbursedIndex.size() <= 0) continue;
                        this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u4e8b\u52a1\u8bb0\u5f55\u660e\u7ec6\u5206\u5f55\u7b2c%s\u884c\uff0c\u5df2\u52fe\u9009\u201c\u9700\u8981\u72ec\u7acb\u7ed3\u7b97\u201d\uff0c\u8bf7\u9009\u62e9\u5408\u540c\u652f\u4ed8\u9879\u3002", (String)"InContractPerformOp_0", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), Arrays.toString(reimbursedIndex.toArray()).replace('[', ' ').replace(']', ' ')));
                    }
                }
            }
        });
    }

    @Override
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String type;
        super.beginOperationTransaction(e);
        String operationKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities.length > 0 && "pmct_inperformrecords".equals(type = e.getDataEntities()[0].getDynamicObjectType().getName()) && (StringUtils.equals((CharSequence)operationKey, (CharSequence)"submit") || StringUtils.equals((CharSequence)operationKey, (CharSequence)"unsubmit") || StringUtils.equals((CharSequence)operationKey, (CharSequence)"audit") || StringUtils.equals((CharSequence)operationKey, (CharSequence)"unaudit"))) {
            this.updateBudgetData(dataEntities, operationKey);
        }
    }

    protected void updateBudgetData(DynamicObject[] entities, String operationKey) {
        for (DynamicObject bill : entities) {
            PerformBillInfo billInfo;
            DynamicObject contract = bill.getDynamicObject("contract");
            DynamicObject project = contract.getDynamicObject("project");
            contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_incontract");
            boolean isOpenedContract = contract.getBoolean("openedcontract");
            boolean isMultiContract = contract.getBoolean("ismulticontract");
            if (project == null || isOpenedContract || isMultiContract) continue;
            DynamicObject[] proApp = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)String.join((CharSequence)",", "org", "currencyfield"), (QFilter[])new QFilter[]{new QFilter("pro", "=", project.getPkValue())});
            if (proApp == null || proApp.length == 0) {
                return;
            }
            Map<String, BigDecimal> projectAmountMap = this.buildBudgetAmountMap(bill, this.getExchangeRate(contract, proApp[0]));
            Map<String, BigDecimal> contractAmountMap = this.buildBudgetAmountMap(bill, BigDecimal.ONE);
            if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"submit")) {
                billInfo = new PerformBillInfoBuilder().formBillId("pmct_inperformrecords").billNo(bill.getString("billno")).billName(bill.getString("name")).creator(bill.getDynamicObject("creator")).createDate(bill.getDate("createtime")).id(bill.getLong("id")).contractId(contract.getPkValue().toString()).contractCurrency(contract.getDynamicObject("currency")).amountType(PerformAmountTypeEnum.CONTRACT).build();
                BudgetValidateAndUpdateHelper.updateBudgetOnSubmit(projectAmountMap, contractAmountMap, (PerformBillInfo)billInfo);
                continue;
            }
            if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"unsubmit")) {
                billInfo = new PerformBillInfoBuilder().formBillId("pmct_inperformrecords").id(bill.getLong("id")).contractId(contract.getPkValue().toString()).amountType(PerformAmountTypeEnum.CONTRACT).build();
                BudgetValidateAndUpdateHelper.updateBudgetOnUnsubmit(projectAmountMap, contractAmountMap, (PerformBillInfo)billInfo);
                continue;
            }
            if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"audit")) {
                billInfo = new PerformBillInfoBuilder().formBillId("pmct_inperformrecords").billNo(bill.getString("billno")).billName(bill.getString("name")).creator(bill.getDynamicObject("creator")).createDate(bill.getDate("createtime")).auditor(bill.getDynamicObject("auditor")).auditDate(bill.getDate("auditdate")).id(bill.getLong("id")).contractId(contract.getPkValue().toString()).amountType(PerformAmountTypeEnum.CONTRACT).build();
                BudgetValidateAndUpdateHelper.updateBudgetOnAudit(projectAmountMap, contractAmountMap, (PerformBillInfo)billInfo);
                continue;
            }
            if (!StringUtils.equals((CharSequence)operationKey, (CharSequence)"unaudit")) continue;
            BudgetValidateAndUpdateHelper.updateBudgetOnUnaudit(projectAmountMap, contractAmountMap, (String)"pmct_inperformrecords", (long)bill.getLong("id"), (String)contract.getPkValue().toString(), (PerformAmountTypeEnum)PerformAmountTypeEnum.CONTRACT);
        }
    }

    protected BigDecimal getExchangeRate(DynamicObject bill, DynamicObject project) {
        DynamicObject exRateTable;
        DynamicObject org = project.getDynamicObject("org");
        DynamicObject proCurrency = project.getDynamicObject("currencyfield");
        DynamicObject contractCurrency = bill.getDynamicObject("currency");
        DynamicObject stdCurrency = bill.getDynamicObject("stdcurrency");
        if (proCurrency != null && contractCurrency != null && proCurrency.getPkValue().equals(contractCurrency.getPkValue())) {
            return BigDecimal.ONE;
        }
        if (proCurrency != null && stdCurrency != null && proCurrency.getPkValue().equals(stdCurrency.getPkValue())) {
            return bill.getBigDecimal("exchangerate");
        }
        BigDecimal exchangeRate = BigDecimal.ONE;
        if (org != null && proCurrency != null && contractCurrency != null && (exRateTable = CurrencyHelper.getExRateTable((Long)org.getLong("id"))) != null) {
            exchangeRate = CurrencyHelper.getExChangeRate((Long)contractCurrency.getLong("id"), (Long)proCurrency.getLong("id"), (Long)exRateTable.getLong("id"), (Date)bill.getDate("createtime"));
        }
        return exchangeRate;
    }

    protected Map<String, BigDecimal> buildBudgetAmountMap(DynamicObject bill, BigDecimal exchangeRate) {
        HashMap<String, BigDecimal> budgetAmountMap = new HashMap<String, BigDecimal>();
        DynamicObjectCollection entryEntity = bill.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entryEntity) {
            BigDecimal amount = entry.getBigDecimal("amount");
            DynamicObject budget = entry.getDynamicObject("budgetitem");
            if (budget == null || amount == null || amount.compareTo(BigDecimal.ZERO) == 0) continue;
            BigDecimal budgetAmount = (BigDecimal)budgetAmountMap.get(budget.getPkValue().toString());
            if (budgetAmount == null) {
                budgetAmount = BigDecimal.ZERO;
            }
            budgetAmountMap.put(budget.getPkValue().toString(), budgetAmount.add(amount.multiply(exchangeRate)));
        }
        return budgetAmountMap;
    }
}

