/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.opplugin.contpref;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.pmgt.pmbs.business.helper.ProBudgetControlHelper;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;
import kd.pmgt.pmbs.common.enums.PerformAmountTypeEnum;
import kd.pmgt.pmbs.common.utils.CurrencyHelper;
import kd.pmgt.pmbs.common.utils.NumberHelper;
import kd.pmgt.pmbs.common.utils.budget.BudgetValidateAndUpdateHelper;
import kd.pmgt.pmbs.common.utils.budget.BudgetValidateInfo;

public class PerformValidator
extends AbstractValidator {
    public void validate() {
        block5: {
            ExtendedDataEntity[] dataEntities;
            String key;
            block4: {
                key = this.getOperateKey();
                dataEntities = this.getDataEntities();
                if (!StringUtils.equals((CharSequence)key, (CharSequence)"submit") && !StringUtils.equals((CharSequence)key, (CharSequence)"audit")) break block4;
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    if (!PayDirectionEnum.OUT.getValue().equals(dataEntity.getDataEntity().getString("paydirection"))) continue;
                    this.vaildBudget(dataEntity, key);
                }
                break block5;
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"unaudit")) break block5;
            for (ExtendedDataEntity dataEntity : dataEntities) {
                this.validUnaudit(dataEntity);
                if (PayDirectionEnum.OUT.getValue().equals(dataEntity.getDataEntity().getString("paydirection"))) {
                    this.vaildBudget(dataEntity, key);
                    this.validPayPlanItemTargetBill(dataEntity);
                } else {
                    this.validIncomePlanItemTargetBill(dataEntity);
                }
                this.validItemHasPayApply(dataEntity);
            }
        }
    }

    private void validIncomePlanItemTargetBill(ExtendedDataEntity dataEntity) {
        DynamicObject[] items;
        DynamicObjectCollection entryEntity = dataEntity.getDataEntity().getDynamicObjectCollection("entryentity");
        ArrayList entryIds = new ArrayList(entryEntity.size());
        entryEntity.forEach(entry -> entryIds.add(entry.getPkValue()));
        for (DynamicObject item : items = BusinessDataServiceHelper.load((String)"pmbs_contractcollectitem", (String)"masterid, status, billno, enable, customer, collecttype, collectfeq, collectway, collectpercent, currency, collectamount, plancollecttime, remarks, collectedamt, collectedcomamt, uncollectedamt, contract, sourcebilltype, autogenerated, creator, createtime, modifier, modifytime, sourcebill, paydirection", (QFilter[])new QFilter[]{new QFilter("sourcebill", "in", entryIds)})) {
            Map targetBillIds = BFTrackerServiceHelper.findTargetBills((String)"pmbs_contractcolitembook", (Long[])new Long[]{item.getLong("id")});
            if (targetBillIds.isEmpty()) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6761\u76ee\u540d\u79f0\uff1a%s\u5df2\u5f15\u7528\u6216\u4e0b\u63a8\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"PerformValidator_13", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), item.getString("name")));
        }
    }

    private void validPayPlanItemTargetBill(ExtendedDataEntity dataEntity) {
        DynamicObject[] items;
        DynamicObjectCollection entryEntity = dataEntity.getDataEntity().getDynamicObjectCollection("entryentity");
        ArrayList entryIds = new ArrayList(entryEntity.size());
        entryEntity.forEach(entry -> entryIds.add(entry.getPkValue()));
        for (DynamicObject item : items = BusinessDataServiceHelper.load((String)"pmbs_contractpayitem", (String)"name, billno,  masterid, status, enable, supplier, paytype, payfeq, payway, paypercent, payamount, planpaytime, remarks, reimbursedamt, reimbursedcomamt, reimbursableamt, paidamt, paidcomamt, unpaidamt, source, payplansource, contract, autogenerated, creator, createtime, modifier, modifytime, payplanentryid, performentryid, currency, paydirection, appliedamt, appliedcomamt, appliableamt, ctrlstrategy, nodesettingsource, nodesetting, taskcompletestatus,paidamount,unpayamount", (QFilter[])new QFilter[]{new QFilter("performentryid", "in", entryIds)})) {
            Map targetBillIds = BFTrackerServiceHelper.findTargetBills((String)"pmbs_contractpayitembook", (Long[])new Long[]{item.getLong("id")});
            if (targetBillIds.isEmpty()) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6761\u76ee\u540d\u79f0\uff1a%s\u5df2\u5f15\u7528\u6216\u4e0b\u63a8\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"PerformValidator_13", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), item.getString("name")));
        }
    }

    protected void validItemHasPayApply(ExtendedDataEntity dataEntity) {
        String downBillInfoTip;
        String itemSourceProperty;
        String applyAmtProperty;
        String itemBillEntity;
        DynamicObject performRecord = dataEntity.getDataEntity();
        DynamicObjectCollection recordDetailEntries = performRecord.getDynamicObjectCollection("entryentity");
        if (recordDetailEntries == null || recordDetailEntries.size() == 0) {
            return;
        }
        Map recordIdMap = recordDetailEntries.stream().collect(Collectors.toMap(k1 -> (Long)k1.getPkValue(), Function.identity(), (k1, k2) -> k2));
        if (PayDirectionEnum.OUT.getValue().equals(dataEntity.getDataEntity().getString("paydirection"))) {
            itemBillEntity = "pmbs_contractpayitem";
            applyAmtProperty = "appliedcomamt";
            itemSourceProperty = "performentryid";
            downBillInfoTip = ResManager.loadKDString((String)"\u4ed8\u6b3e\u7533\u8bf7", (String)"PerformValidator_7", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]);
        } else {
            itemBillEntity = "pmbs_contractcollectitem";
            applyAmtProperty = "appliedcomamt";
            itemSourceProperty = "sourcebill";
            downBillInfoTip = ResManager.loadKDString((String)"\u8bf7\u6b3e", (String)"PerformValidator_8", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]);
        }
        DynamicObject[] contractItems = BusinessDataServiceHelper.load((String)itemBillEntity, (String)String.join((CharSequence)",", applyAmtProperty, itemSourceProperty), (QFilter[])new QFilter[]{new QFilter(itemSourceProperty, "in", recordIdMap.keySet())});
        if (contractItems == null || contractItems.length == 0) {
            return;
        }
        HashSet<Long> hasRefIds = new HashSet<Long>(recordDetailEntries.size());
        for (DynamicObject contractItem : contractItems) {
            BigDecimal appliedCoAmt = contractItem.getBigDecimal(applyAmtProperty);
            if (NumberHelper.isNullZero((BigDecimal)appliedCoAmt)) continue;
            hasRefIds.add(contractItem.getLong(itemSourceProperty));
        }
        if (hasRefIds.size() != 0) {
            ArrayList<String> seqList = new ArrayList<String>(hasRefIds.size());
            for (Long hasRefId : hasRefIds) {
                DynamicObject recordEntry = (DynamicObject)recordIdMap.get(hasRefId);
                int seq = recordEntry.getInt("seq");
                seqList.add(String.valueOf(seq));
            }
            seqList.sort(Comparator.comparing(k -> k));
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u5931\u8d25\uff0c\u7b2c%1$s\u884c\u8bb0\u5f55\u5df2\u53d1\u751f%2$s\u3002", (String)"PerformValidator_12", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), String.join((CharSequence)",", seqList), downBillInfoTip));
        }
    }

    private void vaildBudget(ExtendedDataEntity dataEntity, String key) {
        DynamicObject performBill = dataEntity.getDataEntity();
        if (performBill != null) {
            DynamicObject contract = performBill.getDynamicObject("contract");
            DynamicObject project = contract.getDynamicObject("project");
            contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_outcontract");
            boolean isOpenedContract = contract.getBoolean("openedcontract");
            boolean multiPartSettlement = contract.getBoolean("multipartsettlement");
            if (project != null && !isOpenedContract && !multiPartSettlement) {
                boolean isNew = ProBudgetControlHelper.checkIsNewProBudgetCtrl((Long)((Long)project.getPkValue()));
                if (isNew) {
                    return;
                }
                DynamicObject[] proApp = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"projectcostcontrol,org,currencyfield", (QFilter[])new QFilter[]{new QFilter("pro", "=", project.getPkValue())});
                if (proApp != null && proApp.length > 0 && proApp[0].getBoolean("projectcostcontrol")) {
                    DynamicObjectCollection entryentity = performBill.getDynamicObjectCollection("entryentity");
                    boolean mustInput = true;
                    for (DynamicObject entry : entryentity) {
                        DynamicObject budgetItem;
                        Boolean needSettle = entry.getBoolean("isneedsettle");
                        if (!needSettle.booleanValue() || (budgetItem = entry.getDynamicObject("budgetitem")) != null) continue;
                        String msg = String.format(ResManager.loadKDString((String)"\u4e8b\u52a1\u8bb0\u5f55\u660e\u7ec6\u5206\u5f55\u7b2c%s\u884c\uff0c\u5df2\u52fe\u9009\u201c\u9700\u8981\u72ec\u7acb\u7ed3\u7b97\u201d\uff0c\u8bf7\u9009\u62e9\u9879\u76ee\u9884\u7b97\u9879\u3002", (String)"PerformValidator_14", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), entry.getInt("seq"));
                        this.addErrorMessage(dataEntity, msg);
                        mustInput = false;
                    }
                    if (mustInput) {
                        Map<String, BigDecimal> budgetAmountMap = this.buildBudgetAmountMap(performBill, this.getExchangeRate(performBill, proApp[0]));
                        BudgetValidateInfo validateInfo = null;
                        if (StringUtils.equals((CharSequence)"submit", (CharSequence)key)) {
                            validateInfo = BudgetValidateAndUpdateHelper.validateBudgetAmountOnSubmit(budgetAmountMap, (String)contract.getPkValue().toString(), (PerformAmountTypeEnum)PerformAmountTypeEnum.CONTRACT);
                        } else if (StringUtils.equals((CharSequence)"unsubmit", (CharSequence)key)) {
                            validateInfo = BudgetValidateAndUpdateHelper.validateBudgetAmountOnUnSubmit(budgetAmountMap, (String)contract.getPkValue().toString(), (PerformAmountTypeEnum)PerformAmountTypeEnum.CONTRACT);
                        } else if (StringUtils.equals((CharSequence)"audit", (CharSequence)key)) {
                            validateInfo = BudgetValidateAndUpdateHelper.validateBudgetAmountOnAuditAndUnaudit(budgetAmountMap, (String)contract.getPkValue().toString(), (long)performBill.getLong("id"), (String)"pmct_outperformrecords", (PerformAmountTypeEnum)PerformAmountTypeEnum.CONTRACT, (boolean)false);
                        } else if (StringUtils.equals((CharSequence)"unaudit", (CharSequence)key)) {
                            validateInfo = BudgetValidateAndUpdateHelper.validateBudgetAmountOnAuditAndUnaudit(budgetAmountMap, (String)contract.getPkValue().toString(), (long)performBill.getLong("id"), (String)"pmct_outperformrecords", (PerformAmountTypeEnum)PerformAmountTypeEnum.CONTRACT, (boolean)true);
                        }
                        this.analysisValidateInfo(dataEntity, validateInfo, proApp[0].getDynamicObject("currencyfield"));
                    }
                }
            }
        }
    }

    protected void analysisValidateInfo(ExtendedDataEntity dataEntity, BudgetValidateInfo validateInfo, DynamicObject currency) {
        if (validateInfo != null) {
            boolean outOfControl = validateInfo.isOutOfControl();
            boolean outOfRemind = validateInfo.isOutOfRemind();
            Map resultMap = validateInfo.getResultMap();
            if (resultMap != null && !resultMap.isEmpty()) {
                int amtPrecision = 2;
                if (currency != null) {
                    amtPrecision = currency.getInt("amtprecision");
                }
                for (Map.Entry resultEntry : resultMap.entrySet()) {
                    DynamicObject originalBudget = (DynamicObject)resultEntry.getKey();
                    DynamicObject validateBudget = (DynamicObject)resultEntry.getValue();
                    if (originalBudget.getPkValue().equals(validateBudget.getPkValue())) {
                        if (outOfControl) {
                            this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9884\u7b97\u9879\u201c%s\u201d\u7684\u7d2f\u8ba1\u91d1\u989d\u5df2\u7ecf\u8d85\u51fa\u63a7\u5236\u9650\u989d\u3002", (String)"PerformValidator_15", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), originalBudget.getString("name")));
                            continue;
                        }
                        if (!outOfRemind) continue;
                        this.addWarningMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9884\u7b97\u9879\u201c%1$s\u201d\u7684\u7d2f\u8ba1\u91d1\u989d\u5df2\u7ecf\u8fbe\u5230%2$s\uff0c\u9884\u7b97\u91d1\u989d\u662f%3$s\u3002", (String)"PerformValidator_16", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), originalBudget.getString("name"), originalBudget.getBigDecimal("occupyamt").setScale(amtPrecision, RoundingMode.DOWN).toString(), originalBudget.getBigDecimal("budgetamount").setScale(amtPrecision, RoundingMode.DOWN).toString()));
                        continue;
                    }
                    if (outOfControl) {
                        this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9884\u7b97\u9879\u201c%1$s\u201d\u7684\u4e0a\u7ea7\u9884\u7b97\u9879\u201c%2$s\u201d\u7684\u7d2f\u8ba1\u91d1\u989d\u5df2\u7ecf\u8d85\u51fa\u63a7\u5236\u9650\u989d\u3002", (String)"PerformValidator_17", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), originalBudget.getString("name"), validateBudget.getString("name")));
                        continue;
                    }
                    if (!outOfRemind) continue;
                    this.addWarningMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9884\u7b97\u9879\u201c%1$s\u201d\u7684\u4e0a\u7ea7\u9884\u7b97\u9879\u201c%2$s\u201d\u7684\u7d2f\u8ba1\u91d1\u989d\u5df2\u7ecf\u8fbe\u5230%3$s\uff0c\u9884\u7b97\u91d1\u989d\u662f%4$s\u3002", (String)"PerformValidator_18", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), originalBudget.getString("name"), validateBudget.getString("name"), validateBudget.getBigDecimal("occupyamt").setScale(amtPrecision, RoundingMode.DOWN).toString(), validateBudget.getBigDecimal("budgetamount").setScale(amtPrecision, RoundingMode.DOWN).toString()));
                }
            }
        }
    }

    protected BigDecimal getExchangeRate(DynamicObject bill, DynamicObject project) {
        DynamicObject exRateTable;
        DynamicObject org = project.getDynamicObject("org");
        DynamicObject proCurrency = project.getDynamicObject("currencyfield");
        DynamicObject contractCurrency = bill.getDynamicObject("currency");
        DynamicObject stdCurrency = bill.getDynamicObject("stdcurrency");
        if (proCurrency != null && contractCurrency != null && proCurrency.getPkValue().equals(contractCurrency.getPkValue())) {
            return BigDecimal.ONE;
        }
        if (proCurrency != null && stdCurrency != null && proCurrency.getPkValue().equals(stdCurrency.getPkValue())) {
            return bill.getBigDecimal("exchangerate");
        }
        BigDecimal exchangeRate = BigDecimal.ONE;
        if (org != null && proCurrency != null && contractCurrency != null && (exRateTable = CurrencyHelper.getExRateTable((Long)org.getLong("id"))) != null) {
            exchangeRate = CurrencyHelper.getExChangeRate((Long)contractCurrency.getLong("id"), (Long)proCurrency.getLong("id"), (Long)exRateTable.getLong("id"), (Date)bill.getDate("createtime"));
        }
        return exchangeRate;
    }

    protected Map<String, BigDecimal> buildBudgetAmountMap(DynamicObject bill, BigDecimal exchangeRate) {
        HashMap<String, BigDecimal> budgetAmountMap = new HashMap<String, BigDecimal>();
        DynamicObjectCollection entryentity = bill.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entryentity) {
            BigDecimal amount = entry.getBigDecimal("amount");
            DynamicObject budget = entry.getDynamicObject("budgetitem");
            if (budget == null || amount == null || amount.compareTo(BigDecimal.ZERO) == 0) continue;
            BigDecimal budgetAmount = (BigDecimal)budgetAmountMap.get(budget.getPkValue().toString());
            if (budgetAmount == null) {
                budgetAmount = BigDecimal.ZERO;
            }
            budgetAmountMap.put(budget.getPkValue().toString(), budgetAmount.add(amount.multiply(exchangeRate)));
        }
        return budgetAmountMap;
    }

    private void validUnaudit(ExtendedDataEntity dataEntity) {
        DynamicObject bill = dataEntity.getDataEntity();
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entryentity");
        boolean isError = false;
        for (DynamicObject entry : entrys) {
            boolean issettle = entry.getBoolean("issettle");
            if (!issettle) continue;
            isError = true;
        }
        if (isError) {
            String msg = ResManager.loadKDString((String)"\u5c65\u7ea6\u8bb0\u5f55\u7684\u5206\u5f55\u4e2d\u5b58\u5728\u5df2\u7ed3\u7b97\u7684\u5408\u540c\u652f\u4ed8\u9879\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"PerformValidator_19", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, msg);
        }
    }
}

