/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.opplugin.contsettle;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pmgt.pmbs.business.helper.ProBudgetControlHelper;
import kd.pmgt.pmbs.common.enums.ContractStatusEnum;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;
import kd.pmgt.pmbs.common.enums.PerformAmountTypeEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.utils.CurrencyHelper;
import kd.pmgt.pmbs.common.utils.budget.BudgetValidateAndUpdateHelper;
import kd.pmgt.pmbs.common.utils.budget.BudgetValidateInfo;

public class FinalSettleValidator
extends AbstractValidator {
    public void validate() {
        block4: {
            ExtendedDataEntity[] dataEntities;
            String key;
            block3: {
                key = this.getOperateKey();
                dataEntities = this.getDataEntities();
                if (!StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"submit") && !StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"unaudit")) break block3;
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    if (StringUtils.equals((CharSequence)"submit", (CharSequence)key)) {
                        this.validateContractStatus(dataEntity);
                        this.vaildAppamount(dataEntity);
                    }
                    if (!PayDirectionEnum.OUT.getValue().equals(dataEntity.getDataEntity().getString("paydirection"))) continue;
                    this.vaildBudget(dataEntity, key);
                }
                break block4;
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"audit")) break block4;
            this.auditValid(dataEntities);
            for (ExtendedDataEntity dataEntity : dataEntities) {
                if (!PayDirectionEnum.OUT.getValue().equals(dataEntity.getDataEntity().getString("paydirection"))) continue;
                this.vaildBudget(dataEntity, key);
            }
        }
    }

    protected void validateContractStatus(ExtendedDataEntity dataEntity) {
        DynamicObject finSettleBill = dataEntity.getDataEntity();
        DynamicObject contract = finSettleBill.getDynamicObject("contract");
        if (contract == null) {
            return;
        }
        contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_contracttpl");
        DynamicObject contractStatus = contract.getDynamicObject("contractstatus");
        if (StringUtils.equals((CharSequence)(contractStatus = BusinessDataServiceHelper.loadSingle((Object)contractStatus.getPkValue(), (String)"pmct_contractstatus")).getString("number"), (CharSequence)ContractStatusEnum.CLOSED.getValue())) {
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5408\u540c\u5df2\u5173\u95ed\uff0c\u65e0\u6cd5\u53d8\u66f4\u5408\u540c\u72b6\u6001\u3002", (String)"FinalSettleValidator_11", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
            return;
        }
        String payDirection = contract.getString("paydirection");
        String formBillId = PayDirectionEnum.OUT.getValue().equals(payDirection) ? "pmct_statuschange" : "pmct_instatuschange";
        QFilter filter = new QFilter("contract", "=", (Object)Long.parseLong(contract.getPkValue().toString()));
        filter.and(new QFilter("billstatus", "=", (Object)StatusEnum.UNCHECKED.getValue()));
        DynamicObject[] statusChangeBills = BusinessDataServiceHelper.load((String)formBillId, (String)"id,billno", (QFilter[])new QFilter[]{filter});
        if (statusChangeBills != null && statusChangeBills.length > 0) {
            for (DynamicObject statusChangeBill : statusChangeBills) {
                String billNo = statusChangeBill.getString("billno");
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5408\u540c\u201c%1$s\u201d\u5b58\u5728\u5df2\u63d0\u4ea4\u7684\u5408\u540c\u72b6\u6001\u53d8\u66f4\u5355\uff0c\u5355\u636e\u7f16\u53f7\u662f%2$s\uff0c\u8bf7\u5728\u5355\u636e\u5ba1\u6838\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"FinalSettleValidator_12", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), contract.getString("billno"), billNo));
            }
        }
    }

    private void vaildAppamount(ExtendedDataEntity dataEntity) {
        DynamicObject finSettleBill = dataEntity.getDataEntity();
        DynamicObjectCollection entryEntity = finSettleBill.getDynamicObjectCollection("entryentity");
        boolean projectCostControl = this.isProjectCostControl(finSettleBill);
        if (projectCostControl) {
            BigDecimal itemAppAmountTotal = BigDecimal.ZERO;
            for (DynamicObject entry : entryEntity) {
                BigDecimal amount = entry.getBigDecimal("itemappamount");
                if (amount.compareTo(BigDecimal.ZERO) == 0) continue;
                itemAppAmountTotal = itemAppAmountTotal.add(amount);
            }
            BigDecimal appTaxAmount = finSettleBill.getBigDecimal("apptaxamount");
            if (appTaxAmount.compareTo(itemAppAmountTotal) != 0) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5206\u5f55\u5408\u540c\u5ba1\u5b9a\u542b\u7a0e\u91d1\u989d\u5b57\u6bb5\u5408\u8ba1\u4e0d\u7b49\u4e8e\u5408\u540c\u5ba1\u5b9a\u542b\u7a0e\u603b\u91d1\u989d\u3002", (String)"FinalSettleValidator_1", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                return;
            }
        }
    }

    private void vaildBudget(ExtendedDataEntity dataEntity, String key) {
        DynamicObject finSettleBill = dataEntity.getDataEntity();
        DynamicObject contract = finSettleBill.getDynamicObject("contract");
        DynamicObject project = contract.getDynamicObject("project");
        contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_outcontract");
        boolean projectCostControl = this.isProjectCostControl(finSettleBill);
        if (projectCostControl) {
            Set<Object> controlProIdSet = this.getProIdSetWithMultiSettle(finSettleBill);
            Map<Object, Object> budgetAmountMap = new HashMap(16);
            if (controlProIdSet.isEmpty()) {
                DynamicObject[] proApps = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"org,currencyfield", (QFilter[])new QFilter[]{new QFilter("pro", "=", project.getPkValue())});
                boolean isNew = ProBudgetControlHelper.checkIsNewProBudgetCtrl((Long)((Long)project.getPkValue()));
                if (isNew) {
                    return;
                }
                if (proApps != null && proApps.length > 0) {
                    budgetAmountMap = this.buildBudgetAmountMap(finSettleBill, this.getExchangeRate(contract, proApps[0]));
                }
            } else {
                Set<Object> oldProIdSet = controlProIdSet.stream().map(Object::toString).map(Long::valueOf).filter(proId -> !ProBudgetControlHelper.checkIsNewProBudgetCtrl((Long)proId)).collect(Collectors.toSet());
                budgetAmountMap = this.buildBudgetAmountMap(finSettleBill, oldProIdSet);
            }
            BudgetValidateInfo validateInfo = null;
            if (StringUtils.equals((CharSequence)"submit", (CharSequence)key)) {
                validateInfo = BudgetValidateAndUpdateHelper.validateBudgetAmountOnSubmit(budgetAmountMap, (String)contract.getPkValue().toString(), (PerformAmountTypeEnum)PerformAmountTypeEnum.CONTRACT);
            } else if (StringUtils.equals((CharSequence)"audit", (CharSequence)key)) {
                validateInfo = BudgetValidateAndUpdateHelper.validateBudgetAmountOnAuditAndUnaudit(budgetAmountMap, (String)contract.getPkValue().toString(), (long)finSettleBill.getLong("id"), (String)"pmct_outfinalsettle", (PerformAmountTypeEnum)PerformAmountTypeEnum.CONTRACT, (boolean)false);
            } else if (StringUtils.equals((CharSequence)"unaudit", (CharSequence)key)) {
                validateInfo = BudgetValidateAndUpdateHelper.validateBudgetAmountOnAuditAndUnaudit(budgetAmountMap, (String)contract.getPkValue().toString(), (long)finSettleBill.getLong("id"), (String)"pmct_outfinalsettle", (PerformAmountTypeEnum)PerformAmountTypeEnum.CONTRACT, (boolean)true);
            }
            this.analysisValidateInfo(dataEntity, validateInfo, null);
        }
    }

    @Deprecated
    protected boolean controlAmount(ExtendedDataEntity dataEntity, DynamicObject finSettleBill, DynamicObject contract) {
        boolean outControl = false;
        DynamicObject contractType = contract.getDynamicObject("contracttype");
        String ammountcontrolsettle = (contractType = BusinessDataServiceHelper.loadSingle((Object)contractType.getPkValue(), (String)"pmct_conttype")).getString("ammountcontrolsettle");
        if ("2".equals(ammountcontrolsettle) || "1".equals(ammountcontrolsettle)) {
            Map<String, BigDecimal> budgetAmountMap = this.buildBudgetAmountMap(finSettleBill, BigDecimal.ONE);
            QFilter filter = new QFilter("contract", "=", contract.getPkValue());
            for (Map.Entry<String, BigDecimal> map : budgetAmountMap.entrySet()) {
                if (map.getValue().compareTo(BigDecimal.ZERO) <= 0) continue;
                DynamicObject budget = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(map.getKey()), (String)"pmas_projectbudget");
                if ("2".equals(ammountcontrolsettle)) {
                    this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9884\u7b97\u9879\u201c%s\u201d\u7684\u51b3\u7b97\u91d1\u989d\u5df2\u7ecf\u8d85\u51fa\u5408\u540c\u91d1\u989d\u3002", (String)"FinalSettleValidator_13", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), budget.getString("name")));
                    outControl = true;
                    continue;
                }
                if (!"1".equals(ammountcontrolsettle)) continue;
                this.addWarningMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9884\u7b97\u9879\u201c%s\u201d\u7684\u51b3\u7b97\u91d1\u989d\u5df2\u7ecf\u8d85\u51fa\u5408\u540c\u91d1\u989d\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"FinalSettleValidator_14", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), budget.getString("name")));
            }
        }
        return outControl;
    }

    protected void analysisValidateInfo(ExtendedDataEntity dataEntity, BudgetValidateInfo validateInfo, DynamicObject currency) {
        if (validateInfo != null) {
            boolean outOfControl = validateInfo.isOutOfControl();
            boolean outOfRemind = validateInfo.isOutOfRemind();
            Map resultMap = validateInfo.getResultMap();
            if (resultMap != null && !resultMap.isEmpty()) {
                int amtPrecision = 2;
                if (currency != null) {
                    amtPrecision = currency.getInt("amtprecision");
                }
                for (Map.Entry resultEntry : resultMap.entrySet()) {
                    DynamicObject proCurrency;
                    DynamicObject originalBudget = (DynamicObject)resultEntry.getKey();
                    DynamicObject validateBudget = (DynamicObject)resultEntry.getValue();
                    if (originalBudget.getPkValue().equals(validateBudget.getPkValue())) {
                        if (outOfControl) {
                            this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9884\u7b97\u9879\u201c%s\u201d\u7684\u7d2f\u8ba1\u91d1\u989d\u5df2\u7ecf\u8d85\u51fa\u63a7\u5236\u9650\u989d\u3002", (String)"FinalSettleValidator_15", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), originalBudget.getString("name")));
                            continue;
                        }
                        if (!outOfRemind) continue;
                        proCurrency = originalBudget.getDynamicObject("currency");
                        if (proCurrency != null) {
                            amtPrecision = proCurrency.getInt("amtprecision");
                        }
                        this.addWarningMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9884\u7b97\u9879\u201c%1$s\u201d\u7684\u7d2f\u8ba1\u91d1\u989d\u5df2\u7ecf\u8fbe\u5230%2$s\uff0c\u9884\u7b97\u91d1\u989d\u662f%3$s\u3002", (String)"FinalSettleValidator_16", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), originalBudget.getString("name"), originalBudget.getBigDecimal("occupyamt").setScale(amtPrecision, RoundingMode.DOWN).toString(), originalBudget.getBigDecimal("budgetamount").setScale(amtPrecision, RoundingMode.DOWN).toString()));
                        continue;
                    }
                    if (outOfControl) {
                        this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9884\u7b97\u9879\u201c%1$s\u201d\u7684\u4e0a\u7ea7\u9884\u7b97\u9879\u201c%2$s\u201d\u7684\u7d2f\u8ba1\u91d1\u989d\u5df2\u7ecf\u8d85\u51fa\u63a7\u5236\u9650\u989d\u3002", (String)"FinalSettleValidator_17", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), originalBudget.getString("name"), validateBudget.getString("name")));
                        continue;
                    }
                    if (!outOfRemind) continue;
                    proCurrency = originalBudget.getDynamicObject("currency");
                    if (proCurrency != null) {
                        amtPrecision = proCurrency.getInt("amtprecision");
                    }
                    this.addWarningMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9884\u7b97\u9879\u201c%1$s\u201d\u7684\u4e0a\u7ea7\u9884\u7b97\u9879\u201c%2$s\u201d\u7684\u7d2f\u8ba1\u91d1\u989d\u5df2\u7ecf\u8fbe\u5230%3$s\uff0c\u9884\u7b97\u91d1\u989d\u662f%4$s\u3002", (String)"FinalSettleValidator_18", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), originalBudget.getString("name"), validateBudget.getString("name"), originalBudget.getBigDecimal("occupyamt").setScale(amtPrecision, RoundingMode.DOWN).toString(), originalBudget.getBigDecimal("budgetamount").setScale(amtPrecision, RoundingMode.DOWN).toString()));
                }
            }
        }
    }

    protected BigDecimal getExchangeRate(DynamicObject bill, DynamicObject project) {
        DynamicObject exRateTable;
        DynamicObject org = project.getDynamicObject("org");
        DynamicObject proCurrency = project.getDynamicObject("currencyfield");
        DynamicObject contractCurrency = bill.getDynamicObject("currency");
        DynamicObject stdCurrency = bill.getDynamicObject("stdcurrency");
        if (proCurrency != null && contractCurrency != null && proCurrency.getPkValue().equals(contractCurrency.getPkValue())) {
            return BigDecimal.ONE;
        }
        if (proCurrency != null && stdCurrency != null && proCurrency.getPkValue().equals(stdCurrency.getPkValue())) {
            return bill.getBigDecimal("exchangerate");
        }
        BigDecimal exchangeRate = BigDecimal.ONE;
        if (org != null && proCurrency != null && contractCurrency != null && (exRateTable = CurrencyHelper.getExRateTable((Long)org.getLong("id"))) != null) {
            exchangeRate = CurrencyHelper.getExChangeRate((Long)contractCurrency.getLong("id"), (Long)proCurrency.getLong("id"), (Long)exRateTable.getLong("id"), (Date)bill.getDate("createtime"));
        }
        return exchangeRate;
    }

    protected Map<String, BigDecimal> buildBudgetAmountMap(DynamicObject bill, BigDecimal exchangeRate) {
        HashMap<String, BigDecimal> budgetAmountMap = new HashMap<String, BigDecimal>();
        DynamicObjectCollection entryentity = bill.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entryentity) {
            BigDecimal amount = entry.getBigDecimal("itemsubamount").negate();
            DynamicObject budget = entry.getDynamicObject("budgetitem");
            if (budget == null || amount == null || amount.compareTo(BigDecimal.ZERO) == 0) continue;
            BigDecimal budgetAmount = (BigDecimal)budgetAmountMap.get(budget.getPkValue().toString());
            if (budgetAmount == null) {
                budgetAmount = BigDecimal.ZERO;
            }
            budgetAmountMap.put(budget.getPkValue().toString(), budgetAmount.add(amount.multiply(exchangeRate)));
        }
        return budgetAmountMap;
    }

    protected Map<String, BigDecimal> buildBudgetAmountMap(DynamicObject bill, Set<Object> controlProIdSet) {
        DynamicObject[] proApps = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"pro,org,currencyfield", (QFilter[])new QFilter[]{new QFilter("pro", "in", controlProIdSet)});
        DynamicObject contract = bill.getDynamicObject("contract");
        contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_outcontract");
        HashMap<Object, BigDecimal> exchangeRateMap = new HashMap<Object, BigDecimal>(16);
        if (proApps != null && proApps.length > 0) {
            for (DynamicObject proApp : proApps) {
                BigDecimal exchangeRate = BudgetValidateAndUpdateHelper.getExchangeRate((DynamicObject)contract, (DynamicObject)proApp);
                DynamicObject pro = proApp.getDynamicObject("pro");
                exchangeRateMap.put(pro.getPkValue(), exchangeRate);
            }
        } else {
            for (Object e : controlProIdSet) {
                exchangeRateMap.put(e, BigDecimal.ONE);
            }
        }
        DynamicObjectCollection entryentity = bill.getDynamicObjectCollection("entryentity");
        HashMap<String, BigDecimal> hashMap = new HashMap<String, BigDecimal>(entryentity.size());
        for (DynamicObject entry : entryentity) {
            BigDecimal amount = entry.getBigDecimal("itemappamount");
            DynamicObject budget = entry.getDynamicObject("budgetitem");
            DynamicObject project = budget.getDynamicObject("project");
            if (!controlProIdSet.contains(project.getPkValue()) || budget == null || amount == null || amount.compareTo(BigDecimal.ZERO) == 0) continue;
            BigDecimal budgetAmount = (BigDecimal)hashMap.get(budget.getPkValue().toString());
            if (budgetAmount == null) {
                budgetAmount = BigDecimal.ZERO;
            }
            if (!exchangeRateMap.containsKey(project.getPkValue())) continue;
            hashMap.put(budget.getPkValue().toString(), budgetAmount.add(amount.multiply((BigDecimal)exchangeRateMap.get(project.getPkValue()))));
        }
        return hashMap;
    }

    private void auditValid(ExtendedDataEntity[] dataEntities) {
        HashSet<Object> contractid = new HashSet<Object>();
        if (dataEntities != null && dataEntities.length > 0) {
            for (ExtendedDataEntity dataEntity : dataEntities) {
                DynamicObject bill = dataEntity.getDataEntity();
                if (!StringUtils.equals((CharSequence)bill.getString("billstatus"), (CharSequence)StatusEnum.UNCHECKED.getValue())) {
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u5fc5\u987b\u4e3a\u5df2\u63d0\u4ea4\u624d\u80fd\u5ba1\u6838\u3002", (String)"FinalSettleValidator_8", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObject contract = bill.getDynamicObject("contract");
                QFilter qFilter = new QFilter("contract", "=", contract.getPkValue()).and(new QFilter("billstatus", "=", (Object)"C"));
                QFilter[] qFilters = new QFilter[]{qFilter};
                String direction = contract.getString("paydirection");
                String formBillId = null;
                if (StringUtils.equalsIgnoreCase((CharSequence)direction, (CharSequence)PayDirectionEnum.IN.getValue())) {
                    formBillId = "pmct_infinalsettle";
                } else if (StringUtils.equalsIgnoreCase((CharSequence)direction, (CharSequence)PayDirectionEnum.OUT.getValue())) {
                    formBillId = "pmct_outfinalsettle";
                }
                boolean flag = QueryServiceHelper.exists((String)formBillId, (QFilter[])qFilters);
                if (flag || contractid.contains(contract.getPkValue())) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5408\u540c\u53ea\u80fd\u505a\u4e00\u6b21\u51b3\u7b97\u3002", (String)"FinalSettleValidator_0", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                    continue;
                }
                contractid.add(contract.getPkValue());
            }
        }
    }

    private Set<Object> getProIdSetWithMultiSettle(DynamicObject bill) {
        HashSet<Object> proIdSet = new HashSet<Object>(1);
        DynamicObject contract = bill.getDynamicObject("contract");
        boolean multipartSettlement = (contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_contracttpl")).getBoolean("multipartsettlement");
        if (multipartSettlement) {
            DynamicObjectCollection entryEntity = bill.getDynamicObjectCollection("entryentity");
            proIdSet = new HashSet(entryEntity.size());
            for (DynamicObject entry : entryEntity) {
                DynamicObject budgetItem = entry.getDynamicObject("budgetitem");
                DynamicObject budgetProject = budgetItem.getDynamicObject("project");
                proIdSet.add(budgetProject.getPkValue());
            }
        }
        return proIdSet;
    }

    private boolean isProjectCostControl(DynamicObject bill) {
        DynamicObject[] proApps;
        DynamicObject project = bill.getDynamicObject("project");
        DynamicObject contract = bill.getDynamicObject("contract");
        contract = BusinessDataServiceHelper.loadSingle((String)"pmct_contracttpl", (String)"multipartsettlement", (QFilter[])new QFilter[]{new QFilter("id", "=", contract.getPkValue())});
        DynamicObjectCollection entryEntity = bill.getDynamicObjectCollection("entryentity");
        if (entryEntity.isEmpty()) {
            return false;
        }
        boolean multipartSettlement = contract.getBoolean("multipartsettlement");
        if (multipartSettlement) {
            DynamicObject[] proApps2;
            HashSet<Object> proIdSet = new HashSet<Object>();
            for (DynamicObject entry : entryEntity) {
                DynamicObject budgetItem = entry.getDynamicObject("budgetitem");
                DynamicObject budgetProject = budgetItem.getDynamicObject("project");
                proIdSet.add(budgetProject.getPkValue());
            }
            for (DynamicObject proApp : proApps2 = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"projectcostcontrol", (QFilter[])new QFilter[]{new QFilter("pro", "in", proIdSet)})) {
                boolean projectCostControl = proApp.getBoolean("projectcostcontrol");
                if (!projectCostControl) continue;
                return true;
            }
        } else if (project != null && (proApps = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"projectcostcontrol", (QFilter[])new QFilter[]{new QFilter("pro", "=", project.getPkValue())})) != null && proApps.length > 0 && proApps[0].getBoolean("projectcostcontrol")) {
            return true;
        }
        return false;
    }
}

