/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.opplugin.invoice;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.ksql.util.StringUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.business.helper.ContractHelper;
import kd.pmgt.pmbs.common.enums.InvoiceSellerParamEnum;
import kd.pmgt.pmbs.common.enums.InvoiceSourceEnum;
import kd.pmgt.pmbs.common.enums.OperationEnum;
import kd.pmgt.pmct.business.helper.InvoiceHelper;
import kd.pmgt.pmct.opplugin.AbstractReverseWritingPmctContractOp;

public class InInvoiceOp
extends AbstractReverseWritingPmctContractOp {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fields = e.getFieldKeys();
        fields.add("id");
        fields.add("billno");
        fields.add("invoiceno");
        fields.add("invoicecode");
        fields.add("totalamount");
        fields.add("totaltax");
        fields.add("totaloftaxamount");
        fields.add("contract");
        fields.add("billstatus");
        fields.add("project");
        fields.add("isclaimed");
        fields.add("receiver");
        fields.add("receivedate");
        fields.add("isreceived");
        fields.add("connecttype");
        fields.add("source");
        fields.add("contpartb");
        fields.add("seller");
        fields.add("contract.contstatus");
        fields.add("contract.partb");
        fields.add("totaluseamt");
        fields.add("invoicestatus");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities;
                String invoiceSellerParam = ContractHelper.getInvoiceSellerParam();
                for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                    DynamicObject quoteBill;
                    boolean isClaimed;
                    DynamicObject invoice;
                    String key = this.getOperateKey();
                    if (StringUtils.equals((CharSequence)key, (CharSequence)OperationEnum.SUBMIT.getValue())) {
                        boolean exists;
                        long curInvoiceId;
                        invoice = dataEntity.getDataEntity();
                        String invoiceNo = invoice.getString("invoiceno");
                        String invoiceCode = invoice.getString("invoicecode");
                        QFilter qFilter = new QFilter("invoiceno", "=", (Object)invoiceNo);
                        if (!StringUtils.isEmpty((CharSequence)invoiceCode)) {
                            qFilter.and("invoicecode", "=", (Object)invoiceCode);
                        }
                        if (QueryServiceHelper.exists((String)"pmct_ininvoice", (Object)(curInvoiceId = Long.parseLong(invoice.getPkValue().toString())))) {
                            qFilter.and("id", "!=", (Object)curInvoiceId);
                        }
                        if (exists = QueryServiceHelper.exists((String)"pmct_ininvoice", (QFilter[])new QFilter[]{qFilter})) {
                            String errorTip = String.format(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801\u4e3a[%1$s]\u7684\u53d1\u7968\u5df2\u7ecf\u5728\u8fdb\u9879\u53d1\u7968\u6c60\u4e2d\u5b58\u5728\u3002", (String)"InInvoiceOp_9", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), invoiceNo);
                            if (!StringUtils.isEmpty((CharSequence)invoiceCode)) {
                                errorTip = String.format(ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801\u4e3a[%1$s],\u53d1\u7968\u53f7\u7801\u4e3a[%2$s]\u7684\u53d1\u7968\u5df2\u7ecf\u5728\u8fdb\u9879\u53d1\u7968\u6c60\u4e2d\u5b58\u5728\u3002", (String)"InInvoiceOp_10", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), invoiceCode, invoiceNo);
                            }
                            this.addErrorMessage(dataEntity, errorTip);
                        }
                        BigDecimal totalUseAmt = invoice.getBigDecimal("totaluseamt");
                        DynamicObject contract = invoice.getDynamicObject("contract");
                        if (contract == null) {
                            if (totalUseAmt.compareTo(BigDecimal.ZERO) <= 0) continue;
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7d2f\u8ba1\u4f7f\u7528\u91d1\u989d\u5df2\u586b\u5199\uff0c\u8bf7\u5173\u8054\u652f\u51fa\u5408\u540c\u3002", (String)"InInvoiceOp_5", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                            continue;
                        }
                        String errorTip = "";
                        DynamicObject contPartB = invoice.getDynamicObject("contpartb");
                        DynamicObject seller = invoice.getDynamicObject("seller");
                        if (contPartB == null && seller != null || contPartB != null && seller == null) {
                            errorTip = String.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u548c\u53d1\u7968\uff08\u53d1\u7968\u53f7\u7801\u4e3a%1$s\uff09\u9500\u552e\u65b9\u5173\u8054\u7684\u4f9b\u5e94\u5546\u4e0d\u4e00\u81f4\u3002", (String)"InInvoiceOp_12", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), invoiceNo);
                            if (!StringUtils.isEmpty((CharSequence)invoiceCode)) {
                                errorTip = String.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u548c\u53d1\u7968\uff08\u53d1\u7968\u4ee3\u7801\u4e3a%1$s\uff0c\u53d1\u7968\u53f7\u7801\u4e3a%2$s\uff09\u9500\u552e\u65b9\u5173\u8054\u7684\u4f9b\u5e94\u5546\u4e0d\u4e00\u81f4\u3002", (String)"InInvoiceOp_8", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), invoiceCode, invoiceNo);
                            }
                        }
                        if (contPartB != null && seller != null) {
                            DynamicObject bizPartner = (contPartB = BusinessDataServiceHelper.loadSingle((Object)contPartB.getPkValue(), (String)"bd_supplier")).getDynamicObject("bizpartner");
                            if (bizPartner == null) {
                                errorTip = String.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u548c\u53d1\u7968\uff08\u53d1\u7968\u53f7\u7801\u4e3a%1$s\uff09\u9500\u552e\u65b9\u5173\u8054\u7684\u4f9b\u5e94\u5546\u4e0d\u4e00\u81f4\u3002", (String)"InInvoiceOp_12", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), invoiceNo);
                                if (!StringUtils.isEmpty((CharSequence)invoiceCode)) {
                                    errorTip = String.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u548c\u53d1\u7968\uff08\u53d1\u7968\u4ee3\u7801\u4e3a%1$s\uff0c\u53d1\u7968\u53f7\u7801\u4e3a%2$s\uff09\u9500\u552e\u65b9\u5173\u8054\u7684\u4f9b\u5e94\u5546\u4e0d\u4e00\u81f4\u3002", (String)"InInvoiceOp_8", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), invoiceCode, invoiceNo);
                                }
                            } else {
                                long bizPartnerId;
                                long sellerId = Long.parseLong(seller.getPkValue().toString());
                                if (sellerId != (bizPartnerId = Long.parseLong(bizPartner.getPkValue().toString()))) {
                                    errorTip = String.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u548c\u53d1\u7968\uff08\u53d1\u7968\u53f7\u7801\u4e3a%1$s\uff09\u9500\u552e\u65b9\u5173\u8054\u7684\u4f9b\u5e94\u5546\u4e0d\u4e00\u81f4\u3002", (String)"InInvoiceOp_12", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), invoiceNo);
                                    if (!StringUtils.isEmpty((CharSequence)invoiceCode)) {
                                        errorTip = String.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u548c\u53d1\u7968\uff08\u53d1\u7968\u4ee3\u7801\u4e3a%1$s\uff0c\u53d1\u7968\u53f7\u7801\u4e3a%2$s\uff09\u9500\u552e\u65b9\u5173\u8054\u7684\u4f9b\u5e94\u5546\u4e0d\u4e00\u81f4\u3002", (String)"InInvoiceOp_8", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), invoiceCode, invoiceNo);
                                    }
                                }
                            }
                        }
                        if (StringUtil.isEmpty((String)errorTip)) continue;
                        if (InvoiceSellerParamEnum.STRICTCTRL.getValue().equals(invoiceSellerParam)) {
                            this.addErrorMessage(dataEntity, errorTip);
                        }
                        if (!InvoiceSellerParamEnum.REMINDCTRL.getValue().equals(invoiceSellerParam)) continue;
                        this.addWarningMessage(dataEntity, errorTip);
                        continue;
                    }
                    if (!StringUtils.equals((CharSequence)key, (CharSequence)"unclaim") && !StringUtils.equals((CharSequence)key, (CharSequence)"unaudit")) continue;
                    invoice = dataEntity.getDataEntity();
                    if (StringUtils.equals((CharSequence)key, (CharSequence)"unclaim") && !(isClaimed = invoice.getBoolean("isclaimed"))) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53d1\u7968\u672a\u8ba4\u9886\uff0c\u65e0\u6cd5\u53cd\u8ba4\u9886\u3002", (String)"InInvoiceOp_17", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                    }
                    if ((quoteBill = InvoiceHelper.verifyUnClaim((DynamicObject)invoice)) == null) continue;
                    String errorTip = String.format(ResManager.loadKDString((String)"\u5df2\u5728\u4e1a\u52a1\u5355\u636e\u4ed8\u6b3e\u7533\u8bf7\u5355\u7f16\u7801\u4e3a\uff1a%1$s\u4e2d\u8ba4\u9886\uff0c\u4e0d\u5141\u8bb8\u53cd\u8ba4\u9886\u6216\u53cd\u5ba1\u6838\u3002", (String)"InInvoiceOp_18", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), quoteBill.getString("billno"));
                    this.addErrorMessage(dataEntity, errorTip);
                }
            }
        });
    }

    @Override
    public void reverseWritingToContract(String operationKey, DynamicObject source) {
        DynamicObject contract = source.getDynamicObject("contract");
        switch (operationKey) {
            case "audit": 
            case "unaudit": {
                if (contract == null) break;
                ContractHelper.updateContractInvoiceAmount((DynamicObject)contract, (DynamicObject)source, (String)operationKey);
                break;
            }
            case "noncontclaim": {
                String projectId = this.operateOption.getVariableValue("project_id");
                source.set("project", (Object)projectId);
                source.set("isclaimed", (Object)Boolean.TRUE);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{source});
                break;
            }
            case "unclaim": {
                source.set("contract", null);
                source.set("project", null);
                source.set("contpartb", null);
                source.set("isclaimed", (Object)Boolean.FALSE);
                source.set("totaluseamt", (Object)BigDecimal.ZERO);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{source});
                ContractHelper.updateContractInvoiceAmount((DynamicObject)contract, (DynamicObject)source, (String)operationKey);
                break;
            }
            case "receive": {
                Long receiverId = Long.valueOf(this.operateOption.getVariableValue("receiver_id"));
                Date receiveDate = new Date(Long.parseLong(this.operateOption.getVariableValue("receive_date")));
                source.set("receiver", (Object)receiverId);
                source.set("receivedate", (Object)receiveDate);
                source.set("isreceived", (Object)Boolean.TRUE);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{source});
                break;
            }
            case "unreceive": {
                source.set("receiver", null);
                source.set("receivedate", null);
                source.set("isreceived", (Object)Boolean.FALSE);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{source});
                break;
            }
        }
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        block4: {
            List listingEnts;
            String operateKey;
            block3: {
                super.beforeExecuteOperationTransaction(e);
                operateKey = e.getOperationKey();
                listingEnts = e.getValidExtDataEntities();
                if (!"unaudit".equals(operateKey) && !"audit".equals(operateKey)) break block3;
                for (ExtendedDataEntity listingEnt : listingEnts) {
                    String contStatus;
                    DynamicObject listing = listingEnt.getDataEntity();
                    DynamicObject contract = listing.getDynamicObject("contract");
                    if (contract != null && StringUtils.equals((CharSequence)"04", (CharSequence)(contStatus = (contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_outcontract")).getString("contstatus")))) {
                        this.addErrMessage(listingEnt, ResManager.loadKDString((String)"\u5408\u540c\u5df2\u5173\u95ed\uff0c\u4e0d\u5141\u8bb8\u5ba1\u6838\u548c\u53cd\u5ba1\u6838\u3002", (String)"InInvoiceOp_13", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                        e.cancel = true;
                    }
                    if (!"unaudit".equals(operateKey)) continue;
                    String source = listing.getString("source");
                    if (!InvoiceSourceEnum.SOURCE_04.getValue().equals(source)) continue;
                    this.addErrMessage(listingEnt, String.format(ResManager.loadKDString((String)"%s\uff1a\u5916\u90e8\u5bfc\u5165\u7684\u53d1\u7968\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"InInvoiceOp_14", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), listing.getString("billno")));
                    e.cancel = true;
                }
                break block4;
            }
            if (!"unreceive".equals(operateKey)) break block4;
            for (ExtendedDataEntity listingEnt : listingEnts) {
                DynamicObject listing = listingEnt.getDataEntity();
                boolean aBoolean = listing.getBoolean("isreceived");
                if (aBoolean) continue;
                this.addErrMessage(listingEnt, ResManager.loadKDString((String)"\u672a\u6536\u5b9e\u7968\u4e0d\u80fd\u53d6\u6d88\u6536\u7968\u3002", (String)"InInvoiceOp_7", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                e.cancel = true;
            }
        }
    }

    private void addErrMessage(ExtendedDataEntity dataEntity, String errMsg) {
        Object pkId = dataEntity.getDataEntity().getPkValue();
        int dataIndex = dataEntity.getDataEntityIndex();
        int rowIndex = 0;
        ErrorLevel errorLevel = ErrorLevel.Error;
        ValidationErrorInfo errInfo = new ValidationErrorInfo("", pkId, dataIndex, rowIndex, "BeforeExecuteOperationTransactionSample", ResManager.loadKDString((String)"\u72b6\u6001\u68c0\u67e5", (String)"InInvoiceOp_2", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), errMsg, errorLevel);
        this.operationResult.addErrorInfo((OperateErrorInfo)errInfo);
    }
}

