/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.opplugin.invoice;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.business.helper.ContractHelper;
import kd.pmgt.pmbs.common.enums.InvoiceSourceEnum;
import kd.pmgt.pmbs.common.enums.InvoiceStatusEnum;
import kd.pmgt.pmbs.common.enums.OperationEnum;
import kd.pmgt.pmct.opplugin.AbstractReverseWritingPmctContractOp;

public class OutInvoiceOp
extends AbstractReverseWritingPmctContractOp {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fields = e.getFieldKeys();
        fields.add("id");
        fields.add("totalamount");
        fields.add("totaltax");
        fields.add("totaloftaxamount");
        fields.add("contract");
        fields.add("source");
        fields.add("billstatus");
        fields.add("project");
        fields.add("isclaimed");
        fields.add("connecttype");
        fields.add("invoicecode");
        fields.add("invoiceno");
        fields.add("billno");
        fields.add("contract.contstatus");
        fields.add("invoicestatus");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities;
                for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                    DynamicObject[] incomeInvoices;
                    String source;
                    boolean isClaimed;
                    DynamicObject invoice;
                    String key = this.getOperateKey();
                    if (StringUtils.equals((CharSequence)key, (CharSequence)OperationEnum.SUBMIT.getValue())) {
                        boolean exists;
                        long curInvoiceId;
                        invoice = dataEntity.getDataEntity();
                        String invoiceNo = invoice.getString("invoiceno");
                        String invoiceCode = invoice.getString("invoicecode");
                        QFilter qFilter = new QFilter("invoiceno", "=", (Object)invoiceNo);
                        if (!StringUtils.isEmpty((CharSequence)invoiceCode)) {
                            qFilter.and("invoicecode", "=", (Object)invoiceCode);
                        }
                        if (QueryServiceHelper.exists((String)"pmct_outinvoice", (Object)(curInvoiceId = Long.parseLong(invoice.getPkValue().toString())))) {
                            qFilter.and("id", "!=", (Object)curInvoiceId);
                        }
                        if (!(exists = QueryServiceHelper.exists((String)"pmct_outinvoice", (QFilter[])new QFilter[]{qFilter}))) continue;
                        String errorTip = String.format(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801\u4e3a[%1$s]\u7684\u53d1\u7968\u5df2\u7ecf\u5728\u9500\u9879\u53d1\u7968\u6c60\u4e2d\u5b58\u5728\u3002", (String)"OutInvoiceOp_0", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), invoiceNo);
                        if (!StringUtils.isEmpty((CharSequence)invoiceCode)) {
                            errorTip = String.format(ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801\u4e3a[%1$s],\u53d1\u7968\u53f7\u7801\u4e3a[%2$s]\u7684\u53d1\u7968\u5df2\u7ecf\u5728\u9500\u9879\u53d1\u7968\u6c60\u4e2d\u5b58\u5728\u3002", (String)"OutInvoiceOp_1", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), invoiceCode, invoiceNo);
                        }
                        this.addErrorMessage(dataEntity, errorTip);
                        continue;
                    }
                    if (!StringUtils.equals((CharSequence)key, (CharSequence)"unclaim") && !StringUtils.equals((CharSequence)key, (CharSequence)"unaudit")) continue;
                    invoice = dataEntity.getDataEntity();
                    if (StringUtils.equals((CharSequence)key, (CharSequence)"unclaim") && !(isClaimed = invoice.getBoolean("isclaimed"))) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53d1\u7968\u672a\u8ba4\u9886\uff0c\u65e0\u6cd5\u53cd\u8ba4\u9886\u3002", (String)"OutInvoiceOp_2", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                    }
                    if (StringUtils.equals((CharSequence)(source = invoice.getString("source")), (CharSequence)InvoiceSourceEnum.SOURCE_05.getValue())) {
                        if (key.equals("unaudit")) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53d1\u7968\u4e91\u5bfc\u5165\u7684\u53d1\u7968\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\uff0c\u5982\u9700\u4f5c\u5e9f\u6216\u51b2\u9500\uff0c\u8bf7\u524d\u5f80\u53d1\u7968\u4e91\u64cd\u4f5c\u3002", (String)"OutInvoiceOp_3", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                        } else if (key.equals("unclaim")) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53d1\u7968\u4e91\u5bfc\u5165\u7684\u53d1\u7968\u4e0d\u5141\u8bb8\u53cd\u8ba4\u9886\u3002", (String)"OutInvoiceOp_4", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                        }
                    }
                    String invoiceId = invoice.getPkValue().toString();
                    for (DynamicObject incomeInvoice : incomeInvoices = BusinessDataServiceHelper.load((String)"pmct_incomeapplyinvoice", (String)"invoice,entryid", (QFilter[])new QFilter[0])) {
                        DynamicObject bill;
                        if (incomeInvoice.getDynamicObject("invoice") == null || !invoiceId.equals(incomeInvoice.getDynamicObject("invoice").getString("id")) || (bill = BusinessDataServiceHelper.loadSingle((String)"pmct_incomeapply", (String)"billno,entryentity.id", (QFilter[])new QFilter[]{new QFilter("entryentity.id", "=", (Object)incomeInvoice.getLong("entryid"))})) == null) continue;
                        if (key.equals("unaudit")) {
                            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5df2\u5728\u4e1a\u52a1\u5355\u636e\u8bf7\u6b3e\u5355\u7f16\u7801\u4e3a\uff1a%1$s\u4e2d\u8ba4\u9886\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"OutInvoiceOp_5", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), bill.getString("billno")));
                            continue;
                        }
                        if (!key.equals("unclaim")) continue;
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5df2\u5728\u4e1a\u52a1\u5355\u636e\u8bf7\u6b3e\u5355\u7f16\u7801\u4e3a\uff1a%1$s\u4e2d\u8ba4\u9886\uff0c\u4e0d\u5141\u8bb8\u53cd\u8ba4\u9886\u3002", (String)"OutInvoiceOp_6", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), bill.getString("billno")));
                    }
                }
            }
        });
    }

    @Override
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String operationKey = e.getOperationKey();
        if (operationKey.equals("audit")) {
            for (DynamicObject dataEntity : e.getDataEntities()) {
                DynamicObjectCollection reverseInvoices;
                DynamicObject outInvoice = BusinessDataServiceHelper.loadSingle((Object)dataEntity.getPkValue(), (String)"pmct_outinvoice");
                BigDecimal totalOfTaxAmount = outInvoice.getBigDecimal("totaloftaxamount");
                if (totalOfTaxAmount.compareTo(BigDecimal.ZERO) >= 0 || (reverseInvoices = outInvoice.getDynamicObjectCollection("reverseinvoice")) == null || reverseInvoices.size() <= 0) continue;
                reverseInvoices.forEach(reverseIVo -> {
                    Long blueInvoicesId = Long.parseLong(reverseIVo.getDynamicObject("fbasedataid").get("id").toString());
                    DynamicObject blueInvoice = BusinessDataServiceHelper.loadSingle((Object)blueInvoicesId, (String)"pmct_outinvoice");
                    DynamicObjectCollection blueReverses = blueInvoice.getDynamicObjectCollection("reverseinvoice");
                    Set<Object> redInvoicesIds = new HashSet();
                    if (blueReverses != null && blueReverses.size() > 0) {
                        redInvoicesIds = blueReverses.stream().map(item -> Long.parseLong(item.getDynamicObject("fbasedataid").get("id").toString())).collect(Collectors.toSet());
                    }
                    BigDecimal totalOfTaxAmt = totalOfTaxAmount;
                    if (redInvoicesIds.size() > 0) {
                        DynamicObject[] redInvoices;
                        for (DynamicObject redInvoice : redInvoices = BusinessDataServiceHelper.load((String)"pmct_outinvoice", (String)"totaloftaxamount", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)redInvoicesIds.toArray())})) {
                            totalOfTaxAmt = totalOfTaxAmt.add(redInvoice.getBigDecimal("totaloftaxamount"));
                        }
                    }
                    if (blueInvoice.getBigDecimal("totaloftaxamount").compareTo(BigDecimal.ZERO.subtract(totalOfTaxAmt)) == 0) {
                        blueInvoice.set("invoicestatus", (Object)InvoiceStatusEnum.REDPUNCHING_3.getValue());
                    }
                    if (blueReverses != null) {
                        DynamicObject redVo = new DynamicObject(blueReverses.getDynamicObjectType());
                        redVo.set("fbasedataid", (Object)outInvoice);
                        blueReverses.add((Object)redVo);
                    }
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{blueInvoice});
                });
            }
        }
        super.beginOperationTransaction(e);
    }

    @Override
    public void reverseWritingToContract(String operationKey, DynamicObject source) {
        switch (operationKey) {
            case "audit": 
            case "unaudit": {
                DynamicObject contract = source.getDynamicObject("contract");
                if (contract == null) break;
                ContractHelper.updateContractInvoiceAmount((DynamicObject)contract, (DynamicObject)source, (String)operationKey);
                break;
            }
            case "claim": {
                String contractId = this.operateOption.getVariableValue("contract_id");
                DynamicObject contract = BusinessDataServiceHelper.loadSingle((Object)contractId, (String)"pmct_incontract");
                source.set("contract", (Object)contract);
                source.set("project", (Object)contract.getDynamicObject("project"));
                source.set("isclaimed", (Object)Boolean.TRUE);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{source});
                ContractHelper.updateContractInvoiceAmount((DynamicObject)contract, (DynamicObject)source, (String)operationKey);
                break;
            }
            case "unclaim": {
                DynamicObject contract = source.getDynamicObject("contract");
                source.set("contract", null);
                source.set("project", null);
                source.set("isclaimed", (Object)Boolean.FALSE);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{source});
                ContractHelper.updateContractInvoiceAmount((DynamicObject)contract, (DynamicObject)source, (String)operationKey);
                break;
            }
        }
    }
}

