/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.opplugin.register;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.business.helper.ContractCollectItemHelper;
import kd.pmgt.pmbs.common.enums.OperationEnum;
import kd.pmgt.pmbs.common.enums.PerformAmountTypeEnum;
import kd.pmgt.pmbs.common.utils.NumberHelper;
import kd.pmgt.pmbs.common.utils.budget.BudgetValidateAndUpdateHelper;
import kd.pmgt.pmbs.common.utils.budget.PerformBillInfo;
import kd.pmgt.pmbs.common.utils.budget.PerformBillInfoBuilder;
import kd.pmgt.pmct.opplugin.AbstractReverseWritingPmctContractOp;

public class IncomeRegisterOp
extends AbstractReverseWritingPmctContractOp {
    private static final String OP_RECCONFIRM = "recconfirm";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fields = e.getFieldKeys();
        fields.add("entryentity");
        fields.add("receiptoftaxamount");
        fields.add("entrycontract");
        fields.add("receiptamount");
        fields.add("sourcetype");
        fields.add("project");
        fields.add("id");
        fields.add("currency");
        fields.add("creator");
        fields.add("createtime");
        fields.add("auditor");
        fields.add("auditdate");
        fields.add("billno");
        fields.add("billname");
        fields.add("entryentity");
        fields.add("contpro");
        fields.add("contcurrency");
        fields.add("subentryentity");
        fields.add("budgetitem");
        fields.add("contractamount");
        fields.add("receiptshareamount");
        fields.add("pushed");
        fields.add("isbillrec");
    }

    private void reverseWritingToContract(String operationKey, DynamicObject[] entities) {
        HashSet conIds = new HashSet();
        for (DynamicObject entity : entities) {
            Set curConIds;
            DynamicObjectCollection entryEntity = entity.getDynamicObjectCollection("entryentity");
            if (entryEntity.size() <= 0 || (curConIds = entryEntity.stream().filter(cont -> null != cont.getDynamicObject("entrycontract")).map(cont -> cont.getDynamicObject("entrycontract").getLong("id")).collect(Collectors.toSet())).size() <= 0) continue;
            conIds.addAll(curConIds);
        }
        HashMap<String, DynamicObject> conDynMap = new HashMap<String, DynamicObject>(conIds.size());
        if (conIds.size() > 0) {
            DynamicObject[] contracts;
            for (DynamicObject contract : contracts = BusinessDataServiceHelper.load((Object[])conIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_incontract"))) {
                conDynMap.put(contract.getPkValue().toString(), contract);
            }
        }
        for (DynamicObject entity : entities) {
            DynamicObjectCollection entryEntity;
            Map sourceBills;
            HashSet sourcePks;
            boolean isPush = entity.getBoolean("pushed");
            if (isPush && (sourcePks = (sourceBills = BFTrackerServiceHelper.findSourceBills((String)"pmct_incomeregister", (Long[])new Long[]{(Long)entity.getPkValue()})).getOrDefault("pmct_incomeapply", new HashSet())).isEmpty() || (entryEntity = entity.getDynamicObjectCollection("entryentity")).size() == 0) continue;
            for (DynamicObject cont2 : entryEntity) {
                DynamicObject contract = cont2.getDynamicObject("entrycontract");
                if (contract == null) continue;
                BigDecimal thisReceiptOfTaxAmount = NumberHelper.toBigDecimal((Object)cont2.getBigDecimal("receiptoftaxamount"));
                String contractId = contract.getPkValue().toString();
                if ((contract = (DynamicObject)conDynMap.get(contractId)) == null) continue;
                BigDecimal totalRealOfTaxAmount = NumberHelper.toBigDecimal((Object)contract.getBigDecimal("totalrealoftaxamount"));
                BigDecimal totalRealAmount = NumberHelper.toBigDecimal((Object)contract.get("totalrealamount"));
                BigDecimal thisReceiptAmount = cont2.getBigDecimal("receiptamount");
                if (operationKey.equals("audit")) {
                    contract.set("totalrealoftaxamount", (Object)totalRealOfTaxAmount.add(thisReceiptOfTaxAmount));
                    contract.set("totalrealamount", (Object)totalRealAmount.add(thisReceiptAmount));
                } else if (operationKey.equals("unaudit")) {
                    contract.set("totalrealoftaxamount", (Object)totalRealOfTaxAmount.subtract(thisReceiptOfTaxAmount));
                    contract.set("totalrealamount", (Object)totalRealAmount.subtract(thisReceiptAmount));
                }
                conDynMap.put(contractId, contract);
            }
        }
        if (!conDynMap.isEmpty()) {
            ArrayList updateContracts = new ArrayList(conDynMap.values());
            SaveServiceHelper.save((DynamicObject[])updateContracts.toArray(new DynamicObject[0]));
        }
    }

    @Override
    @Deprecated
    public void reverseWritingToContract(String operationKey, DynamicObject source) {
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities;
                String operateKey = this.getOperateKey();
                for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                    DynamicObject incomeRegBill = dataEntity.getDataEntity();
                    if (StringUtils.equals((CharSequence)operateKey, (CharSequence)OperationEnum.SUBMIT.getValue())) {
                        if (incomeRegBill.getBoolean("pushed")) continue;
                        DynamicObjectCollection registInfoEntry = incomeRegBill.getDynamicObjectCollection("entryentity");
                        if (registInfoEntry == null || registInfoEntry.isEmpty()) {
                            return;
                        }
                        this.incomeRegistAmountValidate(dataEntity, incomeRegBill, registInfoEntry);
                        continue;
                    }
                    if (!operateKey.equals(IncomeRegisterOp.OP_RECCONFIRM)) continue;
                    DynamicObjectCollection entryEntities = dataEntity.getDataEntity().getDynamicObjectCollection("entryentity");
                    Map<Object, BigDecimal> entryAmtSumMap = entryEntities.stream().collect(Collectors.toMap(obj -> obj.getLong("sourceentryid"), val -> val.getBigDecimal("receiptoftaxamount")));
                    DynamicObject payApply = BusinessDataServiceHelper.loadSingle((String)"pmct_incomeapply", (QFilter[])new QFilter[]{new QFilter("entryentity.id", "in", entryAmtSumMap.keySet())});
                    DynamicObjectCollection payItems = payApply.getDynamicObjectCollection("entryentity");
                    boolean isError = false;
                    for (DynamicObject payItem : payItems) {
                        BigDecimal thisPayAmount;
                        BigDecimal entryPayAmount = payItem.getBigDecimal("entryrecamount");
                        BigDecimal entryLockAmount = payItem.getBigDecimal("entrylockamount");
                        BigDecimal thispayableamount = payItem.getBigDecimal("applyoftaxamount");
                        DynamicObject contract = payItem.getDynamicObject("entrycontract");
                        BigDecimal bigDecimal = thisPayAmount = entryAmtSumMap.get(payItem.getPkValue()) != null ? entryAmtSumMap.get(payItem.getPkValue()) : BigDecimal.ZERO;
                        if (entryLockAmount.add(thisPayAmount).compareTo(thispayableamount) > 0) {
                            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u7684\u201c\u5df2\u9501\u5b9a\u542b\u7a0e\u91d1\u989d\u201d\u5c06\u8d85\u51fa\u9650\u989d\u3002", (String)"IncomeRegisterOp_2", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), contract.getString("billname")));
                            isError = true;
                            continue;
                        }
                        if (entryPayAmount.add(thisPayAmount).compareTo(thispayableamount) <= 0) continue;
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u7684\u201c\u5df2\u5b9e\u6536\u542b\u7a0e\u91d1\u989d\u201d\u5c06\u8d85\u51fa\u9650\u989d\u3002", (String)"IncomeRegisterOp_3", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), contract.getString("billname")));
                        isError = true;
                    }
                    if (isError) continue;
                    this.addWarningMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u786e\u8ba4\u6536\u6b3e\u201d\u64cd\u4f5c\u4e0d\u53ef\u9006\uff0c\u8bf7\u68c0\u67e5\u672c\u6b21\u5b9e\u6536\u542b\u7a0e\u91d1\u989d\u662f\u5426\u6b63\u786e\uff0c\u662f\u5426\u786e\u8ba4\u6536\u6b3e\uff1f", (String)"IncomeRegisterOp_5", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                }
            }

            private boolean incomeRegistAmountValidate(ExtendedDataEntity dataEntity, DynamicObject bill, DynamicObjectCollection infoEntry) {
                for (DynamicObject contractEntryRow : infoEntry) {
                    boolean projectCostControl = this.isProjectCostControl(bill, contractEntryRow);
                    if (!projectCostControl) continue;
                    DynamicObjectCollection incomeSplitEntry = contractEntryRow.getDynamicObjectCollection("subentryentity");
                    BigDecimal curSplitTotalAmount = BigDecimal.ZERO;
                    for (DynamicObject entry : incomeSplitEntry) {
                        BigDecimal curSplitAmount = entry.getBigDecimal("receiptshareamount");
                        if (curSplitAmount.compareTo(BigDecimal.ZERO) == 0) continue;
                        curSplitTotalAmount = curSplitTotalAmount.add(curSplitAmount);
                    }
                    BigDecimal curReceiptTotal = contractEntryRow.getBigDecimal("receiptoftaxamount");
                    if (curReceiptTotal.compareTo(curSplitTotalAmount) == 0) continue;
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff0c\u201c\u6536\u6b3e\u5206\u644a\u201d\u7684\u201c\u672c\u6b21\u5b9e\u6536\u5206\u644a\u91d1\u989d\u201d\u603b\u8ba1\u5e94\u7b49\u4e8e\u201c\u6536\u6b3e\u4fe1\u606f\u201d\u7684\u201c\u672c\u6b21\u5b9e\u6536\u542b\u7a0e\u603b\u91d1\u989d\u201d\u3002", (String)"IncomeRegisterOp_1", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                    return true;
                }
                return false;
            }

            private boolean isProjectCostControl(DynamicObject bill, DynamicObject contractEntry) {
                DynamicObject contract = contractEntry.getDynamicObject("entrycontract");
                contract = BusinessDataServiceHelper.loadSingle((String)"pmct_incontract", (String)"multipartsettlement,project", (QFilter[])new QFilter[]{new QFilter("id", "=", contract.getPkValue())});
                DynamicObjectCollection entryEntity = contractEntry.getDynamicObjectCollection("subentryentity");
                if (entryEntity.isEmpty()) {
                    return false;
                }
                boolean multipartSettlement = contract.getBoolean("multipartsettlement");
                if (multipartSettlement) {
                    DynamicObject project = bill.getDynamicObject("project");
                    if (project != null) {
                        DynamicObject[] proApps = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"projectcostcontrol", (QFilter[])new QFilter[]{new QFilter("pro", "=", project.getPkValue())});
                        if (proApps != null && proApps.length > 0 && proApps[0].getBoolean("projectcostcontrol")) {
                            return true;
                        }
                    } else {
                        DynamicObject[] proApps;
                        HashSet<Object> proIdSet = new HashSet<Object>(entryEntity.size());
                        for (DynamicObject entry : entryEntity) {
                            DynamicObject budgetItem = entry.getDynamicObject("budgetitem");
                            DynamicObject budgetProject = budgetItem.getDynamicObject("project");
                            proIdSet.add(budgetProject.getPkValue());
                        }
                        for (DynamicObject proApp : proApps = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"projectcostcontrol", (QFilter[])new QFilter[]{new QFilter("pro", "in", proIdSet)})) {
                            boolean projectCostControl = proApp.getBoolean("projectcostcontrol");
                            if (!projectCostControl) continue;
                            return true;
                        }
                    }
                } else {
                    DynamicObject[] proApps;
                    DynamicObject contPro = contract.getDynamicObject("project");
                    if (contPro != null && (proApps = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"projectcostcontrol", (QFilter[])new QFilter[]{new QFilter("pro", "=", contPro.getPkValue())})) != null && proApps.length > 0 && proApps[0].getBoolean("projectcostcontrol")) {
                        return true;
                    }
                }
                return false;
            }
        });
    }

    @Override
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String operationKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"submit") || StringUtils.equals((CharSequence)operationKey, (CharSequence)"unsubmit") || StringUtils.equals((CharSequence)operationKey, (CharSequence)"audit") || StringUtils.equals((CharSequence)operationKey, (CharSequence)"unaudit")) {
            if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"audit") || StringUtils.equals((CharSequence)operationKey, (CharSequence)"unaudit")) {
                this.reverseWritingToContract(operationKey, dataEntities);
            }
            this.updateBudgetData(dataEntities, operationKey);
            for (DynamicObject dataEntity : dataEntities) {
                boolean isPush = dataEntity.getBoolean("pushed");
                if (!"audit".equals(operationKey) || !isPush) continue;
                dataEntity.set("isbillrec", (Object)true);
            }
        }
    }

    protected void updateBudgetData(DynamicObject[] entities, String operationKey) {
        for (DynamicObject incomeBill : entities) {
            DynamicObject project = incomeBill.getDynamicObject("project");
            DynamicObjectCollection contractEntrys = incomeBill.getDynamicObjectCollection("entryentity");
            HashMap<String, DynamicObject> contractIdSet = new HashMap<String, DynamicObject>(16);
            HashMap<String, Map<String, BigDecimal>> contractToProAmountMap = new HashMap<String, Map<String, BigDecimal>>(16);
            HashMap<String, Map<String, BigDecimal>> contractToContAmountMap = new HashMap<String, Map<String, BigDecimal>>(16);
            for (DynamicObject contractEntryRow : contractEntrys) {
                DynamicObject contract = contractEntryRow.getDynamicObject("entrycontract");
                contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_incontract");
                contractIdSet.put(contract.getPkValue().toString(), contract.getDynamicObject("currency"));
                if (project != null) {
                    DynamicObject[] proApps = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"projectcostcontrol,org,currencyfield", (QFilter[])new QFilter[]{new QFilter("pro", "=", project.getPkValue())});
                    if (proApps != null && proApps.length > 0) {
                        this.buildBudgetAmountMap(contractToProAmountMap, contractEntryRow, BudgetValidateAndUpdateHelper.getExchangeRate((DynamicObject)contract, (DynamicObject)proApps[0]));
                    }
                } else {
                    Set<Object> proIdSet = this.getProIdSet(incomeBill, contractEntryRow);
                    this.buildBudgetAmountMap(contractToProAmountMap, contractEntryRow, proIdSet);
                }
                this.buildBudgetAmountMap(contractToContAmountMap, contractEntryRow, BigDecimal.ONE);
            }
            for (Map.Entry entry : contractIdSet.entrySet()) {
                PerformBillInfo billInfo;
                String contractId = (String)entry.getKey();
                DynamicObject contCurrency = (DynamicObject)entry.getValue();
                Map projectAmountMap = (Map)contractToProAmountMap.get(contractId);
                Map contractAmountMap = (Map)contractToContAmountMap.get(contractId);
                if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"submit")) {
                    billInfo = new PerformBillInfoBuilder().formBillId("pmct_incomeregister").billNo(incomeBill.getString("billno")).billName(incomeBill.getString("billname")).creator(incomeBill.getDynamicObject("creator")).createDate(incomeBill.getDate("createtime")).id(incomeBill.getLong("id")).contractId(contractId).amountType(PerformAmountTypeEnum.ACTUAL_INCOME).contractCurrency(contCurrency).build();
                    BudgetValidateAndUpdateHelper.updateBudgetOnSubmit((Map)projectAmountMap, (Map)contractAmountMap, (PerformBillInfo)billInfo);
                    continue;
                }
                if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"unsubmit")) {
                    billInfo = new PerformBillInfoBuilder().formBillId("pmct_incomeregister").id(incomeBill.getLong("id")).contractId(contractId).amountType(PerformAmountTypeEnum.ACTUAL_INCOME).build();
                    BudgetValidateAndUpdateHelper.updateBudgetOnUnsubmit((Map)projectAmountMap, (Map)contractAmountMap, (PerformBillInfo)billInfo);
                    continue;
                }
                if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"audit")) {
                    billInfo = new PerformBillInfoBuilder().formBillId("pmct_incomeregister").billNo(incomeBill.getString("billno")).billName(incomeBill.getString("billname")).creator(incomeBill.getDynamicObject("creator")).createDate(incomeBill.getDate("createtime")).auditor(incomeBill.getDynamicObject("auditor")).auditDate(incomeBill.getDate("auditdate")).id(incomeBill.getLong("id")).contractId(contractId).amountType(PerformAmountTypeEnum.ACTUAL_INCOME).build();
                    BudgetValidateAndUpdateHelper.updateBudgetOnAudit((Map)projectAmountMap, (Map)contractAmountMap, (PerformBillInfo)billInfo);
                    continue;
                }
                if (!StringUtils.equals((CharSequence)operationKey, (CharSequence)"unaudit")) continue;
                BudgetValidateAndUpdateHelper.updateBudgetOnUnaudit((Map)projectAmountMap, (Map)contractAmountMap, (String)"pmct_incomeregister", (long)incomeBill.getLong("id"), (String)contractId, (PerformAmountTypeEnum)PerformAmountTypeEnum.ACTUAL_INCOME);
            }
        }
    }

    private Set<Object> getProIdSet(DynamicObject payBill, DynamicObject contractEntryRow) {
        HashSet<Object> proIdSet = new HashSet<Object>(1);
        DynamicObject contract = contractEntryRow.getDynamicObject("entrycontract");
        boolean multipartSettlement = (contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_incontract")).getBoolean("multipartsettlement");
        if (multipartSettlement) {
            DynamicObject project = payBill.getDynamicObject("project");
            if (project == null) {
                DynamicObjectCollection entryEntity = contractEntryRow.getDynamicObjectCollection("subentryentity");
                proIdSet = new HashSet(entryEntity.size());
                for (DynamicObject entry : entryEntity) {
                    DynamicObject budgetItem = entry.getDynamicObject("budgetitem");
                    DynamicObject budgetProject = budgetItem.getDynamicObject("project");
                    proIdSet.add(budgetProject.getPkValue());
                }
            }
        } else {
            DynamicObject contPro = contract.getDynamicObject("project");
            if (contPro != null) {
                proIdSet.add(contPro.getPkValue());
            }
        }
        return proIdSet;
    }

    /*
     * WARNING - void declaration
     */
    protected void buildBudgetAmountMap(Map<String, Map<String, BigDecimal>> contractToAmountMap, DynamicObject contractEntryRow, Set<Object> proIdSet) {
        void var8_12;
        DynamicObject contract = contractEntryRow.getDynamicObject("entrycontract");
        contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_incontract");
        DynamicObject[] proApps = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"pro,org,currencyfield", (QFilter[])new QFilter[]{new QFilter("pro", "in", proIdSet)});
        HashMap<Object, BigDecimal> exchangeRateMap = new HashMap<Object, BigDecimal>(16);
        if (proApps != null && proApps.length > 0) {
            for (DynamicObject proApp : proApps) {
                BigDecimal exchangeRate = BudgetValidateAndUpdateHelper.getExchangeRate((DynamicObject)contract, (DynamicObject)proApp);
                DynamicObject pro = proApp.getDynamicObject("pro");
                exchangeRateMap.put(pro.getPkValue(), exchangeRate);
            }
        } else {
            for (Object e : proIdSet) {
                exchangeRateMap.put(e, BigDecimal.ONE);
            }
        }
        DynamicObjectCollection entryentity = contractEntryRow.getDynamicObjectCollection("subentryentity");
        Map<String, BigDecimal> map = contractToAmountMap.get(contract.getPkValue().toString());
        if (map == null) {
            HashMap hashMap = new HashMap(16);
        }
        for (DynamicObject entry : entryentity) {
            DynamicObject project;
            BigDecimal amount = entry.getBigDecimal("receiptshareamount");
            DynamicObject budget = entry.getDynamicObject("budgetitem");
            if (budget == null || amount == null || amount.compareTo(BigDecimal.ZERO) == 0) continue;
            BigDecimal budgetAmount = (BigDecimal)var8_12.get(budget.getPkValue().toString());
            if (budgetAmount == null) {
                budgetAmount = BigDecimal.ZERO;
            }
            if (!exchangeRateMap.containsKey((project = budget.getDynamicObject("project")).getPkValue())) continue;
            var8_12.put(budget.getPkValue().toString(), budgetAmount.add(amount.multiply((BigDecimal)exchangeRateMap.get(project.getPkValue()))));
        }
        contractToAmountMap.put(contract.getPkValue().toString(), (Map<String, BigDecimal>)var8_12);
    }

    protected void buildBudgetAmountMap(Map<String, Map<String, BigDecimal>> contractToAmountMap, DynamicObject contractEntryRow, BigDecimal exchangeRate) {
        DynamicObject contract = contractEntryRow.getDynamicObject("entrycontract");
        Map<String, BigDecimal> budgetAmountMap = contractToAmountMap.get(contract.getPkValue().toString());
        if (budgetAmountMap == null) {
            budgetAmountMap = new HashMap<String, BigDecimal>(16);
        }
        DynamicObjectCollection entryentity = contractEntryRow.getDynamicObjectCollection("subentryentity");
        for (DynamicObject entry : entryentity) {
            BigDecimal amount = entry.getBigDecimal("receiptshareamount");
            DynamicObject budget = entry.getDynamicObject("budgetitem");
            if (budget == null || amount == null || amount.compareTo(BigDecimal.ZERO) == 0) continue;
            BigDecimal budgetAmount = budgetAmountMap.get(budget.getPkValue().toString());
            if (budgetAmount == null) {
                budgetAmount = BigDecimal.ZERO;
            }
            budgetAmountMap.put(budget.getPkValue().toString(), budgetAmount.add(amount.multiply(exchangeRate)));
        }
        contractToAmountMap.put(contract.getPkValue().toString(), budgetAmountMap);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        String operationKey = e.getOperationKey();
        if ("submit".equals(operationKey) || "unsubmit".equals(operationKey) || "audit".equals(operationKey) || "unaudit".equals(operationKey)) {
            DynamicObject[] dataEntities;
            for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
                DynamicObject incomeRegisterObj = BusinessDataServiceHelper.loadSingle((Object)dataEntity.getPkValue(), (String)"pmct_incomeregister");
                DynamicObjectCollection entryColl = incomeRegisterObj.getDynamicObjectCollection("entryentity");
                Map<Object, BigDecimal> entryAmtSumMap = this.getEntryAmtSumMap(entryColl);
                ContractCollectItemHelper.writeBackToCollectItemForIncomeRegister((String)operationKey, entryAmtSumMap);
                if (!"audit".equals(operationKey)) continue;
                dataEntity.set("isbillrec", (Object)true);
            }
        }
    }

    private Map<Object, BigDecimal> getEntryAmtSumMap(DynamicObjectCollection entryColl) {
        HashMap<Object, BigDecimal> entryAmtSumMap = new HashMap<Object, BigDecimal>(entryColl.size());
        for (DynamicObject entry : entryColl) {
            DynamicObject incomeItemObj = entry.getDynamicObject("incomeitem");
            BigDecimal receiptOfTaxAmt = entry.getBigDecimal("receiptoftaxamount");
            if (null == incomeItemObj || receiptOfTaxAmt.compareTo(BigDecimal.ZERO) <= 0) continue;
            if (entryAmtSumMap.containsKey(incomeItemObj.getPkValue())) {
                entryAmtSumMap.put(incomeItemObj.getPkValue(), ((BigDecimal)entryAmtSumMap.get(incomeItemObj.getPkValue())).add(receiptOfTaxAmt));
                continue;
            }
            entryAmtSumMap.put(incomeItemObj.getPkValue(), receiptOfTaxAmt);
        }
        return entryAmtSumMap;
    }
}

