/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.opplugin.register;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.business.helper.ContractPayItemHelper;
import kd.pmgt.pmct.opplugin.AbstractReverseWritingPmctContractOp;

public class PayRegisterOp
extends AbstractReverseWritingPmctContractOp {
    private static final String OP_PAYCONFIRM = "payconfirm";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fields = e.getFieldKeys();
        fields.addAll(this.billEntityType.getAllFields().keySet());
    }

    private void reverseWritingToContract(String operationKey, DynamicObject[] bills) {
        if ("submit".equals(operationKey) || OP_PAYCONFIRM.equals(operationKey)) {
            return;
        }
        ArrayList<DynamicObject> updateConBills = new ArrayList<DynamicObject>();
        for (DynamicObject payRegister : bills) {
            boolean isPush = payRegister.getBoolean("pushed");
            if (isPush) {
                Map sourceBills = BFTrackerServiceHelper.findSourceBills((String)"pmct_paymentregister", (Long[])new Long[]{(Long)payRegister.getPkValue()});
                HashSet sourcePks = sourceBills.getOrDefault("pmct_paymentapply", new HashSet());
                if (sourcePks.isEmpty()) continue;
                updateConBills.add(payRegister);
                continue;
            }
            updateConBills.add(payRegister);
        }
        if (updateConBills.size() > 0) {
            HashMap<Long, BigDecimal> sumContThisPaymentOfTaxAmt = new HashMap<Long, BigDecimal>();
            HashMap<Long, BigDecimal> sumContThisPaymentAmt = new HashMap<Long, BigDecimal>();
            for (DynamicObject payRegister : updateConBills) {
                DynamicObjectCollection entryEntity = payRegister.getDynamicObjectCollection("entryentity");
                for (DynamicObject entry : entryEntity) {
                    BigDecimal thisPayOfTaxAmt = entry.getBigDecimal("thispaymentoftaxamount");
                    BigDecimal thisPayAmt = entry.getBigDecimal("thispaymentamount");
                    if (null == entry.get("entrycontract")) continue;
                    long contId = entry.getDynamicObject("entrycontract").getLong("id");
                    if (sumContThisPaymentOfTaxAmt.containsKey(contId)) {
                        sumContThisPaymentOfTaxAmt.put(contId, ((BigDecimal)sumContThisPaymentOfTaxAmt.get(contId)).add(thisPayOfTaxAmt));
                    } else {
                        sumContThisPaymentOfTaxAmt.put(contId, thisPayOfTaxAmt);
                    }
                    if (sumContThisPaymentAmt.containsKey(contId)) {
                        sumContThisPaymentAmt.put(contId, ((BigDecimal)sumContThisPaymentAmt.get(contId)).add(thisPayAmt));
                        continue;
                    }
                    sumContThisPaymentAmt.put(contId, thisPayAmt);
                }
            }
            Set conIds = sumContThisPaymentOfTaxAmt.keySet();
            DynamicObject[] contracts = BusinessDataServiceHelper.load((String)"pmct_outcontract", (String)String.join((CharSequence)",", "totalrealoftaxamount", "totalrealamount", "taxrate"), (QFilter[])new QFilter[]{new QFilter("id", "in", conIds)});
            ArrayList<DynamicObject> contractList = new ArrayList<DynamicObject>(contracts.length);
            for (DynamicObject contract : contracts) {
                BigDecimal totalRealOfTaxAmount = contract.getBigDecimal("totalrealoftaxamount");
                BigDecimal totalRealAmount = contract.getBigDecimal("totalrealamount");
                if (operationKey.equals("audit")) {
                    contract.set("totalrealoftaxamount", (Object)totalRealOfTaxAmount.add((BigDecimal)sumContThisPaymentOfTaxAmt.get(contract.getLong("id"))));
                    contract.set("totalrealamount", (Object)totalRealAmount.add((BigDecimal)sumContThisPaymentAmt.get(contract.getLong("id"))));
                } else if (operationKey.equals("unaudit")) {
                    contract.set("totalrealoftaxamount", (Object)totalRealOfTaxAmount.subtract((BigDecimal)sumContThisPaymentOfTaxAmt.get(contract.getLong("id"))));
                    contract.set("totalrealamount", (Object)totalRealAmount.subtract((BigDecimal)sumContThisPaymentAmt.get(contract.getLong("id"))));
                }
                contractList.add(contract);
            }
            SaveServiceHelper.save((DynamicObject[])contractList.toArray(new DynamicObject[0]));
        }
    }

    @Override
    @Deprecated
    public void reverseWritingToContract(String operationKey, DynamicObject source) {
    }

    private Map<Object, BigDecimal> getEntryAmtSumMap(DynamicObjectCollection entryColl) {
        HashMap<Object, BigDecimal> entryAmtSumMap = new HashMap<Object, BigDecimal>(entryColl.size());
        for (DynamicObject entry : entryColl) {
            DynamicObject payItemObj = entry.getDynamicObject("payitem");
            BigDecimal thisPaymentOfTaxAmt = entry.getBigDecimal("thispaymentoftaxamount");
            if (null == payItemObj || thisPaymentOfTaxAmt.compareTo(BigDecimal.ZERO) <= 0) continue;
            if (entryAmtSumMap.containsKey(payItemObj.getPkValue())) {
                entryAmtSumMap.put(payItemObj.getPkValue(), ((BigDecimal)entryAmtSumMap.get(payItemObj.getPkValue())).add(thisPaymentOfTaxAmt));
                continue;
            }
            entryAmtSumMap.put(payItemObj.getPkValue(), thisPaymentOfTaxAmt);
        }
        return entryAmtSumMap;
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        String operationKey = e.getOperationKey();
        if ("submit".equals(operationKey) || "unsubmit".equals(operationKey) || "audit".equals(operationKey) || "unaudit".equals(operationKey)) {
            DynamicObject[] dataEntities;
            for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
                DynamicObjectCollection entryColl = dataEntity.getDynamicObjectCollection("entryentity");
                Map<Object, BigDecimal> entryAmtSumMap = this.getEntryAmtSumMap(entryColl);
                if (entryAmtSumMap.isEmpty()) continue;
                ContractPayItemHelper.writeBackToPayItemForPayRegister((String)operationKey, entryAmtSumMap);
            }
        }
    }

    @Override
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String operationKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        this.reverseWritingToContract(operationKey, dataEntities);
        for (DynamicObject dataEntity : dataEntities) {
            boolean isPush = dataEntity.getBoolean("pushed");
            if (!"audit".equals(operationKey) || !isPush) continue;
            dataEntity.set("isbillpay", (Object)true);
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities;
                String operateKey = this.getOperateKey();
                for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                    Map<Object, BigDecimal> entryAmtSumMap;
                    DynamicObjectCollection entryEntities;
                    if (!operateKey.equals(PayRegisterOp.OP_PAYCONFIRM) || (entryEntities = dataEntity.getDataEntity().getDynamicObjectCollection("entryentity")).size() == 0 || (entryAmtSumMap = entryEntities.stream().filter(obj -> obj.getDynamicObject("payapplyno") != null).collect(Collectors.toMap(obj -> obj.getDynamicObject("payapplyno").getPkValue(), val -> val.getBigDecimal("thispaymentoftaxamount")))).size() == 0) continue;
                    DynamicObject payApply = BusinessDataServiceHelper.loadSingle((String)"pmct_paymentapply", (QFilter[])new QFilter[]{new QFilter("entryentity.id", "in", entryAmtSumMap.keySet())});
                    DynamicObjectCollection payItems = payApply.getDynamicObjectCollection("entryentity");
                    boolean isError = false;
                    for (DynamicObject payItem : payItems) {
                        BigDecimal thisPayAmount;
                        BigDecimal entryPayAmount = payItem.getBigDecimal("entrypaidamount");
                        BigDecimal entryLockAmount = payItem.getBigDecimal("entrylockamount");
                        BigDecimal thispayableamount = payItem.getBigDecimal("thispayableamount");
                        DynamicObject contract = payItem.getDynamicObject("entrycontract");
                        BigDecimal bigDecimal = thisPayAmount = entryAmtSumMap.get(payItem.getPkValue()) != null ? entryAmtSumMap.get(payItem.getPkValue()) : BigDecimal.ZERO;
                        if (entryLockAmount.add(thisPayAmount).compareTo(thispayableamount) > 0) {
                            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u7684\u201c\u5df2\u9501\u5b9a\u542b\u7a0e\u91d1\u989d\u201d\u5c06\u8d85\u51fa\u9650\u989d\u3002", (String)"PayRegisterOp_0", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), contract.getString("billname")));
                            isError = true;
                            continue;
                        }
                        if (entryPayAmount.add(thisPayAmount).compareTo(thispayableamount) <= 0) continue;
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u7684\u201c\u5df2\u5b9e\u4ed8\u542b\u7a0e\u91d1\u989d\u201d\u5c06\u8d85\u51fa\u9650\u989d\u3002", (String)"PayRegisterOp_1", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), contract.getString("billname")));
                        isError = true;
                    }
                    if (isError) continue;
                    this.addWarningMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u786e\u8ba4\u4ed8\u6b3e\u201d\u64cd\u4f5c\u4e0d\u53ef\u9006\uff0c\u8bf7\u68c0\u67e5\u672c\u6b21\u5b9e\u4ed8\u542b\u7a0e\u91d1\u989d\u662f\u5426\u6b63\u786e\uff0c\u662f\u5426\u786e\u8ba4\u4ed8\u6b3e\uff1f", (String)"PayRegisterOp_2", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                }
            }
        });
    }
}

