/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.opplugin.revision;

import java.math.BigDecimal;
import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.business.helper.ContractCollectItemHelper;
import kd.pmgt.pmbs.business.helper.ContractPayItemHelper;
import kd.pmgt.pmbs.business.helper.FileAttachmentHelper;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;
import kd.pmgt.pmbs.common.enums.PayPlanSourceEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmct.business.helper.ContractValidateHelper;
import kd.pmgt.pmct.business.helper.FundPlanChangeHelper;
import kd.pmgt.pmct.business.helper.IncomePlanChangeHelper;
import kd.pmgt.pmct.business.helper.UnAuditHelper;
import kd.pmgt.pmct.business.model.ContractValidateResult;
import kd.pmgt.pmct.opplugin.validator.ContractRelationBillUnAuditValidator;

public class ContractAdjustOp
extends AbstractOperationServicePlugIn {
    private static final String OPERATION_AUDIT = "audit";
    private static final String OPERATION_UNAUDIT = "unaudit";
    private static final String OPERATION_SUBMIT = "submit";
    protected FundPlanChangeHelper fundPlanChangeHelper = new FundPlanChangeHelper();
    protected IncomePlanChangeHelper incomePlanChangeHelper = new IncomePlanChangeHelper();
    private static final String ATTACHMENTPANEL = "attachmentpanel";
    private static final String TEXTATTACHMENTPANEL = "textattachmentpanel";

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String operationKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        switch (operationKey) {
            case "audit": {
                this.audit(dataEntities);
                break;
            }
            case "unaudit": {
                this.unAudit(dataEntities);
                break;
            }
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new ContractRelationBillUnAuditValidator());
        e.getValidators().add(new ContractAdjustOpValidator());
    }

    private void audit(DynamicObject[] dataEntities) {
        ArrayList<DynamicObject> outContList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> inContList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> firstEditList = new ArrayList<DynamicObject>();
        for (DynamicObject contractRevisionBill : dataEntities) {
            DynamicObject contract;
            DynamicObject firstEdit = null;
            contractRevisionBill = BusinessDataServiceHelper.loadSingle((Object)contractRevisionBill.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_contractrevision"));
            String payDirection = contractRevisionBill.getDynamicObject("contract").getString("paydirection");
            if (StringUtils.equals((CharSequence)PayDirectionEnum.OUT.getValue(), (CharSequence)payDirection)) {
                contract = BusinessDataServiceHelper.loadSingle((Object)contractRevisionBill.getDynamicObject("contract").getPkValue(), (String)"pmct_outcontract");
                firstEdit = this.checkIsFirstEdit(contract, payDirection);
                this.updateHeadFields(contractRevisionBill, contract);
                this.saveFundPlanChange(contractRevisionBill);
                ContractPayItemHelper.save((DynamicObject)contractRevisionBill, (PayPlanSourceEnum)PayPlanSourceEnum.REVISE);
                outContList.add(contract);
            } else if (StringUtils.equals((CharSequence)PayDirectionEnum.IN.getValue(), (CharSequence)payDirection)) {
                contract = BusinessDataServiceHelper.loadSingle((Object)contractRevisionBill.getDynamicObject("contract").getPkValue(), (String)"pmct_incontract");
                firstEdit = this.checkIsFirstEdit(contract, payDirection);
                this.updateHeadFields(contractRevisionBill, contract);
                this.saveIncomeFundPlanChange(contractRevisionBill);
                new ContractCollectItemHelper().doSave(contractRevisionBill, PayPlanSourceEnum.REVISE);
                inContList.add(contract);
            }
            if (firstEdit == null) continue;
            firstEditList.add(firstEdit);
        }
        SaveServiceHelper.save((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"pmct_contractrevision"), (Object[])firstEditList.toArray());
        SaveServiceHelper.save((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"pmct_outcontract"), (Object[])outContList.toArray());
        SaveServiceHelper.save((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"pmct_incontract"), (Object[])inContList.toArray());
        SaveServiceHelper.update((DynamicObject[])dataEntities);
    }

    private void saveFundPlanChange(DynamicObject dataEntry) {
        Object sourceId = dataEntry.getPkValue();
        Object contractId = ((DynamicObject)dataEntry.get("contract")).getPkValue();
        String changeType = PayPlanSourceEnum.REVISE.getValue();
        DynamicObjectCollection customEntries = dataEntry.getDynamicObjectCollection("outcontpayplanentry");
        DynamicObject fundPlanChangeObj = this.fundPlanChangeHelper.buildFundPlanChangeEntry(sourceId, contractId, changeType, (DynamicObject[])customEntries.toArray((Object[])new DynamicObject[0]), "pmct_contractrevision", true);
        fundPlanChangeObj.set("sourcebillid", dataEntry.getPkValue());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{fundPlanChangeObj});
    }

    private void saveIncomeFundPlanChange(DynamicObject dataEntry) {
        Object sourceId = dataEntry.getPkValue();
        Object contractId = ((DynamicObject)dataEntry.get("contract")).getPkValue();
        String changeType = PayPlanSourceEnum.REVISE.getValue();
        DynamicObjectCollection customEntries = dataEntry.getDynamicObjectCollection("incontpayplanentry");
        DynamicObject fundPlanChangeObj = this.incomePlanChangeHelper.buildFundPlanChangeEntry(sourceId, contractId, changeType, (DynamicObject[])customEntries.toArray((Object[])new DynamicObject[0]), "pmct_contractrevision", true);
        fundPlanChangeObj.set("sourcebillid", dataEntry.getPkValue());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{fundPlanChangeObj});
    }

    private void unAudit(DynamicObject[] dataEntities) {
        for (DynamicObject dataEntity : dataEntities) {
            String currentFormId = dataEntity.getDynamicObjectType().getName();
            DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)dataEntity.getPkValue(), (String)currentFormId);
            DynamicObject contract = bill.getDynamicObject("contract");
            String payDirection = contract.getString("paydirection");
            DynamicObjectCollection planEntry = PayDirectionEnum.OUT.getValue().equals(payDirection) ? bill.getDynamicObjectCollection("outcontpayplanentry") : bill.getDynamicObjectCollection("incontpayplanentry");
            UnAuditHelper.updateLastVersionData((DynamicObject)bill, (DynamicObjectCollection)planEntry);
            this.updateContractData(bill, contract);
            if ((double)bill.getBigDecimal("versionnumber").longValue() != 2.0) continue;
            QFilter versionFilter = new QFilter("versionnumber", "=", (Object)1.0);
            QFilter contractFilter = new QFilter("contract", "=", contract.getPkValue());
            DeleteServiceHelper.delete((String)"pmct_contractrevision", (QFilter[])new QFilter[]{versionFilter, contractFilter});
        }
    }

    private void updateContractData(DynamicObject bill, DynamicObject contract) {
        QFilter auditFilter = new QFilter("auditdate", "<", (Object)bill.getDate("auditdate"));
        QFilter contractFilter = new QFilter("contract", "=", contract.getPkValue());
        DynamicObject[] revisions = BusinessDataServiceHelper.load((String)"pmct_contractrevision", (String)String.join((CharSequence)",", "versionnumber", "contractname", "contractno", "payrate", "outpercentmodel", "inpercentmodel"), (QFilter[])new QFilter[]{auditFilter, contractFilter});
        if (revisions.length > 0) {
            DynamicObject revision = revisions[0];
            contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_outcontract"));
            this.updateHeadFields(revision, contract);
            SaveServiceHelper.update((DynamicObject)contract);
        }
    }

    private DynamicObject checkIsFirstEdit(DynamicObject contract, String payDirection) {
        QFilter contractFilter = new QFilter("contract.id", "=", contract.getPkValue());
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue()).or("versionnumber", "=", (Object)1.0);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"pmct_contractrevision", (String)"id,billno,contract", (QFilter[])new QFilter[]{contractFilter, statusFilter});
        DynamicObject firstEditObj = null;
        if (query.isEmpty()) {
            firstEditObj = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_contractrevision"));
            firstEditObj.set("contract", contract.getPkValue());
            firstEditObj.set("billno", (Object)(contract.get("billno") + "_original"));
            firstEditObj.set("contractname", contract.get("billname"));
            firstEditObj.set("contractno", contract.get("billno"));
            firstEditObj.set("createorg", contract.get("createorg"));
            firstEditObj.set("org", contract.get("org"));
            firstEditObj.set("id", (Object)ORM.create().genLongId("pmct_contractrevision"));
            if (PayDirectionEnum.OUT.getValue().equalsIgnoreCase(payDirection)) {
                firstEditObj.set("payrate", contract.get("payrate"));
                firstEditObj.set("outpercentmodel", contract.get("percentmodel"));
            } else {
                firstEditObj.set("inpercentmodel", contract.get("percentmodel"));
            }
            firstEditObj.set("versionnumber", contract.get("versionnumber"));
            firstEditObj.set("creator", contract.get("creator"));
            firstEditObj.set("createtime", contract.get("createtime"));
            firstEditObj.set("modifier", contract.get("modifier"));
            firstEditObj.set("modifytime", contract.get("modifytime"));
            firstEditObj.set("auditor", contract.get("auditor"));
            firstEditObj.set("auditdate", contract.get("auditdate"));
            DynamicObjectCollection contRiskEntry = contract.getDynamicObjectCollection("riskentry");
            if (!contRiskEntry.isEmpty()) {
                DynamicObjectCollection riskEntry = firstEditObj.getDynamicObjectCollection("riskentry");
                for (DynamicObject contRisk : contRiskEntry) {
                    DynamicObject object = new DynamicObject(riskEntry.getDynamicObjectType());
                    object.set("risksourceid", contRisk.getPkValue());
                    object.set("risktype", contRisk.get("risktype"));
                    object.set("riskname", contRisk.get("riskname"));
                    object.set("measures", contRisk.get("measures"));
                    object.set("riskdesc", contRisk.get("riskdesc"));
                    object.set("islegalrisk", contRisk.get("islegalrisk"));
                    riskEntry.add((Object)object);
                }
            }
            if (StringUtils.equals((CharSequence)PayDirectionEnum.OUT.getValue(), (CharSequence)payDirection)) {
                DynamicObjectCollection contOutEntries = contract.getDynamicObjectCollection("outcontpayplanentry");
                if (!contOutEntries.isEmpty()) {
                    DynamicObjectCollection outEntries = firstEditObj.getDynamicObjectCollection("outcontpayplanentry");
                    for (DynamicObject contEntry : contOutEntries) {
                        DynamicObject object = new DynamicObject(outEntries.getDynamicObjectType());
                        object.set("paysourceid", contEntry.getPkValue());
                        object.set("supplier", contEntry.get("supplier"));
                        object.set("payway", contEntry.get("payway"));
                        object.set("paytype", contEntry.get("paytype"));
                        object.set("paymethod", contEntry.get("paymethod"));
                        object.set("paypercent", contEntry.get("paypercent"));
                        object.set("payamount", contEntry.get("payamount"));
                        object.set("planpaytime", contEntry.get("planpaytime"));
                        object.set("paydescription", contEntry.get("remarks"));
                        object.set("nodesetting", contEntry.get("nodesetting"));
                        object.set("nodesettingsource", contEntry.get("nodesettingsource"));
                        object.set("ctrlstrategy", contEntry.get("ctrlstrategy"));
                        object.set("conpayitemid", (Object)Long.parseLong(contEntry.getString("conplanitemid")));
                        object.set("payplansourceid", (Object)contEntry.getPkValue().toString());
                        outEntries.add((Object)object);
                    }
                }
                firstEditObj.set("billstatus", (Object)StatusEnum.CHECKED.getValue());
                this.synFirstVersionAttachmentPanel(contract.getPkValue(), "pmct_outcontract", firstEditObj);
            } else if (StringUtils.equals((CharSequence)PayDirectionEnum.IN.getValue(), (CharSequence)payDirection)) {
                DynamicObjectCollection contInEntries = contract.getDynamicObjectCollection("incontpayplanentry");
                if (!contInEntries.isEmpty()) {
                    DynamicObjectCollection inEntries = firstEditObj.getDynamicObjectCollection("incontpayplanentry");
                    for (DynamicObject contEntry : contInEntries) {
                        DynamicObject object = new DynamicObject(inEntries.getDynamicObjectType());
                        object.set("insourceid", contEntry.getPkValue());
                        object.set("customer", contEntry.get("customer"));
                        object.set("incomeway", contEntry.get("payway"));
                        object.set("incometype", contEntry.get("paytype"));
                        object.set("incomemethod", contEntry.get("paymethod"));
                        object.set("incomepercent", contEntry.get("paypercent"));
                        object.set("incomeamount", contEntry.get("payamount"));
                        object.set("planincometime", contEntry.get("planpaytime"));
                        object.set("incomedescription", contEntry.get("remarks"));
                        object.set("incomenodesetting", contEntry.get("nodesetting"));
                        object.set("incomesource", contEntry.get("nodesettingsource"));
                        object.set("incomectrlstrategy", contEntry.get("ctrlstrategy"));
                        object.set("conincomeitemid", (Object)Long.parseLong(contEntry.getString("conplanitemid")));
                        object.set("incomeplansourceid", (Object)contEntry.getPkValue().toString());
                        inEntries.add((Object)object);
                    }
                }
                this.synFirstVersionAttachmentPanel(contract.getPkValue(), "pmct_incontract", firstEditObj);
            }
            firstEditObj.set("billstatus", (Object)StatusEnum.CHECKED.getValue());
        }
        return firstEditObj;
    }

    private void synFirstVersionAttachmentPanel(Object srcBillId, String formBillId, DynamicObject firstEditObj) {
        try (TXHandle txHandle = TX.requiresNew((String)"pmgt_contractadjust_attachmentpanel");){
            try {
                FileAttachmentHelper.copyFileFromAToB((String)formBillId, (Object)srcBillId, (String)ATTACHMENTPANEL, (String)"pmct_contractrevision", (Object)firstEditObj.getPkValue(), (String)ATTACHMENTPANEL);
                FileAttachmentHelper.copyFileFromAToB((String)formBillId, (Object)srcBillId, (String)TEXTATTACHMENTPANEL, (String)"pmct_contractrevision", (Object)firstEditObj.getPkValue(), (String)TEXTATTACHMENTPANEL);
            }
            catch (Throwable e) {
                txHandle.markRollback();
                throw e;
            }
        }
    }

    private void updateHeadFields(DynamicObject obj, DynamicObject contract) {
        contract.set("billno", obj.get("contractno"));
        contract.set("billname", obj.get("contractname"));
        if (contract.getString("paydirection").equalsIgnoreCase(PayDirectionEnum.OUT.getValue())) {
            contract.set("payrate", obj.get("payrate"));
            contract.set("percentmodel", obj.get("outpercentmodel"));
        } else {
            contract.set("percentmodel", obj.get("inpercentmodel"));
        }
        contract.set("versionnumber", obj.get("versionnumber"));
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("contract");
        e.getFieldKeys().add("contractname");
        e.getFieldKeys().add("contractno");
        e.getFieldKeys().add("payrate");
        e.getFieldKeys().add("inpercentmodel");
        e.getFieldKeys().add("outpercentmodel");
        e.getFieldKeys().add("originaloftaxamount");
        e.getFieldKeys().add("incontpayplanentry");
        e.getFieldKeys().add("incometype");
        e.getFieldKeys().add("incomemethod");
        e.getFieldKeys().add("incomepercent");
        e.getFieldKeys().add("incomeamount");
        e.getFieldKeys().add("planincometime");
        e.getFieldKeys().add("incomedescription");
        e.getFieldKeys().add("insourceid");
        e.getFieldKeys().add("conincomeitemid");
        e.getFieldKeys().add("incomenodesetting");
        e.getFieldKeys().add("incomesource");
        e.getFieldKeys().add("incomectrlstrategy");
        e.getFieldKeys().add("riskentry");
        e.getFieldKeys().add("riskname");
        e.getFieldKeys().add("risktype");
        e.getFieldKeys().add("measures");
        e.getFieldKeys().add("riskdesc");
        e.getFieldKeys().add("islegalrisk");
        e.getFieldKeys().add("outcontpayplanentry");
        e.getFieldKeys().add("paytype");
        e.getFieldKeys().add("paymethod");
        e.getFieldKeys().add("payamount");
        e.getFieldKeys().add("paypercent");
        e.getFieldKeys().add("planpaytime");
        e.getFieldKeys().add("paydescription");
        e.getFieldKeys().add("supplier");
        e.getFieldKeys().add("payway");
        e.getFieldKeys().add("paysourceid");
        e.getFieldKeys().add("conpayitemid");
        e.getFieldKeys().add("risksourceid");
        e.getFieldKeys().add("versionnumber");
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("outcontpayplanentry.seq");
        e.getFieldKeys().add("seq");
        e.getFieldKeys().add("conincomeitemid");
        e.getFieldKeys().add("org");
    }

    static class ContractAdjustOpValidator
    extends AbstractValidator {
        ContractAdjustOpValidator() {
        }

        public void setOperateType(String operateType) {
            super.setOperateType(operateType);
        }

        public void validate() {
            String key = this.getOperateKey();
            if (StringUtils.equals((CharSequence)ContractAdjustOp.OPERATION_SUBMIT, (CharSequence)key)) {
                ExtendedDataEntity[] dataEntities;
                for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                    DynamicObject bill = dataEntity.getDataEntity();
                    DynamicObject contract = (DynamicObject)bill.get("contract");
                    String payDirection = contract.getString("paydirection");
                    this.checkContractItem(dataEntity, contract, payDirection);
                }
            }
        }

        private void checkContractItem(ExtendedDataEntity dataEntity, DynamicObject contract, String payDirection) {
            if (StringUtils.equals((CharSequence)PayDirectionEnum.OUT.getValue(), (CharSequence)payDirection)) {
                this.checkContractPayItem(dataEntity, contract);
            } else {
                this.checkContractIncomeItem(dataEntity);
            }
        }

        private void checkContractIncomeItem(ExtendedDataEntity dataEntity) {
            BigDecimal originalOfTaxAmount;
            ContractValidateResult result;
            DynamicObject bill = dataEntity.getDataEntity();
            DynamicObjectCollection inContractPayPlanEntries = bill.getDynamicObjectCollection("incontpayplanentry");
            DynamicObject contract = bill.getDynamicObject("contract");
            boolean isOpenedContract = contract.getBoolean("openedcontract");
            if (!isOpenedContract && (result = ContractValidateHelper.checkIncomePlanOriginalOfTaxAmount((BigDecimal)(originalOfTaxAmount = bill.getBigDecimal("originaloftaxamount")), (DynamicObjectCollection)inContractPayPlanEntries)).error()) {
                this.addErrorMessage(dataEntity, result.getMsg());
                return;
            }
            ContractValidateResult result2 = ContractValidateHelper.checkIncomeAmount((DynamicObjectCollection)inContractPayPlanEntries);
            if (result2.error()) {
                this.addErrorMessage(dataEntity, result2.getMsg());
            }
        }

        private void checkContractPayItem(ExtendedDataEntity dataEntity, DynamicObject contract) {
            BigDecimal originalOfTaxAmount;
            ContractValidateResult result;
            DynamicObject bill = dataEntity.getDataEntity();
            DynamicObjectCollection contractPayPlanEntries = bill.getDynamicObjectCollection("outcontpayplanentry");
            boolean isOpenedContract = (contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_outcontract")).getBoolean("openedcontract");
            if (!isOpenedContract && (result = ContractValidateHelper.checkOriginalOfTaxAmount((BigDecimal)(originalOfTaxAmount = bill.getBigDecimal("originaloftaxamount")), (DynamicObjectCollection)contractPayPlanEntries)).error()) {
                this.addErrorMessage(dataEntity, result.getMsg());
                return;
            }
            ContractValidateResult result2 = ContractValidateHelper.checkUsedAmt((Object)contract.getPkValue(), (DynamicObjectCollection)contractPayPlanEntries);
            if (result2.error()) {
                this.addErrorMessage(dataEntity, result2.getMsg());
                return;
            }
            result2 = ContractValidateHelper.checkPayAmount((DynamicObjectCollection)contractPayPlanEntries);
            if (result2.error()) {
                this.addErrorMessage(dataEntity, result2.getMsg());
            }
        }
    }
}

