/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.opplugin.revision;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.common.enums.EnableEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.enums.pmct.ChangeTypeEnum;
import kd.pmgt.pmbs.common.utils.NumberHelper;
import kd.pmgt.pmbs.common.utils.TypeUtils;
import kd.pmgt.pmct.business.helper.ContractListHelper;
import kd.pmgt.pmct.opplugin.AbstractReverseWritingPmctContractOp;
import kd.pmgt.pmct.opplugin.revision.ContractRevisionValidator;

public class ContractRevisionOp
extends AbstractReverseWritingPmctContractOp {
    private static String selector = Stream.of("totalrevisionamount", "totalrevisionoftaxamount", "totalamount", "totaloftaxamount", "lsttaxrate", "lstavgtaxrate").collect(Collectors.joining(","));
    private static final String Entryentity_Listingbudgetitem = "listingbudgetitem";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fields = e.getFieldKeys();
        fields.add("contract");
        fields.add("revisionamount");
        fields.add("revisionoftaxamount");
        fields.add("kapianentry");
        fields.add("superlistingid");
        fields.add("newlistingid");
        fields.add("subchangetype");
        fields.add("listnumber");
        fields.add("listname");
        fields.add("qty");
        fields.add("price");
        fields.add("currency");
        fields.add("taxrate1");
        fields.add("rateobj");
        fields.add("materiel");
        fields.add("measureunit");
        fields.add("qty");
        fields.add("price");
        fields.add("amount");
        fields.add("parentlisting");
        fields.add("latestprice");
        fields.add("curbgbhsje");
        fields.add(Entryentity_Listingbudgetitem);
        fields.add("sysnum");
        fields.add("ismultirate");
        fields.add("taxratechange");
        fields.add("taxrate");
        fields.add("avgtaxrate");
        fields.add("changedtaxrate");
        fields.add("changedavgtaxrate");
        fields.add("currency");
    }

    public void onAddValidators(AddValidatorsEventArgs addvalidatorseventargs) {
        super.onAddValidators(addvalidatorseventargs);
        addvalidatorseventargs.addValidator((AbstractValidator)new ContractRevisionValidator());
    }

    @Override
    public void reverseWritingToContract(String operationKey, DynamicObject dataEntity) {
        boolean isFromDb = dataEntity.getDataEntityState().getFromDatabase();
        if (!isFromDb) {
            return;
        }
        dataEntity = BusinessDataServiceHelper.loadSingle((Object)dataEntity.getPkValue(), (String)dataEntity.getDynamicObjectType().getName());
        DynamicObject contract = BusinessDataServiceHelper.loadSingle((Object)dataEntity.getDynamicObject("contract").getPkValue(), (String)"pmct_outcontract", (String)selector);
        BigDecimal totalRevisionAmount = contract.getBigDecimal("totalrevisionamount");
        BigDecimal totalRevisionOfTaxAmount = contract.getBigDecimal("totalrevisionoftaxamount");
        BigDecimal totalAmount = contract.getBigDecimal("totalamount");
        BigDecimal totalOfTaxAmount = contract.getBigDecimal("totaloftaxamount");
        BigDecimal revisionAmount = dataEntity.getBigDecimal("revisionamount");
        BigDecimal revisionOfTaxAmount = dataEntity.getBigDecimal("revisionoftaxamount");
        if (operationKey.equals("audit")) {
            boolean isMultiRate;
            contract.set("totalrevisionamount", (Object)totalRevisionAmount.add(revisionAmount));
            contract.set("totalrevisionoftaxamount", (Object)totalRevisionOfTaxAmount.add(revisionOfTaxAmount));
            contract.set("totalamount", (Object)totalAmount.add(revisionAmount));
            contract.set("totaloftaxamount", (Object)totalOfTaxAmount.add(revisionOfTaxAmount));
            boolean taxRateChange = dataEntity.getBoolean("taxratechange");
            if (taxRateChange) {
                isMultiRate = dataEntity.getBoolean("ismultirate");
                if (isMultiRate) {
                    contract.set("lstavgtaxrate", dataEntity.get("changedavgtaxrate"));
                } else {
                    contract.set("lsttaxrate", dataEntity.get("changedtaxrate"));
                }
            } else {
                isMultiRate = dataEntity.getBoolean("ismultirate");
                if (isMultiRate) {
                    contract.set("lstavgtaxrate", dataEntity.get("avgtaxrate"));
                }
            }
            DynamicObjectCollection cardEntry = (DynamicObjectCollection)dataEntity.get("kapianentry");
            ArrayList<DynamicObject> listUpdateList = new ArrayList<DynamicObject>();
            ArrayList<DynamicObject> listaddList = new ArrayList<DynamicObject>();
            for (int i = 0; i < cardEntry.size(); ++i) {
                DynamicObjectCollection subentrys = (DynamicObjectCollection)((DynamicObject)cardEntry.get(i)).get("entryentity");
                HashMap<String, DynamicObject> newListingMap = new HashMap<String, DynamicObject>(16);
                this.addNotDetailListing(dataEntity, contract, subentrys, listaddList, newListingMap);
                this.addListingByChangeType(dataEntity, contract, subentrys, listUpdateList, listaddList, newListingMap);
            }
            if (listUpdateList.size() > 0) {
                SaveServiceHelper.update((DynamicObject[])listUpdateList.toArray(new DynamicObject[listUpdateList.size()]));
            }
            if (listaddList.size() > 0) {
                SaveServiceHelper.save((IDataEntityType)((DynamicObject)listaddList.get(0)).getDataEntityType(), (Object[])listaddList.toArray());
            }
        }
        SaveServiceHelper.update((DynamicObject)contract);
    }

    protected void addListingByChangeType(DynamicObject dataEntity, DynamicObject contract, DynamicObjectCollection subentrys, List<DynamicObject> listUpdateList, List<DynamicObject> listaddList, Map<String, DynamicObject> newListingMap) {
        for (int k = 0; k < subentrys.size(); ++k) {
            DynamicObject parentListing;
            BigDecimal totalChangedTaxAmount;
            BigDecimal lastChangedEffectQty;
            DynamicObject parentListing2;
            BigDecimal avgTaxPrice;
            BigDecimal changedTaxAmount;
            BigDecimal curChangedTaxAmount;
            DynamicObject listing;
            DynamicObject subEntry = (DynamicObject)subentrys.get(k);
            String changeType = subEntry.getString("subchangetype");
            if (StringUtils.equals((CharSequence)changeType, (CharSequence)ChangeTypeEnum.NUMBERCHANGE.getValue())) {
                listing = (DynamicObject)subEntry.get("listid");
                if (listing == null) continue;
                listing = BusinessDataServiceHelper.loadSingle((Object)listing.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_contractlist"));
                listing.set("ischanged", (Object)Boolean.TRUE);
                listing.set("enable", (Object)1);
                double changeqty = TypeUtils.StringToDouble((Object)listing.get("changeqty"));
                listing.set("changeqty", (Object)(changeqty += TypeUtils.StringToDouble((Object)subEntry.get("biangengsl"))));
                curChangedTaxAmount = (BigDecimal)subEntry.get("hsbgje");
                changedTaxAmount = (BigDecimal)listing.get("chgoftaxamount");
                listing.set("chgoftaxamount", (Object)changedTaxAmount.add(curChangedTaxAmount));
                double totalQty = TypeUtils.StringToDouble((Object)listing.get("qty")) + changeqty;
                listing.set("totalqty", (Object)totalQty);
                BigDecimal lastTotalChangedTaxAmount = listing.getBigDecimal("lstoftaxamount");
                BigDecimal totalChangedTaxAmount2 = lastTotalChangedTaxAmount.add(curChangedTaxAmount);
                listing.set("lstoftaxamount", (Object)totalChangedTaxAmount2);
                BigDecimal taxrate = subEntry.getBigDecimal("taxrate1");
                DynamicObject currency = dataEntity.getDynamicObject("currency");
                int pricePrecision = currency != null ? currency.getInt("priceprecision") : 10;
                BigDecimal curChangedAmount = NumberHelper.divide((Object)curChangedTaxAmount, (Object)BigDecimal.ONE.add(taxrate.divide(new BigDecimal("100"))), (int)pricePrecision, (RoundingMode)RoundingMode.HALF_UP);
                listing.set("latestamount", (Object)subEntry.getBigDecimal("amount").add(curChangedAmount));
                if (BigDecimal.ZERO.compareTo(BigDecimal.valueOf(totalQty)) != 0) {
                    avgTaxPrice = NumberHelper.divide((Object)totalChangedTaxAmount2, (Object)BigDecimal.valueOf(totalQty), (int)10, (RoundingMode)RoundingMode.HALF_UP);
                    listing.set("avgtaxprice", (Object)avgTaxPrice);
                }
                listUpdateList.add(listing);
                parentListing2 = listing.getDynamicObject("parent");
                if (parentListing2 == null) continue;
                ContractListHelper.updateContractParentDataOnAudit(listUpdateList, (DynamicObject)parentListing2, (BigDecimal)curChangedTaxAmount, (BigDecimal)curChangedAmount);
                continue;
            }
            if (StringUtils.equals((CharSequence)changeType, (CharSequence)ChangeTypeEnum.PRICECHANGE.getValue())) {
                listing = (DynamicObject)subEntry.get("listid");
                if (listing == null) continue;
                listing = BusinessDataServiceHelper.loadSingle((Object)listing.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_contractlist"));
                listing.set("ischanged", (Object)Boolean.TRUE);
                listing.set("enable", (Object)1);
                BigDecimal effectQty = subEntry.getBigDecimal("shouyingxsl");
                lastChangedEffectQty = listing.getBigDecimal("chgeffectqty");
                listing.set("chgeffectqty", (Object)effectQty.add(lastChangedEffectQty));
                listing.set("curtaxprice", (Object)subEntry.getBigDecimal("biangenghouhsdj"));
                listing.set("latestprice", (Object)subEntry.getBigDecimal("latestprice"));
                curChangedTaxAmount = subEntry.getBigDecimal("hsbgje");
                changedTaxAmount = (BigDecimal)listing.get("chgoftaxamount");
                listing.set("chgoftaxamount", (Object)changedTaxAmount.add(curChangedTaxAmount));
                BigDecimal lastTotalChangedTaxAmount = listing.getBigDecimal("lstoftaxamount");
                totalChangedTaxAmount = lastTotalChangedTaxAmount.add(curChangedTaxAmount);
                listing.set("lstoftaxamount", (Object)totalChangedTaxAmount);
                BigDecimal taxrate = subEntry.getBigDecimal("taxrate1");
                DynamicObject currency = dataEntity.getDynamicObject("currency");
                int pricePrecision = currency != null ? currency.getInt("priceprecision") : 10;
                BigDecimal curChangedAmount = NumberHelper.divide((Object)curChangedTaxAmount, (Object)BigDecimal.ONE.add(taxrate.divide(new BigDecimal("100"))), (int)pricePrecision, (RoundingMode)RoundingMode.HALF_UP);
                listing.set("latestamount", (Object)subEntry.getBigDecimal("amount").add(curChangedAmount));
                double totalQty = TypeUtils.StringToDouble((Object)listing.get("totalqty"));
                if (BigDecimal.ZERO.compareTo(BigDecimal.valueOf(totalQty)) != 0) {
                    avgTaxPrice = NumberHelper.divide((Object)totalChangedTaxAmount, (Object)BigDecimal.valueOf(totalQty), (int)10, (RoundingMode)RoundingMode.HALF_UP);
                    listing.set("avgtaxprice", (Object)avgTaxPrice);
                }
                listUpdateList.add(listing);
                parentListing2 = listing.getDynamicObject("parent");
                if (parentListing2 == null) continue;
                ContractListHelper.updateContractParentDataOnAudit(listUpdateList, (DynamicObject)parentListing2, (BigDecimal)curChangedTaxAmount, (BigDecimal)curChangedAmount);
                continue;
            }
            if (StringUtils.equals((CharSequence)changeType, (CharSequence)ChangeTypeEnum.DETAILLISTING.getValue())) {
                listing = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_contractlist"));
                listing.set("id", subEntry.get("newlistingid"));
                listing.set("isaddnew", (Object)Boolean.TRUE);
                listing.set("listparentid", (Object)subEntry.getString("superlistingid"));
                listing.set("number", subEntry.get("listnumber"));
                listing.set("name", subEntry.get("listname"));
                if (subEntry.get("measureunit") != null) {
                    listing.set("measureunit", subEntry.getDynamicObject("measureunit").getPkValue());
                }
                listing.set("sequence", subEntry.get("seq"));
                listing.set("qty", subEntry.get("qty"));
                listing.set("totalqty", subEntry.get("qty"));
                listing.set("paydirection", dataEntity.getDynamicObject("contract").get("paydirection"));
                listing.set("price", subEntry.get("price"));
                listing.set("amount", subEntry.get("amount"));
                listing.set("taxrate", subEntry.get("taxrate1"));
                listing.set("rateobj", subEntry.get("rateobj"));
                listing.set("tax", subEntry.get("tax"));
                listing.set("taxprice", subEntry.get("hanshuidanj"));
                listing.set("avgtaxprice", subEntry.get("hanshuidanj"));
                listing.set("curtaxprice", subEntry.get("hanshuidanj"));
                listing.set("oftax", subEntry.get("oftax"));
                listing.set("lstoftaxamount", subEntry.get("oftax"));
                listing.set("latestamount", subEntry.get("amount"));
                listing.set("desc", subEntry.get("remark"));
                DynamicObject parentnode = (DynamicObject)subEntry.getParent();
                listing.set("listingmodel", parentnode.get("listmodelid"));
                listing.set("contractid", (Object)contract.getPkValue().toString());
                listing.set("enable", (Object)EnableEnum.ENABLE.getValue());
                listing.set("status", (Object)StatusEnum.CHECKED.getValue());
                listing.set("currency", dataEntity.getDynamicObject("currency").getPkValue());
                if (subEntry.get(Entryentity_Listingbudgetitem) != null) {
                    listing.set(Entryentity_Listingbudgetitem, subEntry.get(Entryentity_Listingbudgetitem));
                }
                listing.set("isleaf", (Object)Boolean.TRUE);
                if (subEntry.get("materiel") != null) {
                    listing.set("material", subEntry.getDynamicObject("materiel").getPkValue());
                }
                if (subEntry.getDynamicObject("parentlisting") != null) {
                    listing.set("level", (Object)(subEntry.getDynamicObject("parentlisting").getInt("level") + 1));
                    listing.set("parent", subEntry.getDynamicObject("parentlisting").getPkValue());
                } else if (subEntry.get("superlistingid") != null && subEntry.getLong("superlistingid") != 0L) {
                    DynamicObject superListing = newListingMap.get(String.valueOf(subEntry.getLong("superlistingid")));
                    listing.set("level", (Object)(superListing.getInt("level") + 1));
                    listing.set("parent", (Object)subEntry.getLong("superlistingid"));
                } else {
                    listing.set("level", (Object)1);
                    listing.set("parent", null);
                }
                listing.set("sysnumber", (Object)subEntry.getString("sysnum"));
                DynamicObject parentListing3 = subEntry.getDynamicObject("parentlisting");
                listaddList.add(listing);
                if (parentListing3 == null) continue;
                curChangedTaxAmount = subEntry.getBigDecimal("oftax");
                BigDecimal curChangedAmount = subEntry.getBigDecimal("amount");
                ContractListHelper.updateContractParentDataOnAudit(listUpdateList, (DynamicObject)parentListing3, (BigDecimal)curChangedTaxAmount, (BigDecimal)curChangedAmount);
                continue;
            }
            if (!StringUtils.equals((CharSequence)changeType, (CharSequence)ChangeTypeEnum.TAXRATECHGANGE.getValue()) || (listing = (DynamicObject)subEntry.get("listid")) == null) continue;
            listing = BusinessDataServiceHelper.loadSingle((Object)listing.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_contractlist"));
            listing.set("ischanged", (Object)Boolean.TRUE);
            listing.set("enable", (Object)EnableEnum.ENABLE.getValue());
            listing.set("rateobj", (Object)subEntry.getDynamicObject("changedrateobj"));
            listing.set("taxrate", (Object)subEntry.getBigDecimal("changedtaxrate1"));
            BigDecimal effectQty = subEntry.getBigDecimal("shouyingxsl");
            lastChangedEffectQty = listing.getBigDecimal("chgeffectqty");
            listing.set("chgeffectqty", (Object)effectQty.add(lastChangedEffectQty));
            listing.set("curtaxprice", (Object)subEntry.getBigDecimal("biangenghouhsdj"));
            listing.set("latestprice", (Object)subEntry.getBigDecimal("latestprice"));
            curChangedTaxAmount = subEntry.getBigDecimal("hsbgje");
            changedTaxAmount = (BigDecimal)listing.get("chgoftaxamount");
            listing.set("chgoftaxamount", (Object)changedTaxAmount.add(curChangedTaxAmount));
            BigDecimal lastTotalChangedTaxAmount = listing.getBigDecimal("lstoftaxamount");
            totalChangedTaxAmount = lastTotalChangedTaxAmount.add(curChangedTaxAmount);
            listing.set("lstoftaxamount", (Object)totalChangedTaxAmount);
            listing.set("latestamount", (Object)subEntry.getBigDecimal("amount").add(subEntry.getBigDecimal("curbgbhsje")));
            double totalQty = TypeUtils.StringToDouble((Object)listing.get("totalqty"));
            if (BigDecimal.ZERO.compareTo(BigDecimal.valueOf(totalQty)) != 0) {
                BigDecimal avgTaxPrice2 = NumberHelper.divide((Object)totalChangedTaxAmount, (Object)BigDecimal.valueOf(totalQty), (int)10, (RoundingMode)RoundingMode.HALF_UP);
                listing.set("avgtaxprice", (Object)avgTaxPrice2);
            }
            if ((parentListing = listing.getDynamicObject("parent")) != null) {
                ContractListHelper.updateContractParentDataOnAudit(listUpdateList, (DynamicObject)parentListing, (BigDecimal)curChangedTaxAmount, (BigDecimal)BigDecimal.ZERO);
            }
            listUpdateList.add(listing);
        }
    }

    protected void addNotDetailListing(DynamicObject dataEntity, DynamicObject contract, DynamicObjectCollection subentrys, List<DynamicObject> listaddList, Map<String, DynamicObject> newListingMap) {
        ArrayList<DynamicObject> updateLevelList = new ArrayList<DynamicObject>(10);
        for (int k = 0; k < subentrys.size(); ++k) {
            DynamicObject subEntry = (DynamicObject)subentrys.get(k);
            String changeType = subEntry.getString("subchangetype");
            if (!StringUtils.equals((CharSequence)changeType, (CharSequence)ChangeTypeEnum.NOTDETAILLISTING.getValue())) continue;
            DynamicObject listing = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_contractlist"));
            listing.set("id", subEntry.get("newlistingid"));
            listing.set("isaddnew", (Object)Boolean.TRUE);
            listing.set("isleaf", (Object)Boolean.FALSE);
            listing.set("listparentid", subEntry.get("superlistingid"));
            listing.set("parent", subEntry.get("superlistingid"));
            if (subEntry.getDynamicObject("parentlisting") != null) {
                listing.set("level", (Object)(subEntry.getDynamicObject("parentlisting").getInt("level") + 1));
            } else {
                updateLevelList.add(listing);
            }
            listing.set("number", subEntry.get("listnumber"));
            listing.set("name", subEntry.get("listname"));
            listing.set("amount", subEntry.get("amount"));
            listing.set("tax", subEntry.get("tax"));
            listing.set("oftax", subEntry.get("oftax"));
            listing.set("lstoftaxamount", subEntry.get("oftax"));
            listing.set("desc", subEntry.get("remark"));
            DynamicObject parentnode = (DynamicObject)subEntry.getParent();
            listing.set("listingmodel", parentnode.get("listmodelid"));
            listing.set("contractid", (Object)contract.getPkValue().toString());
            listing.set("enable", (Object)1);
            listing.set("status", (Object)"C");
            listing.set("currency", dataEntity.getDynamicObject("currency").getPkValue());
            if (subEntry.get(Entryentity_Listingbudgetitem) != null) {
                listing.set(Entryentity_Listingbudgetitem, subEntry.get(Entryentity_Listingbudgetitem));
            }
            listing.set("sysnumber", (Object)subEntry.getString("sysnum"));
            listaddList.add(listing);
            newListingMap.put(subEntry.get("newlistingid").toString(), listing);
        }
        for (DynamicObject listing : updateLevelList) {
            if (listing.get("listparentid") != null && listing.getLong("listparentid") != 0L) {
                DynamicObject parent = newListingMap.get(String.valueOf(listing.getLong("listparentid")));
                listing.set("level", (Object)(parent.getInt("level") + 1));
                continue;
            }
            listing.set("level", (Object)1);
        }
    }

    private void updateParentListingData(DynamicObject[] listings) {
        HashMap<Object, Set<DynamicObject>> sonMap = new HashMap<Object, Set<DynamicObject>>();
        HashMap<Object, DynamicObject> idToListingMap = new HashMap<Object, DynamicObject>(listings.length);
        for (DynamicObject listing : listings) {
            DynamicObject parent = listing.getDynamicObject("parent");
            if (parent != null) {
                HashSet<DynamicObject> sonSet = (HashSet<DynamicObject>)sonMap.get(parent.getPkValue());
                if (sonSet == null) {
                    sonSet = new HashSet<DynamicObject>();
                    sonMap.put(parent.getPkValue(), sonSet);
                }
                sonSet.add(listing);
            }
            idToListingMap.put(listing.getPkValue(), listing);
        }
        Iterator iterator = sonMap.keySet().iterator();
        while (iterator.hasNext()) {
            DynamicObject listing = (DynamicObject)idToListingMap.get(iterator.next());
            if (listing.getInt("level") == 1) {
                this.updateListing(listing, sonMap);
            }
            listing.set("isleaf", (Object)Boolean.FALSE);
        }
        SaveServiceHelper.save((DynamicObject[])listings);
    }

    private BigDecimal updateListing(DynamicObject listing, HashMap<Object, Set<DynamicObject>> sonMap) {
        BigDecimal totalOfTaxAmt = listing.getBigDecimal("lstoftaxamount");
        BigDecimal sumOfSonAmt = BigDecimal.ZERO;
        Set<DynamicObject> sonSet = sonMap.get(listing.getPkValue());
        if (sonSet != null) {
            for (DynamicObject sonListing : sonSet) {
                BigDecimal sonTotalOfTaxAmt = this.updateListing(sonListing, sonMap);
                sumOfSonAmt = sumOfSonAmt.add(sonTotalOfTaxAmt);
            }
            if (totalOfTaxAmt.compareTo(sumOfSonAmt) != 0) {
                totalOfTaxAmt = sumOfSonAmt;
                listing.set("lstoftaxamount", (Object)totalOfTaxAmt);
                BigDecimal oftax = listing.getBigDecimal("oftax");
                listing.set("chgoftaxamount", (Object)totalOfTaxAmt.subtract(oftax));
                listing.set("ischanged", (Object)Boolean.TRUE);
            }
        }
        return totalOfTaxAmt;
    }
}

