/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.opplugin.validator;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.business.helper.ProBudgetControlHelper;
import kd.pmgt.pmbs.common.enums.ContractControlEnum;
import kd.pmgt.pmbs.common.enums.ContractStatusEnum;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;
import kd.pmgt.pmbs.common.enums.PerformAmountTypeEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.utils.CurrencyHelper;
import kd.pmgt.pmbs.common.utils.budget.BudgetValidateAndUpdateHelper;
import kd.pmgt.pmbs.common.utils.budget.BudgetValidateInfo;

public class ContStatusChangeValidator
extends AbstractValidator {
    public void validate() {
        String key = this.getOperateKey();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"submit") || StringUtils.equals((CharSequence)key, (CharSequence)"audit") || StringUtils.equals((CharSequence)key, (CharSequence)"unaudit")) {
            for (ExtendedDataEntity dataEntity : dataEntities) {
                DynamicObject contract = dataEntity.getDataEntity().getDynamicObject("contract");
                if (StringUtils.equals((CharSequence)key, (CharSequence)"submit")) {
                    this.validateContractStatus(dataEntity);
                    this.contTypeCtlValidate(dataEntity);
                    this.appAmountValidate(dataEntity);
                }
                String payDirection = contract.getString("paydirection");
                if (PayDirectionEnum.OUT.getValue().equals(payDirection)) {
                    this.vaildBudget(dataEntity, key);
                }
                if (!StringUtils.equals((CharSequence)key, (CharSequence)"unaudit")) continue;
                String formBillId = PayDirectionEnum.OUT.getValue().equals(payDirection) ? "pmct_outfinalsettle" : "pmct_infinalsettle";
                QFilter filter = new QFilter("contract", "=", (Object)Long.parseLong(contract.getPkValue().toString()));
                filter.and(new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue()));
                DynamicObject[] finSettleBill = BusinessDataServiceHelper.load((String)formBillId, (String)"id", (QFilter[])new QFilter[]{filter});
                if (finSettleBill.length <= 0) continue;
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u5df2\u5ba1\u6838\u901a\u8fc7\u7684\u51b3\u7b97\u5355\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u5bf9\u5e94\u5408\u540c\u7684\u5408\u540c\u72b6\u6001\u3002", (String)"ContStatusChangeValidator_15", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
            }
        }
    }

    protected void validateContractStatus(ExtendedDataEntity dataEntity) {
        DynamicObject statusBill = dataEntity.getDataEntity();
        DynamicObject contract = statusBill.getDynamicObject("contract");
        if (contract == null) {
            return;
        }
        contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_contracttpl");
        DynamicObject contractStatus = contract.getDynamicObject("contractstatus");
        if (StringUtils.equals((CharSequence)(contractStatus = BusinessDataServiceHelper.loadSingle((Object)contractStatus.getPkValue(), (String)"pmct_contractstatus")).getString("number"), (CharSequence)ContractStatusEnum.CLOSED.getValue())) {
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5408\u540c\u5df2\u5173\u95ed\uff0c\u65e0\u6cd5\u53d8\u66f4\u5408\u540c\u72b6\u6001\u3002", (String)"ContStatusChangeValidator_16", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
            return;
        }
        String payDirection = contract.getString("paydirection");
        String formBillId = PayDirectionEnum.OUT.getValue().equals(payDirection) ? "pmct_outfinalsettle" : "pmct_infinalsettle";
        QFilter filter = new QFilter("contract", "=", (Object)Long.parseLong(contract.getPkValue().toString()));
        filter.and(new QFilter("billstatus", "=", (Object)StatusEnum.UNCHECKED.getValue()));
        DynamicObject[] finSettleBills = BusinessDataServiceHelper.load((String)formBillId, (String)"id,billno", (QFilter[])new QFilter[]{filter});
        if (finSettleBills != null && finSettleBills.length > 0) {
            for (DynamicObject finSettleBill : finSettleBills) {
                String billNo = finSettleBill.getString("billno");
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5408\u540c\u201c%1$s\u201d\u5b58\u5728\u5df2\u63d0\u4ea4\u7684\u5408\u540c\u51b3\u7b97\u5355\uff0c\u5355\u636e\u7f16\u53f7\u662f%2$s\uff0c\u65e0\u6cd5\u53d8\u66f4\u5408\u540c\u72b6\u6001\u3002", (String)"ContStatusChangeValidator_17", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), contract.getString("billno"), billNo));
            }
        }
    }

    protected void contTypeCtlValidate(ExtendedDataEntity dataEntity) {
        DynamicObject statusBill = dataEntity.getDataEntity();
        DynamicObject contract = statusBill.getDynamicObject("contract");
        contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_contracttpl");
        int compare = this.amountCompare(statusBill, contract);
        DynamicObject contractType = contract.getDynamicObject("contracttype");
        contractType = BusinessDataServiceHelper.loadSingle((Object)contractType.getPkValue(), (String)"pmct_conttype");
        String amountControlSettleParam = contractType.getString("ammountcontrolsettle");
        if (ContractControlEnum.REMINDCONTROL.getValue().equals(amountControlSettleParam) && compare < 0) {
            this.addWarningMessage(dataEntity, ResManager.loadKDString((String)"\u5408\u540c\u5ba1\u5b9a\u603b\u91d1\u989d\u5df2\u8d85\u8fc7\u5408\u540c\u603b\u91d1\u989d", (String)"ContStatusChangeValidator_13", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
        } else if (ContractControlEnum.STRICTCONTROL.getValue().equals(amountControlSettleParam) && compare < 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5408\u540c\u5ba1\u5b9a\u603b\u91d1\u989d\u5df2\u8d85\u51fa\u5408\u540c\u603b\u91d1\u989d\u3002", (String)"ContStatusChangeValidator_8", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
        }
    }

    private void vaildBudget(ExtendedDataEntity dataEntity, String key) {
        DynamicObject statusBill = dataEntity.getDataEntity();
        DynamicObject contract = statusBill.getDynamicObject("contract");
        contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_outcontract");
        Set<Object> controlProIdSet = this.getControlProIdSet(statusBill);
        if (controlProIdSet.isEmpty()) {
            return;
        }
        Set<Object> oldProIdSet = controlProIdSet.stream().map(Object::toString).map(Long::valueOf).filter(proId -> !ProBudgetControlHelper.checkIsNewProBudgetCtrl((Long)proId)).collect(Collectors.toSet());
        Map<String, BigDecimal> proBudgetAmountMap = this.buildBudgetAmountMap(statusBill, oldProIdSet);
        BudgetValidateInfo validateInfo = null;
        if (StringUtils.equals((CharSequence)"submit", (CharSequence)key)) {
            validateInfo = BudgetValidateAndUpdateHelper.validateBudgetAmountOnSubmit(proBudgetAmountMap, (String)contract.getPkValue().toString(), (PerformAmountTypeEnum)PerformAmountTypeEnum.CONTRACT);
        } else if (StringUtils.equals((CharSequence)"audit", (CharSequence)key)) {
            validateInfo = BudgetValidateAndUpdateHelper.validateBudgetAmountOnAuditAndUnaudit(proBudgetAmountMap, (String)contract.getPkValue().toString(), (long)statusBill.getLong("id"), (String)"pmct_statuschange", (PerformAmountTypeEnum)PerformAmountTypeEnum.CONTRACT, (boolean)false);
        } else if (StringUtils.equals((CharSequence)"unaudit", (CharSequence)key)) {
            validateInfo = BudgetValidateAndUpdateHelper.validateBudgetAmountOnAuditAndUnaudit(proBudgetAmountMap, (String)contract.getPkValue().toString(), (long)statusBill.getLong("id"), (String)"pmct_statuschange", (PerformAmountTypeEnum)PerformAmountTypeEnum.CONTRACT, (boolean)true);
        }
        this.analysisValidateInfo(dataEntity, validateInfo, null);
    }

    protected void appAmountValidate(ExtendedDataEntity dataEntity) {
        DynamicObject statusBill = dataEntity.getDataEntity();
        boolean projectCostControl = this.isProjectCostControl(statusBill);
        if (projectCostControl) {
            DynamicObjectCollection entryentity = statusBill.getDynamicObjectCollection("entryentity");
            BigDecimal appAmount = BigDecimal.ZERO;
            for (DynamicObject entryRow : entryentity) {
                BigDecimal amount = entryRow.getBigDecimal("itemappamount");
                if (amount.compareTo(BigDecimal.ZERO) == 0) continue;
                appAmount = appAmount.add(amount);
            }
            BigDecimal apptaxamount = statusBill.getBigDecimal("apptaxamount");
            if (apptaxamount.compareTo(appAmount) != 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5206\u5f55\u5408\u540c\u5ba1\u5b9a\u542b\u7a0e\u91d1\u989d\u5b57\u6bb5\u5408\u8ba1\u4e0d\u7b49\u4e8e\u5408\u540c\u5ba1\u5b9a\u542b\u7a0e\u603b\u91d1\u989d\u3002", (String)"ContStatusChangeValidator_0", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
            }
        }
    }

    @Deprecated
    protected boolean controlAmount(ExtendedDataEntity dataEntity, DynamicObject finSettleBill, DynamicObject contract) {
        boolean outControl = false;
        DynamicObject contractType = contract.getDynamicObject("contracttype");
        String ammountcontrolsettle = (contractType = BusinessDataServiceHelper.loadSingle((Object)contractType.getPkValue(), (String)"pmct_conttype")).getString("ammountcontrolsettle");
        if ("2".equals(ammountcontrolsettle) || "1".equals(ammountcontrolsettle)) {
            Map<String, BigDecimal> budgetAmountMap = this.buildBudgetAmountMap(finSettleBill, BigDecimal.ONE);
            for (Map.Entry<String, BigDecimal> map : budgetAmountMap.entrySet()) {
                if (map.getValue().compareTo(BigDecimal.ZERO) <= 0) continue;
                DynamicObject budget = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(map.getKey()), (String)"pmas_projectbudget");
                if ("2".equals(ammountcontrolsettle)) {
                    this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff0c\u9884\u7b97\u9879\u201c%s\u201d\u7684\u51b3\u7b97\u91d1\u989d\u5df2\u7ecf\u8d85\u51fa\u5408\u540c\u91d1\u989d\u3002", (String)"ContStatusChangeValidator_18", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), budget.getString("name")));
                    outControl = true;
                    continue;
                }
                if (!"1".equals(ammountcontrolsettle)) continue;
                this.addWarningMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9884\u7b97\u9879\u201c%s\u201d\u7684\u51b3\u7b97\u91d1\u989d\u5df2\u7ecf\u8d85\u51fa\u5408\u540c\u91d1\u989d", (String)"ContStatusChangeValidator_19", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), budget.getString("name")));
            }
        }
        return outControl;
    }

    protected void analysisValidateInfo(ExtendedDataEntity dataEntity, BudgetValidateInfo validateInfo, DynamicObject currency) {
        if (validateInfo != null) {
            boolean outOfControl = validateInfo.isOutOfControl();
            boolean outOfRemind = validateInfo.isOutOfRemind();
            Map resultMap = validateInfo.getResultMap();
            if (resultMap != null && !resultMap.isEmpty()) {
                int amtPrecision = 2;
                if (currency != null) {
                    amtPrecision = currency.getInt("amtprecision");
                }
                for (Map.Entry resultEntry : resultMap.entrySet()) {
                    DynamicObject proCurrency;
                    DynamicObject originalBudget = (DynamicObject)resultEntry.getKey();
                    DynamicObject validateBudget = (DynamicObject)resultEntry.getValue();
                    if (originalBudget.getPkValue().equals(validateBudget.getPkValue())) {
                        if (outOfControl) {
                            this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9884\u7b97\u9879\u201c%s\u201d\u7684\u7d2f\u8ba1\u91d1\u989d\u5df2\u7ecf\u8d85\u51fa\u63a7\u5236\u9650\u989d\u3002", (String)"ContStatusChangeValidator_20", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), originalBudget.getString("name")));
                            continue;
                        }
                        if (!outOfRemind) continue;
                        proCurrency = originalBudget.getDynamicObject("currency");
                        if (proCurrency != null) {
                            amtPrecision = proCurrency.getInt("amtprecision");
                        }
                        this.addWarningMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9884\u7b97\u9879\u201c%1$s\u201d\u7684\u7d2f\u8ba1\u91d1\u989d\u5df2\u7ecf\u8fbe\u5230%2$s\uff0c\u9884\u7b97\u91d1\u989d\u662f%3$s\u3002", (String)"ContStatusChangeValidator_21", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), originalBudget.getString("name"), originalBudget.getBigDecimal("occupyamt").setScale(amtPrecision, RoundingMode.DOWN).toString(), originalBudget.getBigDecimal("budgetamount").setScale(amtPrecision, RoundingMode.DOWN).toString()));
                        continue;
                    }
                    if (outOfControl) {
                        this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9884\u7b97\u9879\u201c%1$s\u201d\u7684\u4e0a\u7ea7\u9884\u7b97\u9879\u201c%2$s\u201d\u7684\u7d2f\u8ba1\u91d1\u989d\u5df2\u7ecf\u8d85\u51fa\u63a7\u5236\u9650\u989d\u3002", (String)"ContStatusChangeValidator_22", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), originalBudget.getString("name"), validateBudget.getString("name")));
                        continue;
                    }
                    if (!outOfRemind) continue;
                    proCurrency = originalBudget.getDynamicObject("currency");
                    if (proCurrency != null) {
                        amtPrecision = proCurrency.getInt("amtprecision");
                    }
                    this.addWarningMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9884\u7b97\u9879\u201c%1$s\u201d\u7684\u4e0a\u7ea7\u9884\u7b97\u9879\u201c%2$s\u201d\u7684\u7d2f\u8ba1\u91d1\u989d\u5df2\u7ecf\u8fbe\u5230%3$s\uff0c\u9884\u7b97\u91d1\u989d\u662f%4$s\u3002", (String)"ContStatusChangeValidator_23", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), originalBudget.getString("name"), validateBudget.getString("name"), originalBudget.getBigDecimal("occupyamt").setScale(amtPrecision, RoundingMode.DOWN).toString(), originalBudget.getBigDecimal("budgetamount").setScale(amtPrecision, RoundingMode.DOWN).toString()));
                }
            }
        }
    }

    protected BigDecimal getExchangeRate(DynamicObject contract, DynamicObject project) {
        DynamicObject exRateTable;
        DynamicObject org = project.getDynamicObject("org");
        DynamicObject proCurrency = project.getDynamicObject("currencyfield");
        DynamicObject contractCurrency = contract.getDynamicObject("currency");
        DynamicObject stdCurrency = contract.getDynamicObject("stdcurrency");
        if (proCurrency != null && contractCurrency != null && proCurrency.getPkValue().equals(contractCurrency.getPkValue())) {
            return BigDecimal.ONE;
        }
        if (proCurrency != null && stdCurrency != null && proCurrency.getPkValue().equals(stdCurrency.getPkValue())) {
            return contract.getBigDecimal("exchangerate");
        }
        BigDecimal exchangeRate = BigDecimal.ONE;
        if (org != null && proCurrency != null && contractCurrency != null && (exRateTable = CurrencyHelper.getExRateTable((Long)org.getLong("id"))) != null) {
            exchangeRate = CurrencyHelper.getExChangeRate((Long)contractCurrency.getLong("id"), (Long)proCurrency.getLong("id"), (Long)exRateTable.getLong("id"), (Date)contract.getDate("createtime"));
        }
        return exchangeRate;
    }

    protected Map<String, BigDecimal> buildBudgetAmountMap(DynamicObject bill, BigDecimal exchangeRate) {
        HashMap<String, BigDecimal> budgetAmountMap = new HashMap<String, BigDecimal>();
        DynamicObjectCollection entryentity = bill.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entryentity) {
            BigDecimal amount = entry.getBigDecimal("itemsubamount").negate();
            DynamicObject budget = entry.getDynamicObject("budgetitem");
            if (budget == null || amount == null || amount.compareTo(BigDecimal.ZERO) == 0) continue;
            BigDecimal budgetAmount = (BigDecimal)budgetAmountMap.get(budget.getPkValue().toString());
            if (budgetAmount == null) {
                budgetAmount = BigDecimal.ZERO;
            }
            budgetAmountMap.put(budget.getPkValue().toString(), budgetAmount.add(amount.multiply(exchangeRate)));
        }
        return budgetAmountMap;
    }

    protected int amountCompare(DynamicObject conStatusChangeBill, DynamicObject contract) {
        BigDecimal contractAmount = contract.getBigDecimal("totaloftaxamount");
        BigDecimal appTaxAmount = conStatusChangeBill.getBigDecimal("apptaxamount");
        int compare = contractAmount.compareTo(appTaxAmount);
        return compare;
    }

    private boolean isProjectCostControl(DynamicObject bill) {
        DynamicObject contract = bill.getDynamicObject("contract");
        contract = BusinessDataServiceHelper.loadSingle((String)"pmct_contracttpl", (String)"multipartsettlement,project", (QFilter[])new QFilter[]{new QFilter("id", "=", contract.getPkValue())});
        DynamicObjectCollection entryEntity = bill.getDynamicObjectCollection("entryentity");
        if (entryEntity.isEmpty()) {
            return false;
        }
        boolean multipartSettlement = contract.getBoolean("multipartsettlement");
        if (multipartSettlement) {
            DynamicObject[] proApps;
            HashSet<Object> proIdSet = new HashSet<Object>();
            for (DynamicObject entry : entryEntity) {
                DynamicObject budgetItem = entry.getDynamicObject("budgetitem");
                DynamicObject budgetProject = budgetItem.getDynamicObject("project");
                proIdSet.add(budgetProject.getPkValue());
            }
            for (DynamicObject proApp : proApps = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"projectcostcontrol", (QFilter[])new QFilter[]{new QFilter("pro", "in", proIdSet)})) {
                boolean projectCostControl = proApp.getBoolean("projectcostcontrol");
                if (!projectCostControl) continue;
                return true;
            }
        } else {
            DynamicObject[] proApps;
            DynamicObject contPro = contract.getDynamicObject("project");
            if (contPro != null && (proApps = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"projectcostcontrol", (QFilter[])new QFilter[]{new QFilter("pro", "=", contPro.getPkValue())})) != null && proApps.length > 0 && proApps[0].getBoolean("projectcostcontrol")) {
                return true;
            }
        }
        return false;
    }

    private Set<Object> getControlProIdSet(DynamicObject bill) {
        HashSet<Object> controlProIdSet = new HashSet<Object>(1);
        DynamicObject contract = bill.getDynamicObject("contract");
        boolean multipartSettlement = (contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_outcontract")).getBoolean("multipartsettlement");
        if (multipartSettlement) {
            DynamicObjectCollection entryEntity = bill.getDynamicObjectCollection("entryentity");
            HashSet<Object> proIdSet = new HashSet<Object>(entryEntity.size());
            for (DynamicObject entry : entryEntity) {
                DynamicObject budgetItem = entry.getDynamicObject("budgetitem");
                DynamicObject budgetProject = budgetItem.getDynamicObject("project");
                proIdSet.add(budgetProject.getPkValue());
            }
            DynamicObject[] proApps = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"projectcostcontrol,pro", (QFilter[])new QFilter[]{new QFilter("pro", "in", proIdSet)});
            controlProIdSet = new HashSet(proApps.length);
            for (DynamicObject proApp : proApps) {
                boolean projectCostControl = proApp.getBoolean("projectcostcontrol");
                if (!projectCostControl) continue;
                DynamicObject pro = proApp.getDynamicObject("pro");
                controlProIdSet.add(pro.getPkValue());
            }
        } else {
            DynamicObject[] proApps;
            DynamicObject contPro = contract.getDynamicObject("project");
            if (contPro != null && (proApps = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"projectcostcontrol,org,currencyfield", (QFilter[])new QFilter[]{new QFilter("pro", "=", contPro.getPkValue())})) != null && proApps.length > 0 && proApps[0].getBoolean("projectcostcontrol")) {
                controlProIdSet.add(contPro.getPkValue());
            }
        }
        return controlProIdSet;
    }

    protected Map<String, BigDecimal> buildBudgetAmountMap(DynamicObject bill, Set<Object> controlProIdSet) {
        DynamicObject[] proApps = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"pro,org,currencyfield", (QFilter[])new QFilter[]{new QFilter("pro", "in", controlProIdSet)});
        DynamicObject contract = bill.getDynamicObject("contract");
        contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_outcontract");
        HashMap<Object, BigDecimal> exchangeRateMap = new HashMap<Object, BigDecimal>(16);
        if (proApps != null && proApps.length > 0) {
            for (DynamicObject proApp : proApps) {
                BigDecimal exchangeRate = BudgetValidateAndUpdateHelper.getExchangeRate((DynamicObject)contract, (DynamicObject)proApp);
                DynamicObject pro = proApp.getDynamicObject("pro");
                exchangeRateMap.put(pro.getPkValue(), exchangeRate);
            }
        } else {
            for (Object e : controlProIdSet) {
                exchangeRateMap.put(e, BigDecimal.ONE);
            }
        }
        DynamicObjectCollection entryentity = bill.getDynamicObjectCollection("entryentity");
        HashMap<String, BigDecimal> hashMap = new HashMap<String, BigDecimal>(entryentity.size());
        for (DynamicObject entry : entryentity) {
            BigDecimal amount = entry.getBigDecimal("itemappamount");
            DynamicObject budget = entry.getDynamicObject("budgetitem");
            DynamicObject project = budget.getDynamicObject("project");
            if (!controlProIdSet.contains(project.getPkValue()) || budget == null || amount == null || amount.compareTo(BigDecimal.ZERO) == 0) continue;
            BigDecimal budgetAmount = (BigDecimal)hashMap.get(budget.getPkValue().toString());
            if (budgetAmount == null) {
                budgetAmount = BigDecimal.ZERO;
            }
            if (!exchangeRateMap.containsKey(project.getPkValue())) continue;
            hashMap.put(budget.getPkValue().toString(), budgetAmount.add(amount.multiply((BigDecimal)exchangeRateMap.get(project.getPkValue()))));
        }
        return hashMap;
    }
}

