/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.opplugin.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.basedataref.BaseDataCheckRefrence;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.pmgt.pmbs.common.enums.ContractPayTypeEnum;
import kd.pmgt.pmbs.common.enums.OperationEnum;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;

public class ContractRelationBillUnAuditValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        String key = this.getOperateKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)OperationEnum.UNAUDIT.getValue())) {
            for (ExtendedDataEntity dataEntity : dataEntities) {
                DynamicObject bill = dataEntity.getDataEntity();
                if (!StatusEnum.CHECKED.getValue().equals(bill.getString("billstatus"))) continue;
                String curFormId = bill.getDataEntityType().getName();
                if (this.checkExistNewData(dataEntity, bill = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(bill.getPkValue().toString()), (String)curFormId))) {
                    return;
                }
                this.checkPlanItemList(dataEntity, bill, curFormId);
            }
        }
    }

    private void checkPlanItemList(ExtendedDataEntity dataEntity, DynamicObject bill, String curFormId) {
        DynamicObjectCollection planEntry = new DynamicObjectCollection();
        DynamicObject contract = bill.getDynamicObject("contract");
        contract = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(contract.getPkValue().toString()), (String)"pmct_contracttpl");
        String payDirection = contract.getString("paydirection");
        ArrayList<DynamicObject> newInventoryList = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> priceChangeList = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> numberChangeList = new ArrayList<DynamicObject>(16);
        DynamicObjectCollection cardEntry = null;
        String subBillType = "";
        String planSourceIdKey = null;
        boolean isSettle = false;
        if (StringUtils.equals((CharSequence)PayDirectionEnum.OUT.getValue(), (CharSequence)payDirection)) {
            if (StringUtils.equals((CharSequence)"pmct_contractrevision", (CharSequence)curFormId)) {
                planEntry = bill.getDynamicObjectCollection("outcontpayplanentry");
                planSourceIdKey = "payplansourceid";
            } else if (StringUtils.equals((CharSequence)"pmct_outcontractrevision", (CharSequence)curFormId)) {
                cardEntry = bill.getDynamicObjectCollection("kapianentry");
                subBillType = "subchangetype";
                planEntry = bill.getDynamicObjectCollection("changepayplanentry");
                planSourceIdKey = "payplansourceid";
            } else if (StringUtils.equals((CharSequence)"pmct_outclaimbill", (CharSequence)curFormId)) {
                cardEntry = bill.getDynamicObjectCollection("kapianentry");
                subBillType = "subclaimtype";
                planEntry = bill.getDynamicObjectCollection("claimpayplanentry");
                planSourceIdKey = "payplansourceid";
                isSettle = bill.getBoolean("issettle");
            } else if (StringUtils.equals((CharSequence)"pmct_outaddagreement", (CharSequence)curFormId)) {
                cardEntry = bill.getDynamicObjectCollection("cardentry");
                subBillType = "subaddtype";
                planEntry = bill.getDynamicObjectCollection("payplanentry");
                planSourceIdKey = "payplansourceid";
            }
        } else if (StringUtils.equals((CharSequence)"pmct_contractrevision", (CharSequence)curFormId)) {
            planEntry = bill.getDynamicObjectCollection("incontpayplanentry");
            planSourceIdKey = "incomeplansourceid";
        } else if (StringUtils.equals((CharSequence)"pmct_incontractrevision", (CharSequence)curFormId)) {
            cardEntry = bill.getDynamicObjectCollection("kapianentry");
            subBillType = "subchangetype";
            planEntry = bill.getDynamicObjectCollection("incomeplanentry");
            planSourceIdKey = "incomeplansourceid";
        } else if (StringUtils.equals((CharSequence)"pmct_inclaimbill", (CharSequence)curFormId)) {
            cardEntry = bill.getDynamicObjectCollection("kapianentry");
            subBillType = "subclaimtype";
            planEntry = bill.getDynamicObjectCollection("claimincomeplanentry");
            isSettle = bill.getBoolean("issettle");
            planSourceIdKey = "incomeplansourceid";
        } else if (StringUtils.equals((CharSequence)"pmct_inaddagreement", (CharSequence)curFormId)) {
            cardEntry = bill.getDynamicObjectCollection("cardentry");
            subBillType = "subaddtype";
            planEntry = bill.getDynamicObjectCollection("incomeplanentry");
            planSourceIdKey = "incomeplansourceid";
        }
        if (isSettle) {
            String msg = ResManager.loadKDString((String)"\u5df2\u7ed3\u7b97\u7684\u7d22\u8d54\u5355\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"ContractRelationBillUnAuditValidator_21", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, msg);
        }
        if (cardEntry != null && cardEntry.size() > 0) {
            String billType = subBillType;
            boolean contractListingFlag = false;
            for (DynamicObject cardObject : cardEntry) {
                DynamicObjectCollection inventoryEntry = cardObject.getDynamicObjectCollection("entryentity");
                if (inventoryEntry == null || inventoryEntry.size() <= 0) continue;
                newInventoryList.addAll(inventoryEntry.stream().filter(o -> o.getLong("newlistingid") > 0L).collect(Collectors.toList()));
                numberChangeList.addAll(inventoryEntry.stream().filter(o -> o.getString(billType).equals("0")).collect(Collectors.toList()));
                priceChangeList.addAll(inventoryEntry.stream().filter(o -> o.getString(billType).equals("1")).collect(Collectors.toList()));
                contractListingFlag = true;
            }
            if (contractListingFlag) {
                this.checkContractListing(dataEntity, contract, newInventoryList, priceChangeList, numberChangeList);
            }
        }
        if (StringUtils.equals((CharSequence)PayDirectionEnum.OUT.getValue(), (CharSequence)payDirection)) {
            this.checkPayPlanItem(dataEntity, bill, planEntry, curFormId);
            this.checkPayPlanItemTargetBill(dataEntity, planEntry, curFormId, planSourceIdKey);
        } else {
            this.checkCollectionPlanItem(dataEntity, bill, planEntry, curFormId);
            this.checkCollectionPlanItemTargetBill(dataEntity, planEntry, curFormId, planSourceIdKey);
        }
    }

    private void checkPayPlanItemTargetBill(ExtendedDataEntity dataEntity, DynamicObjectCollection planEntry, String curFormId, String planSourceIdKey) {
        block7: {
            block6: {
                if (!StringUtils.equals((CharSequence)"pmct_outclaimbill", (CharSequence)curFormId) || dataEntity.getDataEntity().getBoolean("isneedsettle")) break block6;
                QFilter filter = new QFilter("payplanentryid", "=", dataEntity.getDataEntity().getPkValue()).and("autogenerated", "=", (Object)Boolean.TRUE);
                DynamicObject payItem = BusinessDataServiceHelper.loadSingle((String)"pmbs_contractpayitem", (String)"", (QFilter[])new QFilter[]{filter});
                if (payItem == null) break block7;
                String payItemName = payItem.getString("name");
                Map targetBillIds = BFTrackerServiceHelper.findTargetBills((String)"pmbs_contractpayitembook", (Long[])new Long[]{payItem.getLong("id")});
                if (targetBillIds.isEmpty()) break block7;
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6761\u76ee\u540d\u79f0\uff1a%s\u5df2\u5f15\u7528\u6216\u4e0b\u63a8\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"ContractRelationBillUnAuditValidator_22", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), payItemName));
                break block7;
            }
            ArrayList<Long> itemIds = new ArrayList<Long>(16);
            for (DynamicObject plan : planEntry) {
                Long itemId = Long.parseLong(StringUtils.equals((CharSequence)"pmct_contractrevision", (CharSequence)curFormId) ? plan.getString("conpayitemid") : plan.getString("conplanitemid"));
                itemIds.add(itemId);
            }
            DynamicObject[] contractPayItems = new DynamicObject[itemIds.size()];
            if (itemIds.size() > 0) {
                contractPayItems = BusinessDataServiceHelper.load((Object[])itemIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmbs_contractpayitem"));
            }
            for (DynamicObject plan : planEntry) {
                Optional<DynamicObject> first;
                long itemId = Long.parseLong(StringUtils.equals((CharSequence)"pmct_contractrevision", (CharSequence)curFormId) ? plan.getString("conpayitemid") : plan.getString("conplanitemid"));
                if (contractPayItems.length <= 0 || !(first = Arrays.stream(contractPayItems).filter(o -> itemId == Long.parseLong(o.getPkValue().toString())).findFirst()).isPresent()) continue;
                DynamicObject item = first.get();
                String itemName = item.getString("name");
                String planSourceId = plan.getString(planSourceIdKey);
                Map targetBillIds = BFTrackerServiceHelper.findTargetBills((String)"pmbs_contractpayitembook", (Long[])new Long[]{item.getLong("id")});
                if (targetBillIds.isEmpty()) continue;
                if (StringUtils.isEmpty((CharSequence)planSourceId)) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6761\u76ee\u540d\u79f0\uff1a%s \u8be5\u8ba1\u5212\u5df2\u7ecf\u88ab\u5f15\u7528\u6216\u4e0b\u63a8\uff0c\u4e0d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"ContractRelationBillUnAuditValidator_19", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), itemName));
                    continue;
                }
                Date auditDate = dataEntity.getDataEntity().getDate("auditdate");
                for (Map.Entry targetBillId : targetBillIds.entrySet()) {
                    String billKey = (String)targetBillId.getKey();
                    HashSet targetIdsByBill = (HashSet)targetBillId.getValue();
                    for (Long billId : targetIdsByBill) {
                        DynamicObject targetBill = BusinessDataServiceHelper.loadSingle((Object)billId, (String)billKey);
                        Date targetCreateTime = targetBill.getDate("createtime");
                        if (auditDate.getTime() >= targetCreateTime.getTime()) continue;
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6761\u76ee\u540d\u79f0\uff1a%s \u8be5\u8ba1\u5212\u5df2\u7ecf\u88ab\u5f15\u7528\u6216\u4e0b\u63a8\uff0c\u4e0d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"ContractRelationBillUnAuditValidator_19", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), itemName));
                    }
                }
            }
        }
    }

    private void checkCollectionPlanItemTargetBill(ExtendedDataEntity dataEntity, DynamicObjectCollection planEntry, String curFormId, String planSourceIdKey) {
        block7: {
            block6: {
                if (!StringUtils.equals((CharSequence)"pmct_inclaimbill", (CharSequence)curFormId) || dataEntity.getDataEntity().getBoolean("isneedsettle")) break block6;
                QFilter filter = new QFilter("sourcebill", "=", dataEntity.getDataEntity().getPkValue()).and("autogenerated", "=", (Object)Boolean.TRUE);
                DynamicObject collectionItem = BusinessDataServiceHelper.loadSingle((String)"pmbs_contractcollectitem", (String)"", (QFilter[])new QFilter[]{filter});
                if (collectionItem == null) break block7;
                String payItemName = collectionItem.getString("name");
                Map targetBillIds = BFTrackerServiceHelper.findTargetBills((String)"pmbs_contractcolitembook", (Long[])new Long[]{collectionItem.getLong("id")});
                if (targetBillIds.isEmpty()) break block7;
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6761\u76ee\u540d\u79f0\uff1a%s \u8be5\u8ba1\u5212\u5df2\u7ecf\u88ab\u5f15\u7528\u6216\u4e0b\u63a8\uff0c\u4e0d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"ContractRelationBillUnAuditValidator_19", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), payItemName));
                break block7;
            }
            ArrayList<Long> itemIds = new ArrayList<Long>(16);
            for (DynamicObject plan : planEntry) {
                Long itemId = Long.parseLong(StringUtils.equals((CharSequence)"pmct_contractrevision", (CharSequence)curFormId) ? plan.getString("conincomeitemid") : plan.getString("conplanitemid"));
                itemIds.add(itemId);
            }
            DynamicObject[] collectItems = new DynamicObject[itemIds.size()];
            if (itemIds.size() > 0) {
                collectItems = BusinessDataServiceHelper.load((Object[])itemIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmbs_contractcollectitem"));
            }
            for (DynamicObject plan : planEntry) {
                Optional<DynamicObject> first;
                Long itemId = Long.parseLong(StringUtils.equals((CharSequence)"pmct_contractrevision", (CharSequence)curFormId) ? plan.getString("conincomeitemid") : plan.getString("conplanitemid"));
                if (collectItems == null || collectItems.length <= 0 || !(first = Arrays.stream(collectItems).filter(o -> itemId.equals(Long.parseLong(o.getPkValue().toString()))).findFirst()).isPresent()) continue;
                DynamicObject item = first.get();
                String itemName = item.getString("name");
                String planSourceId = plan.getString(planSourceIdKey);
                Map targetBillIds = BFTrackerServiceHelper.findTargetBills((String)"pmbs_contractcolitembook", (Long[])new Long[]{item.getLong("id")});
                if (targetBillIds.isEmpty()) continue;
                if (StringUtils.isEmpty((CharSequence)planSourceId)) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6761\u76ee\u540d\u79f0\uff1a%s \u8be5\u8ba1\u5212\u5df2\u7ecf\u88ab\u5f15\u7528\u6216\u4e0b\u63a8\uff0c\u4e0d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"ContractRelationBillUnAuditValidator_19", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), itemName));
                    continue;
                }
                Date auditDate = dataEntity.getDataEntity().getDate("auditdate");
                for (Map.Entry targetBillId : targetBillIds.entrySet()) {
                    String billKey = (String)targetBillId.getKey();
                    HashSet targetIdsByBill = (HashSet)targetBillId.getValue();
                    for (Long billId : targetIdsByBill) {
                        DynamicObject targetBill = BusinessDataServiceHelper.loadSingle((Object)billId, (String)billKey);
                        Date targetCreateTime = targetBill.getDate("createtime");
                        if (auditDate.getTime() >= targetCreateTime.getTime()) continue;
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6761\u76ee\u540d\u79f0\uff1a%s \u8be5\u8ba1\u5212\u5df2\u7ecf\u88ab\u5f15\u7528\u6216\u4e0b\u63a8\uff0c\u4e0d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"ContractRelationBillUnAuditValidator_19", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), itemName));
                    }
                }
            }
        }
    }

    private void checkContractListing(ExtendedDataEntity dataEntity, DynamicObject contract, List<DynamicObject> newInventoryList, List<DynamicObject> priceChangeList, List<DynamicObject> numberChangeList) {
        DynamicObject contractListingSettle;
        DynamicObject[] contractSettles;
        QFilter onListFilter = new QFilter("isonlist", "=", (Object)Boolean.TRUE);
        QFilter contractFilter = new QFilter("contract", "=", (Object)Long.parseLong(contract.getPkValue().toString()));
        String contractSettleFormId = "pmct_incontract_settle";
        if (PayDirectionEnum.OUT.getValue().equals(contract.get("paydirection"))) {
            contractSettleFormId = "pmct_outcontract_settle";
        }
        if ((contractSettles = BusinessDataServiceHelper.load((String)contractSettleFormId, (String)"id", (QFilter[])new QFilter[]{contractFilter, onListFilter})).length == 0) {
            return;
        }
        HashMap<Object, DynamicObject> contractListingMap = new HashMap<Object, DynamicObject>(16);
        Object[] contractSettleIds = Arrays.stream(contractSettles).map(DataEntityBase::getPkValue).collect(Collectors.toList()).toArray();
        if (contractSettleIds.length == 0) {
            return;
        }
        contractSettles = BusinessDataServiceHelper.load((Object[])contractSettleIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)contractSettleFormId));
        for (DynamicObject contractSettle : contractSettles) {
            DynamicObjectCollection listModelCollection = contractSettle.getDynamicObjectCollection("listmodelentry");
            if (listModelCollection == null || listModelCollection.size() == 0) continue;
            for (DynamicObject listModel : listModelCollection) {
                DynamicObjectCollection listEntry = listModel.getDynamicObjectCollection("listentry");
                if (listEntry == null || listEntry.size() == 0) continue;
                for (DynamicObject listObject : listEntry) {
                    if (listObject.getDynamicObject("listing") == null || contractListingMap.containsKey(listObject.getDynamicObject("listing").getPkValue())) continue;
                    contractListingMap.put(listObject.getDynamicObject("listing").getPkValue(), listObject);
                }
            }
        }
        if (contractListingMap.size() == 0) {
            return;
        }
        if (newInventoryList.size() > 0) {
            for (DynamicObject cardObject : newInventoryList) {
                Long inventoryId = cardObject.getLong("newlistingid");
                contractListingSettle = (DynamicObject)contractListingMap.get(inventoryId);
                if (contractListingSettle == null) continue;
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u5931\u8d25\uff0c\u660e\u7ec6\u6e05\u5355%s\u5df2\u7ecf\u5f00\u59cb\u7ed3\u7b97\u3002", (String)"ContractRelationBillUnAuditValidator_1", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), cardObject.getString("listnumber")));
            }
        }
        if (numberChangeList.size() > 0) {
            for (DynamicObject inventory : numberChangeList) {
                DynamicObject contractList = inventory.getDynamicObject("listid");
                if (contractList == null || (contractListingSettle = (DynamicObject)contractListingMap.get(contractList.getPkValue())) == null) continue;
                BigDecimal currentNumber = inventory.getBigDecimal("qty");
                BigDecimal lastQty = contractListingSettle.getBigDecimal("lstqty");
                if (lastQty.compareTo(currentNumber) <= 0) continue;
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u5931\u8d25\uff0c\u660e\u7ec6\u6e05\u5355%1$s\u5f53\u524d\u7ed3\u7b97\u6570\u4e3a%2$s\uff0c\u5df2\u8d85\u8fc7\u8be5\u6e05\u5355\u7684\u5f53\u524d\u6570\u91cf\u3002", (String)"ContractRelationBillUnAuditValidator_20", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), inventory.getString("listname"), lastQty.setScale(0)));
            }
        }
        DynamicObject bill = dataEntity.getDataEntity();
        String curFormId = bill.getDataEntityType().getName();
        String changedTaxPrice = "biangenghouhsdj";
        if ("pmct_inclaimbill".equals(curFormId) || "pmct_outclaimbill".equals(curFormId)) {
            changedTaxPrice = "afterclaimoftaxprice";
        } else if ("pmct_inaddagreement".equals(curFormId) || "pmct_outaddagreement".equals(curFormId)) {
            changedTaxPrice = "changedpriceoftax";
        }
        if (priceChangeList.size() > 0) {
            for (DynamicObject inventory : priceChangeList) {
                DynamicObject contractListingSettle2;
                DynamicObject contractList = inventory.getDynamicObject("listid");
                if (contractList == null || (contractListingSettle2 = (DynamicObject)contractListingMap.get(contractList.getPkValue())) == null) continue;
                BigDecimal currentTaxPrice = contractListingSettle2.getBigDecimal("curtaxprice");
                BigDecimal newTaxPrice = inventory.getBigDecimal(changedTaxPrice);
                if (newTaxPrice.compareTo(currentTaxPrice) != 0) continue;
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u5931\u8d25\uff0c\u660e\u7ec6\u6e05\u5355%s\u5df2\u7ecf\u5f00\u59cb\u57fa\u4e8e\u65b0\u7684\u5355\u4ef7\u8fdb\u884c\u7ed3\u7b97\u3002", (String)"ContractRelationBillUnAuditValidator_3", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), inventory.getString("listname")));
            }
        }
    }

    private void checkPayPlanItem(ExtendedDataEntity dataEntity, DynamicObject bill, DynamicObjectCollection planEntry, String curFormId) {
        String conPlanItemId;
        ArrayList<DynamicObject> changePayPlanIdList = new ArrayList<DynamicObject>(16);
        ArrayList<Long> newPayPlanIdList = new ArrayList<Long>(16);
        HashMap<Long, Integer> payPlanMap = new HashMap<Long, Integer>(16);
        String string = conPlanItemId = "pmct_contractrevision".equals(curFormId) ? "conpayitemid" : "conplanitemid";
        if (planEntry != null && planEntry.size() > 0) {
            int index = 1;
            for (DynamicObject plan : planEntry) {
                if (plan.getString("payplansourceid").isEmpty() && !plan.getString(conPlanItemId).isEmpty()) {
                    newPayPlanIdList.add(Long.valueOf(plan.getString(conPlanItemId)));
                } else {
                    changePayPlanIdList.add(plan);
                }
                if (!plan.getString(conPlanItemId).isEmpty()) {
                    payPlanMap.put(Long.valueOf(plan.getString(conPlanItemId)), index);
                }
                ++index;
            }
        } else {
            DynamicObject[] contractPayItems;
            DynamicObject contract = bill.getDynamicObject("contract");
            DynamicObject[] contractFilter = new QFilter("contract", "=", contract.getPkValue());
            if ("pmct_outclaimbill".equals(curFormId)) {
                contractFilter.and(new QFilter("paytype", "=", (Object)ContractPayTypeEnum.CLAIM_PAYMENT.getValue()));
            }
            if ((contractPayItems = BusinessDataServiceHelper.load((String)"pmbs_contractpayitem", (String)String.join((CharSequence)",", "reimbursedcomamt", "paidcomamt"), (QFilter[])new QFilter[]{contractFilter})) != null && contractPayItems.length > 0) {
                DynamicObject contractPayItem = contractPayItems[0];
                BigDecimal reimbursedComAmt = contractPayItem.getBigDecimal("reimbursedcomamt");
                BigDecimal paidComAmt = contractPayItem.getBigDecimal("paidcomamt");
                if (BigDecimal.ZERO.compareTo(reimbursedComAmt) < 0) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u5931\u8d25\uff0c\u5408\u540c\u4ed8\u6b3e\u6761\u76ee\u5df2\u7ecf\u53d1\u751f\u62a5\u9500\u3002", (String)"ContractRelationBillUnAuditValidator_4", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                }
                if (BigDecimal.ZERO.compareTo(paidComAmt) < 0) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u5931\u8d25\uff0c\u5408\u540c\u4ed8\u6b3e\u6761\u76ee\u5df2\u7ecf\u53d1\u751f\u4ed8\u6b3e\u3002", (String)"ContractRelationBillUnAuditValidator_5", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                }
            }
        }
        if (newPayPlanIdList.size() > 0) {
            DynamicObject[] contractPayItems;
            for (DynamicObject contractPayItem : contractPayItems = BusinessDataServiceHelper.load((String)"pmbs_contractpayitem", (String)String.join((CharSequence)",", "reimbursedcomamt", "paidcomamt"), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)newPayPlanIdList.toArray())})) {
                BigDecimal reimbursedComAmt = contractPayItem.getBigDecimal("reimbursedcomamt");
                BigDecimal paidComAmt = contractPayItem.getBigDecimal("paidcomamt");
                Integer index = (Integer)payPlanMap.get(contractPayItem.getPkValue());
                if (BigDecimal.ZERO.compareTo(reimbursedComAmt) < 0) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u5931\u8d25\uff0c\u7b2c%s\u884c\u4ed8\u6b3e\u8ba1\u5212\u5df2\u7ecf\u53d1\u751f\u62a5\u9500\u3002", (String)"ContractRelationBillUnAuditValidator_6", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), index));
                }
                if (BigDecimal.ZERO.compareTo(paidComAmt) < 0) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u5931\u8d25\uff0c\u7b2c%s\u884c\u4ed8\u6b3e\u8ba1\u5212\u5df2\u7ecf\u53d1\u751f\u4ed8\u6b3e\u3002", (String)"ContractRelationBillUnAuditValidator_7", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), index));
                }
                BaseDataCheckRefrence baseDataCheckRefrence = new BaseDataCheckRefrence();
                baseDataCheckRefrence.setDraftValidReference(true);
                baseDataCheckRefrence.getIgnoreRefEntityIds().add(bill.getDynamicObjectType().getName());
                boolean referenced = baseDataCheckRefrence.isRefrenced((BasedataEntityType)EntityMetadataCache.getDataEntityType((String)"pmbs_contractpayitem"), contractPayItem.getPkValue());
                if (!referenced) continue;
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u5931\u8d25\uff0c\u4ed8\u6b3e\u6761\u76ee%s\u88ab\u5f15\u7528\uff0c\u65e0\u6cd5\u64a4\u56de\u3002", (String)"ContractRelationBillUnAuditValidator_8", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), index));
            }
        }
        if (changePayPlanIdList.size() == 0) {
            return;
        }
        QFilter sourceBillIdFilter = new QFilter("sourcebillid", "=", (Object)Long.parseLong(bill.getPkValue().toString()));
        DynamicObject fundPlanChangeBill = BusinessDataServiceHelper.loadSingle((String)"pmct_fundplanchange", (String)"id", (QFilter[])new QFilter[]{sourceBillIdFilter});
        if (fundPlanChangeBill == null) {
            return;
        }
        fundPlanChangeBill = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(fundPlanChangeBill.getPkValue().toString()), (String)"pmct_fundplanchange");
        DynamicObjectCollection changeEntry = fundPlanChangeBill.getDynamicObjectCollection("changeentity");
        Object[] contractPayItemIds = changePayPlanIdList.stream().map(o -> Long.parseLong(o.getString(conPlanItemId))).collect(Collectors.toList()).toArray();
        DynamicObject[] contractPayItems = BusinessDataServiceHelper.load((Object[])contractPayItemIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmbs_contractpayitem"));
        for (DynamicObject contractPayItem : changePayPlanIdList) {
            long contractPayItemId = Long.parseLong(contractPayItem.getString(conPlanItemId));
            Optional<DynamicObject> first = Arrays.stream(contractPayItems).filter(o -> contractPayItemId == Long.parseLong(o.getPkValue().toString())).findFirst();
            if (!first.isPresent()) continue;
            DynamicObject contractItem = first.get();
            Integer index = (Integer)payPlanMap.get(contractPayItemId);
            for (DynamicObject changeObject : changeEntry) {
                String currentPayPlanId = changeObject.getString("newpayplanid");
                if (StringUtils.isEmpty((CharSequence)currentPayPlanId) || !StringUtils.equals((CharSequence)currentPayPlanId, (CharSequence)contractPayItem.getPkValue().toString())) continue;
                BigDecimal reimbursedComAmt = contractItem.getBigDecimal("reimbursedcomamt");
                BigDecimal paidComAmt = contractItem.getBigDecimal("paidcomamt");
                BigDecimal oldPayAmount = changeObject.getBigDecimal("oldpayamount");
                if (reimbursedComAmt.compareTo(paidComAmt) > 0 && reimbursedComAmt.compareTo(oldPayAmount) > 0) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u8ba1\u5212\u7b2c%s\u9879\uff0c\u5df2\u62a5\u9500\u91d1\u989d\uff08\u542b\u5728\u9014\uff09\u5927\u4e8e \u8be5\u9879\u539f\u542b\u7a0e\u91d1\u989d\u3002", (String)"ContractRelationBillUnAuditValidator_9", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), index));
                    continue;
                }
                if (paidComAmt.compareTo(oldPayAmount) <= 0) continue;
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u8ba1\u5212\u7b2c%s\u9879\uff0c\u5df2\u4ed8\u6b3e\u91d1\u989d\uff08\u542b\u5728\u9014\uff09\u5927\u4e8e \u8be5\u9879\u539f\u542b\u7a0e\u91d1\u989d\u3002", (String)"ContractRelationBillUnAuditValidator_10", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), index));
            }
        }
    }

    private void checkCollectionPlanItem(ExtendedDataEntity dataEntity, DynamicObject bill, DynamicObjectCollection planEntry, String curFormId) {
        String conPlanItemId;
        ArrayList<DynamicObject> changePayList = new ArrayList<DynamicObject>(16);
        ArrayList<Long> newPayPlanIdList = new ArrayList<Long>(16);
        HashMap<Long, Integer> payPlanMap = new HashMap<Long, Integer>(16);
        String string = conPlanItemId = "pmct_contractrevision".equals(curFormId) ? "conincomeitemid" : "conplanitemid";
        if (planEntry != null && planEntry.size() > 0) {
            int index = 1;
            for (DynamicObject plan : planEntry) {
                if (plan.getLong("incomeplansourceid") == 0L && !plan.getString(conPlanItemId).isEmpty()) {
                    newPayPlanIdList.add(Long.valueOf(plan.getString(conPlanItemId)));
                } else {
                    changePayList.add(plan);
                }
                if (!plan.getString(conPlanItemId).isEmpty()) {
                    payPlanMap.put(Long.valueOf(plan.getString(conPlanItemId)), index);
                }
                ++index;
            }
        } else {
            DynamicObject[] contractCollectItems;
            DynamicObject contract = bill.getDynamicObject("contract");
            DynamicObject[] contractFilter = new QFilter("contract", "=", (Object)Long.parseLong(contract.getPkValue().toString()));
            if ("pmct_inclaimbill".equals(curFormId)) {
                contractFilter.and(new QFilter("collecttype", "=", (Object)ContractPayTypeEnum.CLAIM_PAYMENT.getValue()));
            }
            if ((contractCollectItems = BusinessDataServiceHelper.load((String)"pmbs_contractcollectitem", (String)String.join((CharSequence)",", "collectedcomamt", "collectedamt"), (QFilter[])new QFilter[]{contractFilter})) != null && contractCollectItems.length > 0) {
                DynamicObject contractCollectItem = contractCollectItems[0];
                BigDecimal collectComAmt = contractCollectItem.getBigDecimal("collectedcomamt");
                BigDecimal collectAmt = contractCollectItem.getBigDecimal("collectedamt");
                if (BigDecimal.ZERO.compareTo(collectComAmt) < 0 || BigDecimal.ZERO.compareTo(collectAmt) < 0) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u5931\u8d25\uff0c\u5408\u540c\u6536\u6b3e\u6761\u76ee\u5df2\u7ecf\u53d1\u751f\u6536\u6b3e\u3002", (String)"ContractRelationBillUnAuditValidator_11", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                }
            }
        }
        if (newPayPlanIdList.size() > 0) {
            DynamicObject[] contractCollectItems;
            for (DynamicObject contractCollectItem : contractCollectItems = BusinessDataServiceHelper.load((String)"pmbs_contractcollectitem", (String)String.join((CharSequence)",", "collectedcomamt", "collectedamt"), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)newPayPlanIdList.toArray())})) {
                BigDecimal collectComAmt = contractCollectItem.getBigDecimal("collectedcomamt");
                BigDecimal collectAmt = contractCollectItem.getBigDecimal("collectedamt");
                Integer index = (Integer)payPlanMap.get(contractCollectItem.getPkValue());
                if (BigDecimal.ZERO.compareTo(collectComAmt) < 0 || BigDecimal.ZERO.compareTo(collectAmt) < 0) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u5931\u8d25\uff0c\u7b2c%s\u884c\u6536\u6b3e\u8ba1\u5212\u5df2\u7ecf\u53d1\u751f\u6536\u6b3e\u3002", (String)"ContractRelationBillUnAuditValidator_12", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), index));
                }
                BaseDataCheckRefrence baseDataCheckRefrence = new BaseDataCheckRefrence();
                baseDataCheckRefrence.setDraftValidReference(true);
                boolean referenced = baseDataCheckRefrence.isRefrenced((BasedataEntityType)EntityMetadataCache.getDataEntityType((String)"pmbs_contractcollectitem"), contractCollectItem.getPkValue());
                if (!referenced) continue;
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u5931\u8d25\uff0c\u7b2c%s\u884c\u6536\u6b3e\u8ba1\u5212\u5df2\u5f15\u7528\u3002", (String)"ContractRelationBillUnAuditValidator_23", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), index));
            }
        }
        if (changePayList.size() == 0) {
            return;
        }
        Object[] changePayIds = changePayList.stream().map(o -> o.getLong(conPlanItemId)).collect(Collectors.toList()).toArray();
        if (changePayIds.length == 0) {
            return;
        }
        DynamicObject[] contractItems = BusinessDataServiceHelper.load((Object[])changePayIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmbs_contractcollectitem"));
        if (contractItems.length == 0) {
            return;
        }
        QFilter sourceBillIdFilter = new QFilter("sourcebillid", "=", (Object)Long.parseLong(bill.getPkValue().toString()));
        DynamicObject incomePlanChangeBill = BusinessDataServiceHelper.loadSingle((String)"pmct_incomeplanchange", (String)"id", (QFilter[])new QFilter[]{sourceBillIdFilter});
        if (incomePlanChangeBill == null) {
            return;
        }
        incomePlanChangeBill = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(incomePlanChangeBill.getPkValue().toString()), (String)"pmct_incomeplanchange");
        DynamicObjectCollection changeEntry = incomePlanChangeBill.getDynamicObjectCollection("changeentity");
        for (DynamicObject changePay : changePayList) {
            long conCollectPlanItemId = changePay.getLong(conPlanItemId);
            Optional<DynamicObject> first = Arrays.stream(contractItems).filter(o -> conCollectPlanItemId == Long.parseLong(o.getPkValue().toString())).findFirst();
            if (!first.isPresent()) continue;
            DynamicObject contractItem = first.get();
            Integer index = (Integer)payPlanMap.get(conCollectPlanItemId);
            for (DynamicObject changeObject : changeEntry) {
                BigDecimal oldCollectAmt;
                BigDecimal collectComAmt;
                String curCollectPlanId = changeObject.getString("newsourcebillid");
                if (curCollectPlanId.isEmpty() || !StringUtils.equals((CharSequence)curCollectPlanId, (CharSequence)changePay.getPkValue().toString()) || (collectComAmt = contractItem.getBigDecimal("collectedcomamt")).compareTo(oldCollectAmt = changeObject.getBigDecimal("oldcollectamount")) <= 0) continue;
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u8ba1\u5212\u7b2c%s\u9879\uff0c\u5df2\u6536\u6b3e\u91d1\u989d\uff08\u542b\u5728\u9014\uff09\u5927\u4e8e \u8be5\u9879\u539f\u542b\u7a0e\u91d1\u989d\uff0c\u4e0d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"ContractRelationBillUnAuditValidator_14", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), index));
            }
        }
    }

    private boolean checkExistNewData(ExtendedDataEntity dataEntity, DynamicObject bill) {
        String contAddAgreementFormId;
        DynamicObject[] contAddAgreements;
        String revisionFormId;
        DynamicObject[] revisions;
        DynamicObject[] contractRevisions;
        boolean result = false;
        String curFormId = bill.getDataEntityType().getName();
        if (("pmct_outclaimbill".equals(curFormId) || "pmct_inclaimbill".equals(curFormId)) && !bill.getBoolean("isneedsettle")) {
            return false;
        }
        Date auditDate = bill.getDate("auditdate");
        String payDirection = PayDirectionEnum.OUT.getValue();
        QFilter billFilter = new QFilter("createtime", ">", (Object)auditDate);
        DynamicObject contract = bill.getDynamicObject("contract");
        if (contract != null) {
            contract = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(contract.getPkValue().toString()), (String)"pmct_contracttpl");
            payDirection = contract.getString("paydirection");
            billFilter.and(new QFilter("contract", "=", (Object)Long.parseLong(contract.getPkValue().toString())));
        }
        if ((contractRevisions = BusinessDataServiceHelper.load((String)"pmct_contractrevision", (String)"createtime", (QFilter[])new QFilter[]{billFilter}, (String)"createtime desc")).length > 0) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u5931\u8d25\u3002\u5728\u672c\u5355\u636e\u5ba1\u6838\u540e\uff0c\u5b58\u5728\u65b0\u7684\u5408\u540c\u4fee\u8ba2\u5355\uff0c\u53cd\u5ba1\u6838\u672c\u5355\u636e\u4f1a\u5f71\u54cd\u6570\u636e\u7684\u6b63\u786e\u6027\uff0c\u8bf7\u52ff\u53cd\u5ba1\u6838\u3002", (String)"ContractRelationBillUnAuditValidator_24", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
            result = true;
        }
        if ((revisions = BusinessDataServiceHelper.load((String)(revisionFormId = PayDirectionEnum.OUT.getValue().equals(payDirection) ? "pmct_outcontractrevision" : "pmct_incontractrevision"), (String)"createtime", (QFilter[])new QFilter[]{billFilter}, (String)"createtime desc")).length > 0) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u5931\u8d25\u3002\u5728\u672c\u5355\u636e\u5ba1\u6838\u540e\uff0c\u5b58\u5728\u65b0\u7684\u5408\u540c\u53d8\u66f4\u5355\uff0c\u53cd\u5ba1\u6838\u672c\u5355\u636e\u4f1a\u5f71\u54cd\u6570\u636e\u7684\u6b63\u786e\u6027\uff0c\u8bf7\u52ff\u53cd\u5ba1\u6838\u3002", (String)"ContractRelationBillUnAuditValidator_25", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
            result = true;
        }
        if ((contAddAgreements = BusinessDataServiceHelper.load((String)(contAddAgreementFormId = PayDirectionEnum.OUT.getValue().equals(payDirection) ? "pmct_outaddagreement" : "pmct_inaddagreement"), (String)"createtime", (QFilter[])new QFilter[]{billFilter}, (String)"createtime desc")).length > 0) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u5931\u8d25\u3002\u672c\u5355\u636e\u5ba1\u6838\u540e\uff0c\u53d1\u73b0\u6709\u65b0\u7684\u5408\u540c\u8865\u5145\u534f\u8bae\u3002\u53cd\u5ba1\u6838\u4f1a\u5f71\u54cd\u6570\u636e\u51c6\u786e\u6027\uff0c\u8bf7\u52ff\u53cd\u5ba1\u6838\u3002", (String)"ContractRelationBillUnAuditValidator_26", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
            result = true;
        }
        QFilter isNeedSettleFilter = new QFilter("isneedsettle", "=", (Object)Boolean.TRUE);
        String claimFormId = PayDirectionEnum.OUT.getValue().equals(payDirection) ? "pmct_outclaimbill" : "pmct_inclaimbill";
        DynamicObject[] claims = BusinessDataServiceHelper.load((String)claimFormId, (String)"createtime", (QFilter[])new QFilter[]{isNeedSettleFilter, billFilter}, (String)"createtime desc");
        if (claims.length > 0) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u5931\u8d25\u3002\u5728\u672c\u5355\u636e\u5ba1\u6838\u540e\uff0c\u5b58\u5728\u65b0\u7684\u5408\u540c\u7d22\u8d54\u5355\uff0c\u53cd\u5ba1\u6838\u672c\u5355\u636e\u4f1a\u5f71\u54cd\u6570\u636e\u7684\u6b63\u786e\u6027\uff0c\u8bf7\u52ff\u53cd\u5ba1\u6838\u3002", (String)"ContractRelationBillUnAuditValidator_27", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
            result = true;
        }
        return result;
    }
}

