/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.opplugin.validator;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.common.enums.PerformAmountTypeEnum;
import kd.pmgt.pmbs.common.utils.CurrencyHelper;
import kd.pmgt.pmbs.common.utils.budget.BudgetValidateAndUpdateHelper;
import kd.pmgt.pmbs.common.utils.budget.BudgetValidateInfo;

public class InContractBudgetValidator
extends AbstractValidator {
    public void validate() {
        String key = this.getOperateKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"submit") || StringUtils.equals((CharSequence)key, (CharSequence)"unsubmit") || StringUtils.equals((CharSequence)key, (CharSequence)"audit") || StringUtils.equals((CharSequence)key, (CharSequence)"unaudit")) {
            this.validateBudget(key);
        }
    }

    protected void validateBudget(String key) {
        ExtendedDataEntity[] entities;
        for (ExtendedDataEntity dataEntity : entities = this.getDataEntities()) {
            DynamicObject[] proApp;
            DynamicObject bill = dataEntity.getDataEntity();
            DynamicObject project = bill.getDynamicObject("project");
            boolean isOpenedContract = bill.getBoolean("openedcontract");
            boolean multiPartSettlement = bill.getBoolean("multipartsettlement");
            if (project == null || isOpenedContract || multiPartSettlement || (proApp = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"projectcostcontrol,org,currencyfield", (QFilter[])new QFilter[]{new QFilter("pro", "=", project.getPkValue())})) == null || proApp.length <= 0 || !proApp[0].getBoolean("projectcostcontrol")) continue;
            Map<String, BigDecimal> proBudgetAmountMap = this.buildBudgetAmountMap(bill, this.getExchangeRate(bill, proApp[0]));
            BudgetValidateInfo validateInfo = null;
            switch (key) {
                case "submit": {
                    validateInfo = BudgetValidateAndUpdateHelper.validateBudgetAmountOnSubmit(proBudgetAmountMap, (String)"0", (PerformAmountTypeEnum)PerformAmountTypeEnum.CONTRACT);
                    break;
                }
                case "unsubmit": {
                    validateInfo = BudgetValidateAndUpdateHelper.validateBudgetAmountOnUnSubmit(proBudgetAmountMap, (String)bill.getPkValue().toString(), (PerformAmountTypeEnum)PerformAmountTypeEnum.CONTRACT);
                    break;
                }
                case "audit": {
                    validateInfo = BudgetValidateAndUpdateHelper.validateBudgetAmountOnAuditAndUnaudit(proBudgetAmountMap, (String)bill.getPkValue().toString(), (long)bill.getLong("id"), (String)"pmct_incontract", (PerformAmountTypeEnum)PerformAmountTypeEnum.CONTRACT, (boolean)false);
                    break;
                }
                case "unaudit": {
                    validateInfo = BudgetValidateAndUpdateHelper.validateBudgetAmountOnAuditAndUnaudit(proBudgetAmountMap, (String)bill.getPkValue().toString(), (long)bill.getLong("id"), (String)"pmct_incontract", (PerformAmountTypeEnum)PerformAmountTypeEnum.CONTRACT, (boolean)true);
                    break;
                }
            }
            this.analysisValidateInfo(dataEntity, validateInfo, proApp[0].getDynamicObject("currencyfield"));
        }
    }

    @Deprecated
    protected boolean checkBudgetMustinput(ExtendedDataEntity dataEntity) {
        return true;
    }

    protected void analysisValidateInfo(ExtendedDataEntity dataEntity, BudgetValidateInfo validateInfo, DynamicObject currency) {
        if (validateInfo != null) {
            boolean outOfControl = validateInfo.isOutOfControl();
            boolean outOfRemind = validateInfo.isOutOfRemind();
            Map resultMap = validateInfo.getResultMap();
            if (resultMap != null && !resultMap.isEmpty()) {
                int amtPrecision = 2;
                if (currency != null) {
                    amtPrecision = currency.getInt("amtprecision");
                }
                for (Map.Entry resultEntry : resultMap.entrySet()) {
                    DynamicObject originalBudget = (DynamicObject)resultEntry.getKey();
                    DynamicObject validateBudget = (DynamicObject)resultEntry.getValue();
                    if (originalBudget.getPkValue().equals(validateBudget.getPkValue())) {
                        if (outOfControl) {
                            this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9884\u7b97\u9879\u201c%s\u201d\u7684\u7d2f\u8ba1\u91d1\u989d\u5df2\u7ecf\u8d85\u51fa\u63a7\u5236\u9650\u989d\u3002", (String)"InContractBudgetValidator_6", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), originalBudget.getString("name")));
                            continue;
                        }
                        if (!outOfRemind) continue;
                        this.addWarningMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9884\u7b97\u9879\u201c%1$s\u201d\u7684\u7d2f\u8ba1\u91d1\u989d\u5df2\u7ecf\u8fbe\u5230%2$s\uff0c\u9884\u7b97\u91d1\u989d\u662f%3$s\u3002", (String)"InContractBudgetValidator_7", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), originalBudget.getString("name"), originalBudget.getBigDecimal("occupyamt").setScale(amtPrecision, RoundingMode.DOWN).toString(), originalBudget.getBigDecimal("budgetamount").setScale(amtPrecision, RoundingMode.DOWN).toString()));
                        continue;
                    }
                    if (outOfControl) {
                        this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9884\u7b97\u9879\u201c%1$s\u201d\u7684\u4e0a\u7ea7\u9884\u7b97\u9879\u201c%2$s\u201d\u7684\u7d2f\u8ba1\u91d1\u989d\u5df2\u7ecf\u8d85\u51fa\u63a7\u5236\u9650\u989d\u3002", (String)"InContractBudgetValidator_8", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), originalBudget.getString("name"), validateBudget.getString("name")));
                        continue;
                    }
                    if (!outOfRemind) continue;
                    this.addWarningMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9884\u7b97\u9879\u201c%1$s\u201d\u7684\u4e0a\u7ea7\u9884\u7b97\u9879\u201c%2$s\u201d\u7684\u7d2f\u8ba1\u91d1\u989d\u5df2\u7ecf\u8fbe\u5230%3$s\uff0c\u9884\u7b97\u91d1\u989d\u662f%4$s\u3002", (String)"InContractBudgetValidator_9", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), originalBudget.getString("name"), validateBudget.getString("name"), validateBudget.getBigDecimal("occupyamt").setScale(amtPrecision, RoundingMode.DOWN).toString(), validateBudget.getBigDecimal("budgetamount").setScale(amtPrecision, RoundingMode.DOWN).toString()));
                }
            }
        }
    }

    protected BigDecimal getExchangeRate(DynamicObject contract, DynamicObject project) {
        DynamicObject exRateTable;
        DynamicObject org = project.getDynamicObject("org");
        DynamicObject proCurrency = project.getDynamicObject("currencyfield");
        DynamicObject contractCurrency = contract.getDynamicObject("currency");
        DynamicObject stdCurrency = contract.getDynamicObject("stdcurrency");
        if (proCurrency != null && contractCurrency != null && proCurrency.getPkValue().equals(contractCurrency.getPkValue())) {
            return BigDecimal.ONE;
        }
        if (proCurrency != null && stdCurrency != null && proCurrency.getPkValue().equals(stdCurrency.getPkValue())) {
            return contract.getBigDecimal("exchangerate");
        }
        BigDecimal exchangeRate = BigDecimal.ONE;
        if (org != null && proCurrency != null && contractCurrency != null && (exRateTable = CurrencyHelper.getExRateTable((Long)org.getLong("id"))) != null) {
            exchangeRate = CurrencyHelper.getExChangeRate((Long)contractCurrency.getLong("id"), (Long)proCurrency.getLong("id"), (Long)exRateTable.getLong("id"), (Date)contract.getDate("createtime"));
        }
        return exchangeRate;
    }

    protected Map<String, BigDecimal> buildBudgetAmountMap(DynamicObject bill, BigDecimal exchangeRate) {
        HashMap<String, BigDecimal> budgetAmountMap = new HashMap<String, BigDecimal>();
        boolean isOnList = bill.getBoolean("isonlist");
        if (isOnList) {
            DynamicObjectCollection listModelEntries = bill.getDynamicObjectCollection("listmodelentry");
            for (DynamicObject listModelEntry : listModelEntries) {
                DynamicObjectCollection listEntry = listModelEntry.getDynamicObjectCollection("sublistentry");
                String cmpType = listModelEntry.getString("cmptype");
                BigDecimal coefficient = BigDecimal.ONE;
                if ("(0)".equals(cmpType)) continue;
                if ("(-)".equals(cmpType)) {
                    coefficient = BigDecimal.valueOf(-1L);
                }
                for (DynamicObject list : listEntry) {
                    DynamicObject budget = list.getDynamicObject("listingbudgetitem");
                    BigDecimal amount = list.getBigDecimal("oftax").multiply(coefficient);
                    if (!list.getBoolean("isleaf") || budget == null || amount == null || amount.compareTo(BigDecimal.ZERO) == 0) continue;
                    BigDecimal budgetAmount = (BigDecimal)budgetAmountMap.get(budget.getPkValue().toString());
                    if (budgetAmount == null) {
                        budgetAmount = BigDecimal.ZERO;
                    }
                    budgetAmountMap.put(budget.getPkValue().toString(), budgetAmount.add(amount.multiply(exchangeRate)));
                }
            }
        } else {
            DynamicObject budget = bill.getDynamicObject("budgetitem");
            BigDecimal amount = bill.getBigDecimal("originaloftaxamount");
            if (budget != null && amount != null && amount.compareTo(BigDecimal.ZERO) != 0) {
                BigDecimal budgetAmount = BigDecimal.ZERO;
                budgetAmountMap.put(budget.getPkValue().toString(), budgetAmount.add(amount.multiply(exchangeRate)));
            }
        }
        return budgetAmountMap;
    }
}

