/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.opplugin.validator;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.common.enums.PerformAmountTypeEnum;
import kd.pmgt.pmbs.common.utils.CurrencyHelper;
import kd.pmgt.pmbs.common.utils.budget.BudgetValidateAndUpdateHelper;
import kd.pmgt.pmbs.common.utils.budget.BudgetValidateInfo;

public class InContractRevisionBudgetValidator
extends AbstractValidator {
    public void validate() {
        String key = this.getOperateKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"submit") || StringUtils.equals((CharSequence)key, (CharSequence)"unsubmit") || StringUtils.equals((CharSequence)key, (CharSequence)"audit") || StringUtils.equals((CharSequence)key, (CharSequence)"unaudit")) {
            this.validateBudget(key);
        }
    }

    @Deprecated
    protected boolean checkBudgetMustInput(ExtendedDataEntity dataEntity) {
        return true;
    }

    protected void validateBudget(String key) {
        ExtendedDataEntity[] entities;
        for (ExtendedDataEntity dataEntity : entities = this.getDataEntities()) {
            DynamicObject[] proApp;
            DynamicObject bill = dataEntity.getDataEntity();
            DynamicObject project = bill.getDynamicObject("project");
            DynamicObject contract = bill.getDynamicObject("contract");
            if (contract == null) continue;
            boolean isOpenedContract = contract.getBoolean("openedcontract");
            contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_outcontract");
            boolean multiPartSettlement = contract.getBoolean("multipartsettlement");
            if (project == null || isOpenedContract || multiPartSettlement || (proApp = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"projectcostcontrol,org,currencyfield", (QFilter[])new QFilter[]{new QFilter("pro", "=", project.getPkValue())})) == null || proApp.length <= 0 || !proApp[0].getBoolean("projectcostcontrol")) continue;
            Map<String, BigDecimal> budgetAmountMap = this.buildBudgetAmountMap(bill, this.getExchangeRate(bill, proApp[0]));
            BudgetValidateInfo validateInfo = null;
            if (StringUtils.equals((CharSequence)"submit", (CharSequence)key)) {
                validateInfo = BudgetValidateAndUpdateHelper.validateBudgetAmountOnSubmit(budgetAmountMap, (String)contract.getString("id"), (PerformAmountTypeEnum)PerformAmountTypeEnum.CONTRACT);
            } else if (StringUtils.equals((CharSequence)"unsubmit", (CharSequence)key)) {
                validateInfo = BudgetValidateAndUpdateHelper.validateBudgetAmountOnUnSubmit(budgetAmountMap, (String)contract.getString("id"), (PerformAmountTypeEnum)PerformAmountTypeEnum.CONTRACT);
            } else if (StringUtils.equals((CharSequence)"audit", (CharSequence)key)) {
                validateInfo = BudgetValidateAndUpdateHelper.validateBudgetAmountOnAuditAndUnaudit(budgetAmountMap, (String)contract.getString("id"), (long)bill.getLong("id"), (String)"pmct_outcontractrevision", (PerformAmountTypeEnum)PerformAmountTypeEnum.CONTRACT, (boolean)false);
            } else if (StringUtils.equals((CharSequence)"unaudit", (CharSequence)key)) {
                validateInfo = BudgetValidateAndUpdateHelper.validateBudgetAmountOnAuditAndUnaudit(budgetAmountMap, (String)contract.getString("id"), (long)bill.getLong("id"), (String)"pmct_outcontractrevision", (PerformAmountTypeEnum)PerformAmountTypeEnum.CONTRACT, (boolean)true);
            }
            this.analysisValidateInfo(dataEntity, validateInfo, proApp[0].getDynamicObject("currencyfield"));
        }
    }

    protected void analysisValidateInfo(ExtendedDataEntity dataEntity, BudgetValidateInfo validateInfo, DynamicObject currency) {
        if (validateInfo != null) {
            boolean outOfControl = validateInfo.isOutOfControl();
            boolean outOfRemind = validateInfo.isOutOfRemind();
            Map resultMap = validateInfo.getResultMap();
            if (resultMap != null && !resultMap.isEmpty()) {
                int amtPrecision = 2;
                if (currency != null) {
                    amtPrecision = currency.getInt("amtprecision");
                }
                for (Map.Entry resultEntry : resultMap.entrySet()) {
                    DynamicObject originalBudget = (DynamicObject)resultEntry.getKey();
                    DynamicObject validateBudget = (DynamicObject)resultEntry.getValue();
                    if (originalBudget.getPkValue().equals(validateBudget.getPkValue())) {
                        if (outOfControl) {
                            this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9884\u7b97\u9879\u201c%s\u201d\u7684\u7d2f\u8ba1\u91d1\u989d\u5df2\u7ecf\u8d85\u51fa\u63a7\u5236\u9650\u989d\u3002", (String)"InContractRevisionBudgetValidator_6", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), originalBudget.getString("name")));
                            continue;
                        }
                        if (!outOfRemind) continue;
                        this.addWarningMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9884\u7b97\u9879\u201c%1$s\u201d\u7684\u7d2f\u8ba1\u91d1\u989d\u5df2\u7ecf\u8fbe\u5230%2$s\uff0c\u9884\u7b97\u91d1\u989d\u662f%3$s\u3002", (String)"InContractRevisionBudgetValidator_7", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), originalBudget.getString("name"), originalBudget.getBigDecimal("occupyamt").setScale(amtPrecision, RoundingMode.DOWN).toString(), originalBudget.getBigDecimal("budgetamount").setScale(amtPrecision, RoundingMode.DOWN).toString()));
                        continue;
                    }
                    if (outOfControl) {
                        this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9884\u7b97\u9879\u201c%1$s\u201d\u7684\u4e0a\u7ea7\u9884\u7b97\u9879\u201c%2$s\u201d\u7684\u7d2f\u8ba1\u91d1\u989d\u5df2\u7ecf\u8d85\u51fa\u63a7\u5236\u9650\u989d\u3002", (String)"InContractRevisionBudgetValidator_8", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), originalBudget.getString("name"), validateBudget.getString("name")));
                        continue;
                    }
                    if (!outOfRemind) continue;
                    this.addWarningMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9884\u7b97\u9879\u201c%1$s\u201d\u7684\u4e0a\u7ea7\u9884\u7b97\u9879\u201c%2$s\u201d\u7684\u7d2f\u8ba1\u91d1\u989d\u5df2\u7ecf\u8fbe\u5230%3$s\uff0c\u9884\u7b97\u91d1\u989d\u662f%4$s\u3002", (String)"InContractRevisionBudgetValidator_9", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), originalBudget.getString("name"), validateBudget.getString("name"), validateBudget.getBigDecimal("occupyamt").setScale(amtPrecision, RoundingMode.DOWN).toString(), validateBudget.getBigDecimal("budgetamount").setScale(amtPrecision, RoundingMode.DOWN).toString()));
                }
            }
        }
    }

    protected BigDecimal getExchangeRate(DynamicObject bill, DynamicObject project) {
        DynamicObject exRateTable;
        DynamicObject org = project.getDynamicObject("org");
        DynamicObject proCurrency = project.getDynamicObject("currencyfield");
        DynamicObject contractCurrency = bill.getDynamicObject("currency");
        DynamicObject stdCurrency = bill.getDynamicObject("stdcurrency");
        if (proCurrency != null && contractCurrency != null && proCurrency.getPkValue().equals(contractCurrency.getPkValue())) {
            return BigDecimal.ONE;
        }
        if (proCurrency != null && stdCurrency != null && proCurrency.getPkValue().equals(stdCurrency.getPkValue())) {
            return bill.getBigDecimal("exchangerate");
        }
        BigDecimal exchangeRate = BigDecimal.ONE;
        if (org != null && proCurrency != null && contractCurrency != null && (exRateTable = CurrencyHelper.getExRateTable((Long)org.getLong("id"))) != null) {
            exchangeRate = CurrencyHelper.getExChangeRate((Long)contractCurrency.getLong("id"), (Long)proCurrency.getLong("id"), (Long)exRateTable.getLong("id"), (Date)bill.getDate("createtime"));
        }
        return exchangeRate;
    }

    protected Map<String, BigDecimal> buildBudgetAmountMap(DynamicObject bill, BigDecimal exchangeRate) {
        HashMap<String, BigDecimal> budgetAmountMap = new HashMap<String, BigDecimal>();
        boolean isOnList = bill.getBoolean("isbasedonlist");
        if (isOnList) {
            DynamicObjectCollection modelEntry = bill.getDynamicObjectCollection("kapianentry");
            for (DynamicObject modelEntryObj : modelEntry) {
                DynamicObjectCollection listEntry = modelEntryObj.getDynamicObjectCollection("entryentity");
                String cmpType = modelEntryObj.getString("cmptype");
                BigDecimal coefficient = BigDecimal.ONE;
                if ("(0)".equals(cmpType)) continue;
                if ("(-)".equals(cmpType)) {
                    coefficient = BigDecimal.valueOf(-1L);
                }
                for (DynamicObject list : listEntry) {
                    BigDecimal amount;
                    DynamicObject budget = list.getDynamicObject("listingbudgetitem");
                    String changeType = list.getString("subchangetype");
                    if (budget != null && (StringUtils.equals((CharSequence)"0", (CharSequence)changeType) || StringUtils.equals((CharSequence)"1", (CharSequence)changeType))) {
                        amount = list.getBigDecimal("hsbgje").multiply(coefficient);
                        if (amount == null || amount.compareTo(BigDecimal.ZERO) == 0) continue;
                        this.addBudgetAmount(exchangeRate, budgetAmountMap, budget, amount);
                        continue;
                    }
                    if (budget == null || !StringUtils.equals((CharSequence)"2", (CharSequence)changeType) || (amount = list.getBigDecimal("oftax").multiply(coefficient)) == null || amount.compareTo(BigDecimal.ZERO) == 0) continue;
                    this.addBudgetAmount(exchangeRate, budgetAmountMap, budget, amount);
                }
            }
        } else {
            DynamicObject budget = bill.getDynamicObject("budgetitem");
            BigDecimal amount = bill.getBigDecimal("revisionoftaxamount");
            if (budget != null && amount != null && amount.compareTo(BigDecimal.ZERO) != 0) {
                this.addBudgetAmount(exchangeRate, budgetAmountMap, budget, amount);
            }
        }
        return budgetAmountMap;
    }

    protected void addBudgetAmount(BigDecimal exchangeRate, Map<String, BigDecimal> budgetAmountMap, DynamicObject budget, BigDecimal amount) {
        BigDecimal budgetAmount = budgetAmountMap.get(budget.getPkValue().toString());
        if (budgetAmount == null) {
            budgetAmount = BigDecimal.ZERO;
        }
        budgetAmountMap.put(budget.getPkValue().toString(), budgetAmount.add(amount.multiply(exchangeRate)));
    }
}

