/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.opplugin.validator;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.business.helper.ProBudgetControlHelper;
import kd.pmgt.pmbs.common.enums.PerformAmountTypeEnum;
import kd.pmgt.pmbs.common.utils.CurrencyHelper;
import kd.pmgt.pmbs.common.utils.budget.BudgetValidateAndUpdateHelper;
import kd.pmgt.pmbs.common.utils.budget.BudgetValidateInfo;

public class OutContSettleBudgetValidator
extends AbstractValidator {
    public void validate() {
        String key = this.getOperateKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"submit") || StringUtils.equals((CharSequence)key, (CharSequence)"unsubmit") || StringUtils.equals((CharSequence)key, (CharSequence)"audit") || StringUtils.equals((CharSequence)key, (CharSequence)"unaudit")) {
            this.vaildBudget(key);
        }
    }

    private void vaildBudget(String key) {
        ExtendedDataEntity[] entities;
        for (ExtendedDataEntity dataEntity : entities = this.getDataEntities()) {
            DynamicObject[] proApp;
            boolean isNew;
            DynamicObject settleBill = dataEntity.getDataEntity();
            DynamicObject contract = settleBill.getDynamicObject("contract");
            DynamicObject project = settleBill.getDynamicObject("project");
            contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_outcontract");
            if (project == null || (isNew = ProBudgetControlHelper.checkIsNewProBudgetCtrl((Long)((Long)project.getPkValue()))) || (proApp = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"projectcostcontrol,org,currencyfield", (QFilter[])new QFilter[]{new QFilter("pro", "=", project.getPkValue())})) == null || proApp.length <= 0 || !proApp[0].getBoolean("projectcostcontrol")) continue;
            Map<String, BigDecimal> budgetAmountMap = this.buildBudgetAmountMap(settleBill, this.getExchangeRate(settleBill, proApp[0]));
            BudgetValidateInfo validateInfo = null;
            if (StringUtils.equals((CharSequence)"submit", (CharSequence)key)) {
                validateInfo = BudgetValidateAndUpdateHelper.validateBudgetAmountOnSubmit(budgetAmountMap, (String)contract.getPkValue().toString(), (PerformAmountTypeEnum)PerformAmountTypeEnum.SETTLE);
            } else if (StringUtils.equals((CharSequence)"unsubmit", (CharSequence)key)) {
                validateInfo = BudgetValidateAndUpdateHelper.validateBudgetAmountOnUnSubmit(budgetAmountMap, (String)contract.getPkValue().toString(), (PerformAmountTypeEnum)PerformAmountTypeEnum.SETTLE);
            } else if (StringUtils.equals((CharSequence)"audit", (CharSequence)key)) {
                validateInfo = BudgetValidateAndUpdateHelper.validateBudgetAmountOnAuditAndUnaudit(budgetAmountMap, (String)contract.getPkValue().toString(), (long)settleBill.getLong("id"), (String)"pmct_outcontract_settle", (PerformAmountTypeEnum)PerformAmountTypeEnum.SETTLE, (boolean)false);
            } else if (StringUtils.equals((CharSequence)"unaudit", (CharSequence)key)) {
                validateInfo = BudgetValidateAndUpdateHelper.validateBudgetAmountOnAuditAndUnaudit(budgetAmountMap, (String)contract.getPkValue().toString(), (long)settleBill.getLong("id"), (String)"pmct_outcontract_settle", (PerformAmountTypeEnum)PerformAmountTypeEnum.SETTLE, (boolean)true);
            }
            this.analysisValidateInfo(dataEntity, validateInfo, proApp[0].getDynamicObject("currencyfield"));
        }
    }

    @Deprecated
    protected boolean controlAmount(ExtendedDataEntity dataEntity, DynamicObject settleBill, DynamicObject contract) {
        boolean outControl = false;
        DynamicObject contractType = contract.getDynamicObject("contracttype");
        String ammountcontrolsettle = (contractType = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(contractType.getPkValue().toString()), (String)"pmct_conttype")).getString("ammountcontrolsettle");
        if ("2".equals(ammountcontrolsettle) || "1".equals(ammountcontrolsettle)) {
            Map<String, BigDecimal> budgetAmountMap = this.buildBudgetAmountMap(settleBill, BigDecimal.ONE);
            QFilter filter = new QFilter("contract", "=", (Object)Long.valueOf(contract.getPkValue().toString()));
            for (Map.Entry<String, BigDecimal> map : budgetAmountMap.entrySet()) {
                BigDecimal settleAmount;
                QFilter filter1 = new QFilter("budgetitem", "=", (Object)Long.valueOf(map.getKey()));
                DynamicObject[] contractBudgets = BusinessDataServiceHelper.load((String)"pmbs_contractbudget", (String)"contract, projectcurrency, contractcurrency, budgetitem, occupyamt, performamt, contractsubmitamt, contractauditamt, settlesubmitamt, settleauditamt, payapplysubmitamt, payapplyauditamt, actualsubmitamt, actualauditamt, occupyamtex, performamtex, contractsubmitamtex, contractauditamtex, settlesubmitamtex, settleauditamtex, payapplysubmitamtex, payapplyauditamtex, actualsubmitamtex, actualauditamtex", (QFilter[])new QFilter[]{filter, filter1});
                if (contractBudgets.length <= 0 || (settleAmount = map.getValue().add(contractBudgets[0].getBigDecimal("settlesubmitamtex"))).compareTo(contractBudgets[0].getBigDecimal("contractauditamtex")) <= 0) continue;
                DynamicObject budget = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(map.getKey()), (String)"pmas_projectbudget");
                if ("2".equals(ammountcontrolsettle)) {
                    this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9884\u7b97\u9879\u201c%s\u201d\u7684\u7d2f\u8ba1\u7ed3\u7b97\u91d1\u989d\u5df2\u7ecf\u8d85\u51fa\u5408\u540c\u91d1\u989d\u3002", (String)"OutContSettleBudgetValidator_7", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), budget.getString("name")));
                    outControl = true;
                    continue;
                }
                if (!"1".equals(ammountcontrolsettle)) continue;
                this.addWarningMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9884\u7b97\u9879\u201c%s\u201d\u7684\u7d2f\u8ba1\u7ed3\u7b97\u91d1\u989d\u5df2\u7ecf\u8d85\u51fa\u5408\u540c\u91d1\u989d\u3002", (String)"OutContSettleBudgetValidator_7", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), budget.getString("name")));
            }
        }
        return outControl;
    }

    protected void analysisValidateInfo(ExtendedDataEntity dataEntity, BudgetValidateInfo validateInfo, DynamicObject currency) {
        if (validateInfo != null) {
            boolean outOfControl = validateInfo.isOutOfControl();
            boolean outOfRemind = validateInfo.isOutOfRemind();
            Map resultMap = validateInfo.getResultMap();
            if (resultMap != null && !resultMap.isEmpty()) {
                int amtPrecision = 2;
                if (currency != null) {
                    amtPrecision = currency.getInt("amtprecision");
                }
                for (Map.Entry resultEntry : resultMap.entrySet()) {
                    DynamicObject originalBudget = (DynamicObject)resultEntry.getKey();
                    DynamicObject validateBudget = (DynamicObject)resultEntry.getValue();
                    if (originalBudget.getPkValue().equals(validateBudget.getPkValue())) {
                        if (outOfControl) {
                            this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9884\u7b97\u9879\u201c%s\u201d\u7684\u7d2f\u8ba1\u91d1\u989d\u5df2\u7ecf\u8d85\u51fa\u63a7\u5236\u9650\u989d\u3002", (String)"OutContSettleBudgetValidator_8", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), originalBudget.getString("name")));
                            continue;
                        }
                        if (!outOfRemind) continue;
                        this.addWarningMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9884\u7b97\u9879\u201c%1$s\u201d\u7684\u7d2f\u8ba1\u91d1\u989d\u5df2\u7ecf\u8fbe\u5230%2$s\uff0c\u9884\u7b97\u91d1\u989d\u662f%3$s\u3002", (String)"OutContSettleBudgetValidator_9", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), originalBudget.getString("name"), originalBudget.getBigDecimal("occupyamt").setScale(amtPrecision, RoundingMode.DOWN).toString(), originalBudget.getBigDecimal("budgetamount").setScale(amtPrecision, RoundingMode.DOWN).toString()));
                        continue;
                    }
                    if (outOfControl) {
                        this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9884\u7b97\u9879\u201c%1$s\u201d\u7684\u4e0a\u7ea7\u9884\u7b97\u9879\u201c%2$s\u201d\u7684\u7d2f\u8ba1\u91d1\u989d\u5df2\u7ecf\u8d85\u51fa\u63a7\u5236\u9650\u989d\u3002", (String)"OutContSettleBudgetValidator_10", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), originalBudget.getString("name"), validateBudget.getString("name")));
                        continue;
                    }
                    if (!outOfRemind) continue;
                    this.addWarningMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9884\u7b97\u9879\u201c%1$s\u201d\u7684\u4e0a\u7ea7\u9884\u7b97\u9879\u201c%2$s\u201d\u7684\u7d2f\u8ba1\u91d1\u989d\u5df2\u7ecf\u8fbe\u5230%3$s\uff0c\u9884\u7b97\u91d1\u989d\u662f%4$s\u3002", (String)"OutContSettleBudgetValidator_11", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), originalBudget.getString("name"), validateBudget.getString("name"), validateBudget.getBigDecimal("occupyamt").setScale(amtPrecision, RoundingMode.DOWN).toString(), validateBudget.getBigDecimal("budgetamount").setScale(amtPrecision, RoundingMode.DOWN).toString()));
                }
            }
        }
    }

    protected BigDecimal getExchangeRate(DynamicObject bill, DynamicObject project) {
        DynamicObject exRateTable;
        DynamicObject org = project.getDynamicObject("org");
        DynamicObject proCurrency = project.getDynamicObject("currencyfield");
        DynamicObject contractCurrency = bill.getDynamicObject("currency");
        DynamicObject stdCurrency = bill.getDynamicObject("stdcurrency");
        if (proCurrency != null && contractCurrency != null && proCurrency.getPkValue().equals(contractCurrency.getPkValue())) {
            return BigDecimal.ONE;
        }
        if (proCurrency != null && stdCurrency != null && proCurrency.getPkValue().equals(stdCurrency.getPkValue())) {
            return bill.getBigDecimal("exchangerate");
        }
        BigDecimal exchangeRate = BigDecimal.ONE;
        if (org != null && proCurrency != null && contractCurrency != null && (exRateTable = CurrencyHelper.getExRateTable((Long)org.getLong("id"))) != null) {
            exchangeRate = CurrencyHelper.getExChangeRate((Long)contractCurrency.getLong("id"), (Long)proCurrency.getLong("id"), (Long)exRateTable.getLong("id"), (Date)bill.getDate("createtime"));
        }
        return exchangeRate;
    }

    protected Map<String, BigDecimal> buildBudgetAmountMap(DynamicObject bill, BigDecimal exchangeRate) {
        HashMap<String, BigDecimal> budgetAmountMap = new HashMap<String, BigDecimal>();
        DynamicObjectCollection itemEntry = bill.getDynamicObjectCollection("itementry");
        for (DynamicObject item : itemEntry) {
            DynamicObject budget = item.getDynamicObject("paybudgetitem");
            if (budget == null) continue;
            BigDecimal budgetAmount = (BigDecimal)budgetAmountMap.get(String.valueOf(budget.getPkValue()));
            if (budgetAmount == null) {
                budgetAmount = BigDecimal.ZERO;
            }
            budgetAmountMap.put(String.valueOf(budget.getPkValue()), budgetAmount.add(item.getBigDecimal("oftaxamount").multiply(exchangeRate)));
        }
        return budgetAmountMap;
    }
}

